vim-flake8
==========
`vim-flake8` is a Vim plugin that runs the currently open file through Flake8,
a static syntax and style checker for Python source code.  It supersedes both
[vim-pyflakes](https://github.com/nvie/vim-pyflakes) and
[vim-pep8](https://github.com/nvie/vim-pep8).

[Flake8](https://pypi.python.org/pypi/flake8/) is a wrapper around PyFlakes
(static syntax checker), PEP8 (style checker) and Ned's MacCabe script
(complexity checker).


Installation
------------

Make sure you've installed the
[flake8](https://pypi.python.org/pypi/flake8/) package.

If you use vim >= 8, install this plugin with:
```
mkdir -p ~/.vim/pack/flake8/start/
cd ~/.vim/pack/flake8/start/
git clone https://github.com/nvie/vim-flake8.git
```

Otherwise, install [vim-pathogen](https://github.com/tpope/vim-pathogen)
if you're not using it already. Then, simply put the
contents of this repository in your `~/.vim/bundle` directory.

Usage
-----
1. Open a Python file
2. Press `<F7>` to run `flake8` on it

It shows the errors inside a quickfix window, which will allow your to quickly
jump to the error locations by simply pressing [Enter].

If any of `g:flake8_show_in_gutter` or `g:flake8_show_in_file` are set to `1`, call:

    call flake8#Flake8UnplaceMarkers()

To remove all markers. No default mapping is provided.

Customization
-------------
If you don't want to use the `<F7>` key for flake8-checking, simply remap it to
another key.  It autodetects whether it has been remapped and won't register
the `<F7>` key if so.  For example, to remap it to `<F3>` instead, use:

    autocmd FileType python map <buffer> <F3> :call flake8#Flake8()<CR>

Since the `autocmd` order is not specified in Vim, the previous
recommendation is sometimes not sufficient to "unmap" `<F7>`. In such a
case, being more explicit about it should help (see `:h no_mail_maps`):

    let g:no_flake8_maps = 1

For flake8 configuration options please consult the following page:

http://flake8.pycqa.org/en/latest/user/configuration.html

To customize the location of your flake8 binary, set `g:flake8_cmd`:

    let g:flake8_cmd="/opt/strangebin/flake8000"

To customize the location of quick fix window, set `g:flake8_quickfix_location`:

    let g:flake8_quickfix_location="topleft"

To customize the height of quick fix window, set `g:flake8_quickfix_height`:

    let g:flake8_quickfix_height=7

To customize whether the quickfix window opens, set `g:flake8_show_quickfix`:

    let g:flake8_show_quickfix=0  " don't show
    let g:flake8_show_quickfix=1  " show (default)

To customize whether the show signs in the gutter, set `g:flake8_show_in_gutter`:

    let g:flake8_show_in_gutter=0  " don't show (default)
    let g:flake8_show_in_gutter=1  " show

To customize whether the show marks in the file, set `g:flake8_show_in_file`:

    let g:flake8_show_in_file=0  " don't show (default)
    let g:flake8_show_in_file=1  " show

To customize the number of marks to show, set `g:flake8_max_markers`:

    let g:flake8_max_markers=500  " (default)

To customize the gutter markers, set any of `flake8_error_marker`, `flake8_warning_marker`,
`flake8_pyflake_marker`, `flake8_complexity_marker`, `flake8_naming_marker`. Setting one to
the empty string disables it. Ex.:

    let g:flake8_error_marker='EE'     " set error marker to 'EE'
    let g:flake8_warning_marker='WW'   " set warning marker to 'WW'
    let g:flake8_pyflake_marker=''     " disable PyFlakes warnings
    let g:flake8_complexity_marker=''  " disable McCabe complexity warnings
    let g:flake8_naming_marker=''      " disable naming warnings

To customize the colors used for markers, define the highlight groups, `Flake8_Error`,
`Flake8_Warning`, `Flake8_PyFlake`, `Flake8_Complexity`, `Flake8_Naming`:

    " to use colors defined in the colorscheme
    highlight link Flake8_Error      Error
    highlight link Flake8_Warning    WarningMsg
    highlight link Flake8_Complexity WarningMsg
    highlight link Flake8_Naming     WarningMsg
    highlight link Flake8_PyFlake    WarningMsg

To show the error message of the current line in the ruler, call `flake8#ShowError()`:

    " add binding to call the function
    nnoremap <C-K> :call flake8#Flake8ShowError()<cr>
    

Tips
----
A tip might be to run the Flake8 check every time you write a Python file, to
enable this, add the following line to your `.vimrc` file (thanks
[Godefroid](https://github.com/gotcha)!):

    autocmd BufWritePost *.py call flake8#Flake8()

This plugin goes well together with the following plugin:

- [PyUnit](https://github.com/nvie/vim-pyunit) (unit test helper under `<F8>`
  and `<F9>`)


Max line lengths
----------------

One particular customization a lot of people like to make is relaxing the
maximum line length default.  This is a config setting that should be set in
flake8 itself. (vim-flake8 "just" invokes it and deals with showing the output
in Vim's quickfix window.)

To do so, put the following into a `.flake8` file at the root of your project:

    [flake8]
    max-line-length = 120


History
-------
1.6: Deprecated configuring flake8 options through Vim settings.  Instead,
advise users to use a `.flake8` config file in the root of your project.

    - Decprecated options:
      - `g:flake8_builtins`
      - `g:flake8_ignore`
      - `g:flake8_max_line_length`
      - `g:flake8_max_complexity`

    - New options:
      - `g:flake8_quickfix_height`

1.5: Added markers and the option to don't show the quickfix window, also split
functions into a autoload file. Added:

    - Options:
      - `g:flake8_show_quickfix`
      - `g:flake8_show_in_gutter`
      - `g:flake8_show_in_file`
      - `g:flake8_max_markers`
      - `flake8_error_marker`
      - `flake8_warning_marker`
      - `flake8_pyflake_marker`
      - `flake8_complexity_marker`
      - `flake8_naming_marker`
    - Functions:
      - `flake8#Flake8UnplaceMarkers()`
      - `flake8#Flake8()`
    - Highlighting:
      - `Flake8_Error`
      - `Flake8_Warning`
      - `Flake8_Complexity`
      - `Flake8_Naming`
      - `Flake8_PyFlake`

1.4: Suppress output to stdout.

1.3: Added the following options:

    - `g:flake8_builtins="_,apply"`
    - `g:flake8_max_complexity=10`

1.2: Added the following options:

    - `g:flake8_cmd="/opt/strangebin/flake8000"`
    - `g:flake8_max_line_length=120`
    - `g:flake8_ignore="E501,W293"`

1.1: Added `g:flake8_ignore` option.

1.0: Initial version.


License
-------

Liberally licensed under BSD terms.
