/* A recursive-descent parser generated by greg 0.4.3 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
struct _GREG;
#define YYRULECOUNT 269

/* PEG Markdown Highlight
 * Copyright 2011-2016 Ali Rantakari -- http://hasseg.org
 * Licensed under the GPL2+ and MIT licenses (see LICENSE for more info).
 * 
 * pmh_grammar.leg
 * 
 * This is a slightly adapted version of the PEG grammar from John MacFarlane's
 * peg-markdown compiler.
 */

/* PEG Markdown Highlight
 * Copyright 2011-2016 Ali Rantakari -- http://hasseg.org
 * Licensed under the GPL2+ and MIT licenses (see LICENSE for more info).
 * 
 * pmh_parser_head.c
 * 
 * Code to be inserted into the beginning of the parser code generated
 * from the PEG grammar.
 */

#include "pmh_parser.h"

#ifndef pmh_DEBUG_OUTPUT
#define pmh_DEBUG_OUTPUT 0
#endif

#if pmh_DEBUG_OUTPUT
#define pmh_IF(x)           if (x)
#define pmh_PRINTF(x, ...)  fprintf(stderr, x, ##__VA_ARGS__)
#define pmh_PUTCHAR(x)      putchar(x)
#else
#define pmh_IF(x)
#define pmh_PRINTF(x, ...)
#define pmh_PUTCHAR(x)
#endif



// Alias strdup to _strdup on MSVC:
#ifdef _MSC_VER
#define strdup _strdup
#endif


char *strdup_or_null(char *s)
{
    return (s == NULL) ? NULL : strdup(s);
}


// Internal language element occurrence structure, containing
// both public and private members:
struct pmh_RealElement
{
    // "Public" members:
    // (these must match what's defined in pmh_definitions.h)
    // -----------------------------------------------
    pmh_element_type type;
    unsigned long pos;
    unsigned long end;
    struct pmh_RealElement *next;
    char *label;
    char *address;
    
    // "Private" members for use by the parser itself:
    // -----------------------------------------------
    
    // next element in list of all elements:
    struct pmh_RealElement *all_elems_next;
    
    // offset to text (for elements of type pmh_EXTRA_TEXT, used when the
    // parser reads the value of 'text'):
    int text_offset;
    
    // text content (for elements of type pmh_EXTRA_TEXT):
    char *text;
    
    // children of element (for elements of type pmh_RAW_LIST)
    struct pmh_RealElement *children;
};
typedef struct pmh_RealElement pmh_realelement;




// Parser state data:
typedef struct
{
    /* The original, unmodified UTF-8 input: */
    char *original_input;
    
    /* The offsets of the bytes we have stripped from original_input: */
    unsigned long *strip_positions;
    size_t strip_positions_len;
    
    /* Buffer of characters to be parsed: */
    char *charbuf;
    
    /* Linked list of {start, end} offset pairs determining which parts */
    /* of charbuf to actually parse: */
    pmh_realelement *current_elem;
    pmh_realelement *elem_head;
    
    /* Current parsing offset within charbuf: */
    unsigned long offset;
    
    /* The extensions to use for parsing (bitfield */
    /* of enum pmh_extensions): */
    int extensions;
    
    /* Array of parsing result elements, indexed by type: */
    pmh_realelement **head_elems;
    
    /* Whether we are parsing only references: */
    bool parsing_only_references;
    
    /* List of reference elements: */
    pmh_realelement *references;
} parser_data;

static parser_data *mk_parser_data(char *original_input,
                                   unsigned long *strip_positions,
                                   size_t strip_positions_len,
                                   char *charbuf,
                                   pmh_realelement *parsing_elems,
                                   unsigned long offset,
                                   int extensions,
                                   pmh_realelement **head_elems,
                                   pmh_realelement *references)
{
    parser_data *p_data = (parser_data *)malloc(sizeof(parser_data));
    p_data->extensions = extensions;
    p_data->original_input = original_input;
    p_data->strip_positions = strip_positions;
    p_data->strip_positions_len = strip_positions_len;
    p_data->charbuf = charbuf;
    p_data->offset = offset;
    p_data->elem_head = p_data->current_elem = parsing_elems;
    p_data->references = references;
    p_data->parsing_only_references = false;
    if (head_elems != NULL)
        p_data->head_elems = head_elems;
    else {
        p_data->head_elems = (pmh_realelement **)
                             malloc(sizeof(pmh_realelement *) * pmh_NUM_TYPES);
        int i;
        for (i = 0; i < pmh_NUM_TYPES; i++)
            p_data->head_elems[i] = NULL;
    }
    return p_data;
}


// Forward declarations
static void parse_markdown(parser_data *p_data);
static void parse_references(parser_data *p_data);





static char **get_element_type_names()
{
    static char **elem_type_names = NULL;
    if (elem_type_names == NULL)
    {
        elem_type_names = (char **)malloc(sizeof(char*) * pmh_NUM_LANG_TYPES);
        int i;
        for (i = 0; i < pmh_NUM_LANG_TYPES; i++)
            elem_type_names[i] = NULL;
        elem_type_names[pmh_LINK] = "LINK";
        elem_type_names[pmh_AUTO_LINK_URL] = "AUTO_LINK_URL";
        elem_type_names[pmh_AUTO_LINK_EMAIL] = "AUTO_LINK_EMAIL";
        elem_type_names[pmh_IMAGE] = "IMAGE";
        elem_type_names[pmh_CODE] = "CODE";
        elem_type_names[pmh_HTML] = "HTML";
        elem_type_names[pmh_HTML_ENTITY] = "HTML_ENTITY";
        elem_type_names[pmh_EMPH] = "EMPH";
        elem_type_names[pmh_STRONG] = "STRONG";
        elem_type_names[pmh_LIST_BULLET] = "LIST_BULLET";
        elem_type_names[pmh_LIST_ENUMERATOR] = "LIST_ENUMERATOR";
        elem_type_names[pmh_COMMENT] = "COMMENT";
        elem_type_names[pmh_H1] = "H1";
        elem_type_names[pmh_H2] = "H2";
        elem_type_names[pmh_H3] = "H3";
        elem_type_names[pmh_H4] = "H4";
        elem_type_names[pmh_H5] = "H5";
        elem_type_names[pmh_H6] = "H6";
        elem_type_names[pmh_BLOCKQUOTE] = "BLOCKQUOTE";
        elem_type_names[pmh_VERBATIM] = "VERBATIM";
        elem_type_names[pmh_HTMLBLOCK] = "HTMLBLOCK";
        elem_type_names[pmh_HRULE] = "HRULE";
        elem_type_names[pmh_REFERENCE] = "REFERENCE";
        elem_type_names[pmh_FENCEDCODEBLOCK] = "FENCEDCODEBLOCK";
        elem_type_names[pmh_NOTE] = "NOTE";
        elem_type_names[pmh_STRIKE] = "STRIKE";
        elem_type_names[pmh_FRONTMATTER] = "FRONTMATTER";
        elem_type_names[pmh_DISPLAYFORMULA] = "DISPLAYFORMULA";
        elem_type_names[pmh_INLINEEQUATION] = "INLINEEQUATION";
        elem_type_names[pmh_MARK] = "MARK";
        elem_type_names[pmh_TABLE] = "TABLE";
        elem_type_names[pmh_TABLEHEADER] = "TABLEHEADER";
        elem_type_names[pmh_TABLEBORDER] = "TABLEBORDER";
    }
    return elem_type_names;
}

pmh_element_type pmh_element_type_from_name(char *name)
{
    char **elem_type_names = get_element_type_names();
    
    int i;
    for (i = 0; i < pmh_NUM_LANG_TYPES; i++)
    {
        char *i_name = elem_type_names[i];
        if (i_name == NULL)
            continue;
        if (strcmp(i_name, name) == 0)
            return i;
    }
    
    return pmh_NO_TYPE;
}

char *pmh_element_name_from_type(pmh_element_type type)
{
    char **elem_type_names = get_element_type_names();
    char* ret = elem_type_names[type];
    if (ret == NULL)
        return "unknown type";
    return ret;
}




/*
Remove pmh_RAW elements with zero length; return pointer
to new head.
*/
static pmh_realelement *remove_zero_length_raw_spans(pmh_realelement *elem)
{
    pmh_realelement *head = elem;
    pmh_realelement *parent = NULL;
    pmh_realelement *c = head;
    while (c != NULL)
    {
        if (c->type == pmh_RAW && c->pos >= c->end)
        {
            if (parent != NULL)
                parent->next = c->next;
            else
                head = c->next;
            parent = c;
            c = c->next;
            continue;
        }
        parent = c;
        c = c->next;
    }
    return head;
}

#if pmh_DEBUG_OUTPUT
/*
Print null-terminated string s.t. some characters are
represented by their corresponding espace sequences
*/
static void print_str_literal_escapes(char *str)
{
    char *c = str;
    pmh_PRINTF("'");
    while (*c != '\0')
    {
        if (*c == '\n')         pmh_PRINTF("\\n");
        else if (*c == '\t')    pmh_PRINTF("\\t");
        else putchar(*c);
        c++;
    }
    pmh_PRINTF("'");
}
#endif

#if pmh_DEBUG_OUTPUT
/*
Print elements in a linked list of
pmh_RAW, pmh_SEPARATOR, pmh_EXTRA_TEXT elements
*/
static void print_raw_spans_inline(pmh_realelement *elem)
{
    pmh_realelement *cur = elem;
    while (cur != NULL)
    {
        if (cur->type == pmh_SEPARATOR)
            pmh_PRINTF("<pmh_SEP %ld> ", cur->pos);
        else if (cur->type == pmh_EXTRA_TEXT) {
            pmh_PRINTF("{pmh_ETEXT ");
            print_str_literal_escapes(cur->text);
            pmh_PRINTF("}");
        }
        else
            pmh_PRINTF("(%ld-%ld) ", cur->pos, cur->end);
        cur = cur->next;
    }
}
#endif

/*
Perform postprocessing parsing runs for pmh_RAW_LIST elements in `elem`,
iteratively until no such elements exist.
*/
static void process_raw_blocks(parser_data *p_data)
{
    pmh_PRINTF("--------process_raw_blocks---------\n");
    while (p_data->head_elems[pmh_RAW_LIST] != NULL)
    {
        pmh_PRINTF("new iteration.\n");
        pmh_realelement *cursor = p_data->head_elems[pmh_RAW_LIST];
        p_data->head_elems[pmh_RAW_LIST] = NULL;
        while (cursor != NULL)
        {
            pmh_realelement *span_list = (pmh_realelement*)cursor->children;
            
            span_list = remove_zero_length_raw_spans(span_list);
            
            #if pmh_DEBUG_OUTPUT
            pmh_PRINTF("  process: ");
            print_raw_spans_inline(span_list);
            pmh_PRINTF("\n");
            #endif
            
            while (span_list != NULL)
            {
                pmh_PRINTF("next: span_list: %ld-%ld\n",
                           span_list->pos, span_list->end);
                
                // Skip separators in the beginning, as well as
                // separators after another separator:
                if (span_list->type == pmh_SEPARATOR) {
                    span_list = span_list->next;
                    continue;
                }
                
                // Store list of spans until next separator in subspan_list:
                pmh_realelement *subspan_list = span_list;
                pmh_realelement *previous = NULL;
                while (span_list != NULL && span_list->type != pmh_SEPARATOR) {
                    previous = span_list;
                    span_list = span_list->next;
                }
                if (span_list != NULL && span_list->type == pmh_SEPARATOR) {
                    span_list = span_list->next;
                    previous->next = NULL;
                }
                
                #if pmh_DEBUG_OUTPUT
                pmh_PRINTF("    subspan process: ");
                print_raw_spans_inline(subspan_list);
                pmh_PRINTF("\n");
                #endif
                
                // Process subspan_list:
                parser_data *raw_p_data = mk_parser_data(
                    p_data->original_input,
                    p_data->strip_positions,
                    p_data->strip_positions_len,
                    p_data->charbuf,
                    subspan_list,
                    subspan_list->pos,
                    p_data->extensions,
                    p_data->head_elems,
                    p_data->references
                );
                parse_markdown(raw_p_data);
                free(raw_p_data);
                
                pmh_PRINTF("parse over\n");
            }
            
            cursor = cursor->next;
        }
    }
}


#if pmh_DEBUG_OUTPUT
static void print_raw_blocks(char *text, pmh_realelement *elem[])
{
    pmh_PRINTF("--------print_raw_blocks---------\n");
    pmh_PRINTF("block:\n");
    pmh_realelement *cursor = elem[pmh_RAW_LIST];
    while (cursor != NULL)
    {
        print_raw_spans_inline(cursor->children);
        cursor = cursor->next;
    }
}
#endif




/* Free all elements created while parsing */
void pmh_free_elements(pmh_element **elems)
{
    pmh_realelement *cursor = (pmh_realelement*)elems[pmh_ALL];
    while (cursor != NULL) {
        pmh_realelement *tofree = cursor;
        cursor = cursor->all_elems_next;
        if (tofree->text != NULL)
            free(tofree->text);
        if (tofree->label != NULL)
            free(tofree->label);
        if (tofree->address != NULL)
            free(tofree->address);
        free(tofree);
    }
    elems[pmh_ALL] = NULL;
    
    free(elems);
}






#define IS_CONTINUATION_BYTE(x) ((x & 0xC0) == 0x80)
#define HAS_UTF8_BOM(x)         ( ((*x & 0xFF) == 0xEF)\
                                  && ((*(x+1) & 0xFF) == 0xBB)\
                                  && ((*(x+2) & 0xFF) == 0xBF) )
#define ADD_STRIP_POS(x) \
    /* reallocate more space for the array, if needed: */ \
    if (strip_positions_size <= strip_positions_pos) { \
        size_t new_size = strip_positions_size * 2; \
        unsigned long *new_arr = (unsigned long *) \
                                 calloc(new_size, \
                                        sizeof(unsigned long)); \
        memcpy(new_arr, strip_positions, \
               (sizeof(unsigned long) * strip_positions_size)); \
        strip_positions_size = new_size; \
        free(strip_positions); \
        strip_positions = new_arr; \
    } \
    strip_positions[strip_positions_pos] = x; \
    strip_positions_pos++;

/*
Copy `str` to `out`, while doing the following:
  - remove UTF-8 continuation bytes
  - remove possible UTF-8 BOM (byte order mark)
  - append two newlines to the end (like peg-markdown does)
  - keep track of which bytes we have stripped (in strip_positions)
*/
static int strcpy_preformat(char *str, char **out,
                            unsigned long **out_strip_positions,
                            size_t *out_strip_positions_len)
{
    size_t strip_positions_size = 1024;
    size_t strip_positions_pos = 0;
    unsigned long *strip_positions = (unsigned long *)
                                     calloc(strip_positions_size,
                                            sizeof(unsigned long));
    
    
    // +2 in the following is due to the "\n\n" suffix:
    char *new_str = (char *)malloc(sizeof(char) * strlen(str) + 1 + 2);
    char *c = str;
    int i = 0;
    
    if (HAS_UTF8_BOM(c)) {
        c += 3;
        ADD_STRIP_POS(0);
        ADD_STRIP_POS(1);
        ADD_STRIP_POS(2);
    }
    
    while (*c != '\0')
    {
        if (!IS_CONTINUATION_BYTE(*c)) {
            *(new_str+i) = *c, i++;
        } else {
            ADD_STRIP_POS((int)(c-str));
        }
        c++;
    }
    
    *(new_str+(i++)) = '\n';
    *(new_str+(i++)) = '\n';
    *(new_str+i) = '\0';
    
    *out = new_str;
    *out_strip_positions = strip_positions;
    *out_strip_positions_len = strip_positions_pos;
    return i;
}



void pmh_markdown_to_elements(char *text, int extensions,
                              pmh_element **out_result[])
{
    char *text_copy = NULL;
    unsigned long *strip_positions = NULL;
    size_t strip_positions_len = 0;
    int text_copy_len = strcpy_preformat(text, &text_copy, &strip_positions,
                                         &strip_positions_len);
    
    pmh_realelement *parsing_elem = (pmh_realelement *)
                                    malloc(sizeof(pmh_realelement));
    parsing_elem->type = pmh_RAW;
    parsing_elem->pos = 0;
    parsing_elem->end = text_copy_len;
    parsing_elem->next = NULL;
    
    parser_data *p_data = mk_parser_data(
        text,
        strip_positions,
        strip_positions_len,
        text_copy,
        parsing_elem,
        0,
        extensions,
        NULL,
        NULL
    );
    pmh_realelement **result = p_data->head_elems;
    
    if (*text_copy != '\0')
    {
        // Get reference definitions into p_data->references
        parse_references(p_data);
        
        // Reset parser state to beginning of input
        p_data->offset = 0;
        p_data->current_elem = p_data->elem_head;
        
        // Parse whole document
        parse_markdown(p_data);
        
        #if pmh_DEBUG_OUTPUT
        print_raw_blocks(text_copy, result);
        #endif
        
        process_raw_blocks(p_data);
    }
    
    free(strip_positions);
    free(p_data);
    free(parsing_elem);
    free(text_copy);
    
    *out_result = (pmh_element**)result;
}



/*
Mergesort linked list of elements (using comparison function `compare`),
return new head. (Adapted slightly from Simon Tatham's algorithm.)
*/
static pmh_element *ll_mergesort(pmh_element *list,
                                 int (*compare)(const pmh_element*,
                                                const pmh_element*))
{
    if (!list)
        return NULL;
    
    pmh_element *out_head = list;
    
    /* Merge widths of doubling size until done */
    int merge_width = 1;
    while (1)
    {
        pmh_element *l, *r; /* left & right segment pointers */
        pmh_element *tail = NULL; /* tail of sorted section */
        
        l = out_head;
        out_head = NULL;
        
        int merge_count = 0;
        
        while (l)
        {
            merge_count++;
            
            /* Position r, determine lsize & rsize */
            r = l;
            int lsize = 0;
            int i;
            for (i = 0; i < merge_width; i++) {
                lsize++;
                r = r->next;
                if (!r)
                    break;
            }
            int rsize = merge_width;
            
            /* Merge l & r */
            while (lsize > 0 || (rsize > 0 && r))
            {
                bool get_from_left = false;
                if (lsize == 0)             get_from_left = false;
                else if (rsize == 0 || !r)  get_from_left = true;
                else if (compare(l,r) <= 0) get_from_left = true;
                
                pmh_element *e;
                if (get_from_left) {
                    e = l; l = l->next; lsize--;
                } else {
                    e = r; r = r->next; rsize--;
                }
                
                /* add the next pmh_element to the merged list */
                if (tail)
                    tail->next = e;
                else
                    out_head = e;
                tail = e;
            }
            
            l = r;
        }
        tail->next = NULL;
        
        if (merge_count <= 1)
            return out_head;
        
        merge_width *= 2;
    }
}

static int elem_compare_by_pos(const pmh_element *a, const pmh_element *b)
{
    return a->pos - b->pos;
}

void pmh_sort_elements_by_pos(pmh_element *element_lists[])
{
    int i;
    for (i = 0; i < pmh_NUM_LANG_TYPES; i++)
        element_lists[i] = ll_mergesort(element_lists[i], &elem_compare_by_pos);
}








/* return true if extension is selected */
static bool extension(parser_data *p_data, int ext)
{
    return ((p_data->extensions & ext) != 0);
}

/* return reference pmh_realelement for a given label */
static pmh_realelement *get_reference(parser_data *p_data, char *label)
{
    if (!label)
        return NULL;
    
    pmh_realelement *cursor = p_data->references;
    while (cursor != NULL)
    {
        if (cursor->label && strcmp(label, cursor->label) == 0)
            return cursor;
        cursor = cursor->next;
    }
    return NULL;
}


/* cons an element/list onto a list, returning pointer to new head */
static pmh_realelement *cons(pmh_realelement *elem, pmh_realelement *list)
{
    assert(elem != NULL);
    
    pmh_realelement *cur = elem;
    while (cur->next != NULL) {
        cur = cur->next;
    }
    cur->next = list;
    
    return elem;
}


/* reverse a list, returning pointer to new list */
static pmh_realelement *reverse(pmh_realelement *list)
{
    pmh_realelement *new_head = NULL;
    pmh_realelement *next = NULL;
    while (list != NULL) {
        next = list->next;
        list->next = new_head;
        new_head = list;
        list = next;
    }
    return new_head;
}



/* construct pmh_realelement */
static pmh_realelement *mk_element(parser_data *p_data, pmh_element_type type,
                                   long pos, long end)
{
    pmh_realelement *result = (pmh_realelement *)malloc(sizeof(pmh_realelement));
    memset(result, 0, sizeof(*result));
    result->type = type;
    result->pos = pos;
    result->end = end;
    
    pmh_realelement *old_all_elements_head = p_data->head_elems[pmh_ALL];
    p_data->head_elems[pmh_ALL] = result;
    result->all_elems_next = old_all_elements_head;
    
    //pmh_PRINTF("  mk_element: %s [%ld - %ld]\n", pmh_element_name_from_type(type), pos, end);
    
    return result;
}

static pmh_realelement *copy_element(parser_data *p_data, pmh_realelement *elem)
{
    pmh_realelement *result = mk_element(p_data, elem->type, elem->pos, elem->end);
    result->label = strdup_or_null(elem->label);
    result->text = strdup_or_null(elem->text);
    result->address = strdup_or_null(elem->address);
    return result;
}

/* construct pmh_EXTRA_TEXT pmh_realelement */
static pmh_realelement *mk_etext(parser_data *p_data, char *string)
{
    pmh_realelement *result;
    assert(string != NULL);
    result = mk_element(p_data, pmh_EXTRA_TEXT, 0,0);
    result->text = strdup_or_null(string);
    return result;
}


/*
Given an element where the offsets {pos, end} represent
locations in the *parsed text* (defined by the linked list of pmh_RAW and
pmh_EXTRA_TEXT elements in p_data->current_elem), fix these offsets to represent
corresponding offsets in the parse buffer (p_data->charbuf). Also split
the given pmh_realelement into multiple parts if its offsets span multiple
p_data->current_elem elements. Return the (list of) elements with real offsets.
*/
static pmh_realelement *fix_offsets(parser_data *p_data, pmh_realelement *elem)
{
    if (elem->type == pmh_EXTRA_TEXT)
        return mk_etext(p_data, elem->text);
    
    pmh_realelement *new_head = copy_element(p_data, elem);
    
    pmh_realelement *tail = new_head;
    pmh_realelement *prev = NULL;
    
    bool found_start = false;
    bool found_end = false;
    bool tail_needs_pos = false;
    unsigned long previous_end = 0;
    unsigned long c = 0;
    
    pmh_realelement *cursor = p_data->elem_head;
    while (cursor != NULL)
    {
        int thislen = (cursor->type == pmh_EXTRA_TEXT)
                        ? strlen(cursor->text)
                        : cursor->end - cursor->pos;
        
        if (tail_needs_pos && cursor->type != pmh_EXTRA_TEXT) {
            tail->pos = cursor->pos;
            tail_needs_pos = false;
        }
        
        unsigned int this_pos = cursor->pos;
        
        if (!found_start && (c <= elem->pos && elem->pos <= c+thislen)) {
            tail->pos = (cursor->type == pmh_EXTRA_TEXT)
                        ? previous_end
                        : cursor->pos + (elem->pos - c);
            this_pos = tail->pos;
            found_start = true;
        }
        
        if (!found_end && (c <= elem->end && elem->end <= c+thislen)) {
            tail->end = (cursor->type == pmh_EXTRA_TEXT)
                        ? previous_end
                        : cursor->pos + (elem->end - c);
            found_end = true;
        }
        
        if (found_start && found_end)
            break;
        
        if (cursor->type != pmh_EXTRA_TEXT)
            previous_end = cursor->end;
        
        if (found_start) {
            pmh_realelement *new_elem = copy_element(p_data, tail);
            new_elem->pos = this_pos;
            new_elem->end = cursor->end;
            new_elem->next = tail;
            if (prev != NULL)
                prev->next = new_elem;
            if (new_head == tail)
                new_head = new_elem;
            prev = new_elem;
            tail_needs_pos = true;
        }
        
        c += thislen;
        cursor = cursor->next;
    }
    
    return new_head;
}



/* Add an element to p_data->head_elems. */
static void add(parser_data *p_data, pmh_realelement *elem)
{
    if (elem->type != pmh_RAW_LIST)
    {
        pmh_PRINTF("  add: %s [%ld - %ld]\n",
                   pmh_element_name_from_type(elem->type), elem->pos, elem->end);
        elem = fix_offsets(p_data, elem);
        pmh_PRINTF("     > %s [%ld - %ld]\n",
                   pmh_element_name_from_type(elem->type), elem->pos, elem->end);
    }
    else
    {
        pmh_PRINTF("  add: pmh_RAW_LIST ");
        pmh_realelement *cursor = elem->children;
        pmh_realelement *previous = NULL;
        while (cursor != NULL)
        {
            pmh_realelement *next = cursor->next;
            pmh_PRINTF("(%ld-%ld)>", cursor->pos, cursor->end);
            pmh_realelement *new_cursor = fix_offsets(p_data, cursor);
            if (previous != NULL)
                previous->next = new_cursor;
            else
                elem->children = new_cursor;
            pmh_PRINTF("(%ld-%ld)", new_cursor->pos, new_cursor->end);
            while (new_cursor->next != NULL) {
                new_cursor = new_cursor->next;
                pmh_PRINTF("(%ld-%ld)", new_cursor->pos, new_cursor->end);
            }
            pmh_PRINTF(" ");
            if (next != NULL)
                new_cursor->next = next;
            previous = new_cursor;
            cursor = next;
        }
        pmh_PRINTF("\n");
    }
    
    if (p_data->head_elems[elem->type] == NULL)
        p_data->head_elems[elem->type] = elem;
    else
    {
        pmh_realelement *last = elem;
        while (last->next != NULL)
            last = last->next;
        last->next = p_data->head_elems[elem->type];
        p_data->head_elems[elem->type] = elem;
    }
}


// Given a range in the list of spans we use for parsing (pos, end), return
// a copy of the corresponding section in the original input, with all of
// the UTF-8 bytes intact:
static char *copy_input_span(parser_data *p_data,
                             unsigned long pos, unsigned long end)
{
    if (end <= pos)
        return NULL;
    
    char *ret = NULL;
    
    // Adjust (pos,end) to match actual indexes in charbuf:
    pmh_realelement *dummy = mk_element(p_data, pmh_NO_TYPE, pos, end);
    pmh_realelement *fixed_dummies = fix_offsets(p_data, dummy);
    pmh_realelement *cursor = fixed_dummies;
    while (cursor != NULL)
    {
        if (cursor->end <= cursor->pos)
        {
            cursor = cursor->next;
            continue;
        }
        
        // Adjust cursor's span to take bytes stripped from the original
        // input into account (i.e. match the corresponding span in
        // p_data->original_input):
        unsigned long adjusted_pos = cursor->pos;
        unsigned long adjusted_end = cursor->end;
        size_t i;
        for (i = 0; i < p_data->strip_positions_len; i++)
        {
            unsigned long strip_position = p_data->strip_positions[i];
            if (strip_position <= adjusted_pos)
                adjusted_pos++;
            if (strip_position <= adjusted_end)
                adjusted_end++;
            else
                break;
        }
        
        // Copy span from original input:
        size_t adjusted_len = adjusted_end - adjusted_pos;
        char *str = (char *)malloc(sizeof(char)*adjusted_len + 1);
        *str = '\0';
        strncat(str, (p_data->original_input + adjusted_pos), adjusted_len);
        
        if (ret == NULL)
            ret = str;
        else
        {
            // append str to ret:
            char *new_ret = (char *)malloc(sizeof(char)
                                           *(strlen(str) + strlen(ret)) + 1);
            *new_ret = '\0';
            strcat(new_ret, ret);
            strcat(new_ret, str);
            free(ret);
            free(str);
            ret = new_ret;
        }
        
        cursor = cursor->next;
    }
    
    return ret;
}





# define YYSTYPE pmh_realelement *
#ifdef __DEBUG__
# define YY_DEBUG 1
#endif

#define YY_INPUT(buf, result, max_size)\
        yy_input_func(buf, &result, max_size, (parser_data *)G->data)

static void yy_input_func(char *buf, int *result, int max_size,
                          parser_data *p_data)
{
    if (p_data->current_elem == NULL)
    {
        (*result) = 0;
        return;
    }
    
    if (p_data->current_elem->type == pmh_EXTRA_TEXT)
    {
        int yyc;
        bool moreToRead = (p_data->current_elem->text
                           && *(p_data->current_elem->text
                                + p_data->current_elem->text_offset) != '\0');
        if (moreToRead)
        {
            yyc = *(p_data->current_elem->text + p_data->current_elem->text_offset++);
            pmh_PRINTF("\e[47;30m"); pmh_PUTCHAR(yyc); pmh_PRINTF("\e[0m");
            pmh_IF(yyc == '\n') pmh_PRINTF("\e[47m \e[0m");
        }
        else
        {
            yyc = EOF;
            p_data->current_elem = p_data->current_elem->next;
            pmh_PRINTF("\e[41m \e[0m");
            if (p_data->current_elem != NULL)
                p_data->offset = p_data->current_elem->pos;
        }
        (*result) = (EOF == yyc) ? 0 : (*(buf) = yyc, 1);
        return;
    }
    
    *(buf) = *(p_data->charbuf + p_data->offset);
    (*result) = (*buf != '\0');
    p_data->offset++;
    
    pmh_PRINTF("\e[43;30m"); pmh_PUTCHAR(*buf); pmh_PRINTF("\e[0m");
    pmh_IF(*buf == '\n') pmh_PRINTF("\e[42m \e[0m");
    
    if (p_data->offset >= p_data->current_elem->end)
    {
        p_data->current_elem = p_data->current_elem->next;
        pmh_PRINTF("\e[41m \e[0m");
        if (p_data->current_elem != NULL)
            p_data->offset = p_data->current_elem->pos;
    }
}



#define elem(x)     mk_element((parser_data *)G->data, x, thunk->begin, thunk->end)
#define elem_s(x)   mk_element((parser_data *)G->data, x, s->pos, thunk->end)
#define mk_sep      mk_element((parser_data *)G->data, pmh_SEPARATOR, 0,0)
#define mk_notype   mk_element((parser_data *)G->data, pmh_NO_TYPE, 0,0)
#define etext(x)    mk_etext((parser_data *)G->data, x)
#define ADD(x)      add((parser_data *)G->data, x)
#define EXT(x)      extension((parser_data *)G->data, x)
#define REF_EXISTS(x) reference_exists((parser_data *)G->data, x)
#define GET_REF(x)  get_reference((parser_data *)G->data, x)
#define PARSING_REFERENCES ((parser_data *)G->data)->parsing_only_references
#define FREE_LABEL(l) { free(l->label); l->label = NULL; }
#define FREE_ADDRESS(l) { free(l->address); l->address = NULL; }

// This gives us the text matched with < > as it appears in the original input:
#define COPY_YYTEXT_ORIG() copy_input_span((parser_data *)G->data, thunk->begin, thunk->end)

// pos is the postition of next char to parse after matching one $
// Do not allow $, digit, and \ before opening $
bool inline_equation_predict_pre(char *buf, int pos)
{
    if (pos < 2) {
        return true;
    }

    unsigned char ch = buf[pos - 2];
    return ch != '$' && (ch < '0' || ch > '9') && ch != '\\';
}

// Do not allow \, space before ending $
bool inline_equation_predict_post(char *buf, int pos)
{
    unsigned char ch = buf[pos - 2];
    return ch != '\\' && ch != ' ' && ch != '\t';
}

#define IEP_PRE         inline_equation_predict_pre(G->buf, G->pos)
#define IEP_POST        inline_equation_predict_post(G->buf, G->pos)

// Do not allow whitespace before ending ~~
bool strike_predict_post(char *buf, int pos)
{
    unsigned char ch = buf[pos - 1];
    return ch != '\n' && ch != '\r' && ch != ' ' && ch != '\t';
}

#define STRIKE_POST     strike_predict_post(G->buf, G->pos)

// Number of display formula raw opening
unsigned char nr_dfr = 0;

bool start_dfr()
{
    nr_dfr = 1;
    return true;
}

bool inc_dfr()
{
    ++nr_dfr;
    return true;
}

bool dec_dfr()
{
    --nr_dfr;
    return true;
}

bool nested_dfr()
{
    return nr_dfr > 1;
}


#ifndef YY_ALLOC
#define YY_ALLOC(N, D) malloc(N)
#endif
#ifndef YY_CALLOC
#define YY_CALLOC(N, S, D) calloc(N, S)
#endif
#ifndef YY_REALLOC
#define YY_REALLOC(B, N, D) realloc(B, N)
#endif
#ifndef YY_FREE
#define YY_FREE free
#endif
#ifndef YY_LOCAL
#define YY_LOCAL(T)     static T
#endif
#ifndef YY_ACTION
#define YY_ACTION(T)    static T
#endif
#ifndef YY_RULE
#define YY_RULE(T)      static T
#endif
#ifndef YY_PARSE
#define YY_PARSE(T)     T
#endif
#ifndef YY_NAME
#define YY_NAME(N) yy##N
#endif
#ifndef YY_INPUT
#define YY_INPUT(buf, result, max_size)                 \
  {                                                     \
    int yyc= getchar();                                 \
    result= (EOF == yyc) ? 0 : (*(buf)= yyc, 1);        \
    yyprintf((stderr, "<%c>", yyc));                  \
  }
#endif
#ifndef YY_BEGIN
#define YY_BEGIN        ( G->begin= G->pos, 1)
#endif
#ifndef YY_END
#define YY_END          ( G->end= G->pos, 1)
#endif
#ifdef YY_DEBUG
# define yyprintf(args) fprintf args
#else
# define yyprintf(args)
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
#ifndef YY_XTYPE
#define YY_XTYPE void *
#endif
#ifndef YY_XVAR
#define YY_XVAR yyxvar
#endif

#ifndef YY_STACK_SIZE
#define YY_STACK_SIZE 128
#endif

#ifndef YY_BUFFER_START_SIZE
#define YY_BUFFER_START_SIZE 1024
#endif

#ifndef YY_PART
#define yydata G->data
#define yy G->ss

struct _yythunk; // forward declaration
typedef void (*yyaction)(struct _GREG *G, char *yytext, int yyleng, struct _yythunk *thunkpos, YY_XTYPE YY_XVAR);
typedef struct _yythunk { int begin, end;  yyaction  action;  struct _yythunk *next; } yythunk;

typedef struct _GREG {
  char *buf;
  int buflen;
  int   offset;
  int   pos;
  int   limit;
  char *text;
  int   textlen;
  int   begin;
  int   end;
  yythunk *thunks;
  int   thunkslen;
  int thunkpos;
  YYSTYPE ss;
  YYSTYPE *val;
  YYSTYPE *vals;
  int valslen;
  YY_XTYPE data;
} GREG;

YY_LOCAL(int) yyrefill(GREG *G)
{
  int yyn;
  while (G->buflen - G->pos < 512)
    {
      G->buflen *= 2;
      G->buf= (char *)YY_REALLOC(G->buf, G->buflen, G->data);
    }
  YY_INPUT((G->buf + G->pos), yyn, (G->buflen - G->pos));
  if (!yyn) return 0;
  G->limit += yyn;
  return 1;
}

YY_LOCAL(int) yymatchDot(GREG *G)
{
  if (G->pos >= G->limit && !yyrefill(G)) return 0;
  ++G->pos;
  return 1;
}

YY_LOCAL(int) yymatchChar(GREG *G, int c)
{
  if (G->pos >= G->limit && !yyrefill(G)) return 0;
  if ((unsigned char)G->buf[G->pos] == c)
    {
      ++G->pos;
      yyprintf((stderr, "  ok   yymatchChar(%c) @ %s\n", c, G->buf+G->pos));
      return 1;
    }
  yyprintf((stderr, "  fail yymatchChar(%c) @ %s\n", c, G->buf+G->pos));
  return 0;
}

YY_LOCAL(int) yymatchString(GREG *G, char *s)
{
  int yysav= G->pos;
  while (*s)
    {
      if (G->pos >= G->limit && !yyrefill(G)) return 0;
      if (G->buf[G->pos] != *s)
        {
          G->pos= yysav;
          return 0;
        }
      ++s;
      ++G->pos;
    }
  return 1;
}

YY_LOCAL(int) yymatchClass(GREG *G, unsigned char *bits)
{
  int c;
  if (G->pos >= G->limit && !yyrefill(G)) return 0;
  c= (unsigned char)G->buf[G->pos];
  if (bits[c >> 3] & (1 << (c & 7)))
    {
      ++G->pos;
      yyprintf((stderr, "  ok   yymatchClass @ %s\n", G->buf+G->pos));
      return 1;
    }
  yyprintf((stderr, "  fail yymatchClass @ %s\n", G->buf+G->pos));
  return 0;
}

YY_LOCAL(void) yyDo(GREG *G, yyaction action, int begin, int end)
{
  while (G->thunkpos >= G->thunkslen)
    {
      G->thunkslen *= 2;
      G->thunks= (yythunk *)YY_REALLOC(G->thunks, sizeof(yythunk) * G->thunkslen, G->data);
    }
  G->thunks[G->thunkpos].begin=  begin;
  G->thunks[G->thunkpos].end=    end;
  G->thunks[G->thunkpos].action= action;
  ++G->thunkpos;
}

YY_LOCAL(int) yyText(GREG *G, int begin, int end)
{
  int yyleng= end - begin;
  if (yyleng <= 0)
    yyleng= 0;
  else
    {
      while (G->textlen < (yyleng + 1))
        {
          G->textlen *= 2;
          G->text= (char *)YY_REALLOC(G->text, G->textlen, G->data);
        }
      memcpy(G->text, G->buf + begin, yyleng);
    }
  G->text[yyleng]= '\0';
  return yyleng;
}

YY_LOCAL(void) yyDone(GREG *G)
{
  int pos;
  for (pos= 0; pos < G->thunkpos; ++pos)
    {
      yythunk *thunk= &G->thunks[pos];
      int yyleng= thunk->end ? yyText(G, thunk->begin, thunk->end) : thunk->begin;
      yyprintf((stderr, "DO [%d] %p %s\n", pos, thunk->action, G->text));
      thunk->action(G, G->text, yyleng, thunk, G->data);
    }
  G->thunkpos= 0;
}

YY_LOCAL(void) yyCommit(GREG *G)
{
  if ((G->limit -= G->pos))
    {
      memmove(G->buf, G->buf + G->pos, G->limit);
    }
  G->offset += G->pos;
  G->begin -= G->pos;
  G->end -= G->pos;
  G->pos= G->thunkpos= 0;
}

YY_LOCAL(int) yyAccept(GREG *G, int tp0)
{
  if (tp0)
    {
      fprintf(stderr, "accept denied at %d\n", tp0);
      return 0;
    }
  else
    {
      yyDone(G);
      yyCommit(G);
    }
  return 1;
}

YY_LOCAL(void) yyPush(GREG *G, char *text, int count, yythunk *thunk, YY_XTYPE YY_XVAR) { G->val += count; }
YY_LOCAL(void) yyPop(GREG *G, char *text, int count, yythunk *thunk, YY_XTYPE YY_XVAR)  { G->val -= count; }
YY_LOCAL(void) yySet(GREG *G, char *text, int count, yythunk *thunk, YY_XTYPE YY_XVAR)  { G->val[count]= G->ss; }

#endif /* YY_PART */

#define YYACCEPT        yyAccept(G, yythunkpos0)

YY_RULE(int) yy_RawNoteBlock(GREG *G); /* 269 */
YY_RULE(int) yy_RawNoteReference(GREG *G); /* 268 */
YY_RULE(int) yy_AlphanumericAscii(GREG *G); /* 267 */
YY_RULE(int) yy_Quoted(GREG *G); /* 266 */
YY_RULE(int) yy_HtmlTag(GREG *G); /* 265 */
YY_RULE(int) yy_MarkTagClose(GREG *G); /* 264 */
YY_RULE(int) yy_MarkTagText(GREG *G); /* 263 */
YY_RULE(int) yy_MarkTagOpen(GREG *G); /* 262 */
YY_RULE(int) yy_Ticks5(GREG *G); /* 261 */
YY_RULE(int) yy_Ticks4(GREG *G); /* 260 */
YY_RULE(int) yy_Ticks3(GREG *G); /* 259 */
YY_RULE(int) yy_Ticks2(GREG *G); /* 258 */
YY_RULE(int) yy_Ticks1(GREG *G); /* 257 */
YY_RULE(int) yy_SkipBlock(GREG *G); /* 256 */
YY_RULE(int) yy_References(GREG *G); /* 255 */
YY_RULE(int) yy_EmptyTitle(GREG *G); /* 254 */
YY_RULE(int) yy_RefTitleParens(GREG *G); /* 253 */
YY_RULE(int) yy_RefTitleDouble(GREG *G); /* 252 */
YY_RULE(int) yy_RefTitleSingle(GREG *G); /* 251 */
YY_RULE(int) yy_LabelInline(GREG *G); /* 250 */
YY_RULE(int) yy_RefTitle(GREG *G); /* 249 */
YY_RULE(int) yy_RefSrc(GREG *G); /* 248 */
YY_RULE(int) yy_AutoLinkEmail(GREG *G); /* 247 */
YY_RULE(int) yy_AutoLinkUrl(GREG *G); /* 246 */
YY_RULE(int) yy_ImageSizeHeight(GREG *G); /* 245 */
YY_RULE(int) yy_ImageSizeWidth(GREG *G); /* 244 */
YY_RULE(int) yy_ImageSizeComplete(GREG *G); /* 243 */
YY_RULE(int) yy_TitleDoubleExt(GREG *G); /* 242 */
YY_RULE(int) yy_TitleSingleExt(GREG *G); /* 241 */
YY_RULE(int) yy_TitleDouble(GREG *G); /* 240 */
YY_RULE(int) yy_TitleSingle(GREG *G); /* 239 */
YY_RULE(int) yy_SourceContents(GREG *G); /* 238 */
YY_RULE(int) yy_ImageSize(GREG *G); /* 237 */
YY_RULE(int) yy_TitleExt(GREG *G); /* 236 */
YY_RULE(int) yy_Title(GREG *G); /* 235 */
YY_RULE(int) yy_Source(GREG *G); /* 234 */
YY_RULE(int) yy_Label(GREG *G); /* 233 */
YY_RULE(int) yy_ReferenceLinkSingle(GREG *G); /* 232 */
YY_RULE(int) yy_ReferenceLinkDouble(GREG *G); /* 231 */
YY_RULE(int) yy_AutoLink(GREG *G); /* 230 */
YY_RULE(int) yy_ReferenceLink(GREG *G); /* 229 */
YY_RULE(int) yy_ExplicitLinkSize(GREG *G); /* 228 */
YY_RULE(int) yy_ExplicitLink(GREG *G); /* 227 */
YY_RULE(int) yy_StrongUl(GREG *G); /* 226 */
YY_RULE(int) yy_StrongStar(GREG *G); /* 225 */
YY_RULE(int) yy_Whitespace(GREG *G); /* 224 */
YY_RULE(int) yy_EmphUl(GREG *G); /* 223 */
YY_RULE(int) yy_EmphStar(GREG *G); /* 222 */
YY_RULE(int) yy_StarLine(GREG *G); /* 221 */
YY_RULE(int) yy_UlLine(GREG *G); /* 220 */
YY_RULE(int) yy_SpecialChar(GREG *G); /* 219 */
YY_RULE(int) yy_Eof(GREG *G); /* 218 */
YY_RULE(int) yy_NormalEndline(GREG *G); /* 217 */
YY_RULE(int) yy_TerminalEndline(GREG *G); /* 216 */
YY_RULE(int) yy_LineBreak(GREG *G); /* 215 */
YY_RULE(int) yy_CharEntity(GREG *G); /* 214 */
YY_RULE(int) yy_DecEntity(GREG *G); /* 213 */
YY_RULE(int) yy_HexEntity(GREG *G); /* 212 */
YY_RULE(int) yy_ExtendedSpecialChar(GREG *G); /* 211 */
YY_RULE(int) yy_Alphanumeric(GREG *G); /* 210 */
YY_RULE(int) yy_NormalChar(GREG *G); /* 209 */
YY_RULE(int) yy_Symbol(GREG *G); /* 208 */
YY_RULE(int) yy_EscapedChar(GREG *G); /* 207 */
YY_RULE(int) yy_Entity(GREG *G); /* 206 */
YY_RULE(int) yy_RawHtml(GREG *G); /* 205 */
YY_RULE(int) yy_Mark(GREG *G); /* 204 */
YY_RULE(int) yy_Code(GREG *G); /* 203 */
YY_RULE(int) yy_InlineNote(GREG *G); /* 202 */
YY_RULE(int) yy_NoteReference(GREG *G); /* 201 */
YY_RULE(int) yy_Link(GREG *G); /* 200 */
YY_RULE(int) yy_Image(GREG *G); /* 199 */
YY_RULE(int) yy_Strike(GREG *G); /* 198 */
YY_RULE(int) yy_Emph(GREG *G); /* 197 */
YY_RULE(int) yy_Strong(GREG *G); /* 196 */
YY_RULE(int) yy_UlOrStarLine(GREG *G); /* 195 */
YY_RULE(int) yy_Str(GREG *G); /* 194 */
YY_RULE(int) yy_InStyleTags(GREG *G); /* 193 */
YY_RULE(int) yy_StyleClose(GREG *G); /* 192 */
YY_RULE(int) yy_StyleOpen(GREG *G); /* 191 */
YY_RULE(int) yy_HtmlBlockType(GREG *G); /* 190 */
YY_RULE(int) yy_HtmlBlockSelfClosing(GREG *G); /* 189 */
YY_RULE(int) yy_HtmlComment(GREG *G); /* 188 */
YY_RULE(int) yy_HtmlBlockInTags(GREG *G); /* 187 */
YY_RULE(int) yy_HtmlBlockHead(GREG *G); /* 186 */
YY_RULE(int) yy_HtmlBlockCloseHead(GREG *G); /* 185 */
YY_RULE(int) yy_HtmlBlockOpenHead(GREG *G); /* 184 */
YY_RULE(int) yy_HtmlBlockScript(GREG *G); /* 183 */
YY_RULE(int) yy_HtmlBlockCloseScript(GREG *G); /* 182 */
YY_RULE(int) yy_HtmlBlockOpenScript(GREG *G); /* 181 */
YY_RULE(int) yy_HtmlBlockTr(GREG *G); /* 180 */
YY_RULE(int) yy_HtmlBlockCloseTr(GREG *G); /* 179 */
YY_RULE(int) yy_HtmlBlockOpenTr(GREG *G); /* 178 */
YY_RULE(int) yy_HtmlBlockThead(GREG *G); /* 177 */
YY_RULE(int) yy_HtmlBlockCloseThead(GREG *G); /* 176 */
YY_RULE(int) yy_HtmlBlockOpenThead(GREG *G); /* 175 */
YY_RULE(int) yy_HtmlBlockTh(GREG *G); /* 174 */
YY_RULE(int) yy_HtmlBlockCloseTh(GREG *G); /* 173 */
YY_RULE(int) yy_HtmlBlockOpenTh(GREG *G); /* 172 */
YY_RULE(int) yy_HtmlBlockTfoot(GREG *G); /* 171 */
YY_RULE(int) yy_HtmlBlockCloseTfoot(GREG *G); /* 170 */
YY_RULE(int) yy_HtmlBlockOpenTfoot(GREG *G); /* 169 */
YY_RULE(int) yy_HtmlBlockTd(GREG *G); /* 168 */
YY_RULE(int) yy_HtmlBlockCloseTd(GREG *G); /* 167 */
YY_RULE(int) yy_HtmlBlockOpenTd(GREG *G); /* 166 */
YY_RULE(int) yy_HtmlBlockTbody(GREG *G); /* 165 */
YY_RULE(int) yy_HtmlBlockCloseTbody(GREG *G); /* 164 */
YY_RULE(int) yy_HtmlBlockOpenTbody(GREG *G); /* 163 */
YY_RULE(int) yy_HtmlBlockLi(GREG *G); /* 162 */
YY_RULE(int) yy_HtmlBlockCloseLi(GREG *G); /* 161 */
YY_RULE(int) yy_HtmlBlockOpenLi(GREG *G); /* 160 */
YY_RULE(int) yy_HtmlBlockFrameset(GREG *G); /* 159 */
YY_RULE(int) yy_HtmlBlockCloseFrameset(GREG *G); /* 158 */
YY_RULE(int) yy_HtmlBlockOpenFrameset(GREG *G); /* 157 */
YY_RULE(int) yy_HtmlBlockDt(GREG *G); /* 156 */
YY_RULE(int) yy_HtmlBlockCloseDt(GREG *G); /* 155 */
YY_RULE(int) yy_HtmlBlockOpenDt(GREG *G); /* 154 */
YY_RULE(int) yy_HtmlBlockDd(GREG *G); /* 153 */
YY_RULE(int) yy_HtmlBlockCloseDd(GREG *G); /* 152 */
YY_RULE(int) yy_HtmlBlockOpenDd(GREG *G); /* 151 */
YY_RULE(int) yy_HtmlBlockUl(GREG *G); /* 150 */
YY_RULE(int) yy_HtmlBlockCloseUl(GREG *G); /* 149 */
YY_RULE(int) yy_HtmlBlockOpenUl(GREG *G); /* 148 */
YY_RULE(int) yy_HtmlBlockTable(GREG *G); /* 147 */
YY_RULE(int) yy_HtmlBlockCloseTable(GREG *G); /* 146 */
YY_RULE(int) yy_HtmlBlockOpenTable(GREG *G); /* 145 */
YY_RULE(int) yy_HtmlBlockPre(GREG *G); /* 144 */
YY_RULE(int) yy_HtmlBlockClosePre(GREG *G); /* 143 */
YY_RULE(int) yy_HtmlBlockOpenPre(GREG *G); /* 142 */
YY_RULE(int) yy_HtmlBlockP(GREG *G); /* 141 */
YY_RULE(int) yy_HtmlBlockCloseP(GREG *G); /* 140 */
YY_RULE(int) yy_HtmlBlockOpenP(GREG *G); /* 139 */
YY_RULE(int) yy_HtmlBlockOl(GREG *G); /* 138 */
YY_RULE(int) yy_HtmlBlockCloseOl(GREG *G); /* 137 */
YY_RULE(int) yy_HtmlBlockOpenOl(GREG *G); /* 136 */
YY_RULE(int) yy_HtmlBlockNoscript(GREG *G); /* 135 */
YY_RULE(int) yy_HtmlBlockCloseNoscript(GREG *G); /* 134 */
YY_RULE(int) yy_HtmlBlockOpenNoscript(GREG *G); /* 133 */
YY_RULE(int) yy_HtmlBlockNoframes(GREG *G); /* 132 */
YY_RULE(int) yy_HtmlBlockCloseNoframes(GREG *G); /* 131 */
YY_RULE(int) yy_HtmlBlockOpenNoframes(GREG *G); /* 130 */
YY_RULE(int) yy_HtmlBlockMenu(GREG *G); /* 129 */
YY_RULE(int) yy_HtmlBlockCloseMenu(GREG *G); /* 128 */
YY_RULE(int) yy_HtmlBlockOpenMenu(GREG *G); /* 127 */
YY_RULE(int) yy_HtmlBlockH6(GREG *G); /* 126 */
YY_RULE(int) yy_HtmlBlockCloseH6(GREG *G); /* 125 */
YY_RULE(int) yy_HtmlBlockOpenH6(GREG *G); /* 124 */
YY_RULE(int) yy_HtmlBlockH5(GREG *G); /* 123 */
YY_RULE(int) yy_HtmlBlockCloseH5(GREG *G); /* 122 */
YY_RULE(int) yy_HtmlBlockOpenH5(GREG *G); /* 121 */
YY_RULE(int) yy_HtmlBlockH4(GREG *G); /* 120 */
YY_RULE(int) yy_HtmlBlockCloseH4(GREG *G); /* 119 */
YY_RULE(int) yy_HtmlBlockOpenH4(GREG *G); /* 118 */
YY_RULE(int) yy_HtmlBlockH3(GREG *G); /* 117 */
YY_RULE(int) yy_HtmlBlockCloseH3(GREG *G); /* 116 */
YY_RULE(int) yy_HtmlBlockOpenH3(GREG *G); /* 115 */
YY_RULE(int) yy_HtmlBlockH2(GREG *G); /* 114 */
YY_RULE(int) yy_HtmlBlockCloseH2(GREG *G); /* 113 */
YY_RULE(int) yy_HtmlBlockOpenH2(GREG *G); /* 112 */
YY_RULE(int) yy_HtmlBlockH1(GREG *G); /* 111 */
YY_RULE(int) yy_HtmlBlockCloseH1(GREG *G); /* 110 */
YY_RULE(int) yy_HtmlBlockOpenH1(GREG *G); /* 109 */
YY_RULE(int) yy_HtmlBlockForm(GREG *G); /* 108 */
YY_RULE(int) yy_HtmlBlockCloseForm(GREG *G); /* 107 */
YY_RULE(int) yy_HtmlBlockOpenForm(GREG *G); /* 106 */
YY_RULE(int) yy_HtmlBlockFieldset(GREG *G); /* 105 */
YY_RULE(int) yy_HtmlBlockCloseFieldset(GREG *G); /* 104 */
YY_RULE(int) yy_HtmlBlockOpenFieldset(GREG *G); /* 103 */
YY_RULE(int) yy_HtmlBlockDl(GREG *G); /* 102 */
YY_RULE(int) yy_HtmlBlockCloseDl(GREG *G); /* 101 */
YY_RULE(int) yy_HtmlBlockOpenDl(GREG *G); /* 100 */
YY_RULE(int) yy_HtmlBlockDiv(GREG *G); /* 99 */
YY_RULE(int) yy_HtmlBlockCloseDiv(GREG *G); /* 98 */
YY_RULE(int) yy_HtmlBlockOpenDiv(GREG *G); /* 97 */
YY_RULE(int) yy_HtmlBlockDir(GREG *G); /* 96 */
YY_RULE(int) yy_HtmlBlockCloseDir(GREG *G); /* 95 */
YY_RULE(int) yy_HtmlBlockOpenDir(GREG *G); /* 94 */
YY_RULE(int) yy_HtmlBlockCenter(GREG *G); /* 93 */
YY_RULE(int) yy_HtmlBlockCloseCenter(GREG *G); /* 92 */
YY_RULE(int) yy_HtmlBlockOpenCenter(GREG *G); /* 91 */
YY_RULE(int) yy_HtmlBlockBlockquote(GREG *G); /* 90 */
YY_RULE(int) yy_HtmlBlockCloseBlockquote(GREG *G); /* 89 */
YY_RULE(int) yy_HtmlBlockOpenBlockquote(GREG *G); /* 88 */
YY_RULE(int) yy_HtmlBlockAddress(GREG *G); /* 87 */
YY_RULE(int) yy_HtmlBlockCloseAddress(GREG *G); /* 86 */
YY_RULE(int) yy_HtmlAttribute(GREG *G); /* 85 */
YY_RULE(int) yy_HtmlBlockOpenAddress(GREG *G); /* 84 */
YY_RULE(int) yy_OptionallyIndentedLine(GREG *G); /* 83 */
YY_RULE(int) yy_Indent(GREG *G); /* 82 */
YY_RULE(int) yy_ListBlockLine(GREG *G); /* 81 */
YY_RULE(int) yy_ListContinuationBlock(GREG *G); /* 80 */
YY_RULE(int) yy_ListBlock(GREG *G); /* 79 */
YY_RULE(int) yy_ListItem(GREG *G); /* 78 */
YY_RULE(int) yy_Enumerator(GREG *G); /* 77 */
YY_RULE(int) yy_ListItemTight(GREG *G); /* 76 */
YY_RULE(int) yy_ListLoose(GREG *G); /* 75 */
YY_RULE(int) yy_ListTight(GREG *G); /* 74 */
YY_RULE(int) yy_Bullet(GREG *G); /* 73 */
YY_RULE(int) yy_TableCell(GREG *G); /* 72 */
YY_RULE(int) yy_TableBorder(GREG *G); /* 71 */
YY_RULE(int) yy_TableLine(GREG *G); /* 70 */
YY_RULE(int) yy_TableDelimiter(GREG *G); /* 69 */
YY_RULE(int) yy_TableHeader(GREG *G); /* 68 */
YY_RULE(int) yy_InlineEquationMultiple(GREG *G); /* 67 */
YY_RULE(int) yy_InlineEquationSingle(GREG *G); /* 66 */
YY_RULE(int) yy_InlineEquation(GREG *G); /* 65 */
YY_RULE(int) yy_Nonspacechar(GREG *G); /* 64 */
YY_RULE(int) yy_DisplayFormulaRawMark(GREG *G); /* 63 */
YY_RULE(int) yy_DisplayFormulaRawEnd(GREG *G); /* 62 */
YY_RULE(int) yy_Spnl(GREG *G); /* 61 */
YY_RULE(int) yy_DisplayFormulaRawStart(GREG *G); /* 60 */
YY_RULE(int) yy_FormulaNumber(GREG *G); /* 59 */
YY_RULE(int) yy_DisplayFormulaDollarMark(GREG *G); /* 58 */
YY_RULE(int) yy_DisplayFormulaRaw(GREG *G); /* 57 */
YY_RULE(int) yy_DisplayFormulaDollar(GREG *G); /* 56 */
YY_RULE(int) yy_FencedCodeBlockTidle(GREG *G); /* 55 */
YY_RULE(int) yy_FencedCodeBlockTick(GREG *G); /* 54 */
YY_RULE(int) yy_FencedCodeBlockEndTidle(GREG *G); /* 53 */
YY_RULE(int) yy_FencedCodeBlockChunkTidle(GREG *G); /* 52 */
YY_RULE(int) yy_FencedCodeBlockStartTidleLine(GREG *G); /* 51 */
YY_RULE(int) yy_FencedCodeBlockStartTidle(GREG *G); /* 50 */
YY_RULE(int) yy_Spacechar(GREG *G); /* 49 */
YY_RULE(int) yy_FencedCodeBlockEndTick(GREG *G); /* 48 */
YY_RULE(int) yy_FencedCodeBlockChunkTick(GREG *G); /* 47 */
YY_RULE(int) yy_FencedCodeBlockStartTickLine(GREG *G); /* 46 */
YY_RULE(int) yy_FencedCodeBlockStartTick(GREG *G); /* 45 */
YY_RULE(int) yy_VerbatimChunk(GREG *G); /* 44 */
YY_RULE(int) yy_IndentedLine(GREG *G); /* 43 */
YY_RULE(int) yy_NonblankIndentedLine(GREG *G); /* 42 */
YY_RULE(int) yy_Line(GREG *G); /* 41 */
YY_RULE(int) yy_StartList(GREG *G); /* 40 */
YY_RULE(int) yy_BlockQuoteRaw(GREG *G); /* 39 */
YY_RULE(int) yy_Endline(GREG *G); /* 38 */
YY_RULE(int) yy_RawLine(GREG *G); /* 37 */
YY_RULE(int) yy_SetextBottom2(GREG *G); /* 36 */
YY_RULE(int) yy_SetextBottom1(GREG *G); /* 35 */
YY_RULE(int) yy_SetextHeading2(GREG *G); /* 34 */
YY_RULE(int) yy_SetextHeading1(GREG *G); /* 33 */
YY_RULE(int) yy_SetextHeading(GREG *G); /* 32 */
YY_RULE(int) yy_Space(GREG *G); /* 31 */
YY_RULE(int) yy_AtxHeading(GREG *G); /* 30 */
YY_RULE(int) yy_AtxStart(GREG *G); /* 29 */
YY_RULE(int) yy_Inline(GREG *G); /* 28 */
YY_RULE(int) yy_Sp(GREG *G); /* 27 */
YY_RULE(int) yy_AtxInline(GREG *G); /* 26 */
YY_RULE(int) yy_Inlines(GREG *G); /* 25 */
YY_RULE(int) yy_NonindentSpace(GREG *G); /* 24 */
YY_RULE(int) yy_Plain(GREG *G); /* 23 */
YY_RULE(int) yy_Para(GREG *G); /* 22 */
YY_RULE(int) yy_StyleBlock(GREG *G); /* 21 */
YY_RULE(int) yy_HtmlBlock(GREG *G); /* 20 */
YY_RULE(int) yy_Table(GREG *G); /* 19 */
YY_RULE(int) yy_BulletList(GREG *G); /* 18 */
YY_RULE(int) yy_OrderedList(GREG *G); /* 17 */
YY_RULE(int) yy_Heading(GREG *G); /* 16 */
YY_RULE(int) yy_HorizontalRule(GREG *G); /* 15 */
YY_RULE(int) yy_Reference(GREG *G); /* 14 */
YY_RULE(int) yy_Note(GREG *G); /* 13 */
YY_RULE(int) yy_DisplayFormula(GREG *G); /* 12 */
YY_RULE(int) yy_FencedCodeBlock(GREG *G); /* 11 */
YY_RULE(int) yy_Verbatim(GREG *G); /* 10 */
YY_RULE(int) yy_BlockQuote(GREG *G); /* 9 */
YY_RULE(int) yy_BlankLine(GREG *G); /* 8 */
YY_RULE(int) yy_FrontMatterEndMark(GREG *G); /* 7 */
YY_RULE(int) yy_FrontMatterBlock(GREG *G); /* 6 */
YY_RULE(int) yy_Newline(GREG *G); /* 5 */
YY_RULE(int) yy_LocMarker(GREG *G); /* 4 */
YY_RULE(int) yy_Block(GREG *G); /* 3 */
YY_RULE(int) yy_FrontMatter(GREG *G); /* 2 */
YY_RULE(int) yy_Doc(GREG *G); /* 1 */

YY_ACTION(void) yy_1_InlineNote(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_InlineNote\n"));
   ADD(elem_s(pmh_NOTE)); ;
#undef s
}
YY_ACTION(void) yy_1_Note(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_Note\n"));
   ADD(elem_s(pmh_NOTE)); ;
#undef s
}
YY_ACTION(void) yy_1_NoteReference(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_NoteReference\n"));
   ADD(elem(pmh_NOTE)); ;
}
YY_ACTION(void) yy_1_RawLine(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_RawLine\n"));
   yy = elem(pmh_RAW); ;
}
YY_ACTION(void) yy_1_Line(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Line\n"));
   yy = mk_element((parser_data *)G->data, pmh_RAW, yy->pos, yy->end); ;
}
YY_ACTION(void) yy_1_StartList(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_StartList\n"));
   yy = NULL; ;
}
YY_ACTION(void) yy_1_HtmlComment(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_HtmlComment\n"));
   ADD(elem_s(pmh_COMMENT)); ;
#undef s
}
YY_ACTION(void) yy_1_RawHtml(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_RawHtml\n"));
   ADD(elem_s(pmh_HTML)); ;
#undef s
}
YY_ACTION(void) yy_1_MarkTagClose(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_MarkTagClose\n"));
   yy = elem_s(pmh_HTML); ;
#undef s
}
YY_ACTION(void) yy_1_MarkTagOpen(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_MarkTagOpen\n"));
   yy = elem_s(pmh_HTML); ;
#undef s
}
YY_ACTION(void) yy_1_Mark(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define c G->val[-1]
#define o G->val[-2]
  yyprintf((stderr, "do yy_1_Mark\n"));
  
         ADD(o);
         ADD(mk_element((parser_data *)G->data, pmh_MARK, o->end, c->pos));
         ADD(c);
       ;
#undef c
#undef o
}
YY_ACTION(void) yy_1_Code(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_Code\n"));
   ADD(elem_s(pmh_CODE)); ;
#undef s
}
YY_ACTION(void) yy_1_Ticks5(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Ticks5\n"));
   yy = elem(pmh_NO_TYPE); ;
}
YY_ACTION(void) yy_1_Ticks4(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Ticks4\n"));
   yy = elem(pmh_NO_TYPE); ;
}
YY_ACTION(void) yy_1_Ticks3(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Ticks3\n"));
   yy = elem(pmh_NO_TYPE); ;
}
YY_ACTION(void) yy_1_Ticks2(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Ticks2\n"));
   yy = elem(pmh_NO_TYPE); ;
}
YY_ACTION(void) yy_1_Ticks1(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Ticks1\n"));
   yy = elem(pmh_NO_TYPE); ;
}
YY_ACTION(void) yy_1_RefSrc(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_RefSrc\n"));
   yy = mk_notype; yy->address = COPY_YYTEXT_ORIG(); ;
}
YY_ACTION(void) yy_2_Label(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_2_Label\n"));
  
            s->pos = s->pos;
            s->end = thunk->end;
            yy = s;
        ;
#undef s
}
YY_ACTION(void) yy_1_Label(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_Label\n"));
   s->label = COPY_YYTEXT_ORIG(); ;
#undef s
}
YY_ACTION(void) yy_1_Reference(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define r G->val[-1]
#define l G->val[-2]
#define s G->val[-3]
  yyprintf((stderr, "do yy_1_Reference\n"));
  
                pmh_realelement *el = elem_s(pmh_REFERENCE);
                el->label = strdup_or_null(l->label);
                el->address = strdup_or_null(r->address);
                ADD(el);
                FREE_LABEL(l);
                FREE_ADDRESS(r);
              ;
#undef r
#undef l
#undef s
}
YY_ACTION(void) yy_3_AutoLinkEmail(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_3_AutoLinkEmail\n"));
  
                s->end = thunk->end;
                ADD(s);
               ;
#undef s
}
YY_ACTION(void) yy_2_AutoLinkEmail(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_2_AutoLinkEmail\n"));
   s->address = COPY_YYTEXT_ORIG(); ;
#undef s
}
YY_ACTION(void) yy_1_AutoLinkEmail(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_AutoLinkEmail\n"));
   s->type = pmh_AUTO_LINK_EMAIL; ;
#undef s
}
YY_ACTION(void) yy_3_AutoLinkUrl(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_3_AutoLinkUrl\n"));
  
                s->end = thunk->end;
                ADD(s);
               ;
#undef s
}
YY_ACTION(void) yy_2_AutoLinkUrl(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_2_AutoLinkUrl\n"));
   s->address = COPY_YYTEXT_ORIG(); ;
#undef s
}
YY_ACTION(void) yy_1_AutoLinkUrl(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_AutoLinkUrl\n"));
   s->type = pmh_AUTO_LINK_URL; ;
#undef s
}
YY_ACTION(void) yy_3_Source(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_3_Source\n"));
   yy->address = COPY_YYTEXT_ORIG(); ;
}
YY_ACTION(void) yy_2_Source(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_2_Source\n"));
   yy->address = COPY_YYTEXT_ORIG(); ;
}
YY_ACTION(void) yy_1_Source(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Source\n"));
   yy = mk_notype; ;
}
YY_ACTION(void) yy_1_ExplicitLinkSize(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define l G->val[-1]
#define s G->val[-2]
  yyprintf((stderr, "do yy_1_ExplicitLinkSize\n"));
  
                        yy = elem_s(pmh_LINK);
                        if (l->address != NULL)
                            yy->address = strdup_or_null(l->address);
                        FREE_LABEL(s);
                        FREE_ADDRESS(l);
                    ;
#undef l
#undef s
}
YY_ACTION(void) yy_1_ExplicitLink(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define l G->val[-1]
#define s G->val[-2]
  yyprintf((stderr, "do yy_1_ExplicitLink\n"));
  
                    yy = elem_s(pmh_LINK);
                    if (l->address != NULL)
                        yy->address = strdup_or_null(l->address);
                    FREE_LABEL(s);
                    FREE_ADDRESS(l);
                ;
#undef l
#undef s
}
YY_ACTION(void) yy_1_ReferenceLinkSingle(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_ReferenceLinkSingle\n"));
  
                        	pmh_realelement *reference = GET_REF(s->label);
                            if (reference) {
                                yy = elem_s(pmh_LINK);
                                yy->label = strdup_or_null(s->label);
                                yy->address = strdup_or_null(reference->address);
                            } else
                                yy = NULL;
                            FREE_LABEL(s);
                        ;
#undef s
}
YY_ACTION(void) yy_1_ReferenceLinkDouble(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define l G->val[-1]
#define s G->val[-2]
  yyprintf((stderr, "do yy_1_ReferenceLinkDouble\n"));
  
                        	pmh_realelement *reference = GET_REF(l->label);
                            if (reference) {
                                yy = elem_s(pmh_LINK);
                                yy->label = strdup_or_null(l->label);
                                yy->address = strdup_or_null(reference->address);
                            } else
                                yy = NULL;
                            FREE_LABEL(s);
                            FREE_LABEL(l);
                        ;
#undef l
#undef s
}
YY_ACTION(void) yy_1_Link(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Link\n"));
   if (yy) ADD(yy); ;
}
YY_ACTION(void) yy_1_Image(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Image\n"));
  
            if (yy != NULL) {
                yy->type = pmh_IMAGE;
                yy->pos -= 1;
                ADD(yy);
            }
        ;
}
YY_ACTION(void) yy_1_Strike(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_Strike\n"));
   ADD(elem_s(pmh_STRIKE)); ;
#undef s
}
YY_ACTION(void) yy_1_StrongUl(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_StrongUl\n"));
   ADD(elem_s(pmh_STRONG)); ;
#undef s
}
YY_ACTION(void) yy_1_StrongStar(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_StrongStar\n"));
   ADD(elem_s(pmh_STRONG)); ;
#undef s
}
YY_ACTION(void) yy_1_EmphUl(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_EmphUl\n"));
   ADD(elem_s(pmh_EMPH)); ;
#undef s
}
YY_ACTION(void) yy_1_EmphStar(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_EmphStar\n"));
   ADD(elem_s(pmh_EMPH)); ;
#undef s
}
YY_ACTION(void) yy_1_Entity(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_Entity\n"));
   ADD(elem_s(pmh_HTML_ENTITY)); ;
#undef s
}
YY_ACTION(void) yy_1_StyleBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_StyleBlock\n"));
   ADD(elem_s(pmh_HTMLBLOCK)); ;
#undef s
}
YY_ACTION(void) yy_1_HtmlBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_HtmlBlock\n"));
   ADD(elem_s(pmh_HTMLBLOCK)); ;
#undef s
}
YY_ACTION(void) yy_1_HtmlBlockH6(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_HtmlBlockH6\n"));
   ADD(elem_s(pmh_H6)); ;
#undef s
}
YY_ACTION(void) yy_1_HtmlBlockH5(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_HtmlBlockH5\n"));
   ADD(elem_s(pmh_H5)); ;
#undef s
}
YY_ACTION(void) yy_1_HtmlBlockH4(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_HtmlBlockH4\n"));
   ADD(elem_s(pmh_H4)); ;
#undef s
}
YY_ACTION(void) yy_1_HtmlBlockH3(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_HtmlBlockH3\n"));
   ADD(elem_s(pmh_H3)); ;
#undef s
}
YY_ACTION(void) yy_1_HtmlBlockH2(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_HtmlBlockH2\n"));
   ADD(elem_s(pmh_H2)); ;
#undef s
}
YY_ACTION(void) yy_1_HtmlBlockH1(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_HtmlBlockH1\n"));
   ADD(elem_s(pmh_H1)); ;
#undef s
}
YY_ACTION(void) yy_1_Enumerator(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Enumerator\n"));
   ADD(elem(pmh_LIST_ENUMERATOR)); ;
}
YY_ACTION(void) yy_3_ListContinuationBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_ListContinuationBlock\n"));
   yy = a; ;
#undef a
}
YY_ACTION(void) yy_2_ListContinuationBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_ListContinuationBlock\n"));
   a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_ListContinuationBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_ListContinuationBlock\n"));
   if (*yytext == '\0') /* if strlen(yytext) == 0 */
                                a = cons(elem(pmh_SEPARATOR), a);
                            else
                                a = cons(elem(pmh_RAW), a);
                          ;
#undef a
}
YY_ACTION(void) yy_3_ListBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_ListBlock\n"));
   yy = a; ;
#undef a
}
YY_ACTION(void) yy_2_ListBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_ListBlock\n"));
   a = cons(elem(pmh_RAW), a); ;
#undef a
}
YY_ACTION(void) yy_1_ListBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_ListBlock\n"));
   a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_3_ListItemTight(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_ListItemTight\n"));
   yy = a; ;
#undef a
}
YY_ACTION(void) yy_2_ListItemTight(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_ListItemTight\n"));
   a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_ListItemTight(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_ListItemTight\n"));
   a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_3_ListItem(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_ListItem\n"));
   yy = a; ;
#undef a
}
YY_ACTION(void) yy_2_ListItem(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_ListItem\n"));
   a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_ListItem(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_ListItem\n"));
   a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_2_ListLoose(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_2_ListLoose\n"));
   pmh_realelement *cur = a;
              while (cur != NULL) {
                  pmh_realelement *rawlist = mk_element((parser_data *)G->data, pmh_RAW_LIST, 0,0);
                  rawlist->children = reverse(cur->children);
                  ADD(rawlist);
                  cur = cur->next;
              }
            ;
#undef b
#undef a
}
YY_ACTION(void) yy_1_ListLoose(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_ListLoose\n"));
   b = cons(etext("\n\n"), b); /* In loose list, \n\n added to end of each element */
                pmh_realelement *el = mk_notype;
                el->children = b;
                a = cons(el, a);
              ;
#undef b
#undef a
}
YY_ACTION(void) yy_2_ListTight(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_ListTight\n"));
   pmh_realelement *cur = a;
              while (cur != NULL) {
                  pmh_realelement *rawlist = mk_element((parser_data *)G->data, pmh_RAW_LIST, 0,0);
                  rawlist->children = reverse(cur->children);
                  ADD(rawlist);
                  cur = cur->next;
              }
            ;
#undef a
}
YY_ACTION(void) yy_1_ListTight(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_ListTight\n"));
   pmh_realelement *el = mk_notype;
                el->children = yy;
                a = cons(el, a);
              ;
#undef a
}
YY_ACTION(void) yy_1_Bullet(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Bullet\n"));
   ADD(elem(pmh_LIST_BULLET)); ;
}
YY_ACTION(void) yy_1_HorizontalRule(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_HorizontalRule\n"));
   ADD(elem(pmh_HRULE)); ;
}
YY_ACTION(void) yy_1_TableBorder(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_TableBorder\n"));
   ADD(elem(pmh_TABLEBORDER)); ;
}
YY_ACTION(void) yy_1_TableHeader(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_TableHeader\n"));
   ADD(elem_s(pmh_TABLEHEADER)); ;
#undef s
}
YY_ACTION(void) yy_1_Table(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_Table\n"));
   ADD(elem_s(pmh_TABLE)); ;
#undef s
}
YY_ACTION(void) yy_1_InlineEquation(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_InlineEquation\n"));
   ADD(elem(pmh_INLINEEQUATION)); ;
}
YY_ACTION(void) yy_1_DisplayFormulaRaw(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_DisplayFormulaRaw\n"));
   ADD(elem(pmh_DISPLAYFORMULA)); ;
}
YY_ACTION(void) yy_1_DisplayFormulaDollar(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_DisplayFormulaDollar\n"));
   ADD(elem(pmh_DISPLAYFORMULA)); ;
}
YY_ACTION(void) yy_1_FencedCodeBlockTidle(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_FencedCodeBlockTidle\n"));
   ADD(elem(pmh_FENCEDCODEBLOCK)); ;
}
YY_ACTION(void) yy_1_FencedCodeBlockTick(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_FencedCodeBlockTick\n"));
   ADD(elem(pmh_FENCEDCODEBLOCK)); ;
}
YY_ACTION(void) yy_1_Verbatim(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_Verbatim\n"));
   ADD(elem_s(pmh_VERBATIM)); ;
#undef s
}
YY_ACTION(void) yy_5_BlockQuoteRaw(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_5_BlockQuoteRaw\n"));
   yy = a; ;
#undef a
}
YY_ACTION(void) yy_4_BlockQuoteRaw(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_4_BlockQuoteRaw\n"));
   a = cons(etext("\n"), a); ;
#undef a
}
YY_ACTION(void) yy_3_BlockQuoteRaw(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_BlockQuoteRaw\n"));
   a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_2_BlockQuoteRaw(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_BlockQuoteRaw\n"));
   a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_BlockQuoteRaw(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_BlockQuoteRaw\n"));
   ADD(elem(pmh_BLOCKQUOTE)); ;
#undef a
}
YY_ACTION(void) yy_1_BlockQuote(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_BlockQuote\n"));
   pmh_realelement *rawlist = mk_element((parser_data *)G->data, pmh_RAW_LIST, 0,0);
              rawlist->children = reverse(a);
              ADD(rawlist);
            ;
#undef a
}
YY_ACTION(void) yy_1_SetextHeading2(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_SetextHeading2\n"));
   ADD(elem_s(pmh_H2)); ;
#undef s
}
YY_ACTION(void) yy_1_SetextHeading1(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_SetextHeading1\n"));
   ADD(elem_s(pmh_H1)); ;
#undef s
}
YY_ACTION(void) yy_1_AtxHeading(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_AtxHeading\n"));
   ADD(elem_s(s->type)); ;
#undef s
}
YY_ACTION(void) yy_1_AtxStart(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_AtxStart\n"));
   yy = elem((pmh_element_type)(pmh_H1 + (strlen(yytext) - 1))); ;
}
YY_ACTION(void) yy_1_FrontMatter(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_FrontMatter\n"));
  
                    ADD(elem(pmh_FRONTMATTER));
                ;
#undef s
}
YY_ACTION(void) yy_1_LocMarker(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_LocMarker\n"));
   yy = elem(pmh_NO_TYPE); ;
}

YY_RULE(int) yy_RawNoteBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "RawNoteBlock"));
  {  int yypos4= G->pos, yythunkpos4= G->thunkpos;  if (!yy_BlankLine(G)) { goto l4; }  goto l1;
  l4:;	  G->pos= yypos4; G->thunkpos= yythunkpos4;
  }  if (!yy_OptionallyIndentedLine(G)) { goto l1; }
  l2:;	
  {  int yypos3= G->pos, yythunkpos3= G->thunkpos;
  {  int yypos5= G->pos, yythunkpos5= G->thunkpos;  if (!yy_BlankLine(G)) { goto l5; }  goto l3;
  l5:;	  G->pos= yypos5; G->thunkpos= yythunkpos5;
  }  if (!yy_OptionallyIndentedLine(G)) { goto l3; }  goto l2;
  l3:;	  G->pos= yypos3; G->thunkpos= yythunkpos3;
  }
  l6:;	
  {  int yypos7= G->pos, yythunkpos7= G->thunkpos;  if (!yy_BlankLine(G)) { goto l7; }  goto l6;
  l7:;	  G->pos= yypos7; G->thunkpos= yythunkpos7;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "RawNoteBlock", G->buf+G->pos));
  return 1;
  l1:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "RawNoteBlock", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_RawNoteReference(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "RawNoteReference"));  if (!yymatchString(G, "[^")) goto l8;
  {  int yypos11= G->pos, yythunkpos11= G->thunkpos;  if (!yy_Newline(G)) { goto l11; }  goto l8;
  l11:;	  G->pos= yypos11; G->thunkpos= yythunkpos11;
  }
  {  int yypos12= G->pos, yythunkpos12= G->thunkpos;  if (!yymatchChar(G, ']')) goto l12;  goto l8;
  l12:;	  G->pos= yypos12; G->thunkpos= yythunkpos12;
  }  if (!yymatchDot(G)) goto l8;
  l9:;	
  {  int yypos10= G->pos, yythunkpos10= G->thunkpos;
  {  int yypos13= G->pos, yythunkpos13= G->thunkpos;  if (!yy_Newline(G)) { goto l13; }  goto l10;
  l13:;	  G->pos= yypos13; G->thunkpos= yythunkpos13;
  }
  {  int yypos14= G->pos, yythunkpos14= G->thunkpos;  if (!yymatchChar(G, ']')) goto l14;  goto l10;
  l14:;	  G->pos= yypos14; G->thunkpos= yythunkpos14;
  }  if (!yymatchDot(G)) goto l10;  goto l9;
  l10:;	  G->pos= yypos10; G->thunkpos= yythunkpos10;
  }  if (!yymatchChar(G, ']')) goto l8;
  yyprintf((stderr, "  ok   %s @ %s\n", "RawNoteReference", G->buf+G->pos));
  return 1;
  l8:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "RawNoteReference", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_AlphanumericAscii(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "AlphanumericAscii"));  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\376\377\377\007\376\377\377\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l15;
  yyprintf((stderr, "  ok   %s @ %s\n", "AlphanumericAscii", G->buf+G->pos));
  return 1;
  l15:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "AlphanumericAscii", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Quoted(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Quoted"));
  {  int yypos17= G->pos, yythunkpos17= G->thunkpos;  if (!yymatchChar(G, '"')) goto l18;
  l19:;	
  {  int yypos20= G->pos, yythunkpos20= G->thunkpos;
  {  int yypos21= G->pos, yythunkpos21= G->thunkpos;  if (!yymatchChar(G, '"')) goto l21;  goto l20;
  l21:;	  G->pos= yypos21; G->thunkpos= yythunkpos21;
  }  if (!yymatchDot(G)) goto l20;  goto l19;
  l20:;	  G->pos= yypos20; G->thunkpos= yythunkpos20;
  }  if (!yymatchChar(G, '"')) goto l18;  goto l17;
  l18:;	  G->pos= yypos17; G->thunkpos= yythunkpos17;  if (!yymatchChar(G, '\'')) goto l16;
  l22:;	
  {  int yypos23= G->pos, yythunkpos23= G->thunkpos;
  {  int yypos24= G->pos, yythunkpos24= G->thunkpos;  if (!yymatchChar(G, '\'')) goto l24;  goto l23;
  l24:;	  G->pos= yypos24; G->thunkpos= yythunkpos24;
  }  if (!yymatchDot(G)) goto l23;  goto l22;
  l23:;	  G->pos= yypos23; G->thunkpos= yythunkpos23;
  }  if (!yymatchChar(G, '\'')) goto l16;
  }
  l17:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "Quoted", G->buf+G->pos));
  return 1;
  l16:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Quoted", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlTag(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlTag"));  if (!yymatchChar(G, '<')) goto l25;  if (!yy_Spnl(G)) { goto l25; }
  {  int yypos26= G->pos, yythunkpos26= G->thunkpos;  if (!yymatchChar(G, '/')) goto l26;  goto l27;
  l26:;	  G->pos= yypos26; G->thunkpos= yythunkpos26;
  }
  l27:;	  if (!yy_AlphanumericAscii(G)) { goto l25; }
  l28:;	
  {  int yypos29= G->pos, yythunkpos29= G->thunkpos;  if (!yy_AlphanumericAscii(G)) { goto l29; }  goto l28;
  l29:;	  G->pos= yypos29; G->thunkpos= yythunkpos29;
  }  if (!yy_Spnl(G)) { goto l25; }
  l30:;	
  {  int yypos31= G->pos, yythunkpos31= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l31; }  goto l30;
  l31:;	  G->pos= yypos31; G->thunkpos= yythunkpos31;
  }
  {  int yypos32= G->pos, yythunkpos32= G->thunkpos;  if (!yymatchChar(G, '/')) goto l32;  goto l33;
  l32:;	  G->pos= yypos32; G->thunkpos= yythunkpos32;
  }
  l33:;	  if (!yy_Spnl(G)) { goto l25; }  if (!yymatchChar(G, '>')) goto l25;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlTag", G->buf+G->pos));
  return 1;
  l25:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlTag", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_MarkTagClose(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "MarkTagClose"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l34;  if (!yy_LocMarker(G)) { goto l34; }  yyDo(G, yySet, -1, 0);  if (!yymatchChar(G, '<')) goto l34;  if (!yy_Spnl(G)) { goto l34; }  if (!yymatchChar(G, '/')) goto l34;
  {  int yypos35= G->pos, yythunkpos35= G->thunkpos;  if (!yymatchString(G, "mark")) goto l36;  goto l35;
  l36:;	  G->pos= yypos35; G->thunkpos= yythunkpos35;  if (!yymatchString(G, "MARK")) goto l34;
  }
  l35:;	  if (!yy_Spnl(G)) { goto l34; }  if (!yymatchChar(G, '>')) goto l34;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l34;  yyDo(G, yy_1_MarkTagClose, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "MarkTagClose", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l34:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "MarkTagClose", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_MarkTagText(GREG *G)
{
  yyprintf((stderr, "%s\n", "MarkTagText"));
  l38:;	
  {  int yypos39= G->pos, yythunkpos39= G->thunkpos;
  {  int yypos40= G->pos, yythunkpos40= G->thunkpos;  if (!yy_MarkTagClose(G)) { goto l40; }  goto l39;
  l40:;	  G->pos= yypos40; G->thunkpos= yythunkpos40;
  }
  {  int yypos41= G->pos, yythunkpos41= G->thunkpos;  if (!yy_RawHtml(G)) { goto l42; }  goto l41;
  l42:;	  G->pos= yypos41; G->thunkpos= yythunkpos41;  if (!yymatchDot(G)) goto l39;
  }
  l41:;	  goto l38;
  l39:;	  G->pos= yypos39; G->thunkpos= yythunkpos39;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "MarkTagText", G->buf+G->pos));
  return 1;
}
YY_RULE(int) yy_MarkTagOpen(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "MarkTagOpen"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l43;  if (!yy_LocMarker(G)) { goto l43; }  yyDo(G, yySet, -1, 0);  if (!yymatchChar(G, '<')) goto l43;  if (!yy_Spnl(G)) { goto l43; }
  {  int yypos44= G->pos, yythunkpos44= G->thunkpos;  if (!yymatchString(G, "mark")) goto l45;  goto l44;
  l45:;	  G->pos= yypos44; G->thunkpos= yythunkpos44;  if (!yymatchString(G, "MARK")) goto l43;
  }
  l44:;	  if (!yy_Spnl(G)) { goto l43; }
  l46:;	
  {  int yypos47= G->pos, yythunkpos47= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l47; }  goto l46;
  l47:;	  G->pos= yypos47; G->thunkpos= yythunkpos47;
  }  if (!yymatchChar(G, '>')) goto l43;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l43;  yyDo(G, yy_1_MarkTagOpen, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "MarkTagOpen", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l43:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "MarkTagOpen", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Ticks5(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Ticks5"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l48;  if (!yymatchString(G, "`````")) goto l48;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l48;
  {  int yypos49= G->pos, yythunkpos49= G->thunkpos;  if (!yymatchChar(G, '`')) goto l49;  goto l48;
  l49:;	  G->pos= yypos49; G->thunkpos= yythunkpos49;
  }  yyDo(G, yy_1_Ticks5, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Ticks5", G->buf+G->pos));
  return 1;
  l48:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Ticks5", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Ticks4(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Ticks4"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l50;  if (!yymatchString(G, "````")) goto l50;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l50;
  {  int yypos51= G->pos, yythunkpos51= G->thunkpos;  if (!yymatchChar(G, '`')) goto l51;  goto l50;
  l51:;	  G->pos= yypos51; G->thunkpos= yythunkpos51;
  }  yyDo(G, yy_1_Ticks4, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Ticks4", G->buf+G->pos));
  return 1;
  l50:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Ticks4", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Ticks3(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Ticks3"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l52;  if (!yymatchString(G, "```")) goto l52;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l52;
  {  int yypos53= G->pos, yythunkpos53= G->thunkpos;  if (!yymatchChar(G, '`')) goto l53;  goto l52;
  l53:;	  G->pos= yypos53; G->thunkpos= yythunkpos53;
  }  yyDo(G, yy_1_Ticks3, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Ticks3", G->buf+G->pos));
  return 1;
  l52:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Ticks3", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Ticks2(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Ticks2"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l54;  if (!yymatchString(G, "``")) goto l54;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l54;
  {  int yypos55= G->pos, yythunkpos55= G->thunkpos;  if (!yymatchChar(G, '`')) goto l55;  goto l54;
  l55:;	  G->pos= yypos55; G->thunkpos= yythunkpos55;
  }  yyDo(G, yy_1_Ticks2, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Ticks2", G->buf+G->pos));
  return 1;
  l54:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Ticks2", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Ticks1(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Ticks1"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l56;  if (!yymatchChar(G, '`')) goto l56;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l56;
  {  int yypos57= G->pos, yythunkpos57= G->thunkpos;  if (!yymatchChar(G, '`')) goto l57;  goto l56;
  l57:;	  G->pos= yypos57; G->thunkpos= yythunkpos57;
  }  yyDo(G, yy_1_Ticks1, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Ticks1", G->buf+G->pos));
  return 1;
  l56:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Ticks1", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_SkipBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "SkipBlock"));
  {  int yypos59= G->pos, yythunkpos59= G->thunkpos;
  {  int yypos63= G->pos, yythunkpos63= G->thunkpos;  if (!yy_BlankLine(G)) { goto l63; }  goto l60;
  l63:;	  G->pos= yypos63; G->thunkpos= yythunkpos63;
  }  if (!yy_RawLine(G)) { goto l60; }
  l61:;	
  {  int yypos62= G->pos, yythunkpos62= G->thunkpos;
  {  int yypos64= G->pos, yythunkpos64= G->thunkpos;  if (!yy_BlankLine(G)) { goto l64; }  goto l62;
  l64:;	  G->pos= yypos64; G->thunkpos= yythunkpos64;
  }  if (!yy_RawLine(G)) { goto l62; }  goto l61;
  l62:;	  G->pos= yypos62; G->thunkpos= yythunkpos62;
  }
  l65:;	
  {  int yypos66= G->pos, yythunkpos66= G->thunkpos;  if (!yy_BlankLine(G)) { goto l66; }  goto l65;
  l66:;	  G->pos= yypos66; G->thunkpos= yythunkpos66;
  }  goto l59;
  l60:;	  G->pos= yypos59; G->thunkpos= yythunkpos59;  if (!yy_BlankLine(G)) { goto l58; }
  l67:;	
  {  int yypos68= G->pos, yythunkpos68= G->thunkpos;  if (!yy_BlankLine(G)) { goto l68; }  goto l67;
  l68:;	  G->pos= yypos68; G->thunkpos= yythunkpos68;
  }
  }
  l59:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "SkipBlock", G->buf+G->pos));
  return 1;
  l58:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "SkipBlock", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_References(GREG *G)
{
  yyprintf((stderr, "%s\n", "References"));
  l70:;	
  {  int yypos71= G->pos, yythunkpos71= G->thunkpos;
  {  int yypos72= G->pos, yythunkpos72= G->thunkpos;  if (!yy_Reference(G)) { goto l73; }  goto l72;
  l73:;	  G->pos= yypos72; G->thunkpos= yythunkpos72;  if (!yy_SkipBlock(G)) { goto l71; }
  }
  l72:;	  goto l70;
  l71:;	  G->pos= yypos71; G->thunkpos= yythunkpos71;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "References", G->buf+G->pos));
  return 1;
}
YY_RULE(int) yy_EmptyTitle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "EmptyTitle"));  if (!yymatchString(G, "")) goto l74;
  yyprintf((stderr, "  ok   %s @ %s\n", "EmptyTitle", G->buf+G->pos));
  return 1;
  l74:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "EmptyTitle", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_RefTitleParens(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "RefTitleParens"));  if (!yy_Spnl(G)) { goto l75; }  if (!yymatchChar(G, '(')) goto l75;
  l76:;	
  {  int yypos77= G->pos, yythunkpos77= G->thunkpos;
  {  int yypos78= G->pos, yythunkpos78= G->thunkpos;
  {  int yypos79= G->pos, yythunkpos79= G->thunkpos;  if (!yymatchChar(G, ')')) goto l80;  if (!yy_Sp(G)) { goto l80; }  if (!yy_Newline(G)) { goto l80; }  goto l79;
  l80:;	  G->pos= yypos79; G->thunkpos= yythunkpos79;  if (!yy_Newline(G)) { goto l78; }
  }
  l79:;	  goto l77;
  l78:;	  G->pos= yypos78; G->thunkpos= yythunkpos78;
  }  if (!yymatchDot(G)) goto l77;  goto l76;
  l77:;	  G->pos= yypos77; G->thunkpos= yythunkpos77;
  }  if (!yymatchChar(G, ')')) goto l75;
  yyprintf((stderr, "  ok   %s @ %s\n", "RefTitleParens", G->buf+G->pos));
  return 1;
  l75:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "RefTitleParens", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_RefTitleDouble(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "RefTitleDouble"));  if (!yy_Spnl(G)) { goto l81; }  if (!yymatchChar(G, '"')) goto l81;
  l82:;	
  {  int yypos83= G->pos, yythunkpos83= G->thunkpos;
  {  int yypos84= G->pos, yythunkpos84= G->thunkpos;
  {  int yypos85= G->pos, yythunkpos85= G->thunkpos;  if (!yymatchChar(G, '"')) goto l86;  if (!yy_Sp(G)) { goto l86; }  if (!yy_Newline(G)) { goto l86; }  goto l85;
  l86:;	  G->pos= yypos85; G->thunkpos= yythunkpos85;  if (!yy_Newline(G)) { goto l84; }
  }
  l85:;	  goto l83;
  l84:;	  G->pos= yypos84; G->thunkpos= yythunkpos84;
  }  if (!yymatchDot(G)) goto l83;  goto l82;
  l83:;	  G->pos= yypos83; G->thunkpos= yythunkpos83;
  }  if (!yymatchChar(G, '"')) goto l81;
  yyprintf((stderr, "  ok   %s @ %s\n", "RefTitleDouble", G->buf+G->pos));
  return 1;
  l81:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "RefTitleDouble", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_RefTitleSingle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "RefTitleSingle"));  if (!yy_Spnl(G)) { goto l87; }  if (!yymatchChar(G, '\'')) goto l87;
  l88:;	
  {  int yypos89= G->pos, yythunkpos89= G->thunkpos;
  {  int yypos90= G->pos, yythunkpos90= G->thunkpos;
  {  int yypos91= G->pos, yythunkpos91= G->thunkpos;  if (!yymatchChar(G, '\'')) goto l92;  if (!yy_Sp(G)) { goto l92; }  if (!yy_Newline(G)) { goto l92; }  goto l91;
  l92:;	  G->pos= yypos91; G->thunkpos= yythunkpos91;  if (!yy_Newline(G)) { goto l90; }
  }
  l91:;	  goto l89;
  l90:;	  G->pos= yypos90; G->thunkpos= yythunkpos90;
  }  if (!yymatchDot(G)) goto l89;  goto l88;
  l89:;	  G->pos= yypos89; G->thunkpos= yythunkpos89;
  }  if (!yymatchChar(G, '\'')) goto l87;
  yyprintf((stderr, "  ok   %s @ %s\n", "RefTitleSingle", G->buf+G->pos));
  return 1;
  l87:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "RefTitleSingle", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_LabelInline(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "LabelInline"));
  {  int yypos94= G->pos, yythunkpos94= G->thunkpos;  if (!yy_Str(G)) { goto l95; }  goto l94;
  l95:;	  G->pos= yypos94; G->thunkpos= yythunkpos94;  if (!yy_Endline(G)) { goto l96; }  goto l94;
  l96:;	  G->pos= yypos94; G->thunkpos= yythunkpos94;  if (!yy_Space(G)) { goto l97; }  goto l94;
  l97:;	  G->pos= yypos94; G->thunkpos= yythunkpos94;  if (!yy_RawHtml(G)) { goto l98; }  goto l94;
  l98:;	  G->pos= yypos94; G->thunkpos= yythunkpos94;  if (!yy_Entity(G)) { goto l99; }  goto l94;
  l99:;	  G->pos= yypos94; G->thunkpos= yythunkpos94;  if (!yy_EscapedChar(G)) { goto l100; }  goto l94;
  l100:;	  G->pos= yypos94; G->thunkpos= yythunkpos94;  if (!yy_Symbol(G)) { goto l93; }
  }
  l94:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "LabelInline", G->buf+G->pos));
  return 1;
  l93:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "LabelInline", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_RefTitle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "RefTitle"));
  {  int yypos102= G->pos, yythunkpos102= G->thunkpos;  if (!yy_RefTitleSingle(G)) { goto l103; }  goto l102;
  l103:;	  G->pos= yypos102; G->thunkpos= yythunkpos102;  if (!yy_RefTitleDouble(G)) { goto l104; }  goto l102;
  l104:;	  G->pos= yypos102; G->thunkpos= yythunkpos102;  if (!yy_RefTitleParens(G)) { goto l105; }  goto l102;
  l105:;	  G->pos= yypos102; G->thunkpos= yythunkpos102;  if (!yy_EmptyTitle(G)) { goto l101; }
  }
  l102:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "RefTitle", G->buf+G->pos));
  return 1;
  l101:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "RefTitle", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_RefSrc(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "RefSrc"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l106;  if (!yy_Nonspacechar(G)) { goto l106; }
  l107:;	
  {  int yypos108= G->pos, yythunkpos108= G->thunkpos;  if (!yy_Nonspacechar(G)) { goto l108; }  goto l107;
  l108:;	  G->pos= yypos108; G->thunkpos= yythunkpos108;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l106;  yyDo(G, yy_1_RefSrc, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "RefSrc", G->buf+G->pos));
  return 1;
  l106:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "RefSrc", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_AutoLinkEmail(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "AutoLinkEmail"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l109;  if (!yy_LocMarker(G)) { goto l109; }  yyDo(G, yySet, -1, 0);  yyDo(G, yy_1_AutoLinkEmail, G->begin, G->end);  if (!yymatchChar(G, '<')) goto l109;
  {  int yypos110= G->pos, yythunkpos110= G->thunkpos;  if (!yymatchString(G, "mailto:")) goto l110;  goto l111;
  l110:;	  G->pos= yypos110; G->thunkpos= yythunkpos110;
  }
  l111:;	  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l109;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\062\350\377\003\376\377\377\207\376\377\377\107\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l109;
  l112:;	
  {  int yypos113= G->pos, yythunkpos113= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\062\350\377\003\376\377\377\207\376\377\377\107\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l113;  goto l112;
  l113:;	  G->pos= yypos113; G->thunkpos= yythunkpos113;
  }  if (!yymatchChar(G, '@')) goto l109;
  {  int yypos116= G->pos, yythunkpos116= G->thunkpos;  if (!yy_Newline(G)) { goto l116; }  goto l109;
  l116:;	  G->pos= yypos116; G->thunkpos= yythunkpos116;
  }
  {  int yypos117= G->pos, yythunkpos117= G->thunkpos;  if (!yymatchChar(G, '>')) goto l117;  goto l109;
  l117:;	  G->pos= yypos117; G->thunkpos= yythunkpos117;
  }  if (!yymatchDot(G)) goto l109;
  l114:;	
  {  int yypos115= G->pos, yythunkpos115= G->thunkpos;
  {  int yypos118= G->pos, yythunkpos118= G->thunkpos;  if (!yy_Newline(G)) { goto l118; }  goto l115;
  l118:;	  G->pos= yypos118; G->thunkpos= yythunkpos118;
  }
  {  int yypos119= G->pos, yythunkpos119= G->thunkpos;  if (!yymatchChar(G, '>')) goto l119;  goto l115;
  l119:;	  G->pos= yypos119; G->thunkpos= yythunkpos119;
  }  if (!yymatchDot(G)) goto l115;  goto l114;
  l115:;	  G->pos= yypos115; G->thunkpos= yythunkpos115;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l109;  yyDo(G, yy_2_AutoLinkEmail, G->begin, G->end);  if (!yymatchChar(G, '>')) goto l109;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l109;  yyDo(G, yy_3_AutoLinkEmail, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "AutoLinkEmail", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l109:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "AutoLinkEmail", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_AutoLinkUrl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "AutoLinkUrl"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l120;  if (!yy_LocMarker(G)) { goto l120; }  yyDo(G, yySet, -1, 0);  yyDo(G, yy_1_AutoLinkUrl, G->begin, G->end);  if (!yymatchChar(G, '<')) goto l120;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l120;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\000\000\376\377\377\007\376\377\377\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l120;
  l121:;	
  {  int yypos122= G->pos, yythunkpos122= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\000\000\376\377\377\007\376\377\377\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l122;  goto l121;
  l122:;	  G->pos= yypos122; G->thunkpos= yythunkpos122;
  }  if (!yymatchString(G, "://")) goto l120;
  {  int yypos125= G->pos, yythunkpos125= G->thunkpos;  if (!yy_Newline(G)) { goto l125; }  goto l120;
  l125:;	  G->pos= yypos125; G->thunkpos= yythunkpos125;
  }
  {  int yypos126= G->pos, yythunkpos126= G->thunkpos;  if (!yymatchChar(G, '>')) goto l126;  goto l120;
  l126:;	  G->pos= yypos126; G->thunkpos= yythunkpos126;
  }  if (!yymatchDot(G)) goto l120;
  l123:;	
  {  int yypos124= G->pos, yythunkpos124= G->thunkpos;
  {  int yypos127= G->pos, yythunkpos127= G->thunkpos;  if (!yy_Newline(G)) { goto l127; }  goto l124;
  l127:;	  G->pos= yypos127; G->thunkpos= yythunkpos127;
  }
  {  int yypos128= G->pos, yythunkpos128= G->thunkpos;  if (!yymatchChar(G, '>')) goto l128;  goto l124;
  l128:;	  G->pos= yypos128; G->thunkpos= yythunkpos128;
  }  if (!yymatchDot(G)) goto l124;  goto l123;
  l124:;	  G->pos= yypos124; G->thunkpos= yythunkpos124;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l120;  yyDo(G, yy_2_AutoLinkUrl, G->begin, G->end);  if (!yymatchChar(G, '>')) goto l120;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l120;  yyDo(G, yy_3_AutoLinkUrl, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "AutoLinkUrl", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l120:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "AutoLinkUrl", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_ImageSizeHeight(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "ImageSizeHeight"));  if (!yymatchString(G, "=x")) goto l129;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l129;
  l130:;	
  {  int yypos131= G->pos, yythunkpos131= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l131;  goto l130;
  l131:;	  G->pos= yypos131; G->thunkpos= yythunkpos131;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "ImageSizeHeight", G->buf+G->pos));
  return 1;
  l129:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ImageSizeHeight", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_ImageSizeWidth(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "ImageSizeWidth"));  if (!yymatchChar(G, '=')) goto l132;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l132;
  l133:;	
  {  int yypos134= G->pos, yythunkpos134= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l134;  goto l133;
  l134:;	  G->pos= yypos134; G->thunkpos= yythunkpos134;
  }  if (!yymatchChar(G, 'x')) goto l132;
  yyprintf((stderr, "  ok   %s @ %s\n", "ImageSizeWidth", G->buf+G->pos));
  return 1;
  l132:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ImageSizeWidth", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_ImageSizeComplete(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "ImageSizeComplete"));  if (!yymatchChar(G, '=')) goto l135;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l135;
  l136:;	
  {  int yypos137= G->pos, yythunkpos137= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l137;  goto l136;
  l137:;	  G->pos= yypos137; G->thunkpos= yythunkpos137;
  }  if (!yymatchChar(G, 'x')) goto l135;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l135;
  l138:;	
  {  int yypos139= G->pos, yythunkpos139= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l139;  goto l138;
  l139:;	  G->pos= yypos139; G->thunkpos= yythunkpos139;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "ImageSizeComplete", G->buf+G->pos));
  return 1;
  l135:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ImageSizeComplete", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_TitleDoubleExt(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "TitleDoubleExt"));  if (!yymatchChar(G, '"')) goto l140;
  l141:;	
  {  int yypos142= G->pos, yythunkpos142= G->thunkpos;
  {  int yypos143= G->pos, yythunkpos143= G->thunkpos;
  {  int yypos144= G->pos, yythunkpos144= G->thunkpos;  if (!yymatchChar(G, '"')) goto l145;  goto l144;
  l145:;	  G->pos= yypos144; G->thunkpos= yythunkpos144;  if (!yy_Newline(G)) { goto l143; }
  }
  l144:;	  goto l142;
  l143:;	  G->pos= yypos143; G->thunkpos= yythunkpos143;
  }  if (!yymatchDot(G)) goto l142;  goto l141;
  l142:;	  G->pos= yypos142; G->thunkpos= yythunkpos142;
  }  if (!yymatchChar(G, '"')) goto l140;
  yyprintf((stderr, "  ok   %s @ %s\n", "TitleDoubleExt", G->buf+G->pos));
  return 1;
  l140:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "TitleDoubleExt", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_TitleSingleExt(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "TitleSingleExt"));  if (!yymatchChar(G, '\'')) goto l146;
  l147:;	
  {  int yypos148= G->pos, yythunkpos148= G->thunkpos;
  {  int yypos149= G->pos, yythunkpos149= G->thunkpos;
  {  int yypos150= G->pos, yythunkpos150= G->thunkpos;  if (!yymatchChar(G, '\'')) goto l151;  goto l150;
  l151:;	  G->pos= yypos150; G->thunkpos= yythunkpos150;  if (!yy_Newline(G)) { goto l149; }
  }
  l150:;	  goto l148;
  l149:;	  G->pos= yypos149; G->thunkpos= yythunkpos149;
  }  if (!yymatchDot(G)) goto l148;  goto l147;
  l148:;	  G->pos= yypos148; G->thunkpos= yythunkpos148;
  }  if (!yymatchChar(G, '\'')) goto l146;
  yyprintf((stderr, "  ok   %s @ %s\n", "TitleSingleExt", G->buf+G->pos));
  return 1;
  l146:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "TitleSingleExt", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_TitleDouble(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "TitleDouble"));  if (!yymatchChar(G, '"')) goto l152;
  l153:;	
  {  int yypos154= G->pos, yythunkpos154= G->thunkpos;
  {  int yypos155= G->pos, yythunkpos155= G->thunkpos;  if (!yymatchChar(G, '"')) goto l155;  if (!yy_Sp(G)) { goto l155; }
  {  int yypos156= G->pos, yythunkpos156= G->thunkpos;  if (!yymatchChar(G, ')')) goto l157;  goto l156;
  l157:;	  G->pos= yypos156; G->thunkpos= yythunkpos156;  if (!yy_Newline(G)) { goto l155; }
  }
  l156:;	  goto l154;
  l155:;	  G->pos= yypos155; G->thunkpos= yythunkpos155;
  }  if (!yymatchDot(G)) goto l154;  goto l153;
  l154:;	  G->pos= yypos154; G->thunkpos= yythunkpos154;
  }  if (!yymatchChar(G, '"')) goto l152;
  yyprintf((stderr, "  ok   %s @ %s\n", "TitleDouble", G->buf+G->pos));
  return 1;
  l152:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "TitleDouble", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_TitleSingle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "TitleSingle"));  if (!yymatchChar(G, '\'')) goto l158;
  l159:;	
  {  int yypos160= G->pos, yythunkpos160= G->thunkpos;
  {  int yypos161= G->pos, yythunkpos161= G->thunkpos;  if (!yymatchChar(G, '\'')) goto l161;  if (!yy_Sp(G)) { goto l161; }
  {  int yypos162= G->pos, yythunkpos162= G->thunkpos;  if (!yymatchChar(G, ')')) goto l163;  goto l162;
  l163:;	  G->pos= yypos162; G->thunkpos= yythunkpos162;  if (!yy_Newline(G)) { goto l161; }
  }
  l162:;	  goto l160;
  l161:;	  G->pos= yypos161; G->thunkpos= yythunkpos161;
  }  if (!yymatchDot(G)) goto l160;  goto l159;
  l160:;	  G->pos= yypos160; G->thunkpos= yythunkpos160;
  }  if (!yymatchChar(G, '\'')) goto l158;
  yyprintf((stderr, "  ok   %s @ %s\n", "TitleSingle", G->buf+G->pos));
  return 1;
  l158:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "TitleSingle", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_SourceContents(GREG *G)
{
  yyprintf((stderr, "%s\n", "SourceContents"));
  l165:;	
  {  int yypos166= G->pos, yythunkpos166= G->thunkpos;
  {  int yypos167= G->pos, yythunkpos167= G->thunkpos;
  {  int yypos171= G->pos, yythunkpos171= G->thunkpos;  if (!yymatchChar(G, '(')) goto l171;  goto l168;
  l171:;	  G->pos= yypos171; G->thunkpos= yythunkpos171;
  }
  {  int yypos172= G->pos, yythunkpos172= G->thunkpos;  if (!yymatchChar(G, ')')) goto l172;  goto l168;
  l172:;	  G->pos= yypos172; G->thunkpos= yythunkpos172;
  }
  {  int yypos173= G->pos, yythunkpos173= G->thunkpos;  if (!yymatchChar(G, '>')) goto l173;  goto l168;
  l173:;	  G->pos= yypos173; G->thunkpos= yythunkpos173;
  }  if (!yy_Nonspacechar(G)) { goto l168; }
  l169:;	
  {  int yypos170= G->pos, yythunkpos170= G->thunkpos;
  {  int yypos174= G->pos, yythunkpos174= G->thunkpos;  if (!yymatchChar(G, '(')) goto l174;  goto l170;
  l174:;	  G->pos= yypos174; G->thunkpos= yythunkpos174;
  }
  {  int yypos175= G->pos, yythunkpos175= G->thunkpos;  if (!yymatchChar(G, ')')) goto l175;  goto l170;
  l175:;	  G->pos= yypos175; G->thunkpos= yythunkpos175;
  }
  {  int yypos176= G->pos, yythunkpos176= G->thunkpos;  if (!yymatchChar(G, '>')) goto l176;  goto l170;
  l176:;	  G->pos= yypos176; G->thunkpos= yythunkpos176;
  }  if (!yy_Nonspacechar(G)) { goto l170; }  goto l169;
  l170:;	  G->pos= yypos170; G->thunkpos= yythunkpos170;
  }  goto l167;
  l168:;	  G->pos= yypos167; G->thunkpos= yythunkpos167;  if (!yymatchChar(G, '(')) goto l166;  if (!yy_SourceContents(G)) { goto l166; }  if (!yymatchChar(G, ')')) goto l166;
  }
  l167:;	  goto l165;
  l166:;	  G->pos= yypos166; G->thunkpos= yythunkpos166;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "SourceContents", G->buf+G->pos));
  return 1;
}
YY_RULE(int) yy_ImageSize(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "ImageSize"));
  {  int yypos178= G->pos, yythunkpos178= G->thunkpos;  if (!yy_ImageSizeComplete(G)) { goto l179; }  goto l178;
  l179:;	  G->pos= yypos178; G->thunkpos= yythunkpos178;  if (!yy_ImageSizeWidth(G)) { goto l180; }  goto l178;
  l180:;	  G->pos= yypos178; G->thunkpos= yythunkpos178;  if (!yy_ImageSizeHeight(G)) { goto l181; }  goto l178;
  l181:;	  G->pos= yypos178; G->thunkpos= yythunkpos178;  if (!yymatchString(G, "")) goto l177;
  }
  l178:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "ImageSize", G->buf+G->pos));
  return 1;
  l177:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ImageSize", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_TitleExt(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "TitleExt"));
  {  int yypos183= G->pos, yythunkpos183= G->thunkpos;  if (!yy_TitleSingleExt(G)) { goto l184; }  goto l183;
  l184:;	  G->pos= yypos183; G->thunkpos= yythunkpos183;  if (!yy_TitleDoubleExt(G)) { goto l185; }  goto l183;
  l185:;	  G->pos= yypos183; G->thunkpos= yythunkpos183;  if (!yymatchString(G, "")) goto l182;
  }
  l183:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "TitleExt", G->buf+G->pos));
  return 1;
  l182:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "TitleExt", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Title(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Title"));
  {  int yypos187= G->pos, yythunkpos187= G->thunkpos;  if (!yy_TitleSingle(G)) { goto l188; }  goto l187;
  l188:;	  G->pos= yypos187; G->thunkpos= yythunkpos187;  if (!yy_TitleDouble(G)) { goto l189; }  goto l187;
  l189:;	  G->pos= yypos187; G->thunkpos= yythunkpos187;  if (!yymatchString(G, "")) goto l186;
  }
  l187:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "Title", G->buf+G->pos));
  return 1;
  l186:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Title", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Source(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Source"));  yyDo(G, yy_1_Source, G->begin, G->end);
  {  int yypos191= G->pos, yythunkpos191= G->thunkpos;  if (!yymatchChar(G, '<')) goto l192;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l192;  if (!yy_SourceContents(G)) { goto l192; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l192;  yyDo(G, yy_2_Source, G->begin, G->end);  if (!yymatchChar(G, '>')) goto l192;  goto l191;
  l192:;	  G->pos= yypos191; G->thunkpos= yythunkpos191;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l190;  if (!yy_SourceContents(G)) { goto l190; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l190;  yyDo(G, yy_3_Source, G->begin, G->end);
  }
  l191:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "Source", G->buf+G->pos));
  return 1;
  l190:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Source", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Label(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "Label"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l193;  if (!yy_LocMarker(G)) { goto l193; }  yyDo(G, yySet, -1, 0);  if (!yymatchChar(G, '[')) goto l193;
  {  int yypos194= G->pos, yythunkpos194= G->thunkpos;
  {  int yypos196= G->pos, yythunkpos196= G->thunkpos;  if (!yymatchChar(G, '^')) goto l196;  goto l195;
  l196:;	  G->pos= yypos196; G->thunkpos= yythunkpos196;
  }  yyText(G, G->begin, G->end);  if (!( EXT(pmh_EXT_NOTES) )) goto l195;  goto l194;
  l195:;	  G->pos= yypos194; G->thunkpos= yythunkpos194;
  {  int yypos197= G->pos, yythunkpos197= G->thunkpos;  if (!yymatchDot(G)) goto l193;  G->pos= yypos197; G->thunkpos= yythunkpos197;
  }  yyText(G, G->begin, G->end);  if (!( !EXT(pmh_EXT_NOTES) )) goto l193;
  }
  l194:;	  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l193;
  l198:;	
  {  int yypos199= G->pos, yythunkpos199= G->thunkpos;
  {  int yypos200= G->pos, yythunkpos200= G->thunkpos;  if (!yymatchChar(G, ']')) goto l200;  goto l199;
  l200:;	  G->pos= yypos200; G->thunkpos= yythunkpos200;
  }
  {  int yypos201= G->pos, yythunkpos201= G->thunkpos;  if (!yymatchChar(G, '[')) goto l201;  goto l199;
  l201:;	  G->pos= yypos201; G->thunkpos= yythunkpos201;
  }  if (!yy_LabelInline(G)) { goto l199; }  goto l198;
  l199:;	  G->pos= yypos199; G->thunkpos= yythunkpos199;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l193;  yyDo(G, yy_1_Label, G->begin, G->end);  if (!yymatchChar(G, ']')) goto l193;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l193;  yyDo(G, yy_2_Label, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Label", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l193:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Label", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_ReferenceLinkSingle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "ReferenceLinkSingle"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l202;  if (!yy_Label(G)) { goto l202; }  yyDo(G, yySet, -1, 0);
  {  int yypos203= G->pos, yythunkpos203= G->thunkpos;  if (!yy_Spnl(G)) { goto l203; }  if (!yymatchString(G, "[]")) goto l203;  goto l204;
  l203:;	  G->pos= yypos203; G->thunkpos= yythunkpos203;
  }
  l204:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l202;  yyDo(G, yy_1_ReferenceLinkSingle, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "ReferenceLinkSingle", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l202:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ReferenceLinkSingle", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_ReferenceLinkDouble(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0);
  yyprintf((stderr, "%s\n", "ReferenceLinkDouble"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l205;  if (!yy_Label(G)) { goto l205; }  yyDo(G, yySet, -2, 0);  if (!yy_Spnl(G)) { goto l205; }
  {  int yypos206= G->pos, yythunkpos206= G->thunkpos;  if (!yymatchString(G, "[]")) goto l206;  goto l205;
  l206:;	  G->pos= yypos206; G->thunkpos= yythunkpos206;
  }  if (!yy_Label(G)) { goto l205; }  yyDo(G, yySet, -1, 0);  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l205;  yyDo(G, yy_1_ReferenceLinkDouble, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "ReferenceLinkDouble", G->buf+G->pos));  yyDo(G, yyPop, 2, 0);
  return 1;
  l205:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ReferenceLinkDouble", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_AutoLink(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "AutoLink"));
  {  int yypos208= G->pos, yythunkpos208= G->thunkpos;  if (!yy_AutoLinkUrl(G)) { goto l209; }  goto l208;
  l209:;	  G->pos= yypos208; G->thunkpos= yythunkpos208;  if (!yy_AutoLinkEmail(G)) { goto l207; }
  }
  l208:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "AutoLink", G->buf+G->pos));
  return 1;
  l207:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "AutoLink", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_ReferenceLink(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "ReferenceLink"));
  {  int yypos211= G->pos, yythunkpos211= G->thunkpos;  if (!yy_ReferenceLinkDouble(G)) { goto l212; }  goto l211;
  l212:;	  G->pos= yypos211; G->thunkpos= yythunkpos211;  if (!yy_ReferenceLinkSingle(G)) { goto l210; }
  }
  l211:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "ReferenceLink", G->buf+G->pos));
  return 1;
  l210:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ReferenceLink", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_ExplicitLinkSize(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0);
  yyprintf((stderr, "%s\n", "ExplicitLinkSize"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l213;  if (!yy_Label(G)) { goto l213; }  yyDo(G, yySet, -2, 0);  if (!yy_Spnl(G)) { goto l213; }  if (!yymatchChar(G, '(')) goto l213;  if (!yy_Sp(G)) { goto l213; }  if (!yy_Source(G)) { goto l213; }  yyDo(G, yySet, -1, 0);  if (!yy_Spnl(G)) { goto l213; }  if (!yy_TitleExt(G)) { goto l213; }  if (!yy_Sp(G)) { goto l213; }  if (!yy_ImageSize(G)) { goto l213; }  if (!yy_Sp(G)) { goto l213; }  if (!yymatchChar(G, ')')) goto l213;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l213;  yyDo(G, yy_1_ExplicitLinkSize, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "ExplicitLinkSize", G->buf+G->pos));  yyDo(G, yyPop, 2, 0);
  return 1;
  l213:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ExplicitLinkSize", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_ExplicitLink(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0);
  yyprintf((stderr, "%s\n", "ExplicitLink"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l214;  if (!yy_Label(G)) { goto l214; }  yyDo(G, yySet, -2, 0);  if (!yy_Spnl(G)) { goto l214; }  if (!yymatchChar(G, '(')) goto l214;  if (!yy_Sp(G)) { goto l214; }  if (!yy_Source(G)) { goto l214; }  yyDo(G, yySet, -1, 0);  if (!yy_Spnl(G)) { goto l214; }  if (!yy_Title(G)) { goto l214; }  if (!yy_Sp(G)) { goto l214; }  if (!yymatchChar(G, ')')) goto l214;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l214;  yyDo(G, yy_1_ExplicitLink, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "ExplicitLink", G->buf+G->pos));  yyDo(G, yyPop, 2, 0);
  return 1;
  l214:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ExplicitLink", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_StrongUl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "StrongUl"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l215;  if (!yy_LocMarker(G)) { goto l215; }  yyDo(G, yySet, -1, 0);  if (!yymatchString(G, "__")) goto l215;
  {  int yypos216= G->pos, yythunkpos216= G->thunkpos;  if (!yy_Whitespace(G)) { goto l216; }  goto l215;
  l216:;	  G->pos= yypos216; G->thunkpos= yythunkpos216;
  }
  {  int yypos219= G->pos, yythunkpos219= G->thunkpos;  if (!yymatchString(G, "__")) goto l219;  goto l215;
  l219:;	  G->pos= yypos219; G->thunkpos= yythunkpos219;
  }  if (!yy_Inline(G)) { goto l215; }
  l217:;	
  {  int yypos218= G->pos, yythunkpos218= G->thunkpos;
  {  int yypos220= G->pos, yythunkpos220= G->thunkpos;  if (!yymatchString(G, "__")) goto l220;  goto l218;
  l220:;	  G->pos= yypos220; G->thunkpos= yythunkpos220;
  }  if (!yy_Inline(G)) { goto l218; }  goto l217;
  l218:;	  G->pos= yypos218; G->thunkpos= yythunkpos218;
  }  if (!yymatchString(G, "__")) goto l215;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l215;  yyDo(G, yy_1_StrongUl, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "StrongUl", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l215:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "StrongUl", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_StrongStar(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "StrongStar"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l221;  if (!yy_LocMarker(G)) { goto l221; }  yyDo(G, yySet, -1, 0);  if (!yymatchString(G, "**")) goto l221;
  {  int yypos222= G->pos, yythunkpos222= G->thunkpos;  if (!yy_Whitespace(G)) { goto l222; }  goto l221;
  l222:;	  G->pos= yypos222; G->thunkpos= yythunkpos222;
  }
  {  int yypos225= G->pos, yythunkpos225= G->thunkpos;  if (!yymatchString(G, "**")) goto l225;  goto l221;
  l225:;	  G->pos= yypos225; G->thunkpos= yythunkpos225;
  }  if (!yy_Inline(G)) { goto l221; }
  l223:;	
  {  int yypos224= G->pos, yythunkpos224= G->thunkpos;
  {  int yypos226= G->pos, yythunkpos226= G->thunkpos;  if (!yymatchString(G, "**")) goto l226;  goto l224;
  l226:;	  G->pos= yypos226; G->thunkpos= yythunkpos226;
  }  if (!yy_Inline(G)) { goto l224; }  goto l223;
  l224:;	  G->pos= yypos224; G->thunkpos= yythunkpos224;
  }  if (!yymatchString(G, "**")) goto l221;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l221;  yyDo(G, yy_1_StrongStar, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "StrongStar", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l221:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "StrongStar", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Whitespace(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Whitespace"));
  {  int yypos228= G->pos, yythunkpos228= G->thunkpos;  if (!yy_Spacechar(G)) { goto l229; }  goto l228;
  l229:;	  G->pos= yypos228; G->thunkpos= yythunkpos228;  if (!yy_Newline(G)) { goto l227; }
  }
  l228:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "Whitespace", G->buf+G->pos));
  return 1;
  l227:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Whitespace", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_EmphUl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "EmphUl"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l230;  if (!yy_LocMarker(G)) { goto l230; }  yyDo(G, yySet, -1, 0);  if (!yymatchChar(G, '_')) goto l230;
  {  int yypos231= G->pos, yythunkpos231= G->thunkpos;  if (!yy_Whitespace(G)) { goto l231; }  goto l230;
  l231:;	  G->pos= yypos231; G->thunkpos= yythunkpos231;
  }
  {  int yypos234= G->pos, yythunkpos234= G->thunkpos;
  {  int yypos236= G->pos, yythunkpos236= G->thunkpos;  if (!yymatchChar(G, '_')) goto l236;  goto l235;
  l236:;	  G->pos= yypos236; G->thunkpos= yythunkpos236;
  }  if (!yy_Inline(G)) { goto l235; }  goto l234;
  l235:;	  G->pos= yypos234; G->thunkpos= yythunkpos234;  if (!yy_StrongUl(G)) { goto l230; }
  }
  l234:;	
  l232:;	
  {  int yypos233= G->pos, yythunkpos233= G->thunkpos;
  {  int yypos237= G->pos, yythunkpos237= G->thunkpos;
  {  int yypos239= G->pos, yythunkpos239= G->thunkpos;  if (!yymatchChar(G, '_')) goto l239;  goto l238;
  l239:;	  G->pos= yypos239; G->thunkpos= yythunkpos239;
  }  if (!yy_Inline(G)) { goto l238; }  goto l237;
  l238:;	  G->pos= yypos237; G->thunkpos= yythunkpos237;  if (!yy_StrongUl(G)) { goto l233; }
  }
  l237:;	  goto l232;
  l233:;	  G->pos= yypos233; G->thunkpos= yythunkpos233;
  }  if (!yymatchChar(G, '_')) goto l230;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l230;  yyDo(G, yy_1_EmphUl, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "EmphUl", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l230:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "EmphUl", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_EmphStar(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "EmphStar"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l240;  if (!yy_LocMarker(G)) { goto l240; }  yyDo(G, yySet, -1, 0);  if (!yymatchChar(G, '*')) goto l240;
  {  int yypos241= G->pos, yythunkpos241= G->thunkpos;  if (!yy_Whitespace(G)) { goto l241; }  goto l240;
  l241:;	  G->pos= yypos241; G->thunkpos= yythunkpos241;
  }
  {  int yypos244= G->pos, yythunkpos244= G->thunkpos;
  {  int yypos246= G->pos, yythunkpos246= G->thunkpos;  if (!yymatchChar(G, '*')) goto l246;  goto l245;
  l246:;	  G->pos= yypos246; G->thunkpos= yythunkpos246;
  }  if (!yy_Inline(G)) { goto l245; }  goto l244;
  l245:;	  G->pos= yypos244; G->thunkpos= yythunkpos244;  if (!yy_StrongStar(G)) { goto l240; }
  }
  l244:;	
  l242:;	
  {  int yypos243= G->pos, yythunkpos243= G->thunkpos;
  {  int yypos247= G->pos, yythunkpos247= G->thunkpos;
  {  int yypos249= G->pos, yythunkpos249= G->thunkpos;  if (!yymatchChar(G, '*')) goto l249;  goto l248;
  l249:;	  G->pos= yypos249; G->thunkpos= yythunkpos249;
  }  if (!yy_Inline(G)) { goto l248; }  goto l247;
  l248:;	  G->pos= yypos247; G->thunkpos= yythunkpos247;  if (!yy_StrongStar(G)) { goto l243; }
  }
  l247:;	  goto l242;
  l243:;	  G->pos= yypos243; G->thunkpos= yythunkpos243;
  }  if (!yymatchChar(G, '*')) goto l240;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l240;  yyDo(G, yy_1_EmphStar, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "EmphStar", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l240:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "EmphStar", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_StarLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "StarLine"));
  {  int yypos251= G->pos, yythunkpos251= G->thunkpos;  if (!yymatchString(G, "****")) goto l252;
  l253:;	
  {  int yypos254= G->pos, yythunkpos254= G->thunkpos;  if (!yymatchChar(G, '*')) goto l254;  goto l253;
  l254:;	  G->pos= yypos254; G->thunkpos= yythunkpos254;
  }  goto l251;
  l252:;	  G->pos= yypos251; G->thunkpos= yythunkpos251;  if (!yy_Spacechar(G)) { goto l250; }  if (!yymatchChar(G, '*')) goto l250;
  l255:;	
  {  int yypos256= G->pos, yythunkpos256= G->thunkpos;  if (!yymatchChar(G, '*')) goto l256;  goto l255;
  l256:;	  G->pos= yypos256; G->thunkpos= yythunkpos256;
  }
  {  int yypos257= G->pos, yythunkpos257= G->thunkpos;  if (!yy_Spacechar(G)) { goto l250; }  G->pos= yypos257; G->thunkpos= yythunkpos257;
  }
  }
  l251:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "StarLine", G->buf+G->pos));
  return 1;
  l250:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "StarLine", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_UlLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "UlLine"));
  {  int yypos259= G->pos, yythunkpos259= G->thunkpos;  if (!yymatchString(G, "____")) goto l260;
  l261:;	
  {  int yypos262= G->pos, yythunkpos262= G->thunkpos;  if (!yymatchChar(G, '_')) goto l262;  goto l261;
  l262:;	  G->pos= yypos262; G->thunkpos= yythunkpos262;
  }  goto l259;
  l260:;	  G->pos= yypos259; G->thunkpos= yythunkpos259;  if (!yy_Spacechar(G)) { goto l258; }  if (!yymatchChar(G, '_')) goto l258;
  l263:;	
  {  int yypos264= G->pos, yythunkpos264= G->thunkpos;  if (!yymatchChar(G, '_')) goto l264;  goto l263;
  l264:;	  G->pos= yypos264; G->thunkpos= yythunkpos264;
  }
  {  int yypos265= G->pos, yythunkpos265= G->thunkpos;  if (!yy_Spacechar(G)) { goto l258; }  G->pos= yypos265; G->thunkpos= yythunkpos265;
  }
  }
  l259:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "UlLine", G->buf+G->pos));
  return 1;
  l258:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "UlLine", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_SpecialChar(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "SpecialChar"));
  {  int yypos267= G->pos, yythunkpos267= G->thunkpos;  if (!yymatchChar(G, '~')) goto l268;  goto l267;
  l268:;	  G->pos= yypos267; G->thunkpos= yythunkpos267;  if (!yymatchChar(G, '*')) goto l269;  goto l267;
  l269:;	  G->pos= yypos267; G->thunkpos= yythunkpos267;  if (!yymatchChar(G, '_')) goto l270;  goto l267;
  l270:;	  G->pos= yypos267; G->thunkpos= yythunkpos267;  if (!yymatchChar(G, '`')) goto l271;  goto l267;
  l271:;	  G->pos= yypos267; G->thunkpos= yythunkpos267;  if (!yymatchChar(G, '&')) goto l272;  goto l267;
  l272:;	  G->pos= yypos267; G->thunkpos= yythunkpos267;  if (!yymatchChar(G, '[')) goto l273;  goto l267;
  l273:;	  G->pos= yypos267; G->thunkpos= yythunkpos267;  if (!yymatchChar(G, ']')) goto l274;  goto l267;
  l274:;	  G->pos= yypos267; G->thunkpos= yythunkpos267;  if (!yymatchChar(G, '(')) goto l275;  goto l267;
  l275:;	  G->pos= yypos267; G->thunkpos= yythunkpos267;  if (!yymatchChar(G, ')')) goto l276;  goto l267;
  l276:;	  G->pos= yypos267; G->thunkpos= yythunkpos267;  if (!yymatchChar(G, '<')) goto l277;  goto l267;
  l277:;	  G->pos= yypos267; G->thunkpos= yythunkpos267;  if (!yymatchChar(G, '!')) goto l278;  goto l267;
  l278:;	  G->pos= yypos267; G->thunkpos= yythunkpos267;  if (!yymatchChar(G, '#')) goto l279;  goto l267;
  l279:;	  G->pos= yypos267; G->thunkpos= yythunkpos267;  if (!yymatchChar(G, '\\')) goto l280;  goto l267;
  l280:;	  G->pos= yypos267; G->thunkpos= yythunkpos267;  if (!yymatchChar(G, '\'')) goto l281;  goto l267;
  l281:;	  G->pos= yypos267; G->thunkpos= yythunkpos267;  if (!yymatchChar(G, '"')) goto l282;  goto l267;
  l282:;	  G->pos= yypos267; G->thunkpos= yythunkpos267;  if (!yy_ExtendedSpecialChar(G)) { goto l266; }
  }
  l267:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "SpecialChar", G->buf+G->pos));
  return 1;
  l266:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "SpecialChar", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Eof(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Eof"));
  {  int yypos284= G->pos, yythunkpos284= G->thunkpos;  if (!yymatchDot(G)) goto l284;  goto l283;
  l284:;	  G->pos= yypos284; G->thunkpos= yythunkpos284;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "Eof", G->buf+G->pos));
  return 1;
  l283:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Eof", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_NormalEndline(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "NormalEndline"));  if (!yy_Sp(G)) { goto l285; }  if (!yy_Newline(G)) { goto l285; }
  {  int yypos286= G->pos, yythunkpos286= G->thunkpos;  if (!yy_BlankLine(G)) { goto l286; }  goto l285;
  l286:;	  G->pos= yypos286; G->thunkpos= yythunkpos286;
  }
  {  int yypos287= G->pos, yythunkpos287= G->thunkpos;  if (!yymatchChar(G, '>')) goto l287;  goto l285;
  l287:;	  G->pos= yypos287; G->thunkpos= yythunkpos287;
  }
  {  int yypos288= G->pos, yythunkpos288= G->thunkpos;  if (!yy_AtxStart(G)) { goto l288; }  goto l285;
  l288:;	  G->pos= yypos288; G->thunkpos= yythunkpos288;
  }
  {  int yypos289= G->pos, yythunkpos289= G->thunkpos;  if (!yy_Line(G)) { goto l289; }
  {  int yypos290= G->pos, yythunkpos290= G->thunkpos;  if (!yymatchChar(G, '=')) goto l291;
  l292:;	
  {  int yypos293= G->pos, yythunkpos293= G->thunkpos;  if (!yymatchChar(G, '=')) goto l293;  goto l292;
  l293:;	  G->pos= yypos293; G->thunkpos= yythunkpos293;
  }  goto l290;
  l291:;	  G->pos= yypos290; G->thunkpos= yythunkpos290;  if (!yymatchChar(G, '-')) goto l289;
  l294:;	
  {  int yypos295= G->pos, yythunkpos295= G->thunkpos;  if (!yymatchChar(G, '-')) goto l295;  goto l294;
  l295:;	  G->pos= yypos295; G->thunkpos= yythunkpos295;
  }
  }
  l290:;	  if (!yy_Newline(G)) { goto l289; }  goto l285;
  l289:;	  G->pos= yypos289; G->thunkpos= yythunkpos289;
  }
  {  int yypos296= G->pos, yythunkpos296= G->thunkpos;  if (!yy_FencedCodeBlockStartTick(G)) { goto l296; }  goto l285;
  l296:;	  G->pos= yypos296; G->thunkpos= yythunkpos296;
  }
  {  int yypos297= G->pos, yythunkpos297= G->thunkpos;  if (!yy_FencedCodeBlockStartTidle(G)) { goto l297; }  goto l285;
  l297:;	  G->pos= yypos297; G->thunkpos= yythunkpos297;
  }  yyText(G, G->begin, G->end);  if (!( EXT(pmh_EXT_MATH) )) goto l285;
  {  int yypos298= G->pos, yythunkpos298= G->thunkpos;  if (!yy_DisplayFormulaDollarMark(G)) { goto l298; }  goto l285;
  l298:;	  G->pos= yypos298; G->thunkpos= yythunkpos298;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "NormalEndline", G->buf+G->pos));
  return 1;
  l285:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "NormalEndline", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_TerminalEndline(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "TerminalEndline"));  if (!yy_Sp(G)) { goto l299; }  if (!yy_Newline(G)) { goto l299; }  if (!yy_Eof(G)) { goto l299; }
  yyprintf((stderr, "  ok   %s @ %s\n", "TerminalEndline", G->buf+G->pos));
  return 1;
  l299:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "TerminalEndline", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_LineBreak(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "LineBreak"));  if (!yymatchString(G, "  ")) goto l300;  if (!yy_NormalEndline(G)) { goto l300; }
  yyprintf((stderr, "  ok   %s @ %s\n", "LineBreak", G->buf+G->pos));
  return 1;
  l300:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "LineBreak", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_CharEntity(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "CharEntity"));  if (!yymatchChar(G, '&')) goto l301;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\376\377\377\007\376\377\377\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l301;
  l302:;	
  {  int yypos303= G->pos, yythunkpos303= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\376\377\377\007\376\377\377\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l303;  goto l302;
  l303:;	  G->pos= yypos303; G->thunkpos= yythunkpos303;
  }  if (!yymatchChar(G, ';')) goto l301;
  yyprintf((stderr, "  ok   %s @ %s\n", "CharEntity", G->buf+G->pos));
  return 1;
  l301:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "CharEntity", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_DecEntity(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "DecEntity"));  if (!yymatchChar(G, '&')) goto l304;  if (!yymatchChar(G, '#')) goto l304;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l304;
  l305:;	
  {  int yypos306= G->pos, yythunkpos306= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l306;  goto l305;
  l306:;	  G->pos= yypos306; G->thunkpos= yythunkpos306;
  }  if (!yymatchChar(G, ';')) goto l304;
  yyprintf((stderr, "  ok   %s @ %s\n", "DecEntity", G->buf+G->pos));
  return 1;
  l304:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "DecEntity", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HexEntity(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HexEntity"));  if (!yymatchChar(G, '&')) goto l307;  if (!yymatchChar(G, '#')) goto l307;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l307;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\176\000\000\000\176\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l307;
  l308:;	
  {  int yypos309= G->pos, yythunkpos309= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\176\000\000\000\176\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l309;  goto l308;
  l309:;	  G->pos= yypos309; G->thunkpos= yythunkpos309;
  }  if (!yymatchChar(G, ';')) goto l307;
  yyprintf((stderr, "  ok   %s @ %s\n", "HexEntity", G->buf+G->pos));
  return 1;
  l307:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HexEntity", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_ExtendedSpecialChar(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "ExtendedSpecialChar"));
  {  int yypos311= G->pos, yythunkpos311= G->thunkpos;  yyText(G, G->begin, G->end);  if (!( EXT(pmh_EXT_NOTES) )) goto l312;  if (!yymatchChar(G, '^')) goto l312;  goto l311;
  l312:;	  G->pos= yypos311; G->thunkpos= yythunkpos311;  yyText(G, G->begin, G->end);  if (!( EXT(pmh_EXT_MATH) )) goto l313;  if (!yymatchChar(G, '$')) goto l313;  goto l311;
  l313:;	  G->pos= yypos311; G->thunkpos= yythunkpos311;  yyText(G, G->begin, G->end);  if (!( EXT(pmh_EXT_TABLE) )) goto l310;  if (!yymatchChar(G, '|')) goto l310;
  }
  l311:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "ExtendedSpecialChar", G->buf+G->pos));
  return 1;
  l310:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ExtendedSpecialChar", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Alphanumeric(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Alphanumeric"));
  {  int yypos315= G->pos, yythunkpos315= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\376\377\377\007\376\377\377\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l316;  goto l315;
  l316:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\200")) goto l317;  goto l315;
  l317:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\201")) goto l318;  goto l315;
  l318:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\202")) goto l319;  goto l315;
  l319:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\203")) goto l320;  goto l315;
  l320:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\204")) goto l321;  goto l315;
  l321:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\205")) goto l322;  goto l315;
  l322:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\206")) goto l323;  goto l315;
  l323:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\207")) goto l324;  goto l315;
  l324:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\210")) goto l325;  goto l315;
  l325:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\211")) goto l326;  goto l315;
  l326:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\212")) goto l327;  goto l315;
  l327:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\213")) goto l328;  goto l315;
  l328:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\214")) goto l329;  goto l315;
  l329:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\215")) goto l330;  goto l315;
  l330:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\216")) goto l331;  goto l315;
  l331:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\217")) goto l332;  goto l315;
  l332:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\220")) goto l333;  goto l315;
  l333:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\221")) goto l334;  goto l315;
  l334:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\222")) goto l335;  goto l315;
  l335:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\223")) goto l336;  goto l315;
  l336:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\224")) goto l337;  goto l315;
  l337:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\225")) goto l338;  goto l315;
  l338:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\226")) goto l339;  goto l315;
  l339:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\227")) goto l340;  goto l315;
  l340:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\230")) goto l341;  goto l315;
  l341:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\231")) goto l342;  goto l315;
  l342:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\232")) goto l343;  goto l315;
  l343:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\233")) goto l344;  goto l315;
  l344:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\234")) goto l345;  goto l315;
  l345:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\235")) goto l346;  goto l315;
  l346:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\236")) goto l347;  goto l315;
  l347:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\237")) goto l348;  goto l315;
  l348:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\240")) goto l349;  goto l315;
  l349:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\241")) goto l350;  goto l315;
  l350:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\242")) goto l351;  goto l315;
  l351:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\243")) goto l352;  goto l315;
  l352:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\244")) goto l353;  goto l315;
  l353:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\245")) goto l354;  goto l315;
  l354:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\246")) goto l355;  goto l315;
  l355:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\247")) goto l356;  goto l315;
  l356:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\250")) goto l357;  goto l315;
  l357:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\251")) goto l358;  goto l315;
  l358:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\252")) goto l359;  goto l315;
  l359:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\253")) goto l360;  goto l315;
  l360:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\254")) goto l361;  goto l315;
  l361:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\255")) goto l362;  goto l315;
  l362:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\256")) goto l363;  goto l315;
  l363:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\257")) goto l364;  goto l315;
  l364:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\260")) goto l365;  goto l315;
  l365:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\261")) goto l366;  goto l315;
  l366:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\262")) goto l367;  goto l315;
  l367:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\263")) goto l368;  goto l315;
  l368:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\264")) goto l369;  goto l315;
  l369:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\265")) goto l370;  goto l315;
  l370:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\266")) goto l371;  goto l315;
  l371:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\267")) goto l372;  goto l315;
  l372:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\270")) goto l373;  goto l315;
  l373:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\271")) goto l374;  goto l315;
  l374:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\272")) goto l375;  goto l315;
  l375:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\273")) goto l376;  goto l315;
  l376:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\274")) goto l377;  goto l315;
  l377:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\275")) goto l378;  goto l315;
  l378:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\276")) goto l379;  goto l315;
  l379:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\277")) goto l380;  goto l315;
  l380:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\300")) goto l381;  goto l315;
  l381:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\301")) goto l382;  goto l315;
  l382:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\302")) goto l383;  goto l315;
  l383:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\303")) goto l384;  goto l315;
  l384:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\304")) goto l385;  goto l315;
  l385:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\305")) goto l386;  goto l315;
  l386:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\306")) goto l387;  goto l315;
  l387:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\307")) goto l388;  goto l315;
  l388:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\310")) goto l389;  goto l315;
  l389:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\311")) goto l390;  goto l315;
  l390:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\312")) goto l391;  goto l315;
  l391:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\313")) goto l392;  goto l315;
  l392:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\314")) goto l393;  goto l315;
  l393:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\315")) goto l394;  goto l315;
  l394:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\316")) goto l395;  goto l315;
  l395:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\317")) goto l396;  goto l315;
  l396:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\320")) goto l397;  goto l315;
  l397:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\321")) goto l398;  goto l315;
  l398:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\322")) goto l399;  goto l315;
  l399:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\323")) goto l400;  goto l315;
  l400:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\324")) goto l401;  goto l315;
  l401:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\325")) goto l402;  goto l315;
  l402:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\326")) goto l403;  goto l315;
  l403:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\327")) goto l404;  goto l315;
  l404:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\330")) goto l405;  goto l315;
  l405:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\331")) goto l406;  goto l315;
  l406:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\332")) goto l407;  goto l315;
  l407:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\333")) goto l408;  goto l315;
  l408:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\334")) goto l409;  goto l315;
  l409:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\335")) goto l410;  goto l315;
  l410:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\336")) goto l411;  goto l315;
  l411:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\337")) goto l412;  goto l315;
  l412:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\340")) goto l413;  goto l315;
  l413:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\341")) goto l414;  goto l315;
  l414:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\342")) goto l415;  goto l315;
  l415:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\343")) goto l416;  goto l315;
  l416:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\344")) goto l417;  goto l315;
  l417:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\345")) goto l418;  goto l315;
  l418:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\346")) goto l419;  goto l315;
  l419:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\347")) goto l420;  goto l315;
  l420:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\350")) goto l421;  goto l315;
  l421:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\351")) goto l422;  goto l315;
  l422:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\352")) goto l423;  goto l315;
  l423:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\353")) goto l424;  goto l315;
  l424:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\354")) goto l425;  goto l315;
  l425:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\355")) goto l426;  goto l315;
  l426:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\356")) goto l427;  goto l315;
  l427:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\357")) goto l428;  goto l315;
  l428:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\360")) goto l429;  goto l315;
  l429:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\361")) goto l430;  goto l315;
  l430:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\362")) goto l431;  goto l315;
  l431:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\363")) goto l432;  goto l315;
  l432:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\364")) goto l433;  goto l315;
  l433:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\365")) goto l434;  goto l315;
  l434:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\366")) goto l435;  goto l315;
  l435:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\367")) goto l436;  goto l315;
  l436:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\370")) goto l437;  goto l315;
  l437:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\371")) goto l438;  goto l315;
  l438:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\372")) goto l439;  goto l315;
  l439:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\373")) goto l440;  goto l315;
  l440:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\374")) goto l441;  goto l315;
  l441:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\375")) goto l442;  goto l315;
  l442:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\376")) goto l443;  goto l315;
  l443:;	  G->pos= yypos315; G->thunkpos= yythunkpos315;  if (!yymatchString(G, "\377")) goto l314;
  }
  l315:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "Alphanumeric", G->buf+G->pos));
  return 1;
  l314:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Alphanumeric", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_NormalChar(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "NormalChar"));
  {  int yypos445= G->pos, yythunkpos445= G->thunkpos;
  {  int yypos446= G->pos, yythunkpos446= G->thunkpos;  if (!yy_SpecialChar(G)) { goto l447; }  goto l446;
  l447:;	  G->pos= yypos446; G->thunkpos= yythunkpos446;  if (!yy_Spacechar(G)) { goto l448; }  goto l446;
  l448:;	  G->pos= yypos446; G->thunkpos= yythunkpos446;  if (!yy_Newline(G)) { goto l445; }
  }
  l446:;	  goto l444;
  l445:;	  G->pos= yypos445; G->thunkpos= yythunkpos445;
  }  if (!yymatchDot(G)) goto l444;
  yyprintf((stderr, "  ok   %s @ %s\n", "NormalChar", G->buf+G->pos));
  return 1;
  l444:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "NormalChar", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Symbol(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Symbol"));  if (!yy_SpecialChar(G)) { goto l449; }
  yyprintf((stderr, "  ok   %s @ %s\n", "Symbol", G->buf+G->pos));
  return 1;
  l449:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Symbol", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_EscapedChar(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "EscapedChar"));  if (!yymatchChar(G, '\\')) goto l450;
  {  int yypos451= G->pos, yythunkpos451= G->thunkpos;  if (!yy_Newline(G)) { goto l451; }  goto l450;
  l451:;	  G->pos= yypos451; G->thunkpos= yythunkpos451;
  }
  {  int yypos452= G->pos, yythunkpos452= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\012\157\000\120\000\000\000\270\001\000\000\170\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l453;  goto l452;
  l453:;	  G->pos= yypos452; G->thunkpos= yythunkpos452;  if (!yy_ExtendedSpecialChar(G)) { goto l450; }
  }
  l452:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "EscapedChar", G->buf+G->pos));
  return 1;
  l450:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "EscapedChar", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Entity(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "Entity"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l454;  if (!yy_LocMarker(G)) { goto l454; }  yyDo(G, yySet, -1, 0);
  {  int yypos455= G->pos, yythunkpos455= G->thunkpos;  if (!yy_HexEntity(G)) { goto l456; }  goto l455;
  l456:;	  G->pos= yypos455; G->thunkpos= yythunkpos455;  if (!yy_DecEntity(G)) { goto l457; }  goto l455;
  l457:;	  G->pos= yypos455; G->thunkpos= yythunkpos455;  if (!yy_CharEntity(G)) { goto l454; }
  }
  l455:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l454;  yyDo(G, yy_1_Entity, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Entity", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l454:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Entity", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_RawHtml(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "RawHtml"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l458;  if (!yy_LocMarker(G)) { goto l458; }  yyDo(G, yySet, -1, 0);
  {  int yypos459= G->pos, yythunkpos459= G->thunkpos;  if (!yy_HtmlComment(G)) { goto l460; }  goto l459;
  l460:;	  G->pos= yypos459; G->thunkpos= yythunkpos459;  if (!yy_HtmlBlockScript(G)) { goto l461; }  goto l459;
  l461:;	  G->pos= yypos459; G->thunkpos= yythunkpos459;  if (!yy_HtmlTag(G)) { goto l458; }
  }
  l459:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l458;  yyDo(G, yy_1_RawHtml, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "RawHtml", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l458:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "RawHtml", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Mark(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0);
  yyprintf((stderr, "%s\n", "Mark"));  yyText(G, G->begin, G->end);  if (!( EXT(pmh_EXT_MARK) )) goto l462;  if (!yy_MarkTagOpen(G)) { goto l462; }  yyDo(G, yySet, -2, 0);  if (!yy_MarkTagText(G)) { goto l462; }  if (!yy_MarkTagClose(G)) { goto l462; }  yyDo(G, yySet, -1, 0);  yyDo(G, yy_1_Mark, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Mark", G->buf+G->pos));  yyDo(G, yyPop, 2, 0);
  return 1;
  l462:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Mark", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Code(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "Code"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l463;
  {  int yypos464= G->pos, yythunkpos464= G->thunkpos;  if (!yy_Ticks1(G)) { goto l465; }  yyDo(G, yySet, -1, 0);  if (!yy_Sp(G)) { goto l465; }
  {  int yypos468= G->pos, yythunkpos468= G->thunkpos;
  {  int yypos472= G->pos, yythunkpos472= G->thunkpos;  if (!yymatchChar(G, '`')) goto l472;  goto l469;
  l472:;	  G->pos= yypos472; G->thunkpos= yythunkpos472;
  }  if (!yy_Nonspacechar(G)) { goto l469; }
  l470:;	
  {  int yypos471= G->pos, yythunkpos471= G->thunkpos;
  {  int yypos473= G->pos, yythunkpos473= G->thunkpos;  if (!yymatchChar(G, '`')) goto l473;  goto l471;
  l473:;	  G->pos= yypos473; G->thunkpos= yythunkpos473;
  }  if (!yy_Nonspacechar(G)) { goto l471; }  goto l470;
  l471:;	  G->pos= yypos471; G->thunkpos= yythunkpos471;
  }  goto l468;
  l469:;	  G->pos= yypos468; G->thunkpos= yythunkpos468;
  {  int yypos475= G->pos, yythunkpos475= G->thunkpos;  if (!yy_Ticks1(G)) { goto l475; }  goto l474;
  l475:;	  G->pos= yypos475; G->thunkpos= yythunkpos475;
  }  if (!yymatchChar(G, '`')) goto l474;
  l476:;	
  {  int yypos477= G->pos, yythunkpos477= G->thunkpos;  if (!yymatchChar(G, '`')) goto l477;  goto l476;
  l477:;	  G->pos= yypos477; G->thunkpos= yythunkpos477;
  }  goto l468;
  l474:;	  G->pos= yypos468; G->thunkpos= yythunkpos468;
  {  int yypos478= G->pos, yythunkpos478= G->thunkpos;  if (!yy_Sp(G)) { goto l478; }  if (!yy_Ticks1(G)) { goto l478; }  goto l465;
  l478:;	  G->pos= yypos478; G->thunkpos= yythunkpos478;
  }
  {  int yypos479= G->pos, yythunkpos479= G->thunkpos;  if (!yy_Spacechar(G)) { goto l480; }  goto l479;
  l480:;	  G->pos= yypos479; G->thunkpos= yythunkpos479;  if (!yy_Newline(G)) { goto l465; }
  {  int yypos481= G->pos, yythunkpos481= G->thunkpos;  if (!yy_BlankLine(G)) { goto l481; }  goto l465;
  l481:;	  G->pos= yypos481; G->thunkpos= yythunkpos481;
  }
  }
  l479:;	
  }
  l468:;	
  l466:;	
  {  int yypos467= G->pos, yythunkpos467= G->thunkpos;
  {  int yypos482= G->pos, yythunkpos482= G->thunkpos;
  {  int yypos486= G->pos, yythunkpos486= G->thunkpos;  if (!yymatchChar(G, '`')) goto l486;  goto l483;
  l486:;	  G->pos= yypos486; G->thunkpos= yythunkpos486;
  }  if (!yy_Nonspacechar(G)) { goto l483; }
  l484:;	
  {  int yypos485= G->pos, yythunkpos485= G->thunkpos;
  {  int yypos487= G->pos, yythunkpos487= G->thunkpos;  if (!yymatchChar(G, '`')) goto l487;  goto l485;
  l487:;	  G->pos= yypos487; G->thunkpos= yythunkpos487;
  }  if (!yy_Nonspacechar(G)) { goto l485; }  goto l484;
  l485:;	  G->pos= yypos485; G->thunkpos= yythunkpos485;
  }  goto l482;
  l483:;	  G->pos= yypos482; G->thunkpos= yythunkpos482;
  {  int yypos489= G->pos, yythunkpos489= G->thunkpos;  if (!yy_Ticks1(G)) { goto l489; }  goto l488;
  l489:;	  G->pos= yypos489; G->thunkpos= yythunkpos489;
  }  if (!yymatchChar(G, '`')) goto l488;
  l490:;	
  {  int yypos491= G->pos, yythunkpos491= G->thunkpos;  if (!yymatchChar(G, '`')) goto l491;  goto l490;
  l491:;	  G->pos= yypos491; G->thunkpos= yythunkpos491;
  }  goto l482;
  l488:;	  G->pos= yypos482; G->thunkpos= yythunkpos482;
  {  int yypos492= G->pos, yythunkpos492= G->thunkpos;  if (!yy_Sp(G)) { goto l492; }  if (!yy_Ticks1(G)) { goto l492; }  goto l467;
  l492:;	  G->pos= yypos492; G->thunkpos= yythunkpos492;
  }
  {  int yypos493= G->pos, yythunkpos493= G->thunkpos;  if (!yy_Spacechar(G)) { goto l494; }  goto l493;
  l494:;	  G->pos= yypos493; G->thunkpos= yythunkpos493;  if (!yy_Newline(G)) { goto l467; }
  {  int yypos495= G->pos, yythunkpos495= G->thunkpos;  if (!yy_BlankLine(G)) { goto l495; }  goto l467;
  l495:;	  G->pos= yypos495; G->thunkpos= yythunkpos495;
  }
  }
  l493:;	
  }
  l482:;	  goto l466;
  l467:;	  G->pos= yypos467; G->thunkpos= yythunkpos467;
  }  if (!yy_Sp(G)) { goto l465; }  if (!yy_Ticks1(G)) { goto l465; }  goto l464;
  l465:;	  G->pos= yypos464; G->thunkpos= yythunkpos464;  if (!yy_Ticks2(G)) { goto l496; }  yyDo(G, yySet, -1, 0);  if (!yy_Sp(G)) { goto l496; }
  {  int yypos499= G->pos, yythunkpos499= G->thunkpos;
  {  int yypos503= G->pos, yythunkpos503= G->thunkpos;  if (!yymatchChar(G, '`')) goto l503;  goto l500;
  l503:;	  G->pos= yypos503; G->thunkpos= yythunkpos503;
  }  if (!yy_Nonspacechar(G)) { goto l500; }
  l501:;	
  {  int yypos502= G->pos, yythunkpos502= G->thunkpos;
  {  int yypos504= G->pos, yythunkpos504= G->thunkpos;  if (!yymatchChar(G, '`')) goto l504;  goto l502;
  l504:;	  G->pos= yypos504; G->thunkpos= yythunkpos504;
  }  if (!yy_Nonspacechar(G)) { goto l502; }  goto l501;
  l502:;	  G->pos= yypos502; G->thunkpos= yythunkpos502;
  }  goto l499;
  l500:;	  G->pos= yypos499; G->thunkpos= yythunkpos499;
  {  int yypos506= G->pos, yythunkpos506= G->thunkpos;  if (!yy_Ticks2(G)) { goto l506; }  goto l505;
  l506:;	  G->pos= yypos506; G->thunkpos= yythunkpos506;
  }  if (!yymatchChar(G, '`')) goto l505;
  l507:;	
  {  int yypos508= G->pos, yythunkpos508= G->thunkpos;  if (!yymatchChar(G, '`')) goto l508;  goto l507;
  l508:;	  G->pos= yypos508; G->thunkpos= yythunkpos508;
  }  goto l499;
  l505:;	  G->pos= yypos499; G->thunkpos= yythunkpos499;
  {  int yypos509= G->pos, yythunkpos509= G->thunkpos;  if (!yy_Sp(G)) { goto l509; }  if (!yy_Ticks2(G)) { goto l509; }  goto l496;
  l509:;	  G->pos= yypos509; G->thunkpos= yythunkpos509;
  }
  {  int yypos510= G->pos, yythunkpos510= G->thunkpos;  if (!yy_Spacechar(G)) { goto l511; }  goto l510;
  l511:;	  G->pos= yypos510; G->thunkpos= yythunkpos510;  if (!yy_Newline(G)) { goto l496; }
  {  int yypos512= G->pos, yythunkpos512= G->thunkpos;  if (!yy_BlankLine(G)) { goto l512; }  goto l496;
  l512:;	  G->pos= yypos512; G->thunkpos= yythunkpos512;
  }
  }
  l510:;	
  }
  l499:;	
  l497:;	
  {  int yypos498= G->pos, yythunkpos498= G->thunkpos;
  {  int yypos513= G->pos, yythunkpos513= G->thunkpos;
  {  int yypos517= G->pos, yythunkpos517= G->thunkpos;  if (!yymatchChar(G, '`')) goto l517;  goto l514;
  l517:;	  G->pos= yypos517; G->thunkpos= yythunkpos517;
  }  if (!yy_Nonspacechar(G)) { goto l514; }
  l515:;	
  {  int yypos516= G->pos, yythunkpos516= G->thunkpos;
  {  int yypos518= G->pos, yythunkpos518= G->thunkpos;  if (!yymatchChar(G, '`')) goto l518;  goto l516;
  l518:;	  G->pos= yypos518; G->thunkpos= yythunkpos518;
  }  if (!yy_Nonspacechar(G)) { goto l516; }  goto l515;
  l516:;	  G->pos= yypos516; G->thunkpos= yythunkpos516;
  }  goto l513;
  l514:;	  G->pos= yypos513; G->thunkpos= yythunkpos513;
  {  int yypos520= G->pos, yythunkpos520= G->thunkpos;  if (!yy_Ticks2(G)) { goto l520; }  goto l519;
  l520:;	  G->pos= yypos520; G->thunkpos= yythunkpos520;
  }  if (!yymatchChar(G, '`')) goto l519;
  l521:;	
  {  int yypos522= G->pos, yythunkpos522= G->thunkpos;  if (!yymatchChar(G, '`')) goto l522;  goto l521;
  l522:;	  G->pos= yypos522; G->thunkpos= yythunkpos522;
  }  goto l513;
  l519:;	  G->pos= yypos513; G->thunkpos= yythunkpos513;
  {  int yypos523= G->pos, yythunkpos523= G->thunkpos;  if (!yy_Sp(G)) { goto l523; }  if (!yy_Ticks2(G)) { goto l523; }  goto l498;
  l523:;	  G->pos= yypos523; G->thunkpos= yythunkpos523;
  }
  {  int yypos524= G->pos, yythunkpos524= G->thunkpos;  if (!yy_Spacechar(G)) { goto l525; }  goto l524;
  l525:;	  G->pos= yypos524; G->thunkpos= yythunkpos524;  if (!yy_Newline(G)) { goto l498; }
  {  int yypos526= G->pos, yythunkpos526= G->thunkpos;  if (!yy_BlankLine(G)) { goto l526; }  goto l498;
  l526:;	  G->pos= yypos526; G->thunkpos= yythunkpos526;
  }
  }
  l524:;	
  }
  l513:;	  goto l497;
  l498:;	  G->pos= yypos498; G->thunkpos= yythunkpos498;
  }  if (!yy_Sp(G)) { goto l496; }  if (!yy_Ticks2(G)) { goto l496; }  goto l464;
  l496:;	  G->pos= yypos464; G->thunkpos= yythunkpos464;
  {  int yypos528= G->pos, yythunkpos528= G->thunkpos;  if (!yy_FencedCodeBlockStartTickLine(G)) { goto l528; }  goto l527;
  l528:;	  G->pos= yypos528; G->thunkpos= yythunkpos528;
  }  if (!yy_Ticks3(G)) { goto l527; }  yyDo(G, yySet, -1, 0);  if (!yy_Sp(G)) { goto l527; }
  {  int yypos531= G->pos, yythunkpos531= G->thunkpos;
  {  int yypos535= G->pos, yythunkpos535= G->thunkpos;  if (!yymatchChar(G, '`')) goto l535;  goto l532;
  l535:;	  G->pos= yypos535; G->thunkpos= yythunkpos535;
  }  if (!yy_Nonspacechar(G)) { goto l532; }
  l533:;	
  {  int yypos534= G->pos, yythunkpos534= G->thunkpos;
  {  int yypos536= G->pos, yythunkpos536= G->thunkpos;  if (!yymatchChar(G, '`')) goto l536;  goto l534;
  l536:;	  G->pos= yypos536; G->thunkpos= yythunkpos536;
  }  if (!yy_Nonspacechar(G)) { goto l534; }  goto l533;
  l534:;	  G->pos= yypos534; G->thunkpos= yythunkpos534;
  }  goto l531;
  l532:;	  G->pos= yypos531; G->thunkpos= yythunkpos531;
  {  int yypos538= G->pos, yythunkpos538= G->thunkpos;  if (!yy_Ticks3(G)) { goto l538; }  goto l537;
  l538:;	  G->pos= yypos538; G->thunkpos= yythunkpos538;
  }  if (!yymatchChar(G, '`')) goto l537;
  l539:;	
  {  int yypos540= G->pos, yythunkpos540= G->thunkpos;  if (!yymatchChar(G, '`')) goto l540;  goto l539;
  l540:;	  G->pos= yypos540; G->thunkpos= yythunkpos540;
  }  goto l531;
  l537:;	  G->pos= yypos531; G->thunkpos= yythunkpos531;
  {  int yypos541= G->pos, yythunkpos541= G->thunkpos;  if (!yy_Sp(G)) { goto l541; }  if (!yy_Ticks3(G)) { goto l541; }  goto l527;
  l541:;	  G->pos= yypos541; G->thunkpos= yythunkpos541;
  }
  {  int yypos542= G->pos, yythunkpos542= G->thunkpos;  if (!yy_Spacechar(G)) { goto l543; }  goto l542;
  l543:;	  G->pos= yypos542; G->thunkpos= yythunkpos542;  if (!yy_Newline(G)) { goto l527; }
  {  int yypos544= G->pos, yythunkpos544= G->thunkpos;  if (!yy_BlankLine(G)) { goto l544; }  goto l527;
  l544:;	  G->pos= yypos544; G->thunkpos= yythunkpos544;
  }
  }
  l542:;	
  }
  l531:;	
  l529:;	
  {  int yypos530= G->pos, yythunkpos530= G->thunkpos;
  {  int yypos545= G->pos, yythunkpos545= G->thunkpos;
  {  int yypos549= G->pos, yythunkpos549= G->thunkpos;  if (!yymatchChar(G, '`')) goto l549;  goto l546;
  l549:;	  G->pos= yypos549; G->thunkpos= yythunkpos549;
  }  if (!yy_Nonspacechar(G)) { goto l546; }
  l547:;	
  {  int yypos548= G->pos, yythunkpos548= G->thunkpos;
  {  int yypos550= G->pos, yythunkpos550= G->thunkpos;  if (!yymatchChar(G, '`')) goto l550;  goto l548;
  l550:;	  G->pos= yypos550; G->thunkpos= yythunkpos550;
  }  if (!yy_Nonspacechar(G)) { goto l548; }  goto l547;
  l548:;	  G->pos= yypos548; G->thunkpos= yythunkpos548;
  }  goto l545;
  l546:;	  G->pos= yypos545; G->thunkpos= yythunkpos545;
  {  int yypos552= G->pos, yythunkpos552= G->thunkpos;  if (!yy_Ticks3(G)) { goto l552; }  goto l551;
  l552:;	  G->pos= yypos552; G->thunkpos= yythunkpos552;
  }  if (!yymatchChar(G, '`')) goto l551;
  l553:;	
  {  int yypos554= G->pos, yythunkpos554= G->thunkpos;  if (!yymatchChar(G, '`')) goto l554;  goto l553;
  l554:;	  G->pos= yypos554; G->thunkpos= yythunkpos554;
  }  goto l545;
  l551:;	  G->pos= yypos545; G->thunkpos= yythunkpos545;
  {  int yypos555= G->pos, yythunkpos555= G->thunkpos;  if (!yy_Sp(G)) { goto l555; }  if (!yy_Ticks3(G)) { goto l555; }  goto l530;
  l555:;	  G->pos= yypos555; G->thunkpos= yythunkpos555;
  }
  {  int yypos556= G->pos, yythunkpos556= G->thunkpos;  if (!yy_Spacechar(G)) { goto l557; }  goto l556;
  l557:;	  G->pos= yypos556; G->thunkpos= yythunkpos556;  if (!yy_Newline(G)) { goto l530; }
  {  int yypos558= G->pos, yythunkpos558= G->thunkpos;  if (!yy_BlankLine(G)) { goto l558; }  goto l530;
  l558:;	  G->pos= yypos558; G->thunkpos= yythunkpos558;
  }
  }
  l556:;	
  }
  l545:;	  goto l529;
  l530:;	  G->pos= yypos530; G->thunkpos= yythunkpos530;
  }  if (!yy_Sp(G)) { goto l527; }  if (!yy_Ticks3(G)) { goto l527; }  goto l464;
  l527:;	  G->pos= yypos464; G->thunkpos= yythunkpos464;  if (!yy_Ticks4(G)) { goto l559; }  yyDo(G, yySet, -1, 0);  if (!yy_Sp(G)) { goto l559; }
  {  int yypos562= G->pos, yythunkpos562= G->thunkpos;
  {  int yypos566= G->pos, yythunkpos566= G->thunkpos;  if (!yymatchChar(G, '`')) goto l566;  goto l563;
  l566:;	  G->pos= yypos566; G->thunkpos= yythunkpos566;
  }  if (!yy_Nonspacechar(G)) { goto l563; }
  l564:;	
  {  int yypos565= G->pos, yythunkpos565= G->thunkpos;
  {  int yypos567= G->pos, yythunkpos567= G->thunkpos;  if (!yymatchChar(G, '`')) goto l567;  goto l565;
  l567:;	  G->pos= yypos567; G->thunkpos= yythunkpos567;
  }  if (!yy_Nonspacechar(G)) { goto l565; }  goto l564;
  l565:;	  G->pos= yypos565; G->thunkpos= yythunkpos565;
  }  goto l562;
  l563:;	  G->pos= yypos562; G->thunkpos= yythunkpos562;
  {  int yypos569= G->pos, yythunkpos569= G->thunkpos;  if (!yy_Ticks4(G)) { goto l569; }  goto l568;
  l569:;	  G->pos= yypos569; G->thunkpos= yythunkpos569;
  }  if (!yymatchChar(G, '`')) goto l568;
  l570:;	
  {  int yypos571= G->pos, yythunkpos571= G->thunkpos;  if (!yymatchChar(G, '`')) goto l571;  goto l570;
  l571:;	  G->pos= yypos571; G->thunkpos= yythunkpos571;
  }  goto l562;
  l568:;	  G->pos= yypos562; G->thunkpos= yythunkpos562;
  {  int yypos572= G->pos, yythunkpos572= G->thunkpos;  if (!yy_Sp(G)) { goto l572; }  if (!yy_Ticks4(G)) { goto l572; }  goto l559;
  l572:;	  G->pos= yypos572; G->thunkpos= yythunkpos572;
  }
  {  int yypos573= G->pos, yythunkpos573= G->thunkpos;  if (!yy_Spacechar(G)) { goto l574; }  goto l573;
  l574:;	  G->pos= yypos573; G->thunkpos= yythunkpos573;  if (!yy_Newline(G)) { goto l559; }
  {  int yypos575= G->pos, yythunkpos575= G->thunkpos;  if (!yy_BlankLine(G)) { goto l575; }  goto l559;
  l575:;	  G->pos= yypos575; G->thunkpos= yythunkpos575;
  }
  }
  l573:;	
  }
  l562:;	
  l560:;	
  {  int yypos561= G->pos, yythunkpos561= G->thunkpos;
  {  int yypos576= G->pos, yythunkpos576= G->thunkpos;
  {  int yypos580= G->pos, yythunkpos580= G->thunkpos;  if (!yymatchChar(G, '`')) goto l580;  goto l577;
  l580:;	  G->pos= yypos580; G->thunkpos= yythunkpos580;
  }  if (!yy_Nonspacechar(G)) { goto l577; }
  l578:;	
  {  int yypos579= G->pos, yythunkpos579= G->thunkpos;
  {  int yypos581= G->pos, yythunkpos581= G->thunkpos;  if (!yymatchChar(G, '`')) goto l581;  goto l579;
  l581:;	  G->pos= yypos581; G->thunkpos= yythunkpos581;
  }  if (!yy_Nonspacechar(G)) { goto l579; }  goto l578;
  l579:;	  G->pos= yypos579; G->thunkpos= yythunkpos579;
  }  goto l576;
  l577:;	  G->pos= yypos576; G->thunkpos= yythunkpos576;
  {  int yypos583= G->pos, yythunkpos583= G->thunkpos;  if (!yy_Ticks4(G)) { goto l583; }  goto l582;
  l583:;	  G->pos= yypos583; G->thunkpos= yythunkpos583;
  }  if (!yymatchChar(G, '`')) goto l582;
  l584:;	
  {  int yypos585= G->pos, yythunkpos585= G->thunkpos;  if (!yymatchChar(G, '`')) goto l585;  goto l584;
  l585:;	  G->pos= yypos585; G->thunkpos= yythunkpos585;
  }  goto l576;
  l582:;	  G->pos= yypos576; G->thunkpos= yythunkpos576;
  {  int yypos586= G->pos, yythunkpos586= G->thunkpos;  if (!yy_Sp(G)) { goto l586; }  if (!yy_Ticks4(G)) { goto l586; }  goto l561;
  l586:;	  G->pos= yypos586; G->thunkpos= yythunkpos586;
  }
  {  int yypos587= G->pos, yythunkpos587= G->thunkpos;  if (!yy_Spacechar(G)) { goto l588; }  goto l587;
  l588:;	  G->pos= yypos587; G->thunkpos= yythunkpos587;  if (!yy_Newline(G)) { goto l561; }
  {  int yypos589= G->pos, yythunkpos589= G->thunkpos;  if (!yy_BlankLine(G)) { goto l589; }  goto l561;
  l589:;	  G->pos= yypos589; G->thunkpos= yythunkpos589;
  }
  }
  l587:;	
  }
  l576:;	  goto l560;
  l561:;	  G->pos= yypos561; G->thunkpos= yythunkpos561;
  }  if (!yy_Sp(G)) { goto l559; }  if (!yy_Ticks4(G)) { goto l559; }  goto l464;
  l559:;	  G->pos= yypos464; G->thunkpos= yythunkpos464;  if (!yy_Ticks5(G)) { goto l463; }  yyDo(G, yySet, -1, 0);  if (!yy_Sp(G)) { goto l463; }
  {  int yypos592= G->pos, yythunkpos592= G->thunkpos;
  {  int yypos596= G->pos, yythunkpos596= G->thunkpos;  if (!yymatchChar(G, '`')) goto l596;  goto l593;
  l596:;	  G->pos= yypos596; G->thunkpos= yythunkpos596;
  }  if (!yy_Nonspacechar(G)) { goto l593; }
  l594:;	
  {  int yypos595= G->pos, yythunkpos595= G->thunkpos;
  {  int yypos597= G->pos, yythunkpos597= G->thunkpos;  if (!yymatchChar(G, '`')) goto l597;  goto l595;
  l597:;	  G->pos= yypos597; G->thunkpos= yythunkpos597;
  }  if (!yy_Nonspacechar(G)) { goto l595; }  goto l594;
  l595:;	  G->pos= yypos595; G->thunkpos= yythunkpos595;
  }  goto l592;
  l593:;	  G->pos= yypos592; G->thunkpos= yythunkpos592;
  {  int yypos599= G->pos, yythunkpos599= G->thunkpos;  if (!yy_Ticks5(G)) { goto l599; }  goto l598;
  l599:;	  G->pos= yypos599; G->thunkpos= yythunkpos599;
  }  if (!yymatchChar(G, '`')) goto l598;
  l600:;	
  {  int yypos601= G->pos, yythunkpos601= G->thunkpos;  if (!yymatchChar(G, '`')) goto l601;  goto l600;
  l601:;	  G->pos= yypos601; G->thunkpos= yythunkpos601;
  }  goto l592;
  l598:;	  G->pos= yypos592; G->thunkpos= yythunkpos592;
  {  int yypos602= G->pos, yythunkpos602= G->thunkpos;  if (!yy_Sp(G)) { goto l602; }  if (!yy_Ticks5(G)) { goto l602; }  goto l463;
  l602:;	  G->pos= yypos602; G->thunkpos= yythunkpos602;
  }
  {  int yypos603= G->pos, yythunkpos603= G->thunkpos;  if (!yy_Spacechar(G)) { goto l604; }  goto l603;
  l604:;	  G->pos= yypos603; G->thunkpos= yythunkpos603;  if (!yy_Newline(G)) { goto l463; }
  {  int yypos605= G->pos, yythunkpos605= G->thunkpos;  if (!yy_BlankLine(G)) { goto l605; }  goto l463;
  l605:;	  G->pos= yypos605; G->thunkpos= yythunkpos605;
  }
  }
  l603:;	
  }
  l592:;	
  l590:;	
  {  int yypos591= G->pos, yythunkpos591= G->thunkpos;
  {  int yypos606= G->pos, yythunkpos606= G->thunkpos;
  {  int yypos610= G->pos, yythunkpos610= G->thunkpos;  if (!yymatchChar(G, '`')) goto l610;  goto l607;
  l610:;	  G->pos= yypos610; G->thunkpos= yythunkpos610;
  }  if (!yy_Nonspacechar(G)) { goto l607; }
  l608:;	
  {  int yypos609= G->pos, yythunkpos609= G->thunkpos;
  {  int yypos611= G->pos, yythunkpos611= G->thunkpos;  if (!yymatchChar(G, '`')) goto l611;  goto l609;
  l611:;	  G->pos= yypos611; G->thunkpos= yythunkpos611;
  }  if (!yy_Nonspacechar(G)) { goto l609; }  goto l608;
  l609:;	  G->pos= yypos609; G->thunkpos= yythunkpos609;
  }  goto l606;
  l607:;	  G->pos= yypos606; G->thunkpos= yythunkpos606;
  {  int yypos613= G->pos, yythunkpos613= G->thunkpos;  if (!yy_Ticks5(G)) { goto l613; }  goto l612;
  l613:;	  G->pos= yypos613; G->thunkpos= yythunkpos613;
  }  if (!yymatchChar(G, '`')) goto l612;
  l614:;	
  {  int yypos615= G->pos, yythunkpos615= G->thunkpos;  if (!yymatchChar(G, '`')) goto l615;  goto l614;
  l615:;	  G->pos= yypos615; G->thunkpos= yythunkpos615;
  }  goto l606;
  l612:;	  G->pos= yypos606; G->thunkpos= yythunkpos606;
  {  int yypos616= G->pos, yythunkpos616= G->thunkpos;  if (!yy_Sp(G)) { goto l616; }  if (!yy_Ticks5(G)) { goto l616; }  goto l591;
  l616:;	  G->pos= yypos616; G->thunkpos= yythunkpos616;
  }
  {  int yypos617= G->pos, yythunkpos617= G->thunkpos;  if (!yy_Spacechar(G)) { goto l618; }  goto l617;
  l618:;	  G->pos= yypos617; G->thunkpos= yythunkpos617;  if (!yy_Newline(G)) { goto l591; }
  {  int yypos619= G->pos, yythunkpos619= G->thunkpos;  if (!yy_BlankLine(G)) { goto l619; }  goto l591;
  l619:;	  G->pos= yypos619; G->thunkpos= yythunkpos619;
  }
  }
  l617:;	
  }
  l606:;	  goto l590;
  l591:;	  G->pos= yypos591; G->thunkpos= yythunkpos591;
  }  if (!yy_Sp(G)) { goto l463; }  if (!yy_Ticks5(G)) { goto l463; }
  }
  l464:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l463;  yyDo(G, yy_1_Code, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Code", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l463:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Code", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_InlineNote(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "InlineNote"));  yyText(G, G->begin, G->end);  if (!( EXT(pmh_EXT_NOTES) )) goto l620;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l620;  if (!yy_LocMarker(G)) { goto l620; }  yyDo(G, yySet, -1, 0);  if (!yymatchString(G, "^[")) goto l620;
  {  int yypos623= G->pos, yythunkpos623= G->thunkpos;  if (!yymatchChar(G, ']')) goto l623;  goto l620;
  l623:;	  G->pos= yypos623; G->thunkpos= yythunkpos623;
  }  if (!yy_Inline(G)) { goto l620; }
  l621:;	
  {  int yypos622= G->pos, yythunkpos622= G->thunkpos;
  {  int yypos624= G->pos, yythunkpos624= G->thunkpos;  if (!yymatchChar(G, ']')) goto l624;  goto l622;
  l624:;	  G->pos= yypos624; G->thunkpos= yythunkpos624;
  }  if (!yy_Inline(G)) { goto l622; }  goto l621;
  l622:;	  G->pos= yypos622; G->thunkpos= yythunkpos622;
  }  if (!yymatchChar(G, ']')) goto l620;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l620;  yyDo(G, yy_1_InlineNote, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "InlineNote", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l620:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "InlineNote", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_NoteReference(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "NoteReference"));  yyText(G, G->begin, G->end);  if (!( EXT(pmh_EXT_NOTES) )) goto l625;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l625;  if (!yy_RawNoteReference(G)) { goto l625; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l625;  yyDo(G, yy_1_NoteReference, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "NoteReference", G->buf+G->pos));
  return 1;
  l625:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "NoteReference", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Link(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Link"));
  {  int yypos627= G->pos, yythunkpos627= G->thunkpos;  if (!yy_ExplicitLink(G)) { goto l628; }  goto l627;
  l628:;	  G->pos= yypos627; G->thunkpos= yythunkpos627;  if (!yy_ReferenceLink(G)) { goto l629; }  goto l627;
  l629:;	  G->pos= yypos627; G->thunkpos= yythunkpos627;  if (!yy_AutoLink(G)) { goto l626; }
  }
  l627:;	  yyDo(G, yy_1_Link, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Link", G->buf+G->pos));
  return 1;
  l626:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Link", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Image(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Image"));  if (!yymatchChar(G, '!')) goto l630;
  {  int yypos631= G->pos, yythunkpos631= G->thunkpos;  if (!yy_ExplicitLink(G)) { goto l632; }  goto l631;
  l632:;	  G->pos= yypos631; G->thunkpos= yythunkpos631;  if (!yy_ExplicitLinkSize(G)) { goto l633; }  goto l631;
  l633:;	  G->pos= yypos631; G->thunkpos= yythunkpos631;  if (!yy_ReferenceLink(G)) { goto l630; }
  }
  l631:;	  yyDo(G, yy_1_Image, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Image", G->buf+G->pos));
  return 1;
  l630:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Image", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Strike(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "Strike"));  yyText(G, G->begin, G->end);  if (!( EXT(pmh_EXT_STRIKE) )) goto l634;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l634;  if (!yy_LocMarker(G)) { goto l634; }  yyDo(G, yySet, -1, 0);  if (!yymatchString(G, "~~")) goto l634;
  {  int yypos635= G->pos, yythunkpos635= G->thunkpos;  if (!yy_Whitespace(G)) { goto l635; }  goto l634;
  l635:;	  G->pos= yypos635; G->thunkpos= yythunkpos635;
  }
  {  int yypos638= G->pos, yythunkpos638= G->thunkpos;  if (!yymatchString(G, "~~")) goto l638;  goto l634;
  l638:;	  G->pos= yypos638; G->thunkpos= yythunkpos638;
  }  if (!yy_Inline(G)) { goto l634; }
  l636:;	
  {  int yypos637= G->pos, yythunkpos637= G->thunkpos;
  {  int yypos639= G->pos, yythunkpos639= G->thunkpos;  if (!yymatchString(G, "~~")) goto l639;  goto l637;
  l639:;	  G->pos= yypos639; G->thunkpos= yythunkpos639;
  }  if (!yy_Inline(G)) { goto l637; }  goto l636;
  l637:;	  G->pos= yypos637; G->thunkpos= yythunkpos637;
  }  yyText(G, G->begin, G->end);  if (!( STRIKE_POST )) goto l634;  if (!yymatchString(G, "~~")) goto l634;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l634;  yyDo(G, yy_1_Strike, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Strike", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l634:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Strike", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Emph(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Emph"));
  {  int yypos641= G->pos, yythunkpos641= G->thunkpos;  if (!yy_EmphStar(G)) { goto l642; }  goto l641;
  l642:;	  G->pos= yypos641; G->thunkpos= yythunkpos641;  if (!yy_EmphUl(G)) { goto l640; }
  }
  l641:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "Emph", G->buf+G->pos));
  return 1;
  l640:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Emph", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Strong(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Strong"));
  {  int yypos644= G->pos, yythunkpos644= G->thunkpos;  if (!yy_StrongStar(G)) { goto l645; }  goto l644;
  l645:;	  G->pos= yypos644; G->thunkpos= yythunkpos644;  if (!yy_StrongUl(G)) { goto l643; }
  }
  l644:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "Strong", G->buf+G->pos));
  return 1;
  l643:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Strong", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_UlOrStarLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "UlOrStarLine"));
  {  int yypos647= G->pos, yythunkpos647= G->thunkpos;  if (!yy_UlLine(G)) { goto l648; }  goto l647;
  l648:;	  G->pos= yypos647; G->thunkpos= yythunkpos647;  if (!yy_StarLine(G)) { goto l646; }
  }
  l647:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "UlOrStarLine", G->buf+G->pos));
  return 1;
  l646:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "UlOrStarLine", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Str(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Str"));  if (!yy_NormalChar(G)) { goto l649; }
  l650:;	
  {  int yypos651= G->pos, yythunkpos651= G->thunkpos;
  {  int yypos652= G->pos, yythunkpos652= G->thunkpos;  if (!yy_NormalChar(G)) { goto l653; }  goto l652;
  l653:;	  G->pos= yypos652; G->thunkpos= yythunkpos652;  if (!yymatchChar(G, '_')) goto l651;
  l654:;	
  {  int yypos655= G->pos, yythunkpos655= G->thunkpos;  if (!yymatchChar(G, '_')) goto l655;  goto l654;
  l655:;	  G->pos= yypos655; G->thunkpos= yythunkpos655;
  }
  {  int yypos656= G->pos, yythunkpos656= G->thunkpos;  if (!yy_Alphanumeric(G)) { goto l651; }  G->pos= yypos656; G->thunkpos= yythunkpos656;
  }
  }
  l652:;	  goto l650;
  l651:;	  G->pos= yypos651; G->thunkpos= yythunkpos651;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "Str", G->buf+G->pos));
  return 1;
  l649:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Str", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_InStyleTags(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "InStyleTags"));  if (!yy_StyleOpen(G)) { goto l657; }
  l658:;	
  {  int yypos659= G->pos, yythunkpos659= G->thunkpos;
  {  int yypos660= G->pos, yythunkpos660= G->thunkpos;  if (!yy_StyleClose(G)) { goto l660; }  goto l659;
  l660:;	  G->pos= yypos660; G->thunkpos= yythunkpos660;
  }  if (!yymatchDot(G)) goto l659;  goto l658;
  l659:;	  G->pos= yypos659; G->thunkpos= yythunkpos659;
  }  if (!yy_StyleClose(G)) { goto l657; }
  yyprintf((stderr, "  ok   %s @ %s\n", "InStyleTags", G->buf+G->pos));
  return 1;
  l657:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "InStyleTags", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_StyleClose(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "StyleClose"));  if (!yymatchChar(G, '<')) goto l661;  if (!yy_Spnl(G)) { goto l661; }  if (!yymatchChar(G, '/')) goto l661;
  {  int yypos662= G->pos, yythunkpos662= G->thunkpos;  if (!yymatchString(G, "style")) goto l663;  goto l662;
  l663:;	  G->pos= yypos662; G->thunkpos= yythunkpos662;  if (!yymatchString(G, "STYLE")) goto l661;
  }
  l662:;	  if (!yy_Spnl(G)) { goto l661; }  if (!yymatchChar(G, '>')) goto l661;
  yyprintf((stderr, "  ok   %s @ %s\n", "StyleClose", G->buf+G->pos));
  return 1;
  l661:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "StyleClose", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_StyleOpen(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "StyleOpen"));  if (!yymatchChar(G, '<')) goto l664;  if (!yy_Spnl(G)) { goto l664; }
  {  int yypos665= G->pos, yythunkpos665= G->thunkpos;  if (!yymatchString(G, "style")) goto l666;  goto l665;
  l666:;	  G->pos= yypos665; G->thunkpos= yythunkpos665;  if (!yymatchString(G, "STYLE")) goto l664;
  }
  l665:;	  if (!yy_Spnl(G)) { goto l664; }
  l667:;	
  {  int yypos668= G->pos, yythunkpos668= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l668; }  goto l667;
  l668:;	  G->pos= yypos668; G->thunkpos= yythunkpos668;
  }  if (!yymatchChar(G, '>')) goto l664;
  yyprintf((stderr, "  ok   %s @ %s\n", "StyleOpen", G->buf+G->pos));
  return 1;
  l664:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "StyleOpen", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockType(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockType"));
  {  int yypos670= G->pos, yythunkpos670= G->thunkpos;  if (!yymatchString(G, "address")) goto l671;  goto l670;
  l671:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "blockquote")) goto l672;  goto l670;
  l672:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "center")) goto l673;  goto l670;
  l673:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "dir")) goto l674;  goto l670;
  l674:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "div")) goto l675;  goto l670;
  l675:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "dl")) goto l676;  goto l670;
  l676:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "fieldset")) goto l677;  goto l670;
  l677:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "form")) goto l678;  goto l670;
  l678:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "h1")) goto l679;  goto l670;
  l679:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "h2")) goto l680;  goto l670;
  l680:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "h3")) goto l681;  goto l670;
  l681:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "h4")) goto l682;  goto l670;
  l682:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "h5")) goto l683;  goto l670;
  l683:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "h6")) goto l684;  goto l670;
  l684:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "hr")) goto l685;  goto l670;
  l685:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "isindex")) goto l686;  goto l670;
  l686:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "menu")) goto l687;  goto l670;
  l687:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "noframes")) goto l688;  goto l670;
  l688:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "noscript")) goto l689;  goto l670;
  l689:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "ol")) goto l690;  goto l670;
  l690:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchChar(G, 'p')) goto l691;  goto l670;
  l691:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "pre")) goto l692;  goto l670;
  l692:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "table")) goto l693;  goto l670;
  l693:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "ul")) goto l694;  goto l670;
  l694:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "dd")) goto l695;  goto l670;
  l695:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "dt")) goto l696;  goto l670;
  l696:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "frameset")) goto l697;  goto l670;
  l697:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "li")) goto l698;  goto l670;
  l698:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "tbody")) goto l699;  goto l670;
  l699:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "td")) goto l700;  goto l670;
  l700:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "tfoot")) goto l701;  goto l670;
  l701:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "th")) goto l702;  goto l670;
  l702:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "thead")) goto l703;  goto l670;
  l703:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "tr")) goto l704;  goto l670;
  l704:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "script")) goto l705;  goto l670;
  l705:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "ADDRESS")) goto l706;  goto l670;
  l706:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "BLOCKQUOTE")) goto l707;  goto l670;
  l707:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "CENTER")) goto l708;  goto l670;
  l708:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "DIR")) goto l709;  goto l670;
  l709:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "DIV")) goto l710;  goto l670;
  l710:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "DL")) goto l711;  goto l670;
  l711:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "FIELDSET")) goto l712;  goto l670;
  l712:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "FORM")) goto l713;  goto l670;
  l713:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "H1")) goto l714;  goto l670;
  l714:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "H2")) goto l715;  goto l670;
  l715:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "H3")) goto l716;  goto l670;
  l716:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "H4")) goto l717;  goto l670;
  l717:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "H5")) goto l718;  goto l670;
  l718:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "H6")) goto l719;  goto l670;
  l719:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "HR")) goto l720;  goto l670;
  l720:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "ISINDEX")) goto l721;  goto l670;
  l721:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "MENU")) goto l722;  goto l670;
  l722:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "NOFRAMES")) goto l723;  goto l670;
  l723:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "NOSCRIPT")) goto l724;  goto l670;
  l724:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "OL")) goto l725;  goto l670;
  l725:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchChar(G, 'P')) goto l726;  goto l670;
  l726:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "PRE")) goto l727;  goto l670;
  l727:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "TABLE")) goto l728;  goto l670;
  l728:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "UL")) goto l729;  goto l670;
  l729:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "DD")) goto l730;  goto l670;
  l730:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "DT")) goto l731;  goto l670;
  l731:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "FRAMESET")) goto l732;  goto l670;
  l732:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "LI")) goto l733;  goto l670;
  l733:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "TBODY")) goto l734;  goto l670;
  l734:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "TD")) goto l735;  goto l670;
  l735:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "TFOOT")) goto l736;  goto l670;
  l736:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "TH")) goto l737;  goto l670;
  l737:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "THEAD")) goto l738;  goto l670;
  l738:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "TR")) goto l739;  goto l670;
  l739:;	  G->pos= yypos670; G->thunkpos= yythunkpos670;  if (!yymatchString(G, "SCRIPT")) goto l669;
  }
  l670:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockType", G->buf+G->pos));
  return 1;
  l669:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockType", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockSelfClosing(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockSelfClosing"));  if (!yymatchChar(G, '<')) goto l740;  if (!yy_Spnl(G)) { goto l740; }  if (!yy_HtmlBlockType(G)) { goto l740; }  if (!yy_Spnl(G)) { goto l740; }
  l741:;	
  {  int yypos742= G->pos, yythunkpos742= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l742; }  goto l741;
  l742:;	  G->pos= yypos742; G->thunkpos= yythunkpos742;
  }  if (!yymatchChar(G, '/')) goto l740;  if (!yy_Spnl(G)) { goto l740; }  if (!yymatchChar(G, '>')) goto l740;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockSelfClosing", G->buf+G->pos));
  return 1;
  l740:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockSelfClosing", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlComment(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "HtmlComment"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l743;  if (!yy_LocMarker(G)) { goto l743; }  yyDo(G, yySet, -1, 0);  if (!yymatchString(G, "<!--")) goto l743;
  l744:;	
  {  int yypos745= G->pos, yythunkpos745= G->thunkpos;
  {  int yypos746= G->pos, yythunkpos746= G->thunkpos;  if (!yymatchString(G, "-->")) goto l746;  goto l745;
  l746:;	  G->pos= yypos746; G->thunkpos= yythunkpos746;
  }  if (!yymatchDot(G)) goto l745;  goto l744;
  l745:;	  G->pos= yypos745; G->thunkpos= yythunkpos745;
  }  if (!yymatchString(G, "-->")) goto l743;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l743;  yyDo(G, yy_1_HtmlComment, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlComment", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l743:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlComment", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockInTags(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockInTags"));
  {  int yypos748= G->pos, yythunkpos748= G->thunkpos;  if (!yy_HtmlBlockAddress(G)) { goto l749; }  goto l748;
  l749:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockBlockquote(G)) { goto l750; }  goto l748;
  l750:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockCenter(G)) { goto l751; }  goto l748;
  l751:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockDir(G)) { goto l752; }  goto l748;
  l752:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockDiv(G)) { goto l753; }  goto l748;
  l753:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockDl(G)) { goto l754; }  goto l748;
  l754:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockFieldset(G)) { goto l755; }  goto l748;
  l755:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockForm(G)) { goto l756; }  goto l748;
  l756:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockH1(G)) { goto l757; }  goto l748;
  l757:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockH2(G)) { goto l758; }  goto l748;
  l758:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockH3(G)) { goto l759; }  goto l748;
  l759:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockH4(G)) { goto l760; }  goto l748;
  l760:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockH5(G)) { goto l761; }  goto l748;
  l761:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockH6(G)) { goto l762; }  goto l748;
  l762:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockMenu(G)) { goto l763; }  goto l748;
  l763:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockNoframes(G)) { goto l764; }  goto l748;
  l764:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockNoscript(G)) { goto l765; }  goto l748;
  l765:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockOl(G)) { goto l766; }  goto l748;
  l766:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockP(G)) { goto l767; }  goto l748;
  l767:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockPre(G)) { goto l768; }  goto l748;
  l768:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockTable(G)) { goto l769; }  goto l748;
  l769:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockUl(G)) { goto l770; }  goto l748;
  l770:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockDd(G)) { goto l771; }  goto l748;
  l771:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockDt(G)) { goto l772; }  goto l748;
  l772:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockFrameset(G)) { goto l773; }  goto l748;
  l773:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockLi(G)) { goto l774; }  goto l748;
  l774:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockTbody(G)) { goto l775; }  goto l748;
  l775:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockTd(G)) { goto l776; }  goto l748;
  l776:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockTfoot(G)) { goto l777; }  goto l748;
  l777:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockTh(G)) { goto l778; }  goto l748;
  l778:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockThead(G)) { goto l779; }  goto l748;
  l779:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockTr(G)) { goto l780; }  goto l748;
  l780:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockScript(G)) { goto l781; }  goto l748;
  l781:;	  G->pos= yypos748; G->thunkpos= yythunkpos748;  if (!yy_HtmlBlockHead(G)) { goto l747; }
  }
  l748:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockInTags", G->buf+G->pos));
  return 1;
  l747:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockInTags", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockHead(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockHead"));  if (!yy_HtmlBlockOpenHead(G)) { goto l782; }
  l783:;	
  {  int yypos784= G->pos, yythunkpos784= G->thunkpos;
  {  int yypos785= G->pos, yythunkpos785= G->thunkpos;  if (!yy_HtmlBlockCloseHead(G)) { goto l785; }  goto l784;
  l785:;	  G->pos= yypos785; G->thunkpos= yythunkpos785;
  }  if (!yymatchDot(G)) goto l784;  goto l783;
  l784:;	  G->pos= yypos784; G->thunkpos= yythunkpos784;
  }  if (!yy_HtmlBlockCloseHead(G)) { goto l782; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockHead", G->buf+G->pos));
  return 1;
  l782:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockHead", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseHead(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseHead"));  if (!yymatchChar(G, '<')) goto l786;  if (!yy_Spnl(G)) { goto l786; }  if (!yymatchChar(G, '/')) goto l786;
  {  int yypos787= G->pos, yythunkpos787= G->thunkpos;  if (!yymatchString(G, "head")) goto l788;  goto l787;
  l788:;	  G->pos= yypos787; G->thunkpos= yythunkpos787;  if (!yymatchString(G, "HEAD")) goto l786;
  }
  l787:;	  if (!yy_Spnl(G)) { goto l786; }  if (!yymatchChar(G, '>')) goto l786;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseHead", G->buf+G->pos));
  return 1;
  l786:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseHead", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenHead(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenHead"));  if (!yymatchChar(G, '<')) goto l789;  if (!yy_Spnl(G)) { goto l789; }
  {  int yypos790= G->pos, yythunkpos790= G->thunkpos;  if (!yymatchString(G, "head")) goto l791;  goto l790;
  l791:;	  G->pos= yypos790; G->thunkpos= yythunkpos790;  if (!yymatchString(G, "HEAD")) goto l789;
  }
  l790:;	  if (!yy_Spnl(G)) { goto l789; }
  l792:;	
  {  int yypos793= G->pos, yythunkpos793= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l793; }  goto l792;
  l793:;	  G->pos= yypos793; G->thunkpos= yythunkpos793;
  }  if (!yymatchChar(G, '>')) goto l789;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenHead", G->buf+G->pos));
  return 1;
  l789:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenHead", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockScript(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockScript"));  if (!yy_HtmlBlockOpenScript(G)) { goto l794; }
  l795:;	
  {  int yypos796= G->pos, yythunkpos796= G->thunkpos;
  {  int yypos797= G->pos, yythunkpos797= G->thunkpos;  if (!yy_HtmlBlockCloseScript(G)) { goto l797; }  goto l796;
  l797:;	  G->pos= yypos797; G->thunkpos= yythunkpos797;
  }  if (!yymatchDot(G)) goto l796;  goto l795;
  l796:;	  G->pos= yypos796; G->thunkpos= yythunkpos796;
  }  if (!yy_HtmlBlockCloseScript(G)) { goto l794; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockScript", G->buf+G->pos));
  return 1;
  l794:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockScript", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseScript(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseScript"));  if (!yymatchChar(G, '<')) goto l798;  if (!yy_Spnl(G)) { goto l798; }  if (!yymatchChar(G, '/')) goto l798;
  {  int yypos799= G->pos, yythunkpos799= G->thunkpos;  if (!yymatchString(G, "script")) goto l800;  goto l799;
  l800:;	  G->pos= yypos799; G->thunkpos= yythunkpos799;  if (!yymatchString(G, "SCRIPT")) goto l798;
  }
  l799:;	  if (!yy_Spnl(G)) { goto l798; }  if (!yymatchChar(G, '>')) goto l798;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseScript", G->buf+G->pos));
  return 1;
  l798:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseScript", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenScript(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenScript"));  if (!yymatchChar(G, '<')) goto l801;  if (!yy_Spnl(G)) { goto l801; }
  {  int yypos802= G->pos, yythunkpos802= G->thunkpos;  if (!yymatchString(G, "script")) goto l803;  goto l802;
  l803:;	  G->pos= yypos802; G->thunkpos= yythunkpos802;  if (!yymatchString(G, "SCRIPT")) goto l801;
  }
  l802:;	  if (!yy_Spnl(G)) { goto l801; }
  l804:;	
  {  int yypos805= G->pos, yythunkpos805= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l805; }  goto l804;
  l805:;	  G->pos= yypos805; G->thunkpos= yythunkpos805;
  }  if (!yymatchChar(G, '>')) goto l801;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenScript", G->buf+G->pos));
  return 1;
  l801:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenScript", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockTr(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockTr"));  if (!yy_HtmlBlockOpenTr(G)) { goto l806; }
  l807:;	
  {  int yypos808= G->pos, yythunkpos808= G->thunkpos;
  {  int yypos809= G->pos, yythunkpos809= G->thunkpos;  if (!yy_HtmlBlockTr(G)) { goto l810; }  goto l809;
  l810:;	  G->pos= yypos809; G->thunkpos= yythunkpos809;
  {  int yypos811= G->pos, yythunkpos811= G->thunkpos;  if (!yy_HtmlBlockCloseTr(G)) { goto l811; }  goto l808;
  l811:;	  G->pos= yypos811; G->thunkpos= yythunkpos811;
  }  if (!yymatchDot(G)) goto l808;
  }
  l809:;	  goto l807;
  l808:;	  G->pos= yypos808; G->thunkpos= yythunkpos808;
  }  if (!yy_HtmlBlockCloseTr(G)) { goto l806; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockTr", G->buf+G->pos));
  return 1;
  l806:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockTr", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseTr(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseTr"));  if (!yymatchChar(G, '<')) goto l812;  if (!yy_Spnl(G)) { goto l812; }  if (!yymatchChar(G, '/')) goto l812;
  {  int yypos813= G->pos, yythunkpos813= G->thunkpos;  if (!yymatchString(G, "tr")) goto l814;  goto l813;
  l814:;	  G->pos= yypos813; G->thunkpos= yythunkpos813;  if (!yymatchString(G, "TR")) goto l812;
  }
  l813:;	  if (!yy_Spnl(G)) { goto l812; }  if (!yymatchChar(G, '>')) goto l812;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseTr", G->buf+G->pos));
  return 1;
  l812:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseTr", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenTr(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenTr"));  if (!yymatchChar(G, '<')) goto l815;  if (!yy_Spnl(G)) { goto l815; }
  {  int yypos816= G->pos, yythunkpos816= G->thunkpos;  if (!yymatchString(G, "tr")) goto l817;  goto l816;
  l817:;	  G->pos= yypos816; G->thunkpos= yythunkpos816;  if (!yymatchString(G, "TR")) goto l815;
  }
  l816:;	  if (!yy_Spnl(G)) { goto l815; }
  l818:;	
  {  int yypos819= G->pos, yythunkpos819= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l819; }  goto l818;
  l819:;	  G->pos= yypos819; G->thunkpos= yythunkpos819;
  }  if (!yymatchChar(G, '>')) goto l815;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenTr", G->buf+G->pos));
  return 1;
  l815:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenTr", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockThead(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockThead"));  if (!yy_HtmlBlockOpenThead(G)) { goto l820; }
  l821:;	
  {  int yypos822= G->pos, yythunkpos822= G->thunkpos;
  {  int yypos823= G->pos, yythunkpos823= G->thunkpos;  if (!yy_HtmlBlockThead(G)) { goto l824; }  goto l823;
  l824:;	  G->pos= yypos823; G->thunkpos= yythunkpos823;
  {  int yypos825= G->pos, yythunkpos825= G->thunkpos;  if (!yy_HtmlBlockCloseThead(G)) { goto l825; }  goto l822;
  l825:;	  G->pos= yypos825; G->thunkpos= yythunkpos825;
  }  if (!yymatchDot(G)) goto l822;
  }
  l823:;	  goto l821;
  l822:;	  G->pos= yypos822; G->thunkpos= yythunkpos822;
  }  if (!yy_HtmlBlockCloseThead(G)) { goto l820; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockThead", G->buf+G->pos));
  return 1;
  l820:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockThead", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseThead(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseThead"));  if (!yymatchChar(G, '<')) goto l826;  if (!yy_Spnl(G)) { goto l826; }  if (!yymatchChar(G, '/')) goto l826;
  {  int yypos827= G->pos, yythunkpos827= G->thunkpos;  if (!yymatchString(G, "thead")) goto l828;  goto l827;
  l828:;	  G->pos= yypos827; G->thunkpos= yythunkpos827;  if (!yymatchString(G, "THEAD")) goto l826;
  }
  l827:;	  if (!yy_Spnl(G)) { goto l826; }  if (!yymatchChar(G, '>')) goto l826;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseThead", G->buf+G->pos));
  return 1;
  l826:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseThead", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenThead(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenThead"));  if (!yymatchChar(G, '<')) goto l829;  if (!yy_Spnl(G)) { goto l829; }
  {  int yypos830= G->pos, yythunkpos830= G->thunkpos;  if (!yymatchString(G, "thead")) goto l831;  goto l830;
  l831:;	  G->pos= yypos830; G->thunkpos= yythunkpos830;  if (!yymatchString(G, "THEAD")) goto l829;
  }
  l830:;	  if (!yy_Spnl(G)) { goto l829; }
  l832:;	
  {  int yypos833= G->pos, yythunkpos833= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l833; }  goto l832;
  l833:;	  G->pos= yypos833; G->thunkpos= yythunkpos833;
  }  if (!yymatchChar(G, '>')) goto l829;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenThead", G->buf+G->pos));
  return 1;
  l829:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenThead", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockTh(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockTh"));  if (!yy_HtmlBlockOpenTh(G)) { goto l834; }
  l835:;	
  {  int yypos836= G->pos, yythunkpos836= G->thunkpos;
  {  int yypos837= G->pos, yythunkpos837= G->thunkpos;  if (!yy_HtmlBlockTh(G)) { goto l838; }  goto l837;
  l838:;	  G->pos= yypos837; G->thunkpos= yythunkpos837;
  {  int yypos839= G->pos, yythunkpos839= G->thunkpos;  if (!yy_HtmlBlockCloseTh(G)) { goto l839; }  goto l836;
  l839:;	  G->pos= yypos839; G->thunkpos= yythunkpos839;
  }  if (!yymatchDot(G)) goto l836;
  }
  l837:;	  goto l835;
  l836:;	  G->pos= yypos836; G->thunkpos= yythunkpos836;
  }  if (!yy_HtmlBlockCloseTh(G)) { goto l834; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockTh", G->buf+G->pos));
  return 1;
  l834:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockTh", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseTh(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseTh"));  if (!yymatchChar(G, '<')) goto l840;  if (!yy_Spnl(G)) { goto l840; }  if (!yymatchChar(G, '/')) goto l840;
  {  int yypos841= G->pos, yythunkpos841= G->thunkpos;  if (!yymatchString(G, "th")) goto l842;  goto l841;
  l842:;	  G->pos= yypos841; G->thunkpos= yythunkpos841;  if (!yymatchString(G, "TH")) goto l840;
  }
  l841:;	  if (!yy_Spnl(G)) { goto l840; }  if (!yymatchChar(G, '>')) goto l840;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseTh", G->buf+G->pos));
  return 1;
  l840:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseTh", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenTh(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenTh"));  if (!yymatchChar(G, '<')) goto l843;  if (!yy_Spnl(G)) { goto l843; }
  {  int yypos844= G->pos, yythunkpos844= G->thunkpos;  if (!yymatchString(G, "th")) goto l845;  goto l844;
  l845:;	  G->pos= yypos844; G->thunkpos= yythunkpos844;  if (!yymatchString(G, "TH")) goto l843;
  }
  l844:;	  if (!yy_Spnl(G)) { goto l843; }
  l846:;	
  {  int yypos847= G->pos, yythunkpos847= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l847; }  goto l846;
  l847:;	  G->pos= yypos847; G->thunkpos= yythunkpos847;
  }  if (!yymatchChar(G, '>')) goto l843;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenTh", G->buf+G->pos));
  return 1;
  l843:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenTh", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockTfoot(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockTfoot"));  if (!yy_HtmlBlockOpenTfoot(G)) { goto l848; }
  l849:;	
  {  int yypos850= G->pos, yythunkpos850= G->thunkpos;
  {  int yypos851= G->pos, yythunkpos851= G->thunkpos;  if (!yy_HtmlBlockTfoot(G)) { goto l852; }  goto l851;
  l852:;	  G->pos= yypos851; G->thunkpos= yythunkpos851;
  {  int yypos853= G->pos, yythunkpos853= G->thunkpos;  if (!yy_HtmlBlockCloseTfoot(G)) { goto l853; }  goto l850;
  l853:;	  G->pos= yypos853; G->thunkpos= yythunkpos853;
  }  if (!yymatchDot(G)) goto l850;
  }
  l851:;	  goto l849;
  l850:;	  G->pos= yypos850; G->thunkpos= yythunkpos850;
  }  if (!yy_HtmlBlockCloseTfoot(G)) { goto l848; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockTfoot", G->buf+G->pos));
  return 1;
  l848:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockTfoot", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseTfoot(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseTfoot"));  if (!yymatchChar(G, '<')) goto l854;  if (!yy_Spnl(G)) { goto l854; }  if (!yymatchChar(G, '/')) goto l854;
  {  int yypos855= G->pos, yythunkpos855= G->thunkpos;  if (!yymatchString(G, "tfoot")) goto l856;  goto l855;
  l856:;	  G->pos= yypos855; G->thunkpos= yythunkpos855;  if (!yymatchString(G, "TFOOT")) goto l854;
  }
  l855:;	  if (!yy_Spnl(G)) { goto l854; }  if (!yymatchChar(G, '>')) goto l854;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseTfoot", G->buf+G->pos));
  return 1;
  l854:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseTfoot", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenTfoot(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenTfoot"));  if (!yymatchChar(G, '<')) goto l857;  if (!yy_Spnl(G)) { goto l857; }
  {  int yypos858= G->pos, yythunkpos858= G->thunkpos;  if (!yymatchString(G, "tfoot")) goto l859;  goto l858;
  l859:;	  G->pos= yypos858; G->thunkpos= yythunkpos858;  if (!yymatchString(G, "TFOOT")) goto l857;
  }
  l858:;	  if (!yy_Spnl(G)) { goto l857; }
  l860:;	
  {  int yypos861= G->pos, yythunkpos861= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l861; }  goto l860;
  l861:;	  G->pos= yypos861; G->thunkpos= yythunkpos861;
  }  if (!yymatchChar(G, '>')) goto l857;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenTfoot", G->buf+G->pos));
  return 1;
  l857:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenTfoot", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockTd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockTd"));  if (!yy_HtmlBlockOpenTd(G)) { goto l862; }
  l863:;	
  {  int yypos864= G->pos, yythunkpos864= G->thunkpos;
  {  int yypos865= G->pos, yythunkpos865= G->thunkpos;  if (!yy_HtmlBlockTd(G)) { goto l866; }  goto l865;
  l866:;	  G->pos= yypos865; G->thunkpos= yythunkpos865;
  {  int yypos867= G->pos, yythunkpos867= G->thunkpos;  if (!yy_HtmlBlockCloseTd(G)) { goto l867; }  goto l864;
  l867:;	  G->pos= yypos867; G->thunkpos= yythunkpos867;
  }  if (!yymatchDot(G)) goto l864;
  }
  l865:;	  goto l863;
  l864:;	  G->pos= yypos864; G->thunkpos= yythunkpos864;
  }  if (!yy_HtmlBlockCloseTd(G)) { goto l862; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockTd", G->buf+G->pos));
  return 1;
  l862:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockTd", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseTd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseTd"));  if (!yymatchChar(G, '<')) goto l868;  if (!yy_Spnl(G)) { goto l868; }  if (!yymatchChar(G, '/')) goto l868;
  {  int yypos869= G->pos, yythunkpos869= G->thunkpos;  if (!yymatchString(G, "td")) goto l870;  goto l869;
  l870:;	  G->pos= yypos869; G->thunkpos= yythunkpos869;  if (!yymatchString(G, "TD")) goto l868;
  }
  l869:;	  if (!yy_Spnl(G)) { goto l868; }  if (!yymatchChar(G, '>')) goto l868;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseTd", G->buf+G->pos));
  return 1;
  l868:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseTd", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenTd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenTd"));  if (!yymatchChar(G, '<')) goto l871;  if (!yy_Spnl(G)) { goto l871; }
  {  int yypos872= G->pos, yythunkpos872= G->thunkpos;  if (!yymatchString(G, "td")) goto l873;  goto l872;
  l873:;	  G->pos= yypos872; G->thunkpos= yythunkpos872;  if (!yymatchString(G, "TD")) goto l871;
  }
  l872:;	  if (!yy_Spnl(G)) { goto l871; }
  l874:;	
  {  int yypos875= G->pos, yythunkpos875= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l875; }  goto l874;
  l875:;	  G->pos= yypos875; G->thunkpos= yythunkpos875;
  }  if (!yymatchChar(G, '>')) goto l871;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenTd", G->buf+G->pos));
  return 1;
  l871:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenTd", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockTbody(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockTbody"));  if (!yy_HtmlBlockOpenTbody(G)) { goto l876; }
  l877:;	
  {  int yypos878= G->pos, yythunkpos878= G->thunkpos;
  {  int yypos879= G->pos, yythunkpos879= G->thunkpos;  if (!yy_HtmlBlockTbody(G)) { goto l880; }  goto l879;
  l880:;	  G->pos= yypos879; G->thunkpos= yythunkpos879;
  {  int yypos881= G->pos, yythunkpos881= G->thunkpos;  if (!yy_HtmlBlockCloseTbody(G)) { goto l881; }  goto l878;
  l881:;	  G->pos= yypos881; G->thunkpos= yythunkpos881;
  }  if (!yymatchDot(G)) goto l878;
  }
  l879:;	  goto l877;
  l878:;	  G->pos= yypos878; G->thunkpos= yythunkpos878;
  }  if (!yy_HtmlBlockCloseTbody(G)) { goto l876; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockTbody", G->buf+G->pos));
  return 1;
  l876:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockTbody", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseTbody(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseTbody"));  if (!yymatchChar(G, '<')) goto l882;  if (!yy_Spnl(G)) { goto l882; }  if (!yymatchChar(G, '/')) goto l882;
  {  int yypos883= G->pos, yythunkpos883= G->thunkpos;  if (!yymatchString(G, "tbody")) goto l884;  goto l883;
  l884:;	  G->pos= yypos883; G->thunkpos= yythunkpos883;  if (!yymatchString(G, "TBODY")) goto l882;
  }
  l883:;	  if (!yy_Spnl(G)) { goto l882; }  if (!yymatchChar(G, '>')) goto l882;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseTbody", G->buf+G->pos));
  return 1;
  l882:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseTbody", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenTbody(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenTbody"));  if (!yymatchChar(G, '<')) goto l885;  if (!yy_Spnl(G)) { goto l885; }
  {  int yypos886= G->pos, yythunkpos886= G->thunkpos;  if (!yymatchString(G, "tbody")) goto l887;  goto l886;
  l887:;	  G->pos= yypos886; G->thunkpos= yythunkpos886;  if (!yymatchString(G, "TBODY")) goto l885;
  }
  l886:;	  if (!yy_Spnl(G)) { goto l885; }
  l888:;	
  {  int yypos889= G->pos, yythunkpos889= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l889; }  goto l888;
  l889:;	  G->pos= yypos889; G->thunkpos= yythunkpos889;
  }  if (!yymatchChar(G, '>')) goto l885;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenTbody", G->buf+G->pos));
  return 1;
  l885:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenTbody", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockLi(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockLi"));  if (!yy_HtmlBlockOpenLi(G)) { goto l890; }
  l891:;	
  {  int yypos892= G->pos, yythunkpos892= G->thunkpos;
  {  int yypos893= G->pos, yythunkpos893= G->thunkpos;  if (!yy_HtmlBlockLi(G)) { goto l894; }  goto l893;
  l894:;	  G->pos= yypos893; G->thunkpos= yythunkpos893;
  {  int yypos895= G->pos, yythunkpos895= G->thunkpos;  if (!yy_HtmlBlockCloseLi(G)) { goto l895; }  goto l892;
  l895:;	  G->pos= yypos895; G->thunkpos= yythunkpos895;
  }  if (!yymatchDot(G)) goto l892;
  }
  l893:;	  goto l891;
  l892:;	  G->pos= yypos892; G->thunkpos= yythunkpos892;
  }  if (!yy_HtmlBlockCloseLi(G)) { goto l890; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockLi", G->buf+G->pos));
  return 1;
  l890:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockLi", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseLi(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseLi"));  if (!yymatchChar(G, '<')) goto l896;  if (!yy_Spnl(G)) { goto l896; }  if (!yymatchChar(G, '/')) goto l896;
  {  int yypos897= G->pos, yythunkpos897= G->thunkpos;  if (!yymatchString(G, "li")) goto l898;  goto l897;
  l898:;	  G->pos= yypos897; G->thunkpos= yythunkpos897;  if (!yymatchString(G, "LI")) goto l896;
  }
  l897:;	  if (!yy_Spnl(G)) { goto l896; }  if (!yymatchChar(G, '>')) goto l896;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseLi", G->buf+G->pos));
  return 1;
  l896:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseLi", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenLi(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenLi"));  if (!yymatchChar(G, '<')) goto l899;  if (!yy_Spnl(G)) { goto l899; }
  {  int yypos900= G->pos, yythunkpos900= G->thunkpos;  if (!yymatchString(G, "li")) goto l901;  goto l900;
  l901:;	  G->pos= yypos900; G->thunkpos= yythunkpos900;  if (!yymatchString(G, "LI")) goto l899;
  }
  l900:;	  if (!yy_Spnl(G)) { goto l899; }
  l902:;	
  {  int yypos903= G->pos, yythunkpos903= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l903; }  goto l902;
  l903:;	  G->pos= yypos903; G->thunkpos= yythunkpos903;
  }  if (!yymatchChar(G, '>')) goto l899;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenLi", G->buf+G->pos));
  return 1;
  l899:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenLi", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockFrameset(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockFrameset"));  if (!yy_HtmlBlockOpenFrameset(G)) { goto l904; }
  l905:;	
  {  int yypos906= G->pos, yythunkpos906= G->thunkpos;
  {  int yypos907= G->pos, yythunkpos907= G->thunkpos;  if (!yy_HtmlBlockFrameset(G)) { goto l908; }  goto l907;
  l908:;	  G->pos= yypos907; G->thunkpos= yythunkpos907;
  {  int yypos909= G->pos, yythunkpos909= G->thunkpos;  if (!yy_HtmlBlockCloseFrameset(G)) { goto l909; }  goto l906;
  l909:;	  G->pos= yypos909; G->thunkpos= yythunkpos909;
  }  if (!yymatchDot(G)) goto l906;
  }
  l907:;	  goto l905;
  l906:;	  G->pos= yypos906; G->thunkpos= yythunkpos906;
  }  if (!yy_HtmlBlockCloseFrameset(G)) { goto l904; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockFrameset", G->buf+G->pos));
  return 1;
  l904:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockFrameset", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseFrameset(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseFrameset"));  if (!yymatchChar(G, '<')) goto l910;  if (!yy_Spnl(G)) { goto l910; }  if (!yymatchChar(G, '/')) goto l910;
  {  int yypos911= G->pos, yythunkpos911= G->thunkpos;  if (!yymatchString(G, "frameset")) goto l912;  goto l911;
  l912:;	  G->pos= yypos911; G->thunkpos= yythunkpos911;  if (!yymatchString(G, "FRAMESET")) goto l910;
  }
  l911:;	  if (!yy_Spnl(G)) { goto l910; }  if (!yymatchChar(G, '>')) goto l910;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseFrameset", G->buf+G->pos));
  return 1;
  l910:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseFrameset", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenFrameset(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenFrameset"));  if (!yymatchChar(G, '<')) goto l913;  if (!yy_Spnl(G)) { goto l913; }
  {  int yypos914= G->pos, yythunkpos914= G->thunkpos;  if (!yymatchString(G, "frameset")) goto l915;  goto l914;
  l915:;	  G->pos= yypos914; G->thunkpos= yythunkpos914;  if (!yymatchString(G, "FRAMESET")) goto l913;
  }
  l914:;	  if (!yy_Spnl(G)) { goto l913; }
  l916:;	
  {  int yypos917= G->pos, yythunkpos917= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l917; }  goto l916;
  l917:;	  G->pos= yypos917; G->thunkpos= yythunkpos917;
  }  if (!yymatchChar(G, '>')) goto l913;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenFrameset", G->buf+G->pos));
  return 1;
  l913:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenFrameset", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockDt(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockDt"));  if (!yy_HtmlBlockOpenDt(G)) { goto l918; }
  l919:;	
  {  int yypos920= G->pos, yythunkpos920= G->thunkpos;
  {  int yypos921= G->pos, yythunkpos921= G->thunkpos;  if (!yy_HtmlBlockDt(G)) { goto l922; }  goto l921;
  l922:;	  G->pos= yypos921; G->thunkpos= yythunkpos921;
  {  int yypos923= G->pos, yythunkpos923= G->thunkpos;  if (!yy_HtmlBlockCloseDt(G)) { goto l923; }  goto l920;
  l923:;	  G->pos= yypos923; G->thunkpos= yythunkpos923;
  }  if (!yymatchDot(G)) goto l920;
  }
  l921:;	  goto l919;
  l920:;	  G->pos= yypos920; G->thunkpos= yythunkpos920;
  }  if (!yy_HtmlBlockCloseDt(G)) { goto l918; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockDt", G->buf+G->pos));
  return 1;
  l918:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockDt", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseDt(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseDt"));  if (!yymatchChar(G, '<')) goto l924;  if (!yy_Spnl(G)) { goto l924; }  if (!yymatchChar(G, '/')) goto l924;
  {  int yypos925= G->pos, yythunkpos925= G->thunkpos;  if (!yymatchString(G, "dt")) goto l926;  goto l925;
  l926:;	  G->pos= yypos925; G->thunkpos= yythunkpos925;  if (!yymatchString(G, "DT")) goto l924;
  }
  l925:;	  if (!yy_Spnl(G)) { goto l924; }  if (!yymatchChar(G, '>')) goto l924;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseDt", G->buf+G->pos));
  return 1;
  l924:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseDt", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenDt(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenDt"));  if (!yymatchChar(G, '<')) goto l927;  if (!yy_Spnl(G)) { goto l927; }
  {  int yypos928= G->pos, yythunkpos928= G->thunkpos;  if (!yymatchString(G, "dt")) goto l929;  goto l928;
  l929:;	  G->pos= yypos928; G->thunkpos= yythunkpos928;  if (!yymatchString(G, "DT")) goto l927;
  }
  l928:;	  if (!yy_Spnl(G)) { goto l927; }
  l930:;	
  {  int yypos931= G->pos, yythunkpos931= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l931; }  goto l930;
  l931:;	  G->pos= yypos931; G->thunkpos= yythunkpos931;
  }  if (!yymatchChar(G, '>')) goto l927;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenDt", G->buf+G->pos));
  return 1;
  l927:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenDt", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockDd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockDd"));  if (!yy_HtmlBlockOpenDd(G)) { goto l932; }
  l933:;	
  {  int yypos934= G->pos, yythunkpos934= G->thunkpos;
  {  int yypos935= G->pos, yythunkpos935= G->thunkpos;  if (!yy_HtmlBlockDd(G)) { goto l936; }  goto l935;
  l936:;	  G->pos= yypos935; G->thunkpos= yythunkpos935;
  {  int yypos937= G->pos, yythunkpos937= G->thunkpos;  if (!yy_HtmlBlockCloseDd(G)) { goto l937; }  goto l934;
  l937:;	  G->pos= yypos937; G->thunkpos= yythunkpos937;
  }  if (!yymatchDot(G)) goto l934;
  }
  l935:;	  goto l933;
  l934:;	  G->pos= yypos934; G->thunkpos= yythunkpos934;
  }  if (!yy_HtmlBlockCloseDd(G)) { goto l932; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockDd", G->buf+G->pos));
  return 1;
  l932:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockDd", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseDd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseDd"));  if (!yymatchChar(G, '<')) goto l938;  if (!yy_Spnl(G)) { goto l938; }  if (!yymatchChar(G, '/')) goto l938;
  {  int yypos939= G->pos, yythunkpos939= G->thunkpos;  if (!yymatchString(G, "dd")) goto l940;  goto l939;
  l940:;	  G->pos= yypos939; G->thunkpos= yythunkpos939;  if (!yymatchString(G, "DD")) goto l938;
  }
  l939:;	  if (!yy_Spnl(G)) { goto l938; }  if (!yymatchChar(G, '>')) goto l938;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseDd", G->buf+G->pos));
  return 1;
  l938:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseDd", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenDd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenDd"));  if (!yymatchChar(G, '<')) goto l941;  if (!yy_Spnl(G)) { goto l941; }
  {  int yypos942= G->pos, yythunkpos942= G->thunkpos;  if (!yymatchString(G, "dd")) goto l943;  goto l942;
  l943:;	  G->pos= yypos942; G->thunkpos= yythunkpos942;  if (!yymatchString(G, "DD")) goto l941;
  }
  l942:;	  if (!yy_Spnl(G)) { goto l941; }
  l944:;	
  {  int yypos945= G->pos, yythunkpos945= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l945; }  goto l944;
  l945:;	  G->pos= yypos945; G->thunkpos= yythunkpos945;
  }  if (!yymatchChar(G, '>')) goto l941;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenDd", G->buf+G->pos));
  return 1;
  l941:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenDd", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockUl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockUl"));  if (!yy_HtmlBlockOpenUl(G)) { goto l946; }
  l947:;	
  {  int yypos948= G->pos, yythunkpos948= G->thunkpos;
  {  int yypos949= G->pos, yythunkpos949= G->thunkpos;  if (!yy_HtmlBlockUl(G)) { goto l950; }  goto l949;
  l950:;	  G->pos= yypos949; G->thunkpos= yythunkpos949;
  {  int yypos951= G->pos, yythunkpos951= G->thunkpos;  if (!yy_HtmlBlockCloseUl(G)) { goto l951; }  goto l948;
  l951:;	  G->pos= yypos951; G->thunkpos= yythunkpos951;
  }  if (!yymatchDot(G)) goto l948;
  }
  l949:;	  goto l947;
  l948:;	  G->pos= yypos948; G->thunkpos= yythunkpos948;
  }  if (!yy_HtmlBlockCloseUl(G)) { goto l946; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockUl", G->buf+G->pos));
  return 1;
  l946:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockUl", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseUl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseUl"));  if (!yymatchChar(G, '<')) goto l952;  if (!yy_Spnl(G)) { goto l952; }  if (!yymatchChar(G, '/')) goto l952;
  {  int yypos953= G->pos, yythunkpos953= G->thunkpos;  if (!yymatchString(G, "ul")) goto l954;  goto l953;
  l954:;	  G->pos= yypos953; G->thunkpos= yythunkpos953;  if (!yymatchString(G, "UL")) goto l952;
  }
  l953:;	  if (!yy_Spnl(G)) { goto l952; }  if (!yymatchChar(G, '>')) goto l952;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseUl", G->buf+G->pos));
  return 1;
  l952:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseUl", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenUl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenUl"));  if (!yymatchChar(G, '<')) goto l955;  if (!yy_Spnl(G)) { goto l955; }
  {  int yypos956= G->pos, yythunkpos956= G->thunkpos;  if (!yymatchString(G, "ul")) goto l957;  goto l956;
  l957:;	  G->pos= yypos956; G->thunkpos= yythunkpos956;  if (!yymatchString(G, "UL")) goto l955;
  }
  l956:;	  if (!yy_Spnl(G)) { goto l955; }
  l958:;	
  {  int yypos959= G->pos, yythunkpos959= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l959; }  goto l958;
  l959:;	  G->pos= yypos959; G->thunkpos= yythunkpos959;
  }  if (!yymatchChar(G, '>')) goto l955;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenUl", G->buf+G->pos));
  return 1;
  l955:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenUl", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockTable(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockTable"));  if (!yy_HtmlBlockOpenTable(G)) { goto l960; }
  l961:;	
  {  int yypos962= G->pos, yythunkpos962= G->thunkpos;
  {  int yypos963= G->pos, yythunkpos963= G->thunkpos;  if (!yy_HtmlBlockTable(G)) { goto l964; }  goto l963;
  l964:;	  G->pos= yypos963; G->thunkpos= yythunkpos963;
  {  int yypos965= G->pos, yythunkpos965= G->thunkpos;  if (!yy_HtmlBlockCloseTable(G)) { goto l965; }  goto l962;
  l965:;	  G->pos= yypos965; G->thunkpos= yythunkpos965;
  }  if (!yymatchDot(G)) goto l962;
  }
  l963:;	  goto l961;
  l962:;	  G->pos= yypos962; G->thunkpos= yythunkpos962;
  }  if (!yy_HtmlBlockCloseTable(G)) { goto l960; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockTable", G->buf+G->pos));
  return 1;
  l960:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockTable", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseTable(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseTable"));  if (!yymatchChar(G, '<')) goto l966;  if (!yy_Spnl(G)) { goto l966; }  if (!yymatchChar(G, '/')) goto l966;
  {  int yypos967= G->pos, yythunkpos967= G->thunkpos;  if (!yymatchString(G, "table")) goto l968;  goto l967;
  l968:;	  G->pos= yypos967; G->thunkpos= yythunkpos967;  if (!yymatchString(G, "TABLE")) goto l966;
  }
  l967:;	  if (!yy_Spnl(G)) { goto l966; }  if (!yymatchChar(G, '>')) goto l966;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseTable", G->buf+G->pos));
  return 1;
  l966:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseTable", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenTable(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenTable"));  if (!yymatchChar(G, '<')) goto l969;  if (!yy_Spnl(G)) { goto l969; }
  {  int yypos970= G->pos, yythunkpos970= G->thunkpos;  if (!yymatchString(G, "table")) goto l971;  goto l970;
  l971:;	  G->pos= yypos970; G->thunkpos= yythunkpos970;  if (!yymatchString(G, "TABLE")) goto l969;
  }
  l970:;	  if (!yy_Spnl(G)) { goto l969; }
  l972:;	
  {  int yypos973= G->pos, yythunkpos973= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l973; }  goto l972;
  l973:;	  G->pos= yypos973; G->thunkpos= yythunkpos973;
  }  if (!yymatchChar(G, '>')) goto l969;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenTable", G->buf+G->pos));
  return 1;
  l969:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenTable", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockPre(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockPre"));  if (!yy_HtmlBlockOpenPre(G)) { goto l974; }
  l975:;	
  {  int yypos976= G->pos, yythunkpos976= G->thunkpos;
  {  int yypos977= G->pos, yythunkpos977= G->thunkpos;  if (!yy_HtmlBlockPre(G)) { goto l978; }  goto l977;
  l978:;	  G->pos= yypos977; G->thunkpos= yythunkpos977;
  {  int yypos979= G->pos, yythunkpos979= G->thunkpos;  if (!yy_HtmlBlockClosePre(G)) { goto l979; }  goto l976;
  l979:;	  G->pos= yypos979; G->thunkpos= yythunkpos979;
  }  if (!yymatchDot(G)) goto l976;
  }
  l977:;	  goto l975;
  l976:;	  G->pos= yypos976; G->thunkpos= yythunkpos976;
  }  if (!yy_HtmlBlockClosePre(G)) { goto l974; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockPre", G->buf+G->pos));
  return 1;
  l974:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockPre", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockClosePre(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockClosePre"));  if (!yymatchChar(G, '<')) goto l980;  if (!yy_Spnl(G)) { goto l980; }  if (!yymatchChar(G, '/')) goto l980;
  {  int yypos981= G->pos, yythunkpos981= G->thunkpos;  if (!yymatchString(G, "pre")) goto l982;  goto l981;
  l982:;	  G->pos= yypos981; G->thunkpos= yythunkpos981;  if (!yymatchString(G, "PRE")) goto l980;
  }
  l981:;	  if (!yy_Spnl(G)) { goto l980; }  if (!yymatchChar(G, '>')) goto l980;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockClosePre", G->buf+G->pos));
  return 1;
  l980:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockClosePre", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenPre(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenPre"));  if (!yymatchChar(G, '<')) goto l983;  if (!yy_Spnl(G)) { goto l983; }
  {  int yypos984= G->pos, yythunkpos984= G->thunkpos;  if (!yymatchString(G, "pre")) goto l985;  goto l984;
  l985:;	  G->pos= yypos984; G->thunkpos= yythunkpos984;  if (!yymatchString(G, "PRE")) goto l983;
  }
  l984:;	  if (!yy_Spnl(G)) { goto l983; }
  l986:;	
  {  int yypos987= G->pos, yythunkpos987= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l987; }  goto l986;
  l987:;	  G->pos= yypos987; G->thunkpos= yythunkpos987;
  }  if (!yymatchChar(G, '>')) goto l983;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenPre", G->buf+G->pos));
  return 1;
  l983:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenPre", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockP(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockP"));  if (!yy_HtmlBlockOpenP(G)) { goto l988; }
  l989:;	
  {  int yypos990= G->pos, yythunkpos990= G->thunkpos;
  {  int yypos991= G->pos, yythunkpos991= G->thunkpos;  if (!yy_HtmlBlockP(G)) { goto l992; }  goto l991;
  l992:;	  G->pos= yypos991; G->thunkpos= yythunkpos991;
  {  int yypos993= G->pos, yythunkpos993= G->thunkpos;  if (!yy_HtmlBlockCloseP(G)) { goto l993; }  goto l990;
  l993:;	  G->pos= yypos993; G->thunkpos= yythunkpos993;
  }  if (!yymatchDot(G)) goto l990;
  }
  l991:;	  goto l989;
  l990:;	  G->pos= yypos990; G->thunkpos= yythunkpos990;
  }  if (!yy_HtmlBlockCloseP(G)) { goto l988; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockP", G->buf+G->pos));
  return 1;
  l988:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockP", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseP(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseP"));  if (!yymatchChar(G, '<')) goto l994;  if (!yy_Spnl(G)) { goto l994; }  if (!yymatchChar(G, '/')) goto l994;
  {  int yypos995= G->pos, yythunkpos995= G->thunkpos;  if (!yymatchChar(G, 'p')) goto l996;  goto l995;
  l996:;	  G->pos= yypos995; G->thunkpos= yythunkpos995;  if (!yymatchChar(G, 'P')) goto l994;
  }
  l995:;	  if (!yy_Spnl(G)) { goto l994; }  if (!yymatchChar(G, '>')) goto l994;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseP", G->buf+G->pos));
  return 1;
  l994:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseP", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenP(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenP"));  if (!yymatchChar(G, '<')) goto l997;  if (!yy_Spnl(G)) { goto l997; }
  {  int yypos998= G->pos, yythunkpos998= G->thunkpos;  if (!yymatchChar(G, 'p')) goto l999;  goto l998;
  l999:;	  G->pos= yypos998; G->thunkpos= yythunkpos998;  if (!yymatchChar(G, 'P')) goto l997;
  }
  l998:;	  if (!yy_Spnl(G)) { goto l997; }
  l1000:;	
  {  int yypos1001= G->pos, yythunkpos1001= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1001; }  goto l1000;
  l1001:;	  G->pos= yypos1001; G->thunkpos= yythunkpos1001;
  }  if (!yymatchChar(G, '>')) goto l997;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenP", G->buf+G->pos));
  return 1;
  l997:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenP", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOl"));  if (!yy_HtmlBlockOpenOl(G)) { goto l1002; }
  l1003:;	
  {  int yypos1004= G->pos, yythunkpos1004= G->thunkpos;
  {  int yypos1005= G->pos, yythunkpos1005= G->thunkpos;  if (!yy_HtmlBlockOl(G)) { goto l1006; }  goto l1005;
  l1006:;	  G->pos= yypos1005; G->thunkpos= yythunkpos1005;
  {  int yypos1007= G->pos, yythunkpos1007= G->thunkpos;  if (!yy_HtmlBlockCloseOl(G)) { goto l1007; }  goto l1004;
  l1007:;	  G->pos= yypos1007; G->thunkpos= yythunkpos1007;
  }  if (!yymatchDot(G)) goto l1004;
  }
  l1005:;	  goto l1003;
  l1004:;	  G->pos= yypos1004; G->thunkpos= yythunkpos1004;
  }  if (!yy_HtmlBlockCloseOl(G)) { goto l1002; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOl", G->buf+G->pos));
  return 1;
  l1002:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOl", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseOl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseOl"));  if (!yymatchChar(G, '<')) goto l1008;  if (!yy_Spnl(G)) { goto l1008; }  if (!yymatchChar(G, '/')) goto l1008;
  {  int yypos1009= G->pos, yythunkpos1009= G->thunkpos;  if (!yymatchString(G, "ol")) goto l1010;  goto l1009;
  l1010:;	  G->pos= yypos1009; G->thunkpos= yythunkpos1009;  if (!yymatchString(G, "OL")) goto l1008;
  }
  l1009:;	  if (!yy_Spnl(G)) { goto l1008; }  if (!yymatchChar(G, '>')) goto l1008;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseOl", G->buf+G->pos));
  return 1;
  l1008:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseOl", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenOl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenOl"));  if (!yymatchChar(G, '<')) goto l1011;  if (!yy_Spnl(G)) { goto l1011; }
  {  int yypos1012= G->pos, yythunkpos1012= G->thunkpos;  if (!yymatchString(G, "ol")) goto l1013;  goto l1012;
  l1013:;	  G->pos= yypos1012; G->thunkpos= yythunkpos1012;  if (!yymatchString(G, "OL")) goto l1011;
  }
  l1012:;	  if (!yy_Spnl(G)) { goto l1011; }
  l1014:;	
  {  int yypos1015= G->pos, yythunkpos1015= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1015; }  goto l1014;
  l1015:;	  G->pos= yypos1015; G->thunkpos= yythunkpos1015;
  }  if (!yymatchChar(G, '>')) goto l1011;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenOl", G->buf+G->pos));
  return 1;
  l1011:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenOl", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockNoscript(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockNoscript"));  if (!yy_HtmlBlockOpenNoscript(G)) { goto l1016; }
  l1017:;	
  {  int yypos1018= G->pos, yythunkpos1018= G->thunkpos;
  {  int yypos1019= G->pos, yythunkpos1019= G->thunkpos;  if (!yy_HtmlBlockNoscript(G)) { goto l1020; }  goto l1019;
  l1020:;	  G->pos= yypos1019; G->thunkpos= yythunkpos1019;
  {  int yypos1021= G->pos, yythunkpos1021= G->thunkpos;  if (!yy_HtmlBlockCloseNoscript(G)) { goto l1021; }  goto l1018;
  l1021:;	  G->pos= yypos1021; G->thunkpos= yythunkpos1021;
  }  if (!yymatchDot(G)) goto l1018;
  }
  l1019:;	  goto l1017;
  l1018:;	  G->pos= yypos1018; G->thunkpos= yythunkpos1018;
  }  if (!yy_HtmlBlockCloseNoscript(G)) { goto l1016; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockNoscript", G->buf+G->pos));
  return 1;
  l1016:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockNoscript", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseNoscript(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseNoscript"));  if (!yymatchChar(G, '<')) goto l1022;  if (!yy_Spnl(G)) { goto l1022; }  if (!yymatchChar(G, '/')) goto l1022;
  {  int yypos1023= G->pos, yythunkpos1023= G->thunkpos;  if (!yymatchString(G, "noscript")) goto l1024;  goto l1023;
  l1024:;	  G->pos= yypos1023; G->thunkpos= yythunkpos1023;  if (!yymatchString(G, "NOSCRIPT")) goto l1022;
  }
  l1023:;	  if (!yy_Spnl(G)) { goto l1022; }  if (!yymatchChar(G, '>')) goto l1022;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseNoscript", G->buf+G->pos));
  return 1;
  l1022:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseNoscript", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenNoscript(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenNoscript"));  if (!yymatchChar(G, '<')) goto l1025;  if (!yy_Spnl(G)) { goto l1025; }
  {  int yypos1026= G->pos, yythunkpos1026= G->thunkpos;  if (!yymatchString(G, "noscript")) goto l1027;  goto l1026;
  l1027:;	  G->pos= yypos1026; G->thunkpos= yythunkpos1026;  if (!yymatchString(G, "NOSCRIPT")) goto l1025;
  }
  l1026:;	  if (!yy_Spnl(G)) { goto l1025; }
  l1028:;	
  {  int yypos1029= G->pos, yythunkpos1029= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1029; }  goto l1028;
  l1029:;	  G->pos= yypos1029; G->thunkpos= yythunkpos1029;
  }  if (!yymatchChar(G, '>')) goto l1025;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenNoscript", G->buf+G->pos));
  return 1;
  l1025:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenNoscript", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockNoframes(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockNoframes"));  if (!yy_HtmlBlockOpenNoframes(G)) { goto l1030; }
  l1031:;	
  {  int yypos1032= G->pos, yythunkpos1032= G->thunkpos;
  {  int yypos1033= G->pos, yythunkpos1033= G->thunkpos;  if (!yy_HtmlBlockNoframes(G)) { goto l1034; }  goto l1033;
  l1034:;	  G->pos= yypos1033; G->thunkpos= yythunkpos1033;
  {  int yypos1035= G->pos, yythunkpos1035= G->thunkpos;  if (!yy_HtmlBlockCloseNoframes(G)) { goto l1035; }  goto l1032;
  l1035:;	  G->pos= yypos1035; G->thunkpos= yythunkpos1035;
  }  if (!yymatchDot(G)) goto l1032;
  }
  l1033:;	  goto l1031;
  l1032:;	  G->pos= yypos1032; G->thunkpos= yythunkpos1032;
  }  if (!yy_HtmlBlockCloseNoframes(G)) { goto l1030; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockNoframes", G->buf+G->pos));
  return 1;
  l1030:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockNoframes", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseNoframes(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseNoframes"));  if (!yymatchChar(G, '<')) goto l1036;  if (!yy_Spnl(G)) { goto l1036; }  if (!yymatchChar(G, '/')) goto l1036;
  {  int yypos1037= G->pos, yythunkpos1037= G->thunkpos;  if (!yymatchString(G, "noframes")) goto l1038;  goto l1037;
  l1038:;	  G->pos= yypos1037; G->thunkpos= yythunkpos1037;  if (!yymatchString(G, "NOFRAMES")) goto l1036;
  }
  l1037:;	  if (!yy_Spnl(G)) { goto l1036; }  if (!yymatchChar(G, '>')) goto l1036;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseNoframes", G->buf+G->pos));
  return 1;
  l1036:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseNoframes", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenNoframes(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenNoframes"));  if (!yymatchChar(G, '<')) goto l1039;  if (!yy_Spnl(G)) { goto l1039; }
  {  int yypos1040= G->pos, yythunkpos1040= G->thunkpos;  if (!yymatchString(G, "noframes")) goto l1041;  goto l1040;
  l1041:;	  G->pos= yypos1040; G->thunkpos= yythunkpos1040;  if (!yymatchString(G, "NOFRAMES")) goto l1039;
  }
  l1040:;	  if (!yy_Spnl(G)) { goto l1039; }
  l1042:;	
  {  int yypos1043= G->pos, yythunkpos1043= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1043; }  goto l1042;
  l1043:;	  G->pos= yypos1043; G->thunkpos= yythunkpos1043;
  }  if (!yymatchChar(G, '>')) goto l1039;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenNoframes", G->buf+G->pos));
  return 1;
  l1039:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenNoframes", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockMenu(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockMenu"));  if (!yy_HtmlBlockOpenMenu(G)) { goto l1044; }
  l1045:;	
  {  int yypos1046= G->pos, yythunkpos1046= G->thunkpos;
  {  int yypos1047= G->pos, yythunkpos1047= G->thunkpos;  if (!yy_HtmlBlockMenu(G)) { goto l1048; }  goto l1047;
  l1048:;	  G->pos= yypos1047; G->thunkpos= yythunkpos1047;
  {  int yypos1049= G->pos, yythunkpos1049= G->thunkpos;  if (!yy_HtmlBlockCloseMenu(G)) { goto l1049; }  goto l1046;
  l1049:;	  G->pos= yypos1049; G->thunkpos= yythunkpos1049;
  }  if (!yymatchDot(G)) goto l1046;
  }
  l1047:;	  goto l1045;
  l1046:;	  G->pos= yypos1046; G->thunkpos= yythunkpos1046;
  }  if (!yy_HtmlBlockCloseMenu(G)) { goto l1044; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockMenu", G->buf+G->pos));
  return 1;
  l1044:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockMenu", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseMenu(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseMenu"));  if (!yymatchChar(G, '<')) goto l1050;  if (!yy_Spnl(G)) { goto l1050; }  if (!yymatchChar(G, '/')) goto l1050;
  {  int yypos1051= G->pos, yythunkpos1051= G->thunkpos;  if (!yymatchString(G, "menu")) goto l1052;  goto l1051;
  l1052:;	  G->pos= yypos1051; G->thunkpos= yythunkpos1051;  if (!yymatchString(G, "MENU")) goto l1050;
  }
  l1051:;	  if (!yy_Spnl(G)) { goto l1050; }  if (!yymatchChar(G, '>')) goto l1050;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseMenu", G->buf+G->pos));
  return 1;
  l1050:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseMenu", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenMenu(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenMenu"));  if (!yymatchChar(G, '<')) goto l1053;  if (!yy_Spnl(G)) { goto l1053; }
  {  int yypos1054= G->pos, yythunkpos1054= G->thunkpos;  if (!yymatchString(G, "menu")) goto l1055;  goto l1054;
  l1055:;	  G->pos= yypos1054; G->thunkpos= yythunkpos1054;  if (!yymatchString(G, "MENU")) goto l1053;
  }
  l1054:;	  if (!yy_Spnl(G)) { goto l1053; }
  l1056:;	
  {  int yypos1057= G->pos, yythunkpos1057= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1057; }  goto l1056;
  l1057:;	  G->pos= yypos1057; G->thunkpos= yythunkpos1057;
  }  if (!yymatchChar(G, '>')) goto l1053;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenMenu", G->buf+G->pos));
  return 1;
  l1053:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenMenu", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockH6(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "HtmlBlockH6"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1058;  if (!yy_LocMarker(G)) { goto l1058; }  yyDo(G, yySet, -1, 0);  if (!yy_HtmlBlockOpenH6(G)) { goto l1058; }
  l1059:;	
  {  int yypos1060= G->pos, yythunkpos1060= G->thunkpos;
  {  int yypos1061= G->pos, yythunkpos1061= G->thunkpos;  if (!yy_HtmlBlockH6(G)) { goto l1062; }  goto l1061;
  l1062:;	  G->pos= yypos1061; G->thunkpos= yythunkpos1061;
  {  int yypos1063= G->pos, yythunkpos1063= G->thunkpos;  if (!yy_HtmlBlockCloseH6(G)) { goto l1063; }  goto l1060;
  l1063:;	  G->pos= yypos1063; G->thunkpos= yythunkpos1063;
  }  if (!yymatchDot(G)) goto l1060;
  }
  l1061:;	  goto l1059;
  l1060:;	  G->pos= yypos1060; G->thunkpos= yythunkpos1060;
  }  if (!yy_HtmlBlockCloseH6(G)) { goto l1058; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1058;  yyDo(G, yy_1_HtmlBlockH6, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockH6", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1058:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockH6", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseH6(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseH6"));  if (!yymatchChar(G, '<')) goto l1064;  if (!yy_Spnl(G)) { goto l1064; }  if (!yymatchChar(G, '/')) goto l1064;
  {  int yypos1065= G->pos, yythunkpos1065= G->thunkpos;  if (!yymatchString(G, "h6")) goto l1066;  goto l1065;
  l1066:;	  G->pos= yypos1065; G->thunkpos= yythunkpos1065;  if (!yymatchString(G, "H6")) goto l1064;
  }
  l1065:;	  if (!yy_Spnl(G)) { goto l1064; }  if (!yymatchChar(G, '>')) goto l1064;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseH6", G->buf+G->pos));
  return 1;
  l1064:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseH6", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenH6(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenH6"));  if (!yymatchChar(G, '<')) goto l1067;  if (!yy_Spnl(G)) { goto l1067; }
  {  int yypos1068= G->pos, yythunkpos1068= G->thunkpos;  if (!yymatchString(G, "h6")) goto l1069;  goto l1068;
  l1069:;	  G->pos= yypos1068; G->thunkpos= yythunkpos1068;  if (!yymatchString(G, "H6")) goto l1067;
  }
  l1068:;	  if (!yy_Spnl(G)) { goto l1067; }
  l1070:;	
  {  int yypos1071= G->pos, yythunkpos1071= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1071; }  goto l1070;
  l1071:;	  G->pos= yypos1071; G->thunkpos= yythunkpos1071;
  }  if (!yymatchChar(G, '>')) goto l1067;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenH6", G->buf+G->pos));
  return 1;
  l1067:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenH6", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockH5(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "HtmlBlockH5"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1072;  if (!yy_LocMarker(G)) { goto l1072; }  yyDo(G, yySet, -1, 0);  if (!yy_HtmlBlockOpenH5(G)) { goto l1072; }
  l1073:;	
  {  int yypos1074= G->pos, yythunkpos1074= G->thunkpos;
  {  int yypos1075= G->pos, yythunkpos1075= G->thunkpos;  if (!yy_HtmlBlockH5(G)) { goto l1076; }  goto l1075;
  l1076:;	  G->pos= yypos1075; G->thunkpos= yythunkpos1075;
  {  int yypos1077= G->pos, yythunkpos1077= G->thunkpos;  if (!yy_HtmlBlockCloseH5(G)) { goto l1077; }  goto l1074;
  l1077:;	  G->pos= yypos1077; G->thunkpos= yythunkpos1077;
  }  if (!yymatchDot(G)) goto l1074;
  }
  l1075:;	  goto l1073;
  l1074:;	  G->pos= yypos1074; G->thunkpos= yythunkpos1074;
  }  if (!yy_HtmlBlockCloseH5(G)) { goto l1072; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1072;  yyDo(G, yy_1_HtmlBlockH5, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockH5", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1072:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockH5", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseH5(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseH5"));  if (!yymatchChar(G, '<')) goto l1078;  if (!yy_Spnl(G)) { goto l1078; }  if (!yymatchChar(G, '/')) goto l1078;
  {  int yypos1079= G->pos, yythunkpos1079= G->thunkpos;  if (!yymatchString(G, "h5")) goto l1080;  goto l1079;
  l1080:;	  G->pos= yypos1079; G->thunkpos= yythunkpos1079;  if (!yymatchString(G, "H5")) goto l1078;
  }
  l1079:;	  if (!yy_Spnl(G)) { goto l1078; }  if (!yymatchChar(G, '>')) goto l1078;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseH5", G->buf+G->pos));
  return 1;
  l1078:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseH5", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenH5(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenH5"));  if (!yymatchChar(G, '<')) goto l1081;  if (!yy_Spnl(G)) { goto l1081; }
  {  int yypos1082= G->pos, yythunkpos1082= G->thunkpos;  if (!yymatchString(G, "h5")) goto l1083;  goto l1082;
  l1083:;	  G->pos= yypos1082; G->thunkpos= yythunkpos1082;  if (!yymatchString(G, "H5")) goto l1081;
  }
  l1082:;	  if (!yy_Spnl(G)) { goto l1081; }
  l1084:;	
  {  int yypos1085= G->pos, yythunkpos1085= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1085; }  goto l1084;
  l1085:;	  G->pos= yypos1085; G->thunkpos= yythunkpos1085;
  }  if (!yymatchChar(G, '>')) goto l1081;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenH5", G->buf+G->pos));
  return 1;
  l1081:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenH5", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockH4(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "HtmlBlockH4"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1086;  if (!yy_LocMarker(G)) { goto l1086; }  yyDo(G, yySet, -1, 0);  if (!yy_HtmlBlockOpenH4(G)) { goto l1086; }
  l1087:;	
  {  int yypos1088= G->pos, yythunkpos1088= G->thunkpos;
  {  int yypos1089= G->pos, yythunkpos1089= G->thunkpos;  if (!yy_HtmlBlockH4(G)) { goto l1090; }  goto l1089;
  l1090:;	  G->pos= yypos1089; G->thunkpos= yythunkpos1089;
  {  int yypos1091= G->pos, yythunkpos1091= G->thunkpos;  if (!yy_HtmlBlockCloseH4(G)) { goto l1091; }  goto l1088;
  l1091:;	  G->pos= yypos1091; G->thunkpos= yythunkpos1091;
  }  if (!yymatchDot(G)) goto l1088;
  }
  l1089:;	  goto l1087;
  l1088:;	  G->pos= yypos1088; G->thunkpos= yythunkpos1088;
  }  if (!yy_HtmlBlockCloseH4(G)) { goto l1086; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1086;  yyDo(G, yy_1_HtmlBlockH4, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockH4", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1086:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockH4", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseH4(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseH4"));  if (!yymatchChar(G, '<')) goto l1092;  if (!yy_Spnl(G)) { goto l1092; }  if (!yymatchChar(G, '/')) goto l1092;
  {  int yypos1093= G->pos, yythunkpos1093= G->thunkpos;  if (!yymatchString(G, "h4")) goto l1094;  goto l1093;
  l1094:;	  G->pos= yypos1093; G->thunkpos= yythunkpos1093;  if (!yymatchString(G, "H4")) goto l1092;
  }
  l1093:;	  if (!yy_Spnl(G)) { goto l1092; }  if (!yymatchChar(G, '>')) goto l1092;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseH4", G->buf+G->pos));
  return 1;
  l1092:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseH4", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenH4(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenH4"));  if (!yymatchChar(G, '<')) goto l1095;  if (!yy_Spnl(G)) { goto l1095; }
  {  int yypos1096= G->pos, yythunkpos1096= G->thunkpos;  if (!yymatchString(G, "h4")) goto l1097;  goto l1096;
  l1097:;	  G->pos= yypos1096; G->thunkpos= yythunkpos1096;  if (!yymatchString(G, "H4")) goto l1095;
  }
  l1096:;	  if (!yy_Spnl(G)) { goto l1095; }
  l1098:;	
  {  int yypos1099= G->pos, yythunkpos1099= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1099; }  goto l1098;
  l1099:;	  G->pos= yypos1099; G->thunkpos= yythunkpos1099;
  }  if (!yymatchChar(G, '>')) goto l1095;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenH4", G->buf+G->pos));
  return 1;
  l1095:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenH4", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockH3(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "HtmlBlockH3"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1100;  if (!yy_LocMarker(G)) { goto l1100; }  yyDo(G, yySet, -1, 0);  if (!yy_HtmlBlockOpenH3(G)) { goto l1100; }
  l1101:;	
  {  int yypos1102= G->pos, yythunkpos1102= G->thunkpos;
  {  int yypos1103= G->pos, yythunkpos1103= G->thunkpos;  if (!yy_HtmlBlockH3(G)) { goto l1104; }  goto l1103;
  l1104:;	  G->pos= yypos1103; G->thunkpos= yythunkpos1103;
  {  int yypos1105= G->pos, yythunkpos1105= G->thunkpos;  if (!yy_HtmlBlockCloseH3(G)) { goto l1105; }  goto l1102;
  l1105:;	  G->pos= yypos1105; G->thunkpos= yythunkpos1105;
  }  if (!yymatchDot(G)) goto l1102;
  }
  l1103:;	  goto l1101;
  l1102:;	  G->pos= yypos1102; G->thunkpos= yythunkpos1102;
  }  if (!yy_HtmlBlockCloseH3(G)) { goto l1100; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1100;  yyDo(G, yy_1_HtmlBlockH3, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockH3", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1100:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockH3", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseH3(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseH3"));  if (!yymatchChar(G, '<')) goto l1106;  if (!yy_Spnl(G)) { goto l1106; }  if (!yymatchChar(G, '/')) goto l1106;
  {  int yypos1107= G->pos, yythunkpos1107= G->thunkpos;  if (!yymatchString(G, "h3")) goto l1108;  goto l1107;
  l1108:;	  G->pos= yypos1107; G->thunkpos= yythunkpos1107;  if (!yymatchString(G, "H3")) goto l1106;
  }
  l1107:;	  if (!yy_Spnl(G)) { goto l1106; }  if (!yymatchChar(G, '>')) goto l1106;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseH3", G->buf+G->pos));
  return 1;
  l1106:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseH3", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenH3(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenH3"));  if (!yymatchChar(G, '<')) goto l1109;  if (!yy_Spnl(G)) { goto l1109; }
  {  int yypos1110= G->pos, yythunkpos1110= G->thunkpos;  if (!yymatchString(G, "h3")) goto l1111;  goto l1110;
  l1111:;	  G->pos= yypos1110; G->thunkpos= yythunkpos1110;  if (!yymatchString(G, "H3")) goto l1109;
  }
  l1110:;	  if (!yy_Spnl(G)) { goto l1109; }
  l1112:;	
  {  int yypos1113= G->pos, yythunkpos1113= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1113; }  goto l1112;
  l1113:;	  G->pos= yypos1113; G->thunkpos= yythunkpos1113;
  }  if (!yymatchChar(G, '>')) goto l1109;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenH3", G->buf+G->pos));
  return 1;
  l1109:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenH3", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockH2(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "HtmlBlockH2"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1114;  if (!yy_LocMarker(G)) { goto l1114; }  yyDo(G, yySet, -1, 0);  if (!yy_HtmlBlockOpenH2(G)) { goto l1114; }
  l1115:;	
  {  int yypos1116= G->pos, yythunkpos1116= G->thunkpos;
  {  int yypos1117= G->pos, yythunkpos1117= G->thunkpos;  if (!yy_HtmlBlockH2(G)) { goto l1118; }  goto l1117;
  l1118:;	  G->pos= yypos1117; G->thunkpos= yythunkpos1117;
  {  int yypos1119= G->pos, yythunkpos1119= G->thunkpos;  if (!yy_HtmlBlockCloseH2(G)) { goto l1119; }  goto l1116;
  l1119:;	  G->pos= yypos1119; G->thunkpos= yythunkpos1119;
  }  if (!yymatchDot(G)) goto l1116;
  }
  l1117:;	  goto l1115;
  l1116:;	  G->pos= yypos1116; G->thunkpos= yythunkpos1116;
  }  if (!yy_HtmlBlockCloseH2(G)) { goto l1114; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1114;  yyDo(G, yy_1_HtmlBlockH2, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockH2", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1114:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockH2", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseH2(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseH2"));  if (!yymatchChar(G, '<')) goto l1120;  if (!yy_Spnl(G)) { goto l1120; }  if (!yymatchChar(G, '/')) goto l1120;
  {  int yypos1121= G->pos, yythunkpos1121= G->thunkpos;  if (!yymatchString(G, "h2")) goto l1122;  goto l1121;
  l1122:;	  G->pos= yypos1121; G->thunkpos= yythunkpos1121;  if (!yymatchString(G, "H2")) goto l1120;
  }
  l1121:;	  if (!yy_Spnl(G)) { goto l1120; }  if (!yymatchChar(G, '>')) goto l1120;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseH2", G->buf+G->pos));
  return 1;
  l1120:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseH2", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenH2(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenH2"));  if (!yymatchChar(G, '<')) goto l1123;  if (!yy_Spnl(G)) { goto l1123; }
  {  int yypos1124= G->pos, yythunkpos1124= G->thunkpos;  if (!yymatchString(G, "h2")) goto l1125;  goto l1124;
  l1125:;	  G->pos= yypos1124; G->thunkpos= yythunkpos1124;  if (!yymatchString(G, "H2")) goto l1123;
  }
  l1124:;	  if (!yy_Spnl(G)) { goto l1123; }
  l1126:;	
  {  int yypos1127= G->pos, yythunkpos1127= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1127; }  goto l1126;
  l1127:;	  G->pos= yypos1127; G->thunkpos= yythunkpos1127;
  }  if (!yymatchChar(G, '>')) goto l1123;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenH2", G->buf+G->pos));
  return 1;
  l1123:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenH2", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockH1(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "HtmlBlockH1"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1128;  if (!yy_LocMarker(G)) { goto l1128; }  yyDo(G, yySet, -1, 0);  if (!yy_HtmlBlockOpenH1(G)) { goto l1128; }
  l1129:;	
  {  int yypos1130= G->pos, yythunkpos1130= G->thunkpos;
  {  int yypos1131= G->pos, yythunkpos1131= G->thunkpos;  if (!yy_HtmlBlockH1(G)) { goto l1132; }  goto l1131;
  l1132:;	  G->pos= yypos1131; G->thunkpos= yythunkpos1131;
  {  int yypos1133= G->pos, yythunkpos1133= G->thunkpos;  if (!yy_HtmlBlockCloseH1(G)) { goto l1133; }  goto l1130;
  l1133:;	  G->pos= yypos1133; G->thunkpos= yythunkpos1133;
  }  if (!yymatchDot(G)) goto l1130;
  }
  l1131:;	  goto l1129;
  l1130:;	  G->pos= yypos1130; G->thunkpos= yythunkpos1130;
  }  if (!yy_HtmlBlockCloseH1(G)) { goto l1128; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1128;  yyDo(G, yy_1_HtmlBlockH1, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockH1", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1128:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockH1", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseH1(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseH1"));  if (!yymatchChar(G, '<')) goto l1134;  if (!yy_Spnl(G)) { goto l1134; }  if (!yymatchChar(G, '/')) goto l1134;
  {  int yypos1135= G->pos, yythunkpos1135= G->thunkpos;  if (!yymatchString(G, "h1")) goto l1136;  goto l1135;
  l1136:;	  G->pos= yypos1135; G->thunkpos= yythunkpos1135;  if (!yymatchString(G, "H1")) goto l1134;
  }
  l1135:;	  if (!yy_Spnl(G)) { goto l1134; }  if (!yymatchChar(G, '>')) goto l1134;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseH1", G->buf+G->pos));
  return 1;
  l1134:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseH1", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenH1(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenH1"));  if (!yymatchChar(G, '<')) goto l1137;  if (!yy_Spnl(G)) { goto l1137; }
  {  int yypos1138= G->pos, yythunkpos1138= G->thunkpos;  if (!yymatchString(G, "h1")) goto l1139;  goto l1138;
  l1139:;	  G->pos= yypos1138; G->thunkpos= yythunkpos1138;  if (!yymatchString(G, "H1")) goto l1137;
  }
  l1138:;	  if (!yy_Spnl(G)) { goto l1137; }
  l1140:;	
  {  int yypos1141= G->pos, yythunkpos1141= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1141; }  goto l1140;
  l1141:;	  G->pos= yypos1141; G->thunkpos= yythunkpos1141;
  }  if (!yymatchChar(G, '>')) goto l1137;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenH1", G->buf+G->pos));
  return 1;
  l1137:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenH1", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockForm(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockForm"));  if (!yy_HtmlBlockOpenForm(G)) { goto l1142; }
  l1143:;	
  {  int yypos1144= G->pos, yythunkpos1144= G->thunkpos;
  {  int yypos1145= G->pos, yythunkpos1145= G->thunkpos;  if (!yy_HtmlBlockForm(G)) { goto l1146; }  goto l1145;
  l1146:;	  G->pos= yypos1145; G->thunkpos= yythunkpos1145;
  {  int yypos1147= G->pos, yythunkpos1147= G->thunkpos;  if (!yy_HtmlBlockCloseForm(G)) { goto l1147; }  goto l1144;
  l1147:;	  G->pos= yypos1147; G->thunkpos= yythunkpos1147;
  }  if (!yymatchDot(G)) goto l1144;
  }
  l1145:;	  goto l1143;
  l1144:;	  G->pos= yypos1144; G->thunkpos= yythunkpos1144;
  }  if (!yy_HtmlBlockCloseForm(G)) { goto l1142; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockForm", G->buf+G->pos));
  return 1;
  l1142:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockForm", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseForm(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseForm"));  if (!yymatchChar(G, '<')) goto l1148;  if (!yy_Spnl(G)) { goto l1148; }  if (!yymatchChar(G, '/')) goto l1148;
  {  int yypos1149= G->pos, yythunkpos1149= G->thunkpos;  if (!yymatchString(G, "form")) goto l1150;  goto l1149;
  l1150:;	  G->pos= yypos1149; G->thunkpos= yythunkpos1149;  if (!yymatchString(G, "FORM")) goto l1148;
  }
  l1149:;	  if (!yy_Spnl(G)) { goto l1148; }  if (!yymatchChar(G, '>')) goto l1148;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseForm", G->buf+G->pos));
  return 1;
  l1148:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseForm", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenForm(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenForm"));  if (!yymatchChar(G, '<')) goto l1151;  if (!yy_Spnl(G)) { goto l1151; }
  {  int yypos1152= G->pos, yythunkpos1152= G->thunkpos;  if (!yymatchString(G, "form")) goto l1153;  goto l1152;
  l1153:;	  G->pos= yypos1152; G->thunkpos= yythunkpos1152;  if (!yymatchString(G, "FORM")) goto l1151;
  }
  l1152:;	  if (!yy_Spnl(G)) { goto l1151; }
  l1154:;	
  {  int yypos1155= G->pos, yythunkpos1155= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1155; }  goto l1154;
  l1155:;	  G->pos= yypos1155; G->thunkpos= yythunkpos1155;
  }  if (!yymatchChar(G, '>')) goto l1151;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenForm", G->buf+G->pos));
  return 1;
  l1151:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenForm", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockFieldset(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockFieldset"));  if (!yy_HtmlBlockOpenFieldset(G)) { goto l1156; }
  l1157:;	
  {  int yypos1158= G->pos, yythunkpos1158= G->thunkpos;
  {  int yypos1159= G->pos, yythunkpos1159= G->thunkpos;  if (!yy_HtmlBlockFieldset(G)) { goto l1160; }  goto l1159;
  l1160:;	  G->pos= yypos1159; G->thunkpos= yythunkpos1159;
  {  int yypos1161= G->pos, yythunkpos1161= G->thunkpos;  if (!yy_HtmlBlockCloseFieldset(G)) { goto l1161; }  goto l1158;
  l1161:;	  G->pos= yypos1161; G->thunkpos= yythunkpos1161;
  }  if (!yymatchDot(G)) goto l1158;
  }
  l1159:;	  goto l1157;
  l1158:;	  G->pos= yypos1158; G->thunkpos= yythunkpos1158;
  }  if (!yy_HtmlBlockCloseFieldset(G)) { goto l1156; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockFieldset", G->buf+G->pos));
  return 1;
  l1156:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockFieldset", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseFieldset(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseFieldset"));  if (!yymatchChar(G, '<')) goto l1162;  if (!yy_Spnl(G)) { goto l1162; }  if (!yymatchChar(G, '/')) goto l1162;
  {  int yypos1163= G->pos, yythunkpos1163= G->thunkpos;  if (!yymatchString(G, "fieldset")) goto l1164;  goto l1163;
  l1164:;	  G->pos= yypos1163; G->thunkpos= yythunkpos1163;  if (!yymatchString(G, "FIELDSET")) goto l1162;
  }
  l1163:;	  if (!yy_Spnl(G)) { goto l1162; }  if (!yymatchChar(G, '>')) goto l1162;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseFieldset", G->buf+G->pos));
  return 1;
  l1162:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseFieldset", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenFieldset(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenFieldset"));  if (!yymatchChar(G, '<')) goto l1165;  if (!yy_Spnl(G)) { goto l1165; }
  {  int yypos1166= G->pos, yythunkpos1166= G->thunkpos;  if (!yymatchString(G, "fieldset")) goto l1167;  goto l1166;
  l1167:;	  G->pos= yypos1166; G->thunkpos= yythunkpos1166;  if (!yymatchString(G, "FIELDSET")) goto l1165;
  }
  l1166:;	  if (!yy_Spnl(G)) { goto l1165; }
  l1168:;	
  {  int yypos1169= G->pos, yythunkpos1169= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1169; }  goto l1168;
  l1169:;	  G->pos= yypos1169; G->thunkpos= yythunkpos1169;
  }  if (!yymatchChar(G, '>')) goto l1165;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenFieldset", G->buf+G->pos));
  return 1;
  l1165:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenFieldset", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockDl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockDl"));  if (!yy_HtmlBlockOpenDl(G)) { goto l1170; }
  l1171:;	
  {  int yypos1172= G->pos, yythunkpos1172= G->thunkpos;
  {  int yypos1173= G->pos, yythunkpos1173= G->thunkpos;  if (!yy_HtmlBlockDl(G)) { goto l1174; }  goto l1173;
  l1174:;	  G->pos= yypos1173; G->thunkpos= yythunkpos1173;
  {  int yypos1175= G->pos, yythunkpos1175= G->thunkpos;  if (!yy_HtmlBlockCloseDl(G)) { goto l1175; }  goto l1172;
  l1175:;	  G->pos= yypos1175; G->thunkpos= yythunkpos1175;
  }  if (!yymatchDot(G)) goto l1172;
  }
  l1173:;	  goto l1171;
  l1172:;	  G->pos= yypos1172; G->thunkpos= yythunkpos1172;
  }  if (!yy_HtmlBlockCloseDl(G)) { goto l1170; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockDl", G->buf+G->pos));
  return 1;
  l1170:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockDl", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseDl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseDl"));  if (!yymatchChar(G, '<')) goto l1176;  if (!yy_Spnl(G)) { goto l1176; }  if (!yymatchChar(G, '/')) goto l1176;
  {  int yypos1177= G->pos, yythunkpos1177= G->thunkpos;  if (!yymatchString(G, "dl")) goto l1178;  goto l1177;
  l1178:;	  G->pos= yypos1177; G->thunkpos= yythunkpos1177;  if (!yymatchString(G, "DL")) goto l1176;
  }
  l1177:;	  if (!yy_Spnl(G)) { goto l1176; }  if (!yymatchChar(G, '>')) goto l1176;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseDl", G->buf+G->pos));
  return 1;
  l1176:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseDl", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenDl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenDl"));  if (!yymatchChar(G, '<')) goto l1179;  if (!yy_Spnl(G)) { goto l1179; }
  {  int yypos1180= G->pos, yythunkpos1180= G->thunkpos;  if (!yymatchString(G, "dl")) goto l1181;  goto l1180;
  l1181:;	  G->pos= yypos1180; G->thunkpos= yythunkpos1180;  if (!yymatchString(G, "DL")) goto l1179;
  }
  l1180:;	  if (!yy_Spnl(G)) { goto l1179; }
  l1182:;	
  {  int yypos1183= G->pos, yythunkpos1183= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1183; }  goto l1182;
  l1183:;	  G->pos= yypos1183; G->thunkpos= yythunkpos1183;
  }  if (!yymatchChar(G, '>')) goto l1179;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenDl", G->buf+G->pos));
  return 1;
  l1179:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenDl", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockDiv(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockDiv"));  if (!yy_HtmlBlockOpenDiv(G)) { goto l1184; }
  l1185:;	
  {  int yypos1186= G->pos, yythunkpos1186= G->thunkpos;
  {  int yypos1187= G->pos, yythunkpos1187= G->thunkpos;  if (!yy_HtmlBlockDiv(G)) { goto l1188; }  goto l1187;
  l1188:;	  G->pos= yypos1187; G->thunkpos= yythunkpos1187;
  {  int yypos1189= G->pos, yythunkpos1189= G->thunkpos;  if (!yy_HtmlBlockCloseDiv(G)) { goto l1189; }  goto l1186;
  l1189:;	  G->pos= yypos1189; G->thunkpos= yythunkpos1189;
  }  if (!yymatchDot(G)) goto l1186;
  }
  l1187:;	  goto l1185;
  l1186:;	  G->pos= yypos1186; G->thunkpos= yythunkpos1186;
  }  if (!yy_HtmlBlockCloseDiv(G)) { goto l1184; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockDiv", G->buf+G->pos));
  return 1;
  l1184:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockDiv", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseDiv(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseDiv"));  if (!yymatchChar(G, '<')) goto l1190;  if (!yy_Spnl(G)) { goto l1190; }  if (!yymatchChar(G, '/')) goto l1190;
  {  int yypos1191= G->pos, yythunkpos1191= G->thunkpos;  if (!yymatchString(G, "div")) goto l1192;  goto l1191;
  l1192:;	  G->pos= yypos1191; G->thunkpos= yythunkpos1191;  if (!yymatchString(G, "DIV")) goto l1190;
  }
  l1191:;	  if (!yy_Spnl(G)) { goto l1190; }  if (!yymatchChar(G, '>')) goto l1190;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseDiv", G->buf+G->pos));
  return 1;
  l1190:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseDiv", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenDiv(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenDiv"));  if (!yymatchChar(G, '<')) goto l1193;  if (!yy_Spnl(G)) { goto l1193; }
  {  int yypos1194= G->pos, yythunkpos1194= G->thunkpos;  if (!yymatchString(G, "div")) goto l1195;  goto l1194;
  l1195:;	  G->pos= yypos1194; G->thunkpos= yythunkpos1194;  if (!yymatchString(G, "DIV")) goto l1193;
  }
  l1194:;	  if (!yy_Spnl(G)) { goto l1193; }
  l1196:;	
  {  int yypos1197= G->pos, yythunkpos1197= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1197; }  goto l1196;
  l1197:;	  G->pos= yypos1197; G->thunkpos= yythunkpos1197;
  }  if (!yymatchChar(G, '>')) goto l1193;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenDiv", G->buf+G->pos));
  return 1;
  l1193:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenDiv", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockDir(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockDir"));  if (!yy_HtmlBlockOpenDir(G)) { goto l1198; }
  l1199:;	
  {  int yypos1200= G->pos, yythunkpos1200= G->thunkpos;
  {  int yypos1201= G->pos, yythunkpos1201= G->thunkpos;  if (!yy_HtmlBlockDir(G)) { goto l1202; }  goto l1201;
  l1202:;	  G->pos= yypos1201; G->thunkpos= yythunkpos1201;
  {  int yypos1203= G->pos, yythunkpos1203= G->thunkpos;  if (!yy_HtmlBlockCloseDir(G)) { goto l1203; }  goto l1200;
  l1203:;	  G->pos= yypos1203; G->thunkpos= yythunkpos1203;
  }  if (!yymatchDot(G)) goto l1200;
  }
  l1201:;	  goto l1199;
  l1200:;	  G->pos= yypos1200; G->thunkpos= yythunkpos1200;
  }  if (!yy_HtmlBlockCloseDir(G)) { goto l1198; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockDir", G->buf+G->pos));
  return 1;
  l1198:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockDir", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseDir(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseDir"));  if (!yymatchChar(G, '<')) goto l1204;  if (!yy_Spnl(G)) { goto l1204; }  if (!yymatchChar(G, '/')) goto l1204;
  {  int yypos1205= G->pos, yythunkpos1205= G->thunkpos;  if (!yymatchString(G, "dir")) goto l1206;  goto l1205;
  l1206:;	  G->pos= yypos1205; G->thunkpos= yythunkpos1205;  if (!yymatchString(G, "DIR")) goto l1204;
  }
  l1205:;	  if (!yy_Spnl(G)) { goto l1204; }  if (!yymatchChar(G, '>')) goto l1204;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseDir", G->buf+G->pos));
  return 1;
  l1204:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseDir", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenDir(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenDir"));  if (!yymatchChar(G, '<')) goto l1207;  if (!yy_Spnl(G)) { goto l1207; }
  {  int yypos1208= G->pos, yythunkpos1208= G->thunkpos;  if (!yymatchString(G, "dir")) goto l1209;  goto l1208;
  l1209:;	  G->pos= yypos1208; G->thunkpos= yythunkpos1208;  if (!yymatchString(G, "DIR")) goto l1207;
  }
  l1208:;	  if (!yy_Spnl(G)) { goto l1207; }
  l1210:;	
  {  int yypos1211= G->pos, yythunkpos1211= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1211; }  goto l1210;
  l1211:;	  G->pos= yypos1211; G->thunkpos= yythunkpos1211;
  }  if (!yymatchChar(G, '>')) goto l1207;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenDir", G->buf+G->pos));
  return 1;
  l1207:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenDir", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCenter(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCenter"));  if (!yy_HtmlBlockOpenCenter(G)) { goto l1212; }
  l1213:;	
  {  int yypos1214= G->pos, yythunkpos1214= G->thunkpos;
  {  int yypos1215= G->pos, yythunkpos1215= G->thunkpos;  if (!yy_HtmlBlockCenter(G)) { goto l1216; }  goto l1215;
  l1216:;	  G->pos= yypos1215; G->thunkpos= yythunkpos1215;
  {  int yypos1217= G->pos, yythunkpos1217= G->thunkpos;  if (!yy_HtmlBlockCloseCenter(G)) { goto l1217; }  goto l1214;
  l1217:;	  G->pos= yypos1217; G->thunkpos= yythunkpos1217;
  }  if (!yymatchDot(G)) goto l1214;
  }
  l1215:;	  goto l1213;
  l1214:;	  G->pos= yypos1214; G->thunkpos= yythunkpos1214;
  }  if (!yy_HtmlBlockCloseCenter(G)) { goto l1212; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCenter", G->buf+G->pos));
  return 1;
  l1212:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCenter", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseCenter(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseCenter"));  if (!yymatchChar(G, '<')) goto l1218;  if (!yy_Spnl(G)) { goto l1218; }  if (!yymatchChar(G, '/')) goto l1218;
  {  int yypos1219= G->pos, yythunkpos1219= G->thunkpos;  if (!yymatchString(G, "center")) goto l1220;  goto l1219;
  l1220:;	  G->pos= yypos1219; G->thunkpos= yythunkpos1219;  if (!yymatchString(G, "CENTER")) goto l1218;
  }
  l1219:;	  if (!yy_Spnl(G)) { goto l1218; }  if (!yymatchChar(G, '>')) goto l1218;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseCenter", G->buf+G->pos));
  return 1;
  l1218:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseCenter", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenCenter(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenCenter"));  if (!yymatchChar(G, '<')) goto l1221;  if (!yy_Spnl(G)) { goto l1221; }
  {  int yypos1222= G->pos, yythunkpos1222= G->thunkpos;  if (!yymatchString(G, "center")) goto l1223;  goto l1222;
  l1223:;	  G->pos= yypos1222; G->thunkpos= yythunkpos1222;  if (!yymatchString(G, "CENTER")) goto l1221;
  }
  l1222:;	  if (!yy_Spnl(G)) { goto l1221; }
  l1224:;	
  {  int yypos1225= G->pos, yythunkpos1225= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1225; }  goto l1224;
  l1225:;	  G->pos= yypos1225; G->thunkpos= yythunkpos1225;
  }  if (!yymatchChar(G, '>')) goto l1221;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenCenter", G->buf+G->pos));
  return 1;
  l1221:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenCenter", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockBlockquote(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockBlockquote"));  if (!yy_HtmlBlockOpenBlockquote(G)) { goto l1226; }
  l1227:;	
  {  int yypos1228= G->pos, yythunkpos1228= G->thunkpos;
  {  int yypos1229= G->pos, yythunkpos1229= G->thunkpos;  if (!yy_HtmlBlockBlockquote(G)) { goto l1230; }  goto l1229;
  l1230:;	  G->pos= yypos1229; G->thunkpos= yythunkpos1229;
  {  int yypos1231= G->pos, yythunkpos1231= G->thunkpos;  if (!yy_HtmlBlockCloseBlockquote(G)) { goto l1231; }  goto l1228;
  l1231:;	  G->pos= yypos1231; G->thunkpos= yythunkpos1231;
  }  if (!yymatchDot(G)) goto l1228;
  }
  l1229:;	  goto l1227;
  l1228:;	  G->pos= yypos1228; G->thunkpos= yythunkpos1228;
  }  if (!yy_HtmlBlockCloseBlockquote(G)) { goto l1226; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockBlockquote", G->buf+G->pos));
  return 1;
  l1226:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockBlockquote", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseBlockquote(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseBlockquote"));  if (!yymatchChar(G, '<')) goto l1232;  if (!yy_Spnl(G)) { goto l1232; }  if (!yymatchChar(G, '/')) goto l1232;
  {  int yypos1233= G->pos, yythunkpos1233= G->thunkpos;  if (!yymatchString(G, "blockquote")) goto l1234;  goto l1233;
  l1234:;	  G->pos= yypos1233; G->thunkpos= yythunkpos1233;  if (!yymatchString(G, "BLOCKQUOTE")) goto l1232;
  }
  l1233:;	  if (!yy_Spnl(G)) { goto l1232; }  if (!yymatchChar(G, '>')) goto l1232;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseBlockquote", G->buf+G->pos));
  return 1;
  l1232:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseBlockquote", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenBlockquote(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenBlockquote"));  if (!yymatchChar(G, '<')) goto l1235;  if (!yy_Spnl(G)) { goto l1235; }
  {  int yypos1236= G->pos, yythunkpos1236= G->thunkpos;  if (!yymatchString(G, "blockquote")) goto l1237;  goto l1236;
  l1237:;	  G->pos= yypos1236; G->thunkpos= yythunkpos1236;  if (!yymatchString(G, "BLOCKQUOTE")) goto l1235;
  }
  l1236:;	  if (!yy_Spnl(G)) { goto l1235; }
  l1238:;	
  {  int yypos1239= G->pos, yythunkpos1239= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1239; }  goto l1238;
  l1239:;	  G->pos= yypos1239; G->thunkpos= yythunkpos1239;
  }  if (!yymatchChar(G, '>')) goto l1235;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenBlockquote", G->buf+G->pos));
  return 1;
  l1235:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenBlockquote", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockAddress(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockAddress"));  if (!yy_HtmlBlockOpenAddress(G)) { goto l1240; }
  l1241:;	
  {  int yypos1242= G->pos, yythunkpos1242= G->thunkpos;
  {  int yypos1243= G->pos, yythunkpos1243= G->thunkpos;  if (!yy_HtmlBlockAddress(G)) { goto l1244; }  goto l1243;
  l1244:;	  G->pos= yypos1243; G->thunkpos= yythunkpos1243;
  {  int yypos1245= G->pos, yythunkpos1245= G->thunkpos;  if (!yy_HtmlBlockCloseAddress(G)) { goto l1245; }  goto l1242;
  l1245:;	  G->pos= yypos1245; G->thunkpos= yythunkpos1245;
  }  if (!yymatchDot(G)) goto l1242;
  }
  l1243:;	  goto l1241;
  l1242:;	  G->pos= yypos1242; G->thunkpos= yythunkpos1242;
  }  if (!yy_HtmlBlockCloseAddress(G)) { goto l1240; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockAddress", G->buf+G->pos));
  return 1;
  l1240:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockAddress", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseAddress(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockCloseAddress"));  if (!yymatchChar(G, '<')) goto l1246;  if (!yy_Spnl(G)) { goto l1246; }  if (!yymatchChar(G, '/')) goto l1246;
  {  int yypos1247= G->pos, yythunkpos1247= G->thunkpos;  if (!yymatchString(G, "address")) goto l1248;  goto l1247;
  l1248:;	  G->pos= yypos1247; G->thunkpos= yythunkpos1247;  if (!yymatchString(G, "ADDRESS")) goto l1246;
  }
  l1247:;	  if (!yy_Spnl(G)) { goto l1246; }  if (!yymatchChar(G, '>')) goto l1246;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockCloseAddress", G->buf+G->pos));
  return 1;
  l1246:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockCloseAddress", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlAttribute(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlAttribute"));
  {  int yypos1252= G->pos, yythunkpos1252= G->thunkpos;  if (!yy_AlphanumericAscii(G)) { goto l1253; }  goto l1252;
  l1253:;	  G->pos= yypos1252; G->thunkpos= yythunkpos1252;  if (!yymatchChar(G, '-')) goto l1249;
  }
  l1252:;	
  l1250:;	
  {  int yypos1251= G->pos, yythunkpos1251= G->thunkpos;
  {  int yypos1254= G->pos, yythunkpos1254= G->thunkpos;  if (!yy_AlphanumericAscii(G)) { goto l1255; }  goto l1254;
  l1255:;	  G->pos= yypos1254; G->thunkpos= yythunkpos1254;  if (!yymatchChar(G, '-')) goto l1251;
  }
  l1254:;	  goto l1250;
  l1251:;	  G->pos= yypos1251; G->thunkpos= yythunkpos1251;
  }  if (!yy_Spnl(G)) { goto l1249; }
  {  int yypos1256= G->pos, yythunkpos1256= G->thunkpos;  if (!yymatchChar(G, '=')) goto l1256;  if (!yy_Spnl(G)) { goto l1256; }
  {  int yypos1258= G->pos, yythunkpos1258= G->thunkpos;  if (!yy_Quoted(G)) { goto l1259; }  goto l1258;
  l1259:;	  G->pos= yypos1258; G->thunkpos= yythunkpos1258;
  {  int yypos1262= G->pos, yythunkpos1262= G->thunkpos;  if (!yymatchChar(G, '>')) goto l1262;  goto l1256;
  l1262:;	  G->pos= yypos1262; G->thunkpos= yythunkpos1262;
  }  if (!yy_Nonspacechar(G)) { goto l1256; }
  l1260:;	
  {  int yypos1261= G->pos, yythunkpos1261= G->thunkpos;
  {  int yypos1263= G->pos, yythunkpos1263= G->thunkpos;  if (!yymatchChar(G, '>')) goto l1263;  goto l1261;
  l1263:;	  G->pos= yypos1263; G->thunkpos= yythunkpos1263;
  }  if (!yy_Nonspacechar(G)) { goto l1261; }  goto l1260;
  l1261:;	  G->pos= yypos1261; G->thunkpos= yythunkpos1261;
  }
  }
  l1258:;	  goto l1257;
  l1256:;	  G->pos= yypos1256; G->thunkpos= yythunkpos1256;
  }
  l1257:;	  if (!yy_Spnl(G)) { goto l1249; }
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlAttribute", G->buf+G->pos));
  return 1;
  l1249:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlAttribute", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenAddress(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HtmlBlockOpenAddress"));  if (!yymatchChar(G, '<')) goto l1264;  if (!yy_Spnl(G)) { goto l1264; }
  {  int yypos1265= G->pos, yythunkpos1265= G->thunkpos;  if (!yymatchString(G, "address")) goto l1266;  goto l1265;
  l1266:;	  G->pos= yypos1265; G->thunkpos= yythunkpos1265;  if (!yymatchString(G, "ADDRESS")) goto l1264;
  }
  l1265:;	  if (!yy_Spnl(G)) { goto l1264; }
  l1267:;	
  {  int yypos1268= G->pos, yythunkpos1268= G->thunkpos;  if (!yy_HtmlAttribute(G)) { goto l1268; }  goto l1267;
  l1268:;	  G->pos= yypos1268; G->thunkpos= yythunkpos1268;
  }  if (!yymatchChar(G, '>')) goto l1264;
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlockOpenAddress", G->buf+G->pos));
  return 1;
  l1264:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlockOpenAddress", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_OptionallyIndentedLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "OptionallyIndentedLine"));
  {  int yypos1270= G->pos, yythunkpos1270= G->thunkpos;  if (!yy_Indent(G)) { goto l1270; }  goto l1271;
  l1270:;	  G->pos= yypos1270; G->thunkpos= yythunkpos1270;
  }
  l1271:;	  if (!yy_Line(G)) { goto l1269; }
  yyprintf((stderr, "  ok   %s @ %s\n", "OptionallyIndentedLine", G->buf+G->pos));
  return 1;
  l1269:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "OptionallyIndentedLine", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Indent(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Indent"));
  {  int yypos1273= G->pos, yythunkpos1273= G->thunkpos;  if (!yymatchChar(G, '\t')) goto l1274;  goto l1273;
  l1274:;	  G->pos= yypos1273; G->thunkpos= yythunkpos1273;  if (!yymatchString(G, "    ")) goto l1272;
  }
  l1273:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "Indent", G->buf+G->pos));
  return 1;
  l1272:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Indent", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_ListBlockLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "ListBlockLine"));
  {  int yypos1276= G->pos, yythunkpos1276= G->thunkpos;  if (!yy_BlankLine(G)) { goto l1276; }  goto l1275;
  l1276:;	  G->pos= yypos1276; G->thunkpos= yythunkpos1276;
  }
  {  int yypos1277= G->pos, yythunkpos1277= G->thunkpos;
  {  int yypos1278= G->pos, yythunkpos1278= G->thunkpos;  if (!yy_Indent(G)) { goto l1278; }  goto l1279;
  l1278:;	  G->pos= yypos1278; G->thunkpos= yythunkpos1278;
  }
  l1279:;	
  {  int yypos1280= G->pos, yythunkpos1280= G->thunkpos;  if (!yy_Bullet(G)) { goto l1281; }  goto l1280;
  l1281:;	  G->pos= yypos1280; G->thunkpos= yythunkpos1280;  if (!yy_Enumerator(G)) { goto l1277; }
  }
  l1280:;	  goto l1275;
  l1277:;	  G->pos= yypos1277; G->thunkpos= yythunkpos1277;
  }
  {  int yypos1282= G->pos, yythunkpos1282= G->thunkpos;  if (!yy_HorizontalRule(G)) { goto l1282; }  goto l1275;
  l1282:;	  G->pos= yypos1282; G->thunkpos= yythunkpos1282;
  }  if (!yy_OptionallyIndentedLine(G)) { goto l1275; }
  yyprintf((stderr, "  ok   %s @ %s\n", "ListBlockLine", G->buf+G->pos));
  return 1;
  l1275:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ListBlockLine", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_ListContinuationBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "ListContinuationBlock"));  if (!yy_StartList(G)) { goto l1283; }  yyDo(G, yySet, -1, 0);  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1283;
  l1284:;	
  {  int yypos1285= G->pos, yythunkpos1285= G->thunkpos;  if (!yy_BlankLine(G)) { goto l1285; }  goto l1284;
  l1285:;	  G->pos= yypos1285; G->thunkpos= yythunkpos1285;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1283;  yyDo(G, yy_1_ListContinuationBlock, G->begin, G->end);  if (!yy_Indent(G)) { goto l1283; }  if (!yy_ListBlock(G)) { goto l1283; }  yyDo(G, yy_2_ListContinuationBlock, G->begin, G->end);
  l1286:;	
  {  int yypos1287= G->pos, yythunkpos1287= G->thunkpos;  if (!yy_Indent(G)) { goto l1287; }  if (!yy_ListBlock(G)) { goto l1287; }  yyDo(G, yy_2_ListContinuationBlock, G->begin, G->end);  goto l1286;
  l1287:;	  G->pos= yypos1287; G->thunkpos= yythunkpos1287;
  }  yyDo(G, yy_3_ListContinuationBlock, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "ListContinuationBlock", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1283:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ListContinuationBlock", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_ListBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "ListBlock"));  if (!yy_StartList(G)) { goto l1288; }  yyDo(G, yySet, -1, 0);
  {  int yypos1289= G->pos, yythunkpos1289= G->thunkpos;  if (!yy_BlankLine(G)) { goto l1289; }  goto l1288;
  l1289:;	  G->pos= yypos1289; G->thunkpos= yythunkpos1289;
  }  if (!yy_Line(G)) { goto l1288; }  yyDo(G, yy_1_ListBlock, G->begin, G->end);
  l1290:;	
  {  int yypos1291= G->pos, yythunkpos1291= G->thunkpos;  if (!yy_ListBlockLine(G)) { goto l1291; }  yyDo(G, yy_2_ListBlock, G->begin, G->end);  goto l1290;
  l1291:;	  G->pos= yypos1291; G->thunkpos= yythunkpos1291;
  }  yyDo(G, yy_3_ListBlock, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "ListBlock", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1288:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ListBlock", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_ListItem(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "ListItem"));
  {  int yypos1293= G->pos, yythunkpos1293= G->thunkpos;  if (!yy_Bullet(G)) { goto l1294; }  goto l1293;
  l1294:;	  G->pos= yypos1293; G->thunkpos= yythunkpos1293;  if (!yy_Enumerator(G)) { goto l1292; }
  }
  l1293:;	  if (!yy_StartList(G)) { goto l1292; }  yyDo(G, yySet, -1, 0);  if (!yy_ListBlock(G)) { goto l1292; }  yyDo(G, yy_1_ListItem, G->begin, G->end);
  l1295:;	
  {  int yypos1296= G->pos, yythunkpos1296= G->thunkpos;  if (!yy_ListContinuationBlock(G)) { goto l1296; }  yyDo(G, yy_2_ListItem, G->begin, G->end);  goto l1295;
  l1296:;	  G->pos= yypos1296; G->thunkpos= yythunkpos1296;
  }  yyDo(G, yy_3_ListItem, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "ListItem", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1292:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ListItem", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Enumerator(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Enumerator"));  if (!yy_NonindentSpace(G)) { goto l1297; }  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1297;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l1297;
  l1298:;	
  {  int yypos1299= G->pos, yythunkpos1299= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l1299;  goto l1298;
  l1299:;	  G->pos= yypos1299; G->thunkpos= yythunkpos1299;
  }  if (!yymatchChar(G, '.')) goto l1297;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1297;  if (!yy_Spacechar(G)) { goto l1297; }
  l1300:;	
  {  int yypos1301= G->pos, yythunkpos1301= G->thunkpos;  if (!yy_Spacechar(G)) { goto l1301; }  goto l1300;
  l1301:;	  G->pos= yypos1301; G->thunkpos= yythunkpos1301;
  }  yyDo(G, yy_1_Enumerator, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Enumerator", G->buf+G->pos));
  return 1;
  l1297:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Enumerator", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_ListItemTight(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "ListItemTight"));
  {  int yypos1303= G->pos, yythunkpos1303= G->thunkpos;  if (!yy_Bullet(G)) { goto l1304; }  goto l1303;
  l1304:;	  G->pos= yypos1303; G->thunkpos= yythunkpos1303;  if (!yy_Enumerator(G)) { goto l1302; }
  }
  l1303:;	  if (!yy_StartList(G)) { goto l1302; }  yyDo(G, yySet, -1, 0);  if (!yy_ListBlock(G)) { goto l1302; }  yyDo(G, yy_1_ListItemTight, G->begin, G->end);
  l1305:;	
  {  int yypos1306= G->pos, yythunkpos1306= G->thunkpos;
  {  int yypos1307= G->pos, yythunkpos1307= G->thunkpos;  if (!yy_BlankLine(G)) { goto l1307; }  goto l1306;
  l1307:;	  G->pos= yypos1307; G->thunkpos= yythunkpos1307;
  }  if (!yy_ListContinuationBlock(G)) { goto l1306; }  yyDo(G, yy_2_ListItemTight, G->begin, G->end);  goto l1305;
  l1306:;	  G->pos= yypos1306; G->thunkpos= yythunkpos1306;
  }
  {  int yypos1308= G->pos, yythunkpos1308= G->thunkpos;  if (!yy_ListContinuationBlock(G)) { goto l1308; }  goto l1302;
  l1308:;	  G->pos= yypos1308; G->thunkpos= yythunkpos1308;
  }  yyDo(G, yy_3_ListItemTight, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "ListItemTight", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1302:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ListItemTight", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_ListLoose(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0);
  yyprintf((stderr, "%s\n", "ListLoose"));  if (!yy_StartList(G)) { goto l1309; }  yyDo(G, yySet, -2, 0);  if (!yy_ListItem(G)) { goto l1309; }  yyDo(G, yySet, -1, 0);
  l1312:;	
  {  int yypos1313= G->pos, yythunkpos1313= G->thunkpos;  if (!yy_BlankLine(G)) { goto l1313; }  goto l1312;
  l1313:;	  G->pos= yypos1313; G->thunkpos= yythunkpos1313;
  }  yyDo(G, yy_1_ListLoose, G->begin, G->end);
  l1310:;	
  {  int yypos1311= G->pos, yythunkpos1311= G->thunkpos;  if (!yy_ListItem(G)) { goto l1311; }  yyDo(G, yySet, -1, 0);
  l1314:;	
  {  int yypos1315= G->pos, yythunkpos1315= G->thunkpos;  if (!yy_BlankLine(G)) { goto l1315; }  goto l1314;
  l1315:;	  G->pos= yypos1315; G->thunkpos= yythunkpos1315;
  }  yyDo(G, yy_1_ListLoose, G->begin, G->end);  goto l1310;
  l1311:;	  G->pos= yypos1311; G->thunkpos= yythunkpos1311;
  }  yyDo(G, yy_2_ListLoose, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "ListLoose", G->buf+G->pos));  yyDo(G, yyPop, 2, 0);
  return 1;
  l1309:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ListLoose", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_ListTight(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "ListTight"));  if (!yy_StartList(G)) { goto l1316; }  yyDo(G, yySet, -1, 0);  if (!yy_ListItemTight(G)) { goto l1316; }  yyDo(G, yy_1_ListTight, G->begin, G->end);
  l1317:;	
  {  int yypos1318= G->pos, yythunkpos1318= G->thunkpos;  if (!yy_ListItemTight(G)) { goto l1318; }  yyDo(G, yy_1_ListTight, G->begin, G->end);  goto l1317;
  l1318:;	  G->pos= yypos1318; G->thunkpos= yythunkpos1318;
  }
  l1319:;	
  {  int yypos1320= G->pos, yythunkpos1320= G->thunkpos;  if (!yy_BlankLine(G)) { goto l1320; }  goto l1319;
  l1320:;	  G->pos= yypos1320; G->thunkpos= yythunkpos1320;
  }
  {  int yypos1321= G->pos, yythunkpos1321= G->thunkpos;
  {  int yypos1322= G->pos, yythunkpos1322= G->thunkpos;  if (!yy_Bullet(G)) { goto l1323; }  goto l1322;
  l1323:;	  G->pos= yypos1322; G->thunkpos= yythunkpos1322;  if (!yy_Enumerator(G)) { goto l1321; }
  }
  l1322:;	  goto l1316;
  l1321:;	  G->pos= yypos1321; G->thunkpos= yythunkpos1321;
  }  yyDo(G, yy_2_ListTight, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "ListTight", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1316:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ListTight", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Bullet(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Bullet"));
  {  int yypos1325= G->pos, yythunkpos1325= G->thunkpos;  if (!yy_HorizontalRule(G)) { goto l1325; }  goto l1324;
  l1325:;	  G->pos= yypos1325; G->thunkpos= yythunkpos1325;
  }  if (!yy_NonindentSpace(G)) { goto l1324; }  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1324;
  {  int yypos1326= G->pos, yythunkpos1326= G->thunkpos;  if (!yymatchChar(G, '+')) goto l1327;  goto l1326;
  l1327:;	  G->pos= yypos1326; G->thunkpos= yythunkpos1326;  if (!yymatchChar(G, '*')) goto l1328;  goto l1326;
  l1328:;	  G->pos= yypos1326; G->thunkpos= yythunkpos1326;  if (!yymatchChar(G, '-')) goto l1324;
  }
  l1326:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1324;  if (!yy_Spacechar(G)) { goto l1324; }
  l1329:;	
  {  int yypos1330= G->pos, yythunkpos1330= G->thunkpos;  if (!yy_Spacechar(G)) { goto l1330; }  goto l1329;
  l1330:;	  G->pos= yypos1330; G->thunkpos= yythunkpos1330;
  }  yyDo(G, yy_1_Bullet, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Bullet", G->buf+G->pos));
  return 1;
  l1324:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Bullet", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_TableCell(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "TableCell"));  if (!yy_Sp(G)) { goto l1331; }
  l1332:;	
  {  int yypos1333= G->pos, yythunkpos1333= G->thunkpos;
  {  int yypos1334= G->pos, yythunkpos1334= G->thunkpos;  if (!yymatchChar(G, '|')) goto l1334;  goto l1333;
  l1334:;	  G->pos= yypos1334; G->thunkpos= yythunkpos1334;
  }
  {  int yypos1335= G->pos, yythunkpos1335= G->thunkpos;  if (!yy_Newline(G)) { goto l1335; }  goto l1333;
  l1335:;	  G->pos= yypos1335; G->thunkpos= yythunkpos1335;
  }  if (!yy_Inline(G)) { goto l1333; }  goto l1332;
  l1333:;	  G->pos= yypos1333; G->thunkpos= yythunkpos1333;
  }  if (!yy_TableBorder(G)) { goto l1331; }
  yyprintf((stderr, "  ok   %s @ %s\n", "TableCell", G->buf+G->pos));
  return 1;
  l1331:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "TableCell", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_TableBorder(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "TableBorder"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1336;  if (!yymatchChar(G, '|')) goto l1336;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1336;  yyDo(G, yy_1_TableBorder, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "TableBorder", G->buf+G->pos));
  return 1;
  l1336:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "TableBorder", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_TableLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "TableLine"));  if (!yy_TableBorder(G)) { goto l1337; }  if (!yy_TableCell(G)) { goto l1337; }
  l1338:;	
  {  int yypos1339= G->pos, yythunkpos1339= G->thunkpos;  if (!yy_TableCell(G)) { goto l1339; }  goto l1338;
  l1339:;	  G->pos= yypos1339; G->thunkpos= yythunkpos1339;
  }  if (!yy_Sp(G)) { goto l1337; }  if (!yy_Newline(G)) { goto l1337; }
  yyprintf((stderr, "  ok   %s @ %s\n", "TableLine", G->buf+G->pos));
  return 1;
  l1337:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "TableLine", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_TableDelimiter(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "TableDelimiter"));  if (!yy_TableBorder(G)) { goto l1340; }  if (!yy_Sp(G)) { goto l1340; }
  {  int yypos1343= G->pos, yythunkpos1343= G->thunkpos;  if (!yymatchChar(G, ':')) goto l1343;  goto l1344;
  l1343:;	  G->pos= yypos1343; G->thunkpos= yythunkpos1343;
  }
  l1344:;	  if (!yymatchChar(G, '-')) goto l1340;
  l1345:;	
  {  int yypos1346= G->pos, yythunkpos1346= G->thunkpos;  if (!yymatchChar(G, '-')) goto l1346;  goto l1345;
  l1346:;	  G->pos= yypos1346; G->thunkpos= yythunkpos1346;
  }
  {  int yypos1347= G->pos, yythunkpos1347= G->thunkpos;  if (!yymatchChar(G, ':')) goto l1347;  goto l1348;
  l1347:;	  G->pos= yypos1347; G->thunkpos= yythunkpos1347;
  }
  l1348:;	  if (!yy_Sp(G)) { goto l1340; }  if (!yy_TableBorder(G)) { goto l1340; }
  l1341:;	
  {  int yypos1342= G->pos, yythunkpos1342= G->thunkpos;  if (!yy_Sp(G)) { goto l1342; }
  {  int yypos1349= G->pos, yythunkpos1349= G->thunkpos;  if (!yymatchChar(G, ':')) goto l1349;  goto l1350;
  l1349:;	  G->pos= yypos1349; G->thunkpos= yythunkpos1349;
  }
  l1350:;	  if (!yymatchChar(G, '-')) goto l1342;
  l1351:;	
  {  int yypos1352= G->pos, yythunkpos1352= G->thunkpos;  if (!yymatchChar(G, '-')) goto l1352;  goto l1351;
  l1352:;	  G->pos= yypos1352; G->thunkpos= yythunkpos1352;
  }
  {  int yypos1353= G->pos, yythunkpos1353= G->thunkpos;  if (!yymatchChar(G, ':')) goto l1353;  goto l1354;
  l1353:;	  G->pos= yypos1353; G->thunkpos= yythunkpos1353;
  }
  l1354:;	  if (!yy_Sp(G)) { goto l1342; }  if (!yy_TableBorder(G)) { goto l1342; }  goto l1341;
  l1342:;	  G->pos= yypos1342; G->thunkpos= yythunkpos1342;
  }  if (!yy_Sp(G)) { goto l1340; }  if (!yy_Newline(G)) { goto l1340; }
  yyprintf((stderr, "  ok   %s @ %s\n", "TableDelimiter", G->buf+G->pos));
  return 1;
  l1340:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "TableDelimiter", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_TableHeader(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "TableHeader"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1355;  if (!yy_LocMarker(G)) { goto l1355; }  yyDo(G, yySet, -1, 0);  if (!yy_TableLine(G)) { goto l1355; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1355;  yyDo(G, yy_1_TableHeader, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "TableHeader", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1355:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "TableHeader", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_InlineEquationMultiple(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "InlineEquationMultiple"));
  {  int yypos1357= G->pos, yythunkpos1357= G->thunkpos;  if (!yymatchChar(G, '$')) goto l1357;  goto l1356;
  l1357:;	  G->pos= yypos1357; G->thunkpos= yythunkpos1357;
  }  if (!yy_Nonspacechar(G)) { goto l1356; }
  {  int yypos1360= G->pos, yythunkpos1360= G->thunkpos;  if (!yymatchChar(G, '$')) goto l1360;  goto l1356;
  l1360:;	  G->pos= yypos1360; G->thunkpos= yythunkpos1360;
  }
  {  int yypos1361= G->pos, yythunkpos1361= G->thunkpos;  if (!yy_Newline(G)) { goto l1361; }  goto l1356;
  l1361:;	  G->pos= yypos1361; G->thunkpos= yythunkpos1361;
  }  if (!yymatchDot(G)) goto l1356;
  l1358:;	
  {  int yypos1359= G->pos, yythunkpos1359= G->thunkpos;
  {  int yypos1362= G->pos, yythunkpos1362= G->thunkpos;  if (!yymatchChar(G, '$')) goto l1362;  goto l1359;
  l1362:;	  G->pos= yypos1362; G->thunkpos= yythunkpos1362;
  }
  {  int yypos1363= G->pos, yythunkpos1363= G->thunkpos;  if (!yy_Newline(G)) { goto l1363; }  goto l1359;
  l1363:;	  G->pos= yypos1363; G->thunkpos= yythunkpos1363;
  }  if (!yymatchDot(G)) goto l1359;  goto l1358;
  l1359:;	  G->pos= yypos1359; G->thunkpos= yythunkpos1359;
  }  if (!yymatchChar(G, '$')) goto l1356;  yyText(G, G->begin, G->end);  if (!( IEP_POST )) goto l1356;
  yyprintf((stderr, "  ok   %s @ %s\n", "InlineEquationMultiple", G->buf+G->pos));
  return 1;
  l1356:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "InlineEquationMultiple", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_InlineEquationSingle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "InlineEquationSingle"));
  {  int yypos1365= G->pos, yythunkpos1365= G->thunkpos;  if (!yymatchChar(G, '$')) goto l1365;  goto l1364;
  l1365:;	  G->pos= yypos1365; G->thunkpos= yythunkpos1365;
  }
  {  int yypos1366= G->pos, yythunkpos1366= G->thunkpos;  if (!yymatchChar(G, '\\')) goto l1366;  goto l1364;
  l1366:;	  G->pos= yypos1366; G->thunkpos= yythunkpos1366;
  }  if (!yy_Nonspacechar(G)) { goto l1364; }  if (!yymatchChar(G, '$')) goto l1364;
  yyprintf((stderr, "  ok   %s @ %s\n", "InlineEquationSingle", G->buf+G->pos));
  return 1;
  l1364:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "InlineEquationSingle", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_InlineEquation(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "InlineEquation"));  yyText(G, G->begin, G->end);  if (!( EXT(pmh_EXT_MATH) )) goto l1367;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1367;  if (!yymatchChar(G, '$')) goto l1367;  yyText(G, G->begin, G->end);  if (!( IEP_PRE )) goto l1367;
  {  int yypos1368= G->pos, yythunkpos1368= G->thunkpos;  if (!yy_InlineEquationSingle(G)) { goto l1369; }  goto l1368;
  l1369:;	  G->pos= yypos1368; G->thunkpos= yythunkpos1368;  if (!yy_InlineEquationMultiple(G)) { goto l1367; }
  }
  l1368:;	
  {  int yypos1370= G->pos, yythunkpos1370= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l1370;  goto l1367;
  l1370:;	  G->pos= yypos1370; G->thunkpos= yythunkpos1370;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1367;  yyDo(G, yy_1_InlineEquation, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "InlineEquation", G->buf+G->pos));
  return 1;
  l1367:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "InlineEquation", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Nonspacechar(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Nonspacechar"));
  {  int yypos1372= G->pos, yythunkpos1372= G->thunkpos;  if (!yy_Spacechar(G)) { goto l1372; }  goto l1371;
  l1372:;	  G->pos= yypos1372; G->thunkpos= yythunkpos1372;
  }
  {  int yypos1373= G->pos, yythunkpos1373= G->thunkpos;  if (!yy_Newline(G)) { goto l1373; }  goto l1371;
  l1373:;	  G->pos= yypos1373; G->thunkpos= yythunkpos1373;
  }  if (!yymatchDot(G)) goto l1371;
  yyprintf((stderr, "  ok   %s @ %s\n", "Nonspacechar", G->buf+G->pos));
  return 1;
  l1371:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Nonspacechar", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_DisplayFormulaRawMark(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "DisplayFormulaRawMark"));
  {  int yypos1377= G->pos, yythunkpos1377= G->thunkpos;  if (!yymatchChar(G, '{')) goto l1377;  goto l1374;
  l1377:;	  G->pos= yypos1377; G->thunkpos= yythunkpos1377;
  }
  {  int yypos1378= G->pos, yythunkpos1378= G->thunkpos;  if (!yymatchChar(G, '}')) goto l1378;  goto l1374;
  l1378:;	  G->pos= yypos1378; G->thunkpos= yythunkpos1378;
  }  if (!yy_Nonspacechar(G)) { goto l1374; }
  l1375:;	
  {  int yypos1376= G->pos, yythunkpos1376= G->thunkpos;
  {  int yypos1379= G->pos, yythunkpos1379= G->thunkpos;  if (!yymatchChar(G, '{')) goto l1379;  goto l1376;
  l1379:;	  G->pos= yypos1379; G->thunkpos= yythunkpos1379;
  }
  {  int yypos1380= G->pos, yythunkpos1380= G->thunkpos;  if (!yymatchChar(G, '}')) goto l1380;  goto l1376;
  l1380:;	  G->pos= yypos1380; G->thunkpos= yythunkpos1380;
  }  if (!yy_Nonspacechar(G)) { goto l1376; }  goto l1375;
  l1376:;	  G->pos= yypos1376; G->thunkpos= yythunkpos1376;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "DisplayFormulaRawMark", G->buf+G->pos));
  return 1;
  l1374:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "DisplayFormulaRawMark", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_DisplayFormulaRawEnd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "DisplayFormulaRawEnd"));  if (!yymatchString(G, "\\end")) goto l1381;  if (!yymatchChar(G, '{')) goto l1381;  if (!yy_DisplayFormulaRawMark(G)) { goto l1381; }  if (!yymatchChar(G, '}')) goto l1381;
  yyprintf((stderr, "  ok   %s @ %s\n", "DisplayFormulaRawEnd", G->buf+G->pos));
  return 1;
  l1381:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "DisplayFormulaRawEnd", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Spnl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Spnl"));  if (!yy_Sp(G)) { goto l1382; }
  {  int yypos1383= G->pos, yythunkpos1383= G->thunkpos;  if (!yy_Newline(G)) { goto l1383; }  if (!yy_Sp(G)) { goto l1383; }  goto l1384;
  l1383:;	  G->pos= yypos1383; G->thunkpos= yythunkpos1383;
  }
  l1384:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "Spnl", G->buf+G->pos));
  return 1;
  l1382:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Spnl", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_DisplayFormulaRawStart(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "DisplayFormulaRawStart"));  if (!yymatchString(G, "\\begin")) goto l1385;  if (!yymatchChar(G, '{')) goto l1385;  if (!yy_DisplayFormulaRawMark(G)) { goto l1385; }  if (!yymatchChar(G, '}')) goto l1385;
  yyprintf((stderr, "  ok   %s @ %s\n", "DisplayFormulaRawStart", G->buf+G->pos));
  return 1;
  l1385:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "DisplayFormulaRawStart", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_FormulaNumber(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "FormulaNumber"));  if (!yymatchChar(G, '(')) goto l1386;
  {  int yypos1389= G->pos, yythunkpos1389= G->thunkpos;  if (!yymatchChar(G, ')')) goto l1389;  goto l1386;
  l1389:;	  G->pos= yypos1389; G->thunkpos= yythunkpos1389;
  }
  {  int yypos1390= G->pos, yythunkpos1390= G->thunkpos;  if (!yymatchChar(G, '$')) goto l1390;  goto l1386;
  l1390:;	  G->pos= yypos1390; G->thunkpos= yythunkpos1390;
  }
  {  int yypos1391= G->pos, yythunkpos1391= G->thunkpos;  if (!yy_Newline(G)) { goto l1391; }  goto l1386;
  l1391:;	  G->pos= yypos1391; G->thunkpos= yythunkpos1391;
  }  if (!yymatchDot(G)) goto l1386;
  l1387:;	
  {  int yypos1388= G->pos, yythunkpos1388= G->thunkpos;
  {  int yypos1392= G->pos, yythunkpos1392= G->thunkpos;  if (!yymatchChar(G, ')')) goto l1392;  goto l1388;
  l1392:;	  G->pos= yypos1392; G->thunkpos= yythunkpos1392;
  }
  {  int yypos1393= G->pos, yythunkpos1393= G->thunkpos;  if (!yymatchChar(G, '$')) goto l1393;  goto l1388;
  l1393:;	  G->pos= yypos1393; G->thunkpos= yythunkpos1393;
  }
  {  int yypos1394= G->pos, yythunkpos1394= G->thunkpos;  if (!yy_Newline(G)) { goto l1394; }  goto l1388;
  l1394:;	  G->pos= yypos1394; G->thunkpos= yythunkpos1394;
  }  if (!yymatchDot(G)) goto l1388;  goto l1387;
  l1388:;	  G->pos= yypos1388; G->thunkpos= yythunkpos1388;
  }  if (!yymatchChar(G, ')')) goto l1386;
  yyprintf((stderr, "  ok   %s @ %s\n", "FormulaNumber", G->buf+G->pos));
  return 1;
  l1386:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "FormulaNumber", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_DisplayFormulaDollarMark(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "DisplayFormulaDollarMark"));  if (!yymatchString(G, "$$")) goto l1395;
  yyprintf((stderr, "  ok   %s @ %s\n", "DisplayFormulaDollarMark", G->buf+G->pos));
  return 1;
  l1395:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "DisplayFormulaDollarMark", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_DisplayFormulaRaw(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "DisplayFormulaRaw"));  yyText(G, G->begin, G->end);  if (!( EXT(pmh_EXT_MATH_RAW) )) goto l1396;  if (!yy_NonindentSpace(G)) { goto l1396; }  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1396;  if (!yy_DisplayFormulaRawStart(G)) { goto l1396; }  yyText(G, G->begin, G->end);  if (!( start_dfr() )) goto l1396;  if (!yy_Spnl(G)) { goto l1396; }
  l1397:;	
  {  int yypos1398= G->pos, yythunkpos1398= G->thunkpos;
  {  int yypos1399= G->pos, yythunkpos1399= G->thunkpos;  if (!yy_DisplayFormulaRawStart(G)) { goto l1400; }  yyText(G, G->begin, G->end);  if (!( inc_dfr() )) goto l1400;  goto l1399;
  l1400:;	  G->pos= yypos1399; G->thunkpos= yythunkpos1399;  yyText(G, G->begin, G->end);  if (!( nested_dfr() )) goto l1401;  if (!yy_DisplayFormulaRawEnd(G)) { goto l1401; }  yyText(G, G->begin, G->end);  if (!( dec_dfr() )) goto l1401;  goto l1399;
  l1401:;	  G->pos= yypos1399; G->thunkpos= yythunkpos1399;
  {  int yypos1402= G->pos, yythunkpos1402= G->thunkpos;  if (!yy_DisplayFormulaRawEnd(G)) { goto l1402; }  goto l1398;
  l1402:;	  G->pos= yypos1402; G->thunkpos= yythunkpos1402;
  }
  {  int yypos1403= G->pos, yythunkpos1403= G->thunkpos;  if (!yy_DisplayFormulaRawStart(G)) { goto l1403; }  goto l1398;
  l1403:;	  G->pos= yypos1403; G->thunkpos= yythunkpos1403;
  }
  {  int yypos1404= G->pos, yythunkpos1404= G->thunkpos;  if (!yy_Newline(G)) { goto l1404; }  if (!yy_Newline(G)) { goto l1404; }
  l1405:;	
  {  int yypos1406= G->pos, yythunkpos1406= G->thunkpos;  if (!yy_Newline(G)) { goto l1406; }  goto l1405;
  l1406:;	  G->pos= yypos1406; G->thunkpos= yythunkpos1406;
  }  goto l1398;
  l1404:;	  G->pos= yypos1404; G->thunkpos= yythunkpos1404;
  }  if (!yymatchDot(G)) goto l1398;
  }
  l1399:;	  goto l1397;
  l1398:;	  G->pos= yypos1398; G->thunkpos= yythunkpos1398;
  }  yyText(G, G->begin, G->end);  if (!( !nested_dfr() )) goto l1396;  if (!yy_DisplayFormulaRawEnd(G)) { goto l1396; }  yyText(G, G->begin, G->end);  if (!( dec_dfr() )) goto l1396;  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1396;  if (!yy_Sp(G)) { goto l1396; }  if (!yy_Newline(G)) { goto l1396; }  yyDo(G, yy_1_DisplayFormulaRaw, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "DisplayFormulaRaw", G->buf+G->pos));
  return 1;
  l1396:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "DisplayFormulaRaw", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_DisplayFormulaDollar(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "DisplayFormulaDollar"));  if (!yy_NonindentSpace(G)) { goto l1407; }  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1407;  if (!yy_DisplayFormulaDollarMark(G)) { goto l1407; }
  l1408:;	
  {  int yypos1409= G->pos, yythunkpos1409= G->thunkpos;
  {  int yypos1410= G->pos, yythunkpos1410= G->thunkpos;  if (!yy_DisplayFormulaDollarMark(G)) { goto l1410; }  goto l1409;
  l1410:;	  G->pos= yypos1410; G->thunkpos= yythunkpos1410;
  }  if (!yymatchDot(G)) goto l1409;  goto l1408;
  l1409:;	  G->pos= yypos1409; G->thunkpos= yythunkpos1409;
  }  if (!yy_DisplayFormulaDollarMark(G)) { goto l1407; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1407;  if (!yy_Sp(G)) { goto l1407; }
  {  int yypos1411= G->pos, yythunkpos1411= G->thunkpos;  if (!yy_FormulaNumber(G)) { goto l1411; }  goto l1412;
  l1411:;	  G->pos= yypos1411; G->thunkpos= yythunkpos1411;
  }
  l1412:;	  if (!yy_Sp(G)) { goto l1407; }  if (!yy_Newline(G)) { goto l1407; }  yyDo(G, yy_1_DisplayFormulaDollar, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "DisplayFormulaDollar", G->buf+G->pos));
  return 1;
  l1407:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "DisplayFormulaDollar", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_FencedCodeBlockTidle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "FencedCodeBlockTidle"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1413;  if (!yy_FencedCodeBlockStartTidleLine(G)) { goto l1413; }
  l1414:;	
  {  int yypos1415= G->pos, yythunkpos1415= G->thunkpos;  if (!yy_FencedCodeBlockChunkTidle(G)) { goto l1415; }  goto l1414;
  l1415:;	  G->pos= yypos1415; G->thunkpos= yythunkpos1415;
  }  if (!yy_FencedCodeBlockEndTidle(G)) { goto l1413; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1413;  yyDo(G, yy_1_FencedCodeBlockTidle, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "FencedCodeBlockTidle", G->buf+G->pos));
  return 1;
  l1413:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "FencedCodeBlockTidle", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_FencedCodeBlockTick(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "FencedCodeBlockTick"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1416;  if (!yy_FencedCodeBlockStartTickLine(G)) { goto l1416; }
  l1417:;	
  {  int yypos1418= G->pos, yythunkpos1418= G->thunkpos;  if (!yy_FencedCodeBlockChunkTick(G)) { goto l1418; }  goto l1417;
  l1418:;	  G->pos= yypos1418; G->thunkpos= yythunkpos1418;
  }  if (!yy_FencedCodeBlockEndTick(G)) { goto l1416; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1416;  yyDo(G, yy_1_FencedCodeBlockTick, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "FencedCodeBlockTick", G->buf+G->pos));
  return 1;
  l1416:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "FencedCodeBlockTick", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_FencedCodeBlockEndTidle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "FencedCodeBlockEndTidle"));  if (!yymatchString(G, "~~~")) goto l1419;
  l1420:;	
  {  int yypos1421= G->pos, yythunkpos1421= G->thunkpos;  if (!yy_Spacechar(G)) { goto l1421; }  goto l1420;
  l1421:;	  G->pos= yypos1421; G->thunkpos= yythunkpos1421;
  }  if (!yy_Newline(G)) { goto l1419; }
  yyprintf((stderr, "  ok   %s @ %s\n", "FencedCodeBlockEndTidle", G->buf+G->pos));
  return 1;
  l1419:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "FencedCodeBlockEndTidle", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_FencedCodeBlockChunkTidle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "FencedCodeBlockChunkTidle"));
  {  int yypos1423= G->pos, yythunkpos1423= G->thunkpos;  if (!yy_FencedCodeBlockEndTidle(G)) { goto l1423; }  goto l1422;
  l1423:;	  G->pos= yypos1423; G->thunkpos= yythunkpos1423;
  }
  l1424:;	
  {  int yypos1425= G->pos, yythunkpos1425= G->thunkpos;
  {  int yypos1426= G->pos, yythunkpos1426= G->thunkpos;  if (!yy_Newline(G)) { goto l1426; }  goto l1425;
  l1426:;	  G->pos= yypos1426; G->thunkpos= yythunkpos1426;
  }  if (!yymatchDot(G)) goto l1425;  goto l1424;
  l1425:;	  G->pos= yypos1425; G->thunkpos= yythunkpos1425;
  }  if (!yy_Newline(G)) { goto l1422; }
  yyprintf((stderr, "  ok   %s @ %s\n", "FencedCodeBlockChunkTidle", G->buf+G->pos));
  return 1;
  l1422:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "FencedCodeBlockChunkTidle", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_FencedCodeBlockStartTidleLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "FencedCodeBlockStartTidleLine"));  if (!yy_FencedCodeBlockStartTidle(G)) { goto l1427; }  if (!yy_Newline(G)) { goto l1427; }
  yyprintf((stderr, "  ok   %s @ %s\n", "FencedCodeBlockStartTidleLine", G->buf+G->pos));
  return 1;
  l1427:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "FencedCodeBlockStartTidleLine", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_FencedCodeBlockStartTidle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "FencedCodeBlockStartTidle"));  if (!yymatchString(G, "~~~")) goto l1428;
  l1429:;	
  {  int yypos1430= G->pos, yythunkpos1430= G->thunkpos;
  {  int yypos1431= G->pos, yythunkpos1431= G->thunkpos;  if (!yy_Newline(G)) { goto l1431; }  goto l1430;
  l1431:;	  G->pos= yypos1431; G->thunkpos= yythunkpos1431;
  }
  {  int yypos1432= G->pos, yythunkpos1432= G->thunkpos;  if (!yymatchChar(G, '~')) goto l1432;  goto l1430;
  l1432:;	  G->pos= yypos1432; G->thunkpos= yythunkpos1432;
  }  if (!yymatchDot(G)) goto l1430;  goto l1429;
  l1430:;	  G->pos= yypos1430; G->thunkpos= yythunkpos1430;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "FencedCodeBlockStartTidle", G->buf+G->pos));
  return 1;
  l1428:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "FencedCodeBlockStartTidle", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Spacechar(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Spacechar"));
  {  int yypos1434= G->pos, yythunkpos1434= G->thunkpos;  if (!yymatchChar(G, ' ')) goto l1435;  goto l1434;
  l1435:;	  G->pos= yypos1434; G->thunkpos= yythunkpos1434;  if (!yymatchChar(G, '\t')) goto l1433;
  }
  l1434:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "Spacechar", G->buf+G->pos));
  return 1;
  l1433:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Spacechar", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_FencedCodeBlockEndTick(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "FencedCodeBlockEndTick"));  if (!yymatchString(G, "```")) goto l1436;
  l1437:;	
  {  int yypos1438= G->pos, yythunkpos1438= G->thunkpos;  if (!yy_Spacechar(G)) { goto l1438; }  goto l1437;
  l1438:;	  G->pos= yypos1438; G->thunkpos= yythunkpos1438;
  }  if (!yy_Newline(G)) { goto l1436; }
  yyprintf((stderr, "  ok   %s @ %s\n", "FencedCodeBlockEndTick", G->buf+G->pos));
  return 1;
  l1436:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "FencedCodeBlockEndTick", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_FencedCodeBlockChunkTick(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "FencedCodeBlockChunkTick"));
  {  int yypos1440= G->pos, yythunkpos1440= G->thunkpos;  if (!yy_FencedCodeBlockEndTick(G)) { goto l1440; }  goto l1439;
  l1440:;	  G->pos= yypos1440; G->thunkpos= yythunkpos1440;
  }
  l1441:;	
  {  int yypos1442= G->pos, yythunkpos1442= G->thunkpos;
  {  int yypos1443= G->pos, yythunkpos1443= G->thunkpos;  if (!yy_Newline(G)) { goto l1443; }  goto l1442;
  l1443:;	  G->pos= yypos1443; G->thunkpos= yythunkpos1443;
  }  if (!yymatchDot(G)) goto l1442;  goto l1441;
  l1442:;	  G->pos= yypos1442; G->thunkpos= yythunkpos1442;
  }  if (!yy_Newline(G)) { goto l1439; }
  yyprintf((stderr, "  ok   %s @ %s\n", "FencedCodeBlockChunkTick", G->buf+G->pos));
  return 1;
  l1439:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "FencedCodeBlockChunkTick", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_FencedCodeBlockStartTickLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "FencedCodeBlockStartTickLine"));  if (!yy_FencedCodeBlockStartTick(G)) { goto l1444; }  if (!yy_Newline(G)) { goto l1444; }
  yyprintf((stderr, "  ok   %s @ %s\n", "FencedCodeBlockStartTickLine", G->buf+G->pos));
  return 1;
  l1444:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "FencedCodeBlockStartTickLine", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_FencedCodeBlockStartTick(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "FencedCodeBlockStartTick"));  if (!yymatchString(G, "```")) goto l1445;
  l1446:;	
  {  int yypos1447= G->pos, yythunkpos1447= G->thunkpos;
  {  int yypos1448= G->pos, yythunkpos1448= G->thunkpos;  if (!yy_Newline(G)) { goto l1448; }  goto l1447;
  l1448:;	  G->pos= yypos1448; G->thunkpos= yythunkpos1448;
  }
  {  int yypos1449= G->pos, yythunkpos1449= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1449;  goto l1447;
  l1449:;	  G->pos= yypos1449; G->thunkpos= yythunkpos1449;
  }  if (!yymatchDot(G)) goto l1447;  goto l1446;
  l1447:;	  G->pos= yypos1447; G->thunkpos= yythunkpos1447;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "FencedCodeBlockStartTick", G->buf+G->pos));
  return 1;
  l1445:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "FencedCodeBlockStartTick", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_VerbatimChunk(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "VerbatimChunk"));
  l1451:;	
  {  int yypos1452= G->pos, yythunkpos1452= G->thunkpos;  if (!yy_BlankLine(G)) { goto l1452; }  goto l1451;
  l1452:;	  G->pos= yypos1452; G->thunkpos= yythunkpos1452;
  }  if (!yy_NonblankIndentedLine(G)) { goto l1450; }
  l1453:;	
  {  int yypos1454= G->pos, yythunkpos1454= G->thunkpos;  if (!yy_NonblankIndentedLine(G)) { goto l1454; }  goto l1453;
  l1454:;	  G->pos= yypos1454; G->thunkpos= yythunkpos1454;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "VerbatimChunk", G->buf+G->pos));
  return 1;
  l1450:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "VerbatimChunk", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_IndentedLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "IndentedLine"));  if (!yy_Indent(G)) { goto l1455; }  if (!yy_Line(G)) { goto l1455; }
  yyprintf((stderr, "  ok   %s @ %s\n", "IndentedLine", G->buf+G->pos));
  return 1;
  l1455:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "IndentedLine", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_NonblankIndentedLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "NonblankIndentedLine"));
  {  int yypos1457= G->pos, yythunkpos1457= G->thunkpos;  if (!yy_BlankLine(G)) { goto l1457; }  goto l1456;
  l1457:;	  G->pos= yypos1457; G->thunkpos= yythunkpos1457;
  }  if (!yy_IndentedLine(G)) { goto l1456; }
  yyprintf((stderr, "  ok   %s @ %s\n", "NonblankIndentedLine", G->buf+G->pos));
  return 1;
  l1456:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "NonblankIndentedLine", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Line(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Line"));  if (!yy_RawLine(G)) { goto l1458; }  yyDo(G, yy_1_Line, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Line", G->buf+G->pos));
  return 1;
  l1458:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Line", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_StartList(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "StartList"));
  {  int yypos1460= G->pos, yythunkpos1460= G->thunkpos;  if (!yymatchDot(G)) goto l1459;  G->pos= yypos1460; G->thunkpos= yythunkpos1460;
  }  yyDo(G, yy_1_StartList, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "StartList", G->buf+G->pos));
  return 1;
  l1459:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "StartList", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_BlockQuoteRaw(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "BlockQuoteRaw"));  if (!yy_StartList(G)) { goto l1461; }  yyDo(G, yySet, -1, 0);  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1461;  if (!yymatchChar(G, '>')) goto l1461;
  {  int yypos1464= G->pos, yythunkpos1464= G->thunkpos;  if (!yymatchChar(G, ' ')) goto l1464;  goto l1465;
  l1464:;	  G->pos= yypos1464; G->thunkpos= yythunkpos1464;
  }
  l1465:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1461;  yyDo(G, yy_1_BlockQuoteRaw, G->begin, G->end);  if (!yy_Line(G)) { goto l1461; }  yyDo(G, yy_2_BlockQuoteRaw, G->begin, G->end);
  l1466:;	
  {  int yypos1467= G->pos, yythunkpos1467= G->thunkpos;
  {  int yypos1468= G->pos, yythunkpos1468= G->thunkpos;  if (!yymatchChar(G, '>')) goto l1468;  goto l1467;
  l1468:;	  G->pos= yypos1468; G->thunkpos= yythunkpos1468;
  }
  {  int yypos1469= G->pos, yythunkpos1469= G->thunkpos;  if (!yy_BlankLine(G)) { goto l1469; }  goto l1467;
  l1469:;	  G->pos= yypos1469; G->thunkpos= yythunkpos1469;
  }  if (!yy_Line(G)) { goto l1467; }  yyDo(G, yy_3_BlockQuoteRaw, G->begin, G->end);  goto l1466;
  l1467:;	  G->pos= yypos1467; G->thunkpos= yythunkpos1467;
  }
  l1470:;	
  {  int yypos1471= G->pos, yythunkpos1471= G->thunkpos;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1471;  if (!yy_BlankLine(G)) { goto l1471; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1471;  yyDo(G, yy_4_BlockQuoteRaw, G->begin, G->end);  goto l1470;
  l1471:;	  G->pos= yypos1471; G->thunkpos= yythunkpos1471;
  }
  l1462:;	
  {  int yypos1463= G->pos, yythunkpos1463= G->thunkpos;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1463;  if (!yymatchChar(G, '>')) goto l1463;
  {  int yypos1472= G->pos, yythunkpos1472= G->thunkpos;  if (!yymatchChar(G, ' ')) goto l1472;  goto l1473;
  l1472:;	  G->pos= yypos1472; G->thunkpos= yythunkpos1472;
  }
  l1473:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1463;  yyDo(G, yy_1_BlockQuoteRaw, G->begin, G->end);  if (!yy_Line(G)) { goto l1463; }  yyDo(G, yy_2_BlockQuoteRaw, G->begin, G->end);
  l1474:;	
  {  int yypos1475= G->pos, yythunkpos1475= G->thunkpos;
  {  int yypos1476= G->pos, yythunkpos1476= G->thunkpos;  if (!yymatchChar(G, '>')) goto l1476;  goto l1475;
  l1476:;	  G->pos= yypos1476; G->thunkpos= yythunkpos1476;
  }
  {  int yypos1477= G->pos, yythunkpos1477= G->thunkpos;  if (!yy_BlankLine(G)) { goto l1477; }  goto l1475;
  l1477:;	  G->pos= yypos1477; G->thunkpos= yythunkpos1477;
  }  if (!yy_Line(G)) { goto l1475; }  yyDo(G, yy_3_BlockQuoteRaw, G->begin, G->end);  goto l1474;
  l1475:;	  G->pos= yypos1475; G->thunkpos= yythunkpos1475;
  }
  l1478:;	
  {  int yypos1479= G->pos, yythunkpos1479= G->thunkpos;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1479;  if (!yy_BlankLine(G)) { goto l1479; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1479;  yyDo(G, yy_4_BlockQuoteRaw, G->begin, G->end);  goto l1478;
  l1479:;	  G->pos= yypos1479; G->thunkpos= yythunkpos1479;
  }  goto l1462;
  l1463:;	  G->pos= yypos1463; G->thunkpos= yythunkpos1463;
  }  yyDo(G, yy_5_BlockQuoteRaw, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "BlockQuoteRaw", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1461:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "BlockQuoteRaw", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Endline(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Endline"));
  {  int yypos1481= G->pos, yythunkpos1481= G->thunkpos;  if (!yy_LineBreak(G)) { goto l1482; }  goto l1481;
  l1482:;	  G->pos= yypos1481; G->thunkpos= yythunkpos1481;  if (!yy_TerminalEndline(G)) { goto l1483; }  goto l1481;
  l1483:;	  G->pos= yypos1481; G->thunkpos= yythunkpos1481;  if (!yy_NormalEndline(G)) { goto l1480; }
  }
  l1481:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "Endline", G->buf+G->pos));
  return 1;
  l1480:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Endline", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_RawLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "RawLine"));
  {  int yypos1485= G->pos, yythunkpos1485= G->thunkpos;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1486;
  l1487:;	
  {  int yypos1488= G->pos, yythunkpos1488= G->thunkpos;
  {  int yypos1489= G->pos, yythunkpos1489= G->thunkpos;  if (!yymatchChar(G, '\r')) goto l1489;  goto l1488;
  l1489:;	  G->pos= yypos1489; G->thunkpos= yythunkpos1489;
  }
  {  int yypos1490= G->pos, yythunkpos1490= G->thunkpos;  if (!yymatchChar(G, '\n')) goto l1490;  goto l1488;
  l1490:;	  G->pos= yypos1490; G->thunkpos= yythunkpos1490;
  }  if (!yymatchDot(G)) goto l1488;  goto l1487;
  l1488:;	  G->pos= yypos1488; G->thunkpos= yythunkpos1488;
  }  if (!yy_Newline(G)) { goto l1486; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1486;  goto l1485;
  l1486:;	  G->pos= yypos1485; G->thunkpos= yythunkpos1485;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1484;  if (!yymatchDot(G)) goto l1484;
  l1491:;	
  {  int yypos1492= G->pos, yythunkpos1492= G->thunkpos;  if (!yymatchDot(G)) goto l1492;  goto l1491;
  l1492:;	  G->pos= yypos1492; G->thunkpos= yythunkpos1492;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1484;  if (!yy_Eof(G)) { goto l1484; }
  }
  l1485:;	  yyDo(G, yy_1_RawLine, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "RawLine", G->buf+G->pos));
  return 1;
  l1484:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "RawLine", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_SetextBottom2(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "SetextBottom2"));  if (!yymatchChar(G, '-')) goto l1493;
  l1494:;	
  {  int yypos1495= G->pos, yythunkpos1495= G->thunkpos;  if (!yymatchChar(G, '-')) goto l1495;  goto l1494;
  l1495:;	  G->pos= yypos1495; G->thunkpos= yythunkpos1495;
  }  if (!yy_Newline(G)) { goto l1493; }
  yyprintf((stderr, "  ok   %s @ %s\n", "SetextBottom2", G->buf+G->pos));
  return 1;
  l1493:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "SetextBottom2", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_SetextBottom1(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "SetextBottom1"));  if (!yymatchChar(G, '=')) goto l1496;
  l1497:;	
  {  int yypos1498= G->pos, yythunkpos1498= G->thunkpos;  if (!yymatchChar(G, '=')) goto l1498;  goto l1497;
  l1498:;	  G->pos= yypos1498; G->thunkpos= yythunkpos1498;
  }  if (!yy_Newline(G)) { goto l1496; }
  yyprintf((stderr, "  ok   %s @ %s\n", "SetextBottom1", G->buf+G->pos));
  return 1;
  l1496:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "SetextBottom1", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_SetextHeading2(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "SetextHeading2"));
  {  int yypos1500= G->pos, yythunkpos1500= G->thunkpos;  if (!yy_RawLine(G)) { goto l1499; }  if (!yy_SetextBottom2(G)) { goto l1499; }  G->pos= yypos1500; G->thunkpos= yythunkpos1500;
  }  if (!yy_LocMarker(G)) { goto l1499; }  yyDo(G, yySet, -1, 0);  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1499;
  {  int yypos1503= G->pos, yythunkpos1503= G->thunkpos;  if (!yy_Endline(G)) { goto l1503; }  goto l1499;
  l1503:;	  G->pos= yypos1503; G->thunkpos= yythunkpos1503;
  }  if (!yy_Inline(G)) { goto l1499; }
  l1501:;	
  {  int yypos1502= G->pos, yythunkpos1502= G->thunkpos;
  {  int yypos1504= G->pos, yythunkpos1504= G->thunkpos;  if (!yy_Endline(G)) { goto l1504; }  goto l1502;
  l1504:;	  G->pos= yypos1504; G->thunkpos= yythunkpos1504;
  }  if (!yy_Inline(G)) { goto l1502; }  goto l1501;
  l1502:;	  G->pos= yypos1502; G->thunkpos= yythunkpos1502;
  }  if (!yy_Sp(G)) { goto l1499; }  if (!yy_Newline(G)) { goto l1499; }  if (!yy_SetextBottom2(G)) { goto l1499; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1499;  yyDo(G, yy_1_SetextHeading2, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "SetextHeading2", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1499:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "SetextHeading2", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_SetextHeading1(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "SetextHeading1"));
  {  int yypos1506= G->pos, yythunkpos1506= G->thunkpos;  if (!yy_RawLine(G)) { goto l1505; }  if (!yy_SetextBottom1(G)) { goto l1505; }  G->pos= yypos1506; G->thunkpos= yythunkpos1506;
  }  if (!yy_LocMarker(G)) { goto l1505; }  yyDo(G, yySet, -1, 0);  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1505;
  {  int yypos1509= G->pos, yythunkpos1509= G->thunkpos;  if (!yy_Endline(G)) { goto l1509; }  goto l1505;
  l1509:;	  G->pos= yypos1509; G->thunkpos= yythunkpos1509;
  }  if (!yy_Inline(G)) { goto l1505; }
  l1507:;	
  {  int yypos1508= G->pos, yythunkpos1508= G->thunkpos;
  {  int yypos1510= G->pos, yythunkpos1510= G->thunkpos;  if (!yy_Endline(G)) { goto l1510; }  goto l1508;
  l1510:;	  G->pos= yypos1510; G->thunkpos= yythunkpos1510;
  }  if (!yy_Inline(G)) { goto l1508; }  goto l1507;
  l1508:;	  G->pos= yypos1508; G->thunkpos= yythunkpos1508;
  }  if (!yy_Sp(G)) { goto l1505; }  if (!yy_Newline(G)) { goto l1505; }  if (!yy_SetextBottom1(G)) { goto l1505; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1505;  yyDo(G, yy_1_SetextHeading1, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "SetextHeading1", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1505:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "SetextHeading1", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_SetextHeading(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "SetextHeading"));
  {  int yypos1512= G->pos, yythunkpos1512= G->thunkpos;  if (!yy_SetextHeading1(G)) { goto l1513; }  goto l1512;
  l1513:;	  G->pos= yypos1512; G->thunkpos= yythunkpos1512;  if (!yy_SetextHeading2(G)) { goto l1511; }
  }
  l1512:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "SetextHeading", G->buf+G->pos));
  return 1;
  l1511:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "SetextHeading", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Space(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Space"));  if (!yy_Spacechar(G)) { goto l1514; }
  l1515:;	
  {  int yypos1516= G->pos, yythunkpos1516= G->thunkpos;  if (!yy_Spacechar(G)) { goto l1516; }  goto l1515;
  l1516:;	  G->pos= yypos1516; G->thunkpos= yythunkpos1516;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "Space", G->buf+G->pos));
  return 1;
  l1514:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Space", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_AtxHeading(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "AtxHeading"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1517;  if (!yy_AtxStart(G)) { goto l1517; }  yyDo(G, yySet, -1, 0);  if (!yy_Space(G)) { goto l1517; }  if (!yy_AtxInline(G)) { goto l1517; }
  l1518:;	
  {  int yypos1519= G->pos, yythunkpos1519= G->thunkpos;  if (!yy_AtxInline(G)) { goto l1519; }  goto l1518;
  l1519:;	  G->pos= yypos1519; G->thunkpos= yythunkpos1519;
  }
  {  int yypos1520= G->pos, yythunkpos1520= G->thunkpos;  if (!yy_Sp(G)) { goto l1520; }
  l1522:;	
  {  int yypos1523= G->pos, yythunkpos1523= G->thunkpos;  if (!yymatchChar(G, '#')) goto l1523;  goto l1522;
  l1523:;	  G->pos= yypos1523; G->thunkpos= yythunkpos1523;
  }  if (!yy_Sp(G)) { goto l1520; }  goto l1521;
  l1520:;	  G->pos= yypos1520; G->thunkpos= yythunkpos1520;
  }
  l1521:;	  if (!yy_Newline(G)) { goto l1517; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1517;  yyDo(G, yy_1_AtxHeading, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "AtxHeading", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1517:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "AtxHeading", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_AtxStart(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "AtxStart"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1524;
  {  int yypos1525= G->pos, yythunkpos1525= G->thunkpos;  if (!yymatchString(G, "######")) goto l1526;  goto l1525;
  l1526:;	  G->pos= yypos1525; G->thunkpos= yythunkpos1525;  if (!yymatchString(G, "#####")) goto l1527;  goto l1525;
  l1527:;	  G->pos= yypos1525; G->thunkpos= yythunkpos1525;  if (!yymatchString(G, "####")) goto l1528;  goto l1525;
  l1528:;	  G->pos= yypos1525; G->thunkpos= yythunkpos1525;  if (!yymatchString(G, "###")) goto l1529;  goto l1525;
  l1529:;	  G->pos= yypos1525; G->thunkpos= yythunkpos1525;  if (!yymatchString(G, "##")) goto l1530;  goto l1525;
  l1530:;	  G->pos= yypos1525; G->thunkpos= yythunkpos1525;  if (!yymatchChar(G, '#')) goto l1524;
  }
  l1525:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1524;  yyDo(G, yy_1_AtxStart, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "AtxStart", G->buf+G->pos));
  return 1;
  l1524:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "AtxStart", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Inline(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Inline"));
  {  int yypos1532= G->pos, yythunkpos1532= G->thunkpos;  if (!yy_Str(G)) { goto l1533; }  goto l1532;
  l1533:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_Endline(G)) { goto l1534; }  goto l1532;
  l1534:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_UlOrStarLine(G)) { goto l1535; }  goto l1532;
  l1535:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_Space(G)) { goto l1536; }  goto l1532;
  l1536:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_Strong(G)) { goto l1537; }  goto l1532;
  l1537:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_Emph(G)) { goto l1538; }  goto l1532;
  l1538:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_Strike(G)) { goto l1539; }  goto l1532;
  l1539:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_Image(G)) { goto l1540; }  goto l1532;
  l1540:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_Link(G)) { goto l1541; }  goto l1532;
  l1541:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_NoteReference(G)) { goto l1542; }  goto l1532;
  l1542:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_InlineNote(G)) { goto l1543; }  goto l1532;
  l1543:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_Code(G)) { goto l1544; }  goto l1532;
  l1544:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_InlineEquation(G)) { goto l1545; }  goto l1532;
  l1545:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_Mark(G)) { goto l1546; }  goto l1532;
  l1546:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_RawHtml(G)) { goto l1547; }  goto l1532;
  l1547:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_Entity(G)) { goto l1548; }  goto l1532;
  l1548:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_EscapedChar(G)) { goto l1549; }  goto l1532;
  l1549:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_Symbol(G)) { goto l1531; }
  }
  l1532:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "Inline", G->buf+G->pos));
  return 1;
  l1531:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Inline", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Sp(GREG *G)
{
  yyprintf((stderr, "%s\n", "Sp"));
  l1551:;	
  {  int yypos1552= G->pos, yythunkpos1552= G->thunkpos;  if (!yy_Spacechar(G)) { goto l1552; }  goto l1551;
  l1552:;	  G->pos= yypos1552; G->thunkpos= yythunkpos1552;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "Sp", G->buf+G->pos));
  return 1;
}
YY_RULE(int) yy_AtxInline(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "AtxInline"));
  {  int yypos1554= G->pos, yythunkpos1554= G->thunkpos;  if (!yy_Newline(G)) { goto l1554; }  goto l1553;
  l1554:;	  G->pos= yypos1554; G->thunkpos= yythunkpos1554;
  }
  {  int yypos1555= G->pos, yythunkpos1555= G->thunkpos;  if (!yy_Sp(G)) { goto l1555; }
  l1556:;	
  {  int yypos1557= G->pos, yythunkpos1557= G->thunkpos;  if (!yymatchChar(G, '#')) goto l1557;  goto l1556;
  l1557:;	  G->pos= yypos1557; G->thunkpos= yythunkpos1557;
  }  if (!yy_Sp(G)) { goto l1555; }  if (!yy_Newline(G)) { goto l1555; }  goto l1553;
  l1555:;	  G->pos= yypos1555; G->thunkpos= yythunkpos1555;
  }  if (!yy_Inline(G)) { goto l1553; }
  yyprintf((stderr, "  ok   %s @ %s\n", "AtxInline", G->buf+G->pos));
  return 1;
  l1553:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "AtxInline", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Inlines(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Inlines"));
  {  int yypos1561= G->pos, yythunkpos1561= G->thunkpos;
  {  int yypos1563= G->pos, yythunkpos1563= G->thunkpos;  if (!yy_Endline(G)) { goto l1563; }  goto l1562;
  l1563:;	  G->pos= yypos1563; G->thunkpos= yythunkpos1563;
  }  if (!yy_Inline(G)) { goto l1562; }  goto l1561;
  l1562:;	  G->pos= yypos1561; G->thunkpos= yythunkpos1561;  if (!yy_Endline(G)) { goto l1558; }
  {  int yypos1564= G->pos, yythunkpos1564= G->thunkpos;  if (!yy_Inline(G)) { goto l1558; }  G->pos= yypos1564; G->thunkpos= yythunkpos1564;
  }
  }
  l1561:;	
  l1559:;	
  {  int yypos1560= G->pos, yythunkpos1560= G->thunkpos;
  {  int yypos1565= G->pos, yythunkpos1565= G->thunkpos;
  {  int yypos1567= G->pos, yythunkpos1567= G->thunkpos;  if (!yy_Endline(G)) { goto l1567; }  goto l1566;
  l1567:;	  G->pos= yypos1567; G->thunkpos= yythunkpos1567;
  }  if (!yy_Inline(G)) { goto l1566; }  goto l1565;
  l1566:;	  G->pos= yypos1565; G->thunkpos= yythunkpos1565;  if (!yy_Endline(G)) { goto l1560; }
  {  int yypos1568= G->pos, yythunkpos1568= G->thunkpos;  if (!yy_Inline(G)) { goto l1560; }  G->pos= yypos1568; G->thunkpos= yythunkpos1568;
  }
  }
  l1565:;	  goto l1559;
  l1560:;	  G->pos= yypos1560; G->thunkpos= yythunkpos1560;
  }
  {  int yypos1569= G->pos, yythunkpos1569= G->thunkpos;  if (!yy_Endline(G)) { goto l1569; }  goto l1570;
  l1569:;	  G->pos= yypos1569; G->thunkpos= yythunkpos1569;
  }
  l1570:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "Inlines", G->buf+G->pos));
  return 1;
  l1558:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Inlines", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_NonindentSpace(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "NonindentSpace"));
  {  int yypos1572= G->pos, yythunkpos1572= G->thunkpos;  if (!yymatchString(G, "   ")) goto l1573;  goto l1572;
  l1573:;	  G->pos= yypos1572; G->thunkpos= yythunkpos1572;  if (!yymatchString(G, "  ")) goto l1574;  goto l1572;
  l1574:;	  G->pos= yypos1572; G->thunkpos= yythunkpos1572;  if (!yymatchChar(G, ' ')) goto l1575;  goto l1572;
  l1575:;	  G->pos= yypos1572; G->thunkpos= yythunkpos1572;  if (!yymatchString(G, "")) goto l1571;
  }
  l1572:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "NonindentSpace", G->buf+G->pos));
  return 1;
  l1571:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "NonindentSpace", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Plain(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Plain"));  if (!yy_Inlines(G)) { goto l1576; }
  yyprintf((stderr, "  ok   %s @ %s\n", "Plain", G->buf+G->pos));
  return 1;
  l1576:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Plain", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Para(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Para"));  if (!yy_NonindentSpace(G)) { goto l1577; }  if (!yy_Inlines(G)) { goto l1577; }  if (!yy_BlankLine(G)) { goto l1577; }
  l1578:;	
  {  int yypos1579= G->pos, yythunkpos1579= G->thunkpos;  if (!yy_BlankLine(G)) { goto l1579; }  goto l1578;
  l1579:;	  G->pos= yypos1579; G->thunkpos= yythunkpos1579;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "Para", G->buf+G->pos));
  return 1;
  l1577:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Para", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_StyleBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "StyleBlock"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1580;  if (!yy_LocMarker(G)) { goto l1580; }  yyDo(G, yySet, -1, 0);  if (!yy_InStyleTags(G)) { goto l1580; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1580;
  l1581:;	
  {  int yypos1582= G->pos, yythunkpos1582= G->thunkpos;  if (!yy_BlankLine(G)) { goto l1582; }  goto l1581;
  l1582:;	  G->pos= yypos1582; G->thunkpos= yythunkpos1582;
  }  yyDo(G, yy_1_StyleBlock, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "StyleBlock", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1580:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "StyleBlock", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HtmlBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "HtmlBlock"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1583;  if (!yy_LocMarker(G)) { goto l1583; }  yyDo(G, yySet, -1, 0);
  {  int yypos1584= G->pos, yythunkpos1584= G->thunkpos;  if (!yy_HtmlBlockInTags(G)) { goto l1585; }  goto l1584;
  l1585:;	  G->pos= yypos1584; G->thunkpos= yythunkpos1584;  if (!yy_HtmlComment(G)) { goto l1586; }  goto l1584;
  l1586:;	  G->pos= yypos1584; G->thunkpos= yythunkpos1584;  if (!yy_HtmlBlockSelfClosing(G)) { goto l1583; }
  }
  l1584:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1583;  if (!yy_BlankLine(G)) { goto l1583; }
  l1587:;	
  {  int yypos1588= G->pos, yythunkpos1588= G->thunkpos;  if (!yy_BlankLine(G)) { goto l1588; }  goto l1587;
  l1588:;	  G->pos= yypos1588; G->thunkpos= yythunkpos1588;
  }  yyDo(G, yy_1_HtmlBlock, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "HtmlBlock", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1583:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HtmlBlock", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Table(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "Table"));  yyText(G, G->begin, G->end);  if (!( EXT(pmh_EXT_TABLE) )) goto l1589;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1589;  if (!yy_LocMarker(G)) { goto l1589; }  yyDo(G, yySet, -1, 0);  if (!yy_TableHeader(G)) { goto l1589; }  if (!yy_TableDelimiter(G)) { goto l1589; }
  l1590:;	
  {  int yypos1591= G->pos, yythunkpos1591= G->thunkpos;  if (!yy_TableLine(G)) { goto l1591; }  goto l1590;
  l1591:;	  G->pos= yypos1591; G->thunkpos= yythunkpos1591;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1589;  yyDo(G, yy_1_Table, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Table", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1589:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Table", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_BulletList(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "BulletList"));
  {  int yypos1593= G->pos, yythunkpos1593= G->thunkpos;  if (!yy_Bullet(G)) { goto l1592; }  G->pos= yypos1593; G->thunkpos= yythunkpos1593;
  }
  {  int yypos1594= G->pos, yythunkpos1594= G->thunkpos;  if (!yy_ListTight(G)) { goto l1595; }  goto l1594;
  l1595:;	  G->pos= yypos1594; G->thunkpos= yythunkpos1594;  if (!yy_ListLoose(G)) { goto l1592; }
  }
  l1594:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "BulletList", G->buf+G->pos));
  return 1;
  l1592:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "BulletList", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_OrderedList(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "OrderedList"));
  {  int yypos1597= G->pos, yythunkpos1597= G->thunkpos;  if (!yy_Enumerator(G)) { goto l1596; }  G->pos= yypos1597; G->thunkpos= yythunkpos1597;
  }
  {  int yypos1598= G->pos, yythunkpos1598= G->thunkpos;  if (!yy_ListTight(G)) { goto l1599; }  goto l1598;
  l1599:;	  G->pos= yypos1598; G->thunkpos= yythunkpos1598;  if (!yy_ListLoose(G)) { goto l1596; }
  }
  l1598:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "OrderedList", G->buf+G->pos));
  return 1;
  l1596:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "OrderedList", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Heading(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Heading"));
  {  int yypos1601= G->pos, yythunkpos1601= G->thunkpos;  if (!yy_SetextHeading(G)) { goto l1602; }  goto l1601;
  l1602:;	  G->pos= yypos1601; G->thunkpos= yythunkpos1601;  if (!yy_AtxHeading(G)) { goto l1600; }
  }
  l1601:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "Heading", G->buf+G->pos));
  return 1;
  l1600:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Heading", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_HorizontalRule(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "HorizontalRule"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1603;  if (!yy_NonindentSpace(G)) { goto l1603; }
  {  int yypos1604= G->pos, yythunkpos1604= G->thunkpos;  if (!yymatchChar(G, '*')) goto l1605;  if (!yy_Sp(G)) { goto l1605; }  if (!yymatchChar(G, '*')) goto l1605;  if (!yy_Sp(G)) { goto l1605; }  if (!yymatchChar(G, '*')) goto l1605;
  l1606:;	
  {  int yypos1607= G->pos, yythunkpos1607= G->thunkpos;  if (!yy_Sp(G)) { goto l1607; }  if (!yymatchChar(G, '*')) goto l1607;  goto l1606;
  l1607:;	  G->pos= yypos1607; G->thunkpos= yythunkpos1607;
  }  goto l1604;
  l1605:;	  G->pos= yypos1604; G->thunkpos= yythunkpos1604;  if (!yymatchChar(G, '-')) goto l1608;  if (!yy_Sp(G)) { goto l1608; }  if (!yymatchChar(G, '-')) goto l1608;  if (!yy_Sp(G)) { goto l1608; }  if (!yymatchChar(G, '-')) goto l1608;
  l1609:;	
  {  int yypos1610= G->pos, yythunkpos1610= G->thunkpos;  if (!yy_Sp(G)) { goto l1610; }  if (!yymatchChar(G, '-')) goto l1610;  goto l1609;
  l1610:;	  G->pos= yypos1610; G->thunkpos= yythunkpos1610;
  }  goto l1604;
  l1608:;	  G->pos= yypos1604; G->thunkpos= yythunkpos1604;  if (!yymatchChar(G, '_')) goto l1603;  if (!yy_Sp(G)) { goto l1603; }  if (!yymatchChar(G, '_')) goto l1603;  if (!yy_Sp(G)) { goto l1603; }  if (!yymatchChar(G, '_')) goto l1603;
  l1611:;	
  {  int yypos1612= G->pos, yythunkpos1612= G->thunkpos;  if (!yy_Sp(G)) { goto l1612; }  if (!yymatchChar(G, '_')) goto l1612;  goto l1611;
  l1612:;	  G->pos= yypos1612; G->thunkpos= yythunkpos1612;
  }
  }
  l1604:;	  if (!yy_Sp(G)) { goto l1603; }  if (!yy_Newline(G)) { goto l1603; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1603;  yyDo(G, yy_1_HorizontalRule, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "HorizontalRule", G->buf+G->pos));
  return 1;
  l1603:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "HorizontalRule", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Reference(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 3, 0);
  yyprintf((stderr, "%s\n", "Reference"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1613;  if (!yy_LocMarker(G)) { goto l1613; }  yyDo(G, yySet, -3, 0);  if (!yy_NonindentSpace(G)) { goto l1613; }
  {  int yypos1614= G->pos, yythunkpos1614= G->thunkpos;  if (!yymatchString(G, "[]")) goto l1614;  goto l1613;
  l1614:;	  G->pos= yypos1614; G->thunkpos= yythunkpos1614;
  }  if (!yy_Label(G)) { goto l1613; }  yyDo(G, yySet, -2, 0);  if (!yymatchChar(G, ':')) goto l1613;  if (!yy_Spnl(G)) { goto l1613; }  if (!yy_RefSrc(G)) { goto l1613; }  yyDo(G, yySet, -1, 0);  if (!yy_RefTitle(G)) { goto l1613; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1613;  if (!yy_BlankLine(G)) { goto l1613; }
  l1615:;	
  {  int yypos1616= G->pos, yythunkpos1616= G->thunkpos;  if (!yy_BlankLine(G)) { goto l1616; }  goto l1615;
  l1616:;	  G->pos= yypos1616; G->thunkpos= yythunkpos1616;
  }  yyDo(G, yy_1_Reference, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Reference", G->buf+G->pos));  yyDo(G, yyPop, 3, 0);
  return 1;
  l1613:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Reference", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Note(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "Note"));  yyText(G, G->begin, G->end);  if (!( EXT(pmh_EXT_NOTES) )) goto l1617;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1617;  if (!yy_LocMarker(G)) { goto l1617; }  yyDo(G, yySet, -1, 0);  if (!yy_NonindentSpace(G)) { goto l1617; }  if (!yy_RawNoteReference(G)) { goto l1617; }  if (!yymatchChar(G, ':')) goto l1617;  if (!yy_Sp(G)) { goto l1617; }  if (!yy_RawNoteBlock(G)) { goto l1617; }
  l1618:;	
  {  int yypos1619= G->pos, yythunkpos1619= G->thunkpos;
  {  int yypos1620= G->pos, yythunkpos1620= G->thunkpos;  if (!yy_Indent(G)) { goto l1619; }  G->pos= yypos1620; G->thunkpos= yythunkpos1620;
  }  if (!yy_RawNoteBlock(G)) { goto l1619; }  goto l1618;
  l1619:;	  G->pos= yypos1619; G->thunkpos= yythunkpos1619;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1617;  yyDo(G, yy_1_Note, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Note", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1617:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Note", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_DisplayFormula(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "DisplayFormula"));  yyText(G, G->begin, G->end);  if (!( EXT(pmh_EXT_MATH) )) goto l1621;
  {  int yypos1622= G->pos, yythunkpos1622= G->thunkpos;  if (!yy_DisplayFormulaDollar(G)) { goto l1623; }  goto l1622;
  l1623:;	  G->pos= yypos1622; G->thunkpos= yythunkpos1622;  if (!yy_DisplayFormulaRaw(G)) { goto l1621; }
  }
  l1622:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "DisplayFormula", G->buf+G->pos));
  return 1;
  l1621:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "DisplayFormula", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_FencedCodeBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "FencedCodeBlock"));
  {  int yypos1625= G->pos, yythunkpos1625= G->thunkpos;  if (!yy_FencedCodeBlockTick(G)) { goto l1626; }  goto l1625;
  l1626:;	  G->pos= yypos1625; G->thunkpos= yythunkpos1625;  if (!yy_FencedCodeBlockTidle(G)) { goto l1624; }
  }
  l1625:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "FencedCodeBlock", G->buf+G->pos));
  return 1;
  l1624:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "FencedCodeBlock", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Verbatim(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "Verbatim"));  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1627;  if (!yy_LocMarker(G)) { goto l1627; }  yyDo(G, yySet, -1, 0);  if (!yy_VerbatimChunk(G)) { goto l1627; }
  l1628:;	
  {  int yypos1629= G->pos, yythunkpos1629= G->thunkpos;  if (!yy_VerbatimChunk(G)) { goto l1629; }  goto l1628;
  l1629:;	  G->pos= yypos1629; G->thunkpos= yythunkpos1629;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1627;  yyDo(G, yy_1_Verbatim, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "Verbatim", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1627:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Verbatim", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_BlockQuote(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "BlockQuote"));  if (!yy_BlockQuoteRaw(G)) { goto l1630; }  yyDo(G, yySet, -1, 0);  yyDo(G, yy_1_BlockQuote, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "BlockQuote", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1630:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "BlockQuote", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_BlankLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "BlankLine"));  if (!yy_Sp(G)) { goto l1631; }  if (!yy_Newline(G)) { goto l1631; }
  yyprintf((stderr, "  ok   %s @ %s\n", "BlankLine", G->buf+G->pos));
  return 1;
  l1631:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "BlankLine", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_FrontMatterEndMark(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "FrontMatterEndMark"));
  {  int yypos1633= G->pos, yythunkpos1633= G->thunkpos;  if (!yymatchString(G, "---")) goto l1634;  goto l1633;
  l1634:;	  G->pos= yypos1633; G->thunkpos= yythunkpos1633;  if (!yymatchString(G, "...")) goto l1632;
  }
  l1633:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "FrontMatterEndMark", G->buf+G->pos));
  return 1;
  l1632:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "FrontMatterEndMark", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_FrontMatterBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "FrontMatterBlock"));
  {  int yypos1636= G->pos, yythunkpos1636= G->thunkpos;  if (!yy_FrontMatterEndMark(G)) { goto l1636; }  goto l1635;
  l1636:;	  G->pos= yypos1636; G->thunkpos= yythunkpos1636;
  }
  l1637:;	
  {  int yypos1638= G->pos, yythunkpos1638= G->thunkpos;
  {  int yypos1639= G->pos, yythunkpos1639= G->thunkpos;  if (!yy_Newline(G)) { goto l1639; }  goto l1638;
  l1639:;	  G->pos= yypos1639; G->thunkpos= yythunkpos1639;
  }  if (!yymatchDot(G)) goto l1638;  goto l1637;
  l1638:;	  G->pos= yypos1638; G->thunkpos= yythunkpos1638;
  }  if (!yy_Newline(G)) { goto l1635; }
  yyprintf((stderr, "  ok   %s @ %s\n", "FrontMatterBlock", G->buf+G->pos));
  return 1;
  l1635:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "FrontMatterBlock", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Newline(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Newline"));
  {  int yypos1641= G->pos, yythunkpos1641= G->thunkpos;  if (!yymatchChar(G, '\n')) goto l1642;  goto l1641;
  l1642:;	  G->pos= yypos1641; G->thunkpos= yythunkpos1641;  if (!yymatchChar(G, '\r')) goto l1640;
  {  int yypos1643= G->pos, yythunkpos1643= G->thunkpos;  if (!yymatchChar(G, '\n')) goto l1643;  goto l1644;
  l1643:;	  G->pos= yypos1643; G->thunkpos= yythunkpos1643;
  }
  l1644:;	
  }
  l1641:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "Newline", G->buf+G->pos));
  return 1;
  l1640:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Newline", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_LocMarker(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "LocMarker"));
  {  int yypos1646= G->pos, yythunkpos1646= G->thunkpos;  if (!yymatchDot(G)) goto l1645;  G->pos= yypos1646; G->thunkpos= yythunkpos1646;
  }  yyDo(G, yy_1_LocMarker, G->begin, G->end);
  yyprintf((stderr, "  ok   %s @ %s\n", "LocMarker", G->buf+G->pos));
  return 1;
  l1645:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "LocMarker", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Block(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Block"));
  l1648:;	
  {  int yypos1649= G->pos, yythunkpos1649= G->thunkpos;  if (!yy_BlankLine(G)) { goto l1649; }  goto l1648;
  l1649:;	  G->pos= yypos1649; G->thunkpos= yythunkpos1649;
  }
  {  int yypos1650= G->pos, yythunkpos1650= G->thunkpos;  if (!yy_BlockQuote(G)) { goto l1651; }  goto l1650;
  l1651:;	  G->pos= yypos1650; G->thunkpos= yythunkpos1650;  if (!yy_Verbatim(G)) { goto l1652; }  goto l1650;
  l1652:;	  G->pos= yypos1650; G->thunkpos= yythunkpos1650;  if (!yy_FencedCodeBlock(G)) { goto l1653; }  goto l1650;
  l1653:;	  G->pos= yypos1650; G->thunkpos= yythunkpos1650;  if (!yy_DisplayFormula(G)) { goto l1654; }  goto l1650;
  l1654:;	  G->pos= yypos1650; G->thunkpos= yythunkpos1650;  if (!yy_Note(G)) { goto l1655; }  goto l1650;
  l1655:;	  G->pos= yypos1650; G->thunkpos= yythunkpos1650;  if (!yy_Reference(G)) { goto l1656; }  goto l1650;
  l1656:;	  G->pos= yypos1650; G->thunkpos= yythunkpos1650;  if (!yy_HorizontalRule(G)) { goto l1657; }  goto l1650;
  l1657:;	  G->pos= yypos1650; G->thunkpos= yythunkpos1650;  if (!yy_Heading(G)) { goto l1658; }  goto l1650;
  l1658:;	  G->pos= yypos1650; G->thunkpos= yythunkpos1650;  if (!yy_OrderedList(G)) { goto l1659; }  goto l1650;
  l1659:;	  G->pos= yypos1650; G->thunkpos= yythunkpos1650;  if (!yy_BulletList(G)) { goto l1660; }  goto l1650;
  l1660:;	  G->pos= yypos1650; G->thunkpos= yythunkpos1650;  if (!yy_Table(G)) { goto l1661; }  goto l1650;
  l1661:;	  G->pos= yypos1650; G->thunkpos= yythunkpos1650;  if (!yy_HtmlBlock(G)) { goto l1662; }  goto l1650;
  l1662:;	  G->pos= yypos1650; G->thunkpos= yythunkpos1650;  if (!yy_StyleBlock(G)) { goto l1663; }  goto l1650;
  l1663:;	  G->pos= yypos1650; G->thunkpos= yythunkpos1650;  if (!yy_Para(G)) { goto l1664; }  goto l1650;
  l1664:;	  G->pos= yypos1650; G->thunkpos= yythunkpos1650;  if (!yy_Plain(G)) { goto l1647; }
  }
  l1650:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "Block", G->buf+G->pos));
  return 1;
  l1647:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Block", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_FrontMatter(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0);
  yyprintf((stderr, "%s\n", "FrontMatter"));  if (!yy_LocMarker(G)) { goto l1665; }  yyDo(G, yySet, -1, 0);
  {  int yypos1666= G->pos, yythunkpos1666= G->thunkpos;  yyText(G, G->begin, G->end);  if (!( EXT(pmh_EXT_FRONTMATTER) )) goto l1666;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1666;  if (!yymatchString(G, "---")) goto l1666;  if (!yy_Newline(G)) { goto l1666; }
  l1668:;	
  {  int yypos1669= G->pos, yythunkpos1669= G->thunkpos;  if (!yy_FrontMatterBlock(G)) { goto l1669; }  goto l1668;
  l1669:;	  G->pos= yypos1669; G->thunkpos= yythunkpos1669;
  }  if (!yy_FrontMatterEndMark(G)) { goto l1666; }  if (!yy_Newline(G)) { goto l1666; }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1666;  yyDo(G, yy_1_FrontMatter, G->begin, G->end);  goto l1667;
  l1666:;	  G->pos= yypos1666; G->thunkpos= yythunkpos1666;
  }
  l1667:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "FrontMatter", G->buf+G->pos));  yyDo(G, yyPop, 1, 0);
  return 1;
  l1665:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "FrontMatter", G->buf+G->pos));
  return 0;
}
YY_RULE(int) yy_Doc(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;
  yyprintf((stderr, "%s\n", "Doc"));  if (!yy_FrontMatter(G)) { goto l1670; }
  l1671:;	
  {  int yypos1672= G->pos, yythunkpos1672= G->thunkpos;  if (!yy_Block(G)) { goto l1672; }  goto l1671;
  l1672:;	  G->pos= yypos1672; G->thunkpos= yythunkpos1672;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "Doc", G->buf+G->pos));
  return 1;
  l1670:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "Doc", G->buf+G->pos));
  return 0;
}

#ifndef YY_PART

typedef int (*yyrule)(GREG *G);

YY_PARSE(int) YY_NAME(parse_from)(GREG *G, yyrule yystart)
{
  int yyok;
  if (!G->buflen)
    {
      G->buflen= YY_BUFFER_START_SIZE;
      G->buf= (char *)YY_ALLOC(G->buflen, G->data);
      G->textlen= YY_BUFFER_START_SIZE;
      G->text= (char *)YY_ALLOC(G->textlen, G->data);
      G->thunkslen= YY_STACK_SIZE;
      G->thunks= (yythunk *)YY_ALLOC(sizeof(yythunk) * G->thunkslen, G->data);
      G->valslen= YY_STACK_SIZE;
      G->vals= (YYSTYPE*)YY_ALLOC(sizeof(YYSTYPE) * G->valslen, G->data);
      G->begin= G->end= G->pos= G->limit= G->thunkpos= 0;
    }
  G->pos = 0;
  G->begin= G->end= G->pos;
  G->thunkpos= 0;
  G->val= G->vals;
  yyok= yystart(G);
  if (yyok) yyDone(G);
  yyCommit(G);
  return yyok;
  (void)yyrefill(NULL);
  (void)yymatchDot(NULL);
  (void)yymatchChar(NULL, 0);
  (void)yymatchString(NULL, NULL);
  (void)yymatchClass(NULL, NULL);
  (void)yyDo(NULL, NULL, 0, 0);
  (void)yyText(NULL, 0, 0);
  (void)yyDone(NULL);
  (void)yyCommit(NULL);
  (void)yyAccept(NULL, 0);
  (void)yyPush(NULL, NULL, 0, NULL, NULL);
  (void)yyPop(NULL, NULL, 0, NULL, NULL);
  (void)yySet(NULL, NULL, 0, NULL, NULL);
}

YY_PARSE(int) YY_NAME(parse)(GREG *G)
{
  return YY_NAME(parse_from)(G, yy_Doc);
}

YY_PARSE(GREG *) YY_NAME(parse_new)(YY_XTYPE data)
{
  GREG *G = (GREG *)YY_CALLOC(1, sizeof(GREG), G->data);
  G->data = data;
  return G;
}

YY_PARSE(void) YY_NAME(parse_free)(GREG *G)
{
  YY_FREE(G->buf);
  YY_FREE(G->text);
  YY_FREE(G->thunks);
  YY_FREE(G->vals);
  YY_FREE(G);
}

#endif




/* PEG Markdown Highlight
 * Copyright 2011-2016 Ali Rantakari -- http://hasseg.org
 * Licensed under the GPL2+ and MIT licenses (see LICENSE for more info).
 * 
 * pmh_parser_foot.c
 * 
 * Code to be appended to the end of the parser code generated from the
 * PEG grammar.
 */


static void _parse(parser_data *p_data, yyrule start_rule)
{
    GREG *g = YY_NAME(parse_new)(p_data);
    if (start_rule == NULL)
        YY_NAME(parse)(g);
    else
        YY_NAME(parse_from)(g, start_rule);
    YY_NAME(parse_free)(g);
    
    pmh_PRINTF("\n\n");
}

static void parse_markdown(parser_data *p_data)
{
    pmh_PRINTF("\nPARSING DOCUMENT: ");
    
    _parse(p_data, NULL);
}

static void parse_references(parser_data *p_data)
{
    pmh_PRINTF("\nPARSING REFERENCES: ");
    
    p_data->parsing_only_references = true;
    _parse(p_data, yy_References);
    p_data->parsing_only_references = false;
    
    p_data->references = p_data->head_elems[pmh_REFERENCE];
    p_data->head_elems[pmh_REFERENCE] = NULL;
}

