import {ppath, xfs} from '@yarnpkg/fslib';

describe(`Features`, () => {
  describe(`Berry Lockfile`, () => {
    test(`it should correctly import the lockfile from a Berry install`, makeTemporaryEnv({
      dependencies: {[`no-deps`]: `^1.0.0`},
    }, async ({path, run, source}) => {
      await xfs.writeFilePromise(ppath.join(path, `yarn.lock`), [
        `# This file is generated by running "yarn install" inside your project.\n`,
        `# Manual changes might be lost - proceed with caution!\n`,
        `\n`,
        `__metadata:\n`,
        `  version: 8\n`,
        `  cacheKey: 0c0\n`,
        `\n`,
        `"no-deps@npm:^1.0.0":\n`,
        `  version: 1.0.0\n`,
        `  resolution: "no-deps@npm:1.0.0"\n`,
        `  checksum: 0c0/af041f19ffad13c40b220f0319b95436c0e886ddb630988d78e35eb3b4e3d64131f1e7e9efa5818a7f3307718e322220bda7676fcc202f1841e587aa079b7205\n`,
        `  languageName: node\n`,
        `  linkType: hard\n`,
      ].join(``));

      await run(`install`);

      await expect(source(`require('no-deps')`)).resolves.toMatchObject({
        name: `no-deps`,
        version: `1.0.0`,
      });
    }));
  });
});
