#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-HeTEhICrwINHKsGOfVjnsv
key:                  dhall-1.42.3-HeTEhICrwINHKsGOfVjnsv
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  c1f2d0d05213799a3f8ec931ae84ab11
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-HeTEhICrwINHKsGOfVjnsv
depends:
    Diff-0.5-2tX1FyxWy6p7M2fvM0xekx
    aeson-2.1.2.1-3HLieqpkeG06w6MDAYdLLk
    aeson-pretty-0.8.10-7oLs7OTWYk9GnMVCodyIc4
    ansi-terminal-1.0.2-HSq0v3QUl8T11Wgx1QLnTe
    atomic-write-0.2.1.1-6x7hUjEFijv9Phbax449Fq base-4.17.2.1
    base16-bytestring-1.0.2.0-1Uz6oHjhPf9KewF5fWee2u
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-4psXWcL2Or6Ff92NkDcfKY
    cborg-0.2.10.0-5BRUlyfzoFs9IjP1vVWdDh
    cborg-json-0.2.6.0-3zTGmqFZRSHIle3MCJTcwl containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-9lKR7BNsiyq7t2yDe4jjeV
    data-fix-0.3.4-2QKrXqW8Z1hJYHuxPNlbzr deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-1H3QHzumjE7EgPwL47HtVu exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-LkaRI3G7pR6ASmgen08p5d
    hashable-1.4.7.0-KrA5CwhmktQ6Qu5a4JCqq7 haskeline-0.8.2
    http-client-0.7.19-Iyp8kyAVyHs5ic3dfNFLTs
    http-client-tls-0.3.6.4-Fuw6mDzbeZhIZH9nOSD8AM
    http-types-0.12.4-3Rkn4NOOYhzvBVdRap5Ii
    indexed-traversable-0.1.4-KvS9wRlCKDWFRGYTEgz6lC
    megaparsec-9.7.0-A5HZG6HxQB028mYZSYROei
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-DVBcu05aYxxCjTvpzOd17v
    optparse-applicative-0.18.1.0-t4C6chS8YH5x9x9VuRkT0
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-AruA0KJE2LQHQP2zlD1Eci
    pretty-simple-4.1.3.0-IHQqimZJecBB0lXT72fSyX
    prettyprinter-1.7.1-IxfK3MMc5TsGC7SkX421m7
    prettyprinter-ansi-terminal-1.1.3-AVYpYA7i4fdJ805glBa68
    repline-0.4.2.0-KVntTSpWnVfIRYxV1mly8a
    scientific-0.3.8.0-6QoqQGQc0yZ1FsULZsdy9C
    serialise-0.2.6.1-EctFCD5KUkFBHlRXLD4kc7 template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-4qP8BZPHRfwCwgJYKSWK9Q
    text-short-0.1.6-KhjI1V9MdzIFcMKi9m67eJ
    th-lift-instances-0.1.20-HSRjlGXAGtLJZoUMZdls5z time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-4GSEG4F7IBa3tepmzc9c8r
    unordered-containers-0.2.20.1-JRJBW0Nl9iEJULI134IWXM
    vector-0.13.2.0-DhQEcquLn8PDmAHUsOvAGS

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

