/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.AccentedAtom;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharBox;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.CharSymbol;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.UnderOverAtom;
import org.scilab.forge.jlatexmath.VerticalBox;

public class ScriptsAtom
extends Atom {
    private static final SpaceAtom SCRIPT_SPACE = new SpaceAtom(3, 0.5f, 0.0f, 0.0f);
    private final Atom base;
    private final Atom subscript;
    private final Atom superscript;
    private int align = 0;

    public ScriptsAtom(Atom base, Atom sub, Atom sup) {
        this.base = base;
        this.subscript = sub;
        this.superscript = sup;
    }

    public ScriptsAtom(Atom base, Atom sub, Atom sup, boolean left) {
        this(base, sub, sup);
        if (!left) {
            this.align = 1;
        }
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        Box x;
        float shiftDown;
        float shiftUp;
        Box b = this.base == null ? new StrutBox(0.0f, 0.0f, 0.0f, 0.0f) : this.base.createBox(env);
        Box deltaSymbol = new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
        if (this.subscript == null && this.superscript == null) {
            return b;
        }
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        if (this.base.type_limits == 2 || this.base.type_limits == 0 && style == 0) {
            return new UnderOverAtom(new UnderOverAtom(this.base, this.subscript, 3, 0.3f, true, false), this.superscript, 3, 3.0f, true, true).createBox(env);
        }
        HorizontalBox hor = new HorizontalBox(b);
        int lastFontId = b.getLastFontId();
        if (lastFontId == -1) {
            lastFontId = tf.getMuFontId();
        }
        TeXEnvironment subStyle = env.subStyle();
        TeXEnvironment supStyle = env.supStyle();
        float delta = 0.0f;
        if (this.base instanceof AccentedAtom) {
            Box box = ((AccentedAtom)this.base).base.createBox(env.crampStyle());
            shiftUp = box.getHeight() - tf.getSupDrop(supStyle.getStyle());
            shiftDown = box.getDepth() + tf.getSubDrop(subStyle.getStyle());
        } else if (this.base instanceof SymbolAtom && this.base.type == 1) {
            Char c = tf.getChar(((SymbolAtom)this.base).getName(), style);
            if (style < 2 && tf.hasNextLarger(c)) {
                c = tf.getNextLarger(c, style);
            }
            CharBox x2 = new CharBox(c);
            x2.setShift(-(x2.getHeight() + x2.getDepth()) / 2.0f - env.getTeXFont().getAxisHeight(env.getStyle()));
            hor = new HorizontalBox(x2);
            delta = c.getItalic();
            deltaSymbol = new SpaceAtom(2).createBox(env);
            if (delta > 1.0E-7f && this.subscript == null) {
                hor.add(new StrutBox(delta, 0.0f, 0.0f, 0.0f));
            }
            shiftUp = hor.getHeight() - tf.getSupDrop(supStyle.getStyle());
            shiftDown = hor.getDepth() + tf.getSubDrop(subStyle.getStyle());
        } else if (this.base instanceof CharSymbol) {
            shiftDown = 0.0f;
            shiftUp = 0.0f;
            CharFont cf = ((CharSymbol)this.base).getCharFont(tf);
            if (!((CharSymbol)this.base).isMarkedAsTextSymbol() || !tf.hasSpace(cf.fontId)) {
                delta = tf.getChar(cf, style).getItalic();
            }
            if (delta > 1.0E-7f && this.subscript == null) {
                hor.add(new StrutBox(delta, 0.0f, 0.0f, 0.0f));
                delta = 0.0f;
            }
        } else {
            shiftUp = b.getHeight() - tf.getSupDrop(supStyle.getStyle());
            shiftDown = b.getDepth() + tf.getSubDrop(subStyle.getStyle());
        }
        if (this.superscript == null) {
            x = this.subscript.createBox(subStyle);
            x.setShift(Math.max(Math.max(shiftDown, tf.getSub1(style)), x.getHeight() - 4.0f * Math.abs(tf.getXHeight(style, lastFontId)) / 5.0f));
            hor.add(x);
            hor.add(deltaSymbol);
            return hor;
        }
        x = this.superscript.createBox(supStyle);
        float msiz = x.getWidth();
        if (this.subscript != null && this.align == 1) {
            msiz = Math.max(msiz, this.subscript.createBox(subStyle).getWidth());
        }
        HorizontalBox sup = new HorizontalBox(x, msiz, this.align);
        sup.add(SCRIPT_SPACE.createBox(env));
        float p = style == 0 ? tf.getSup1(style) : (env.crampStyle().getStyle() == style ? tf.getSup3(style) : tf.getSup2(style));
        shiftUp = Math.max(Math.max(shiftUp, p), x.getDepth() + Math.abs(tf.getXHeight(style, lastFontId)) / 4.0f);
        if (this.subscript == null) {
            sup.setShift(-shiftUp);
            hor.add(sup);
        } else {
            Box y = this.subscript.createBox(subStyle);
            HorizontalBox sub = new HorizontalBox(y, msiz, this.align);
            sub.add(SCRIPT_SPACE.createBox(env));
            shiftDown = Math.max(shiftDown, tf.getSub2(style));
            float drt = tf.getDefaultRuleThickness(style);
            float interSpace = shiftUp - x.getDepth() + shiftDown - y.getHeight();
            if (interSpace < 4.0f * drt) {
                shiftUp += 4.0f * drt - interSpace;
                float psi = 4.0f * Math.abs(tf.getXHeight(style, lastFontId)) / 5.0f - (shiftUp - x.getDepth());
                if (psi > 0.0f) {
                    shiftUp += psi;
                    shiftDown -= psi;
                }
            }
            VerticalBox vBox = new VerticalBox();
            sup.setShift(delta);
            vBox.add(sup);
            interSpace = shiftUp - x.getDepth() + shiftDown - y.getHeight();
            vBox.add(new StrutBox(0.0f, interSpace, 0.0f, 0.0f));
            vBox.add(sub);
            vBox.setHeight(shiftUp + x.getHeight());
            vBox.setDepth(shiftDown + y.getDepth());
            hor.add(vBox);
        }
        hor.add(deltaSymbol);
        return hor;
    }

    @Override
    public int getLeftType() {
        return this.base.getLeftType();
    }

    @Override
    public int getRightType() {
        return this.base.getRightType();
    }
}

