#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 cipher-aes
version:              0.2.11
visibility:           public
id:                   cipher-aes-0.2.11-2PlTl2Aj1Aj7gY786y03yN
key:                  cipher-aes-0.2.11-2PlTl2Aj1Aj7gY786y03yN
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           Vincent Hanquez <vincent@snarc.org>
author:               Vincent Hanquez <vincent@snarc.org>
homepage:             https://github.com/vincenthz/hs-cipher-aes
synopsis:
    Fast AES cipher implementation with advanced mode of operations

description:
    Fast AES cipher implementation with advanced mode of operations.

    The modes of operations available are ECB (Electronic code book),
    CBC (Cipher block chaining), CTR (Counter), XTS (XEX with ciphertext stealing),
    GCM (Galois Counter Mode).

    The AES implementation uses AES-NI when available (on x86 and x86-64 architecture),
    but fallback gracefully to a software C implementation.

    The software implementation uses S-Boxes, which might suffer for cache timing issues.
    However do notes that most other known software implementations, including very popular
    one (openssl, gnutls) also uses similar implementation. If it matters for your
    case, you should make sure you have AES-NI available, or you'\''ll need to use a different
    implementation.

category:             Cryptography
abi:                  135f453307b2e5afc2cd7f4302c12434
exposed:              True
exposed-modules:      Crypto.Cipher.AES
import-dirs:          /usr/lib/ghc-9.4.8/site-local/cipher-aes-0.2.11
library-dirs:         /usr/lib/ghc-9.4.8/site-local/cipher-aes-0.2.11
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/cipher-aes-0.2.11
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-cipher-aes
hs-libraries:         HScipher-aes-0.2.11-2PlTl2Aj1Aj7gY786y03yN
depends:
    base-4.17.2.1 byteable-0.1.1-BiXMgwkGoIQH63GBEhxKBY
    bytestring-0.11.5.3
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    securemem-0.1.10-EOlWoZVaToP2K6s5wFpHsU

haddock-interfaces:   /usr/share/doc/haskell-cipher-aes/html/cipher-aes.haddock
haddock-html:         /usr/share/doc/haskell-cipher-aes/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

