#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 language-c
version:              0.10.0
visibility:           public
id:                   language-c-0.10.0-6d0F2bkBjXrAo0mkIjLwwu
key:                  language-c-0.10.0-6d0F2bkBjXrAo0mkIjLwwu
license:              BSD-3-Clause
copyright:            LICENSE
maintainer:           language.c@monoid.al
author:               AUTHORS
homepage:             https://visq.github.io/language-c/
synopsis:             Analysis and generation of C code
description:
    Language C is a Haskell library for the analysis and generation of C code.
    It features a complete, well tested parser and pretty printer for all of C99 and a large
    set of C11 and clang/GNU extensions.

category:             Language
abi:                  23c3821f4f3a42726077e477f273f87d
exposed:              True
exposed-modules:
    Language.C Language.C.Analysis Language.C.Analysis.AstAnalysis
    Language.C.Analysis.Builtins Language.C.Analysis.ConstEval
    Language.C.Analysis.Debug Language.C.Analysis.DeclAnalysis
    Language.C.Analysis.DefTable Language.C.Analysis.Export
    Language.C.Analysis.MachineDescs Language.C.Analysis.NameSpaceMap
    Language.C.Analysis.SemError Language.C.Analysis.SemRep
    Language.C.Analysis.TravMonad Language.C.Analysis.TypeCheck
    Language.C.Analysis.TypeConversions Language.C.Analysis.TypeUtils
    Language.C.Data Language.C.Data.Error Language.C.Data.Ident
    Language.C.Data.InputStream Language.C.Data.Name
    Language.C.Data.Node Language.C.Data.Position Language.C.Parser
    Language.C.Pretty Language.C.Syntax Language.C.Syntax.AST
    Language.C.Syntax.Constants Language.C.Syntax.Ops
    Language.C.Syntax.Utils Language.C.System.GCC
    Language.C.System.Preprocess

hidden-modules:
    Language.C.Data.RList Language.C.Parser.Builtin
    Language.C.Parser.Lexer Language.C.Parser.ParserMonad
    Language.C.Parser.Tokens Language.C.Parser.Parser

import-dirs:          /usr/lib/ghc-9.4.8/site-local/language-c-0.10.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/language-c-0.10.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/language-c-0.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-language-c
hs-libraries:         HSlanguage-c-0.10.0-6d0F2bkBjXrAo0mkIjLwwu
depends:
    array-0.5.4.0 base-4.17.2.1 bytestring-0.11.5.3 containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2 mtl-2.2.2
    pretty-1.1.3.6 process-1.6.18.0

haddock-interfaces:   /usr/share/doc/haskell-language-c/html/language-c.haddock
haddock-html:         /usr/share/doc/haskell-language-c/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

