/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OraclePKIX509CrlHelper;
import oracle.security.pki.OraclePKIX509CrlStore;
import oracle.security.pki.TransitionMode;
import oracle.security.pki.internal.cert.CRL;
import oracle.security.pki.internal.cert.X500Name;
import oracle.security.pki.internal.cert.X509;

public class OraclePKIX509CrlFileStore
implements OraclePKIX509CrlStore {
    File a;

    public OraclePKIX509CrlFileStore(File file) throws IOException {
        if (!file.isDirectory() || !file.canRead()) {
            throw new IOException("Can't open crl location");
        }
        this.a = file;
    }

    @Override
    public CRL getCrlFor(X509Certificate x509Certificate) throws IOException, CertificateException {
        OraclePKIDebug.a("OraclePKIX509CrlFileStore: entry");
        X509 x509 = null;
        x509 = x509Certificate instanceof OraclePKIX509CertImpl ? ((OraclePKIX509CertImpl)x509Certificate).getX509() : new X509(x509Certificate.getEncoded());
        OraclePKIDebug.a("OraclePKIX509CrlFileStore: looking for CRL for " + x509.n());
        String string = OraclePKIX509CrlFileStore.hashName(x509.n());
        OraclePKIDebug.a("OraclePKIX509CrlFileStore: looking for file " + string);
        File file = new File(this.a, string);
        try {
            return new CRL(file);
        }
        catch (IOException iOException) {
            return OraclePKIX509CrlHelper.readB64CRLFrom(new FileReader(file));
        }
    }

    public static String hashName(X500Name x500Name) {
        MessageDigest messageDigest;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            x500Name.output(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            return "";
        }
        String string = TransitionMode.isFIPS140ModeEnabled() ? "SHA-256" : "MD5";
        try {
            messageDigest = JCEUtil.getMessageDigestInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            OraclePKIDebug.a("OraclePKIX509CrlFileStore: NoSuchAlgorithmException - " + string);
            return "";
        }
        messageDigest.update(byteArrayOutputStream.toByteArray());
        byte[] byArray = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer(9);
        for (int i = 3; i >= 0; --i) {
            if (byArray[i] < 0) {
                stringBuffer.append(Integer.toHexString(256 + byArray[i]));
                continue;
            }
            if (byArray[i] < 16) {
                stringBuffer.append("0");
                stringBuffer.append(Integer.toHexString(byArray[i]));
                continue;
            }
            stringBuffer.append(Integer.toHexString(byArray[i]));
        }
        stringBuffer.append(".rN");
        return stringBuffer.toString();
    }
}

