-- Copyright © 2008-2025 Pioneer Developers. See AUTHORS.txt for details
-- Licensed under the terms of the GPL v3. See licenses/GPL-3.txt

local utils = require 'utils'
local CultureName = require './common'

local male = {
	"Achaeus",
	"Adeimantus",
	"Agapetus",
	"Agasias",
	"Agesipolis",
	"Agis",
	"Akis",
	"Alekos",
	"Alexandros",
	"Alexis",
	"Alexius",
	"Anastasius",
	"Andreas",
	"Angelos",
	"Antonios",
	"Antonis",
	"Apostolos",
	"Aris",
	"Aristophanes",
	"Athan",
	"Athanasius",
	"Charalambos",
	"Charis",
	"Christodoulos",
	"Christos",
	"Chrysanthos",
	"Costas",
	"Damaskinos",
	"Damianos",
	"Damon",
	"Demetres",
	"Demetrius",
	"Dimitris",
	"Dimos",
	"Dorotheus",
	"Elias",
	"Emmanouil",
	"Eustathius",
	"Evangelos",
	"Georgios",
	"Giorgos",
	"Grigorios",
	"Heraclitus",
	"Hermogenes",
	"Homeros",
	"Iakovos",
	"Ilias",
	"Ioannis",
	"Isidoros",
	"Joseph",
	"Julius",
	"Karolos",
	"Kokos",
	"Konstantinos",
	"Kostis",
	"Lambros",
	"Leonidas",
	"Loukas",
	"Lycurgus",
	"Manolis",
	"Marcos",
	"Marios",
	"Matthaios",
	"Miltiades",
	"Nathaniel",
	"Nectarios",
	"Neoklis",
	"Nestor",
	"Nicephorus",
	"Nicetas",
	"Nikolaos",
	"Nikos",
	"Orestes",
	"Panagiotis",
	"Pantelis",
	"Paraskevas",
	"Paris",
	"Pavlos",
	"Perikles",
	"Petros",
	"Phaedon",
	"Plutarchos",
	"Polychronis",
	"Sakis",
	"Simon",
	"Sophocles",
	"Sotirios",
	"Spiridon",
	"Spiros",
	"Spyridon",
	"Stathis",
	"Stavros",
	"Stelios",
	"Stephanos",
	"Tassos",
	"Thaddeus",
	"Thanos",
	"Themistocles",
	"Theodoros",
	"Theofanis",
	"Theophilus",
	"Therapontas",
	"Timos",
	"Timotheus",
	"Ulysseos",
	"Vangelis",
	"Velissarios",
	"Vassilios",
	"Vissarion",
	"Yannis",
	"Zenobios"
}

local female = {
	"Agariste",
	"Agatha",
	"Agne",
	"Alessia",
	"Alexandra",
	"Alexia",
	"Alina",
	"Amalia",
	"Amaryllis",
	"Anastasia",
	"Angeliki",
	"Angelina",
	"Anna",
	"Athena",
	"Barbara",
	"Callisto",
	"Carolina",
	"Cassandra",
	"Chara",
	"Charis",
	"Chloe",
	"Christa",
	"Christina",
	"Christine",
	"Crino",
	"Cynthia",
	"Daphne",
	"Deianira",
	"Demetria",
	"Despina",
	"Dina",
	"Dora",
	"Dorothea",
	"Eftychia",
	"Ekaterini",
	"Elektra",
	"Elena",
	"Eleni",
	"Eliana",
	"Elina",
	"Elisa",
	"Eudoxia",
	"Eugenia",
	"Euthemia",
	"Eva",
	"Evangelia",
	"Evi",
	"Fotini",
	"Georgia",
	"Helen",
	"Helena",
	"Helene",
	"Hermione",
	"Hero",
	"Hilda",
	"Irene",
	"Irina",
	"Iris",
	"Joanna",
	"Julia",
	"Kassandra",
	"Katerina",
	"Konstantina",
	"Lena",
	"Lia",
	"Lidia",
	"Lydia",
	"Margareta",
	"Maria",
	"Marianna",
	"Marina",
	"Medea",
	"Melania",
	"Melina",
	"Markella",
	"Melissa",
	"Nadia",
	"Nana",
	"Natalia",
	"Nika",
	"Nike",
	"Nikoleta",
	"Nikolina",
	"Olga",
	"Olivia",
	"Olympias",
	"Panorea",
	"Penelope",
	"Philippa",
	"Phyllis",
	"Polina",
	"Sandra",
	"Sophia",
	"Stamatia",
	"Stefania",
	"Stella",
	"Tatiana",
	"Theodora",
	"Valentina",
	"Valeria",
	"Vasileia",
	"Vassiliki",
	"Vera",
	"Veronice",
	"Violeta",
	"Xenia",
	"Yianna",
	"Zenaida",
	"Zoe"
}

local female_surname = {
	"Afroudaki",
	"Agathangelou",
	"Aggeloniti",
	"Alexaki",
	"Alexandri",
	"Alexandrou",
	"Alexiadi",
	"Alexiou",
	"Alexoudi",
	"Anagnostaki",
	"Anagnostou",
	"Anastasiadi",
	"Andreadi",
	"Andreou",
	"Androulaki",
	"Anesti",
	"Angelidi",
	"Angelidou",
	"Antonaki",
	"Antoniadi",
	"Antoniadou",
	"Antoniou",
	"Antonopoulou",
	"Apostolidi",
	"Apostolou",
	"Armaou",
	"Armeni",
	"Arseni",
	"Arvanitaki",
	"Athanasiadi",
	"Athanasiou",
	"Avramidi",
	"Axioti",
	"Bakirtzi",
	"Bakoyanni",
	"Belevoni",
	"Bernardaki",
	"Botsari",
	"Botsi",
	"Bountrogianni",
	"Calligari",
	"Canellaki",
	"Catsimatidi",
	"Chatzigeorgiou",
	"Christaki",
	"Christidou",
	"Christodoulou",
	"Christou",
	"Dalidaki",
	"Daskalaki",
	"Diamandi",
	"Dimitriadi",
	"Dimitriou",
	"Dousmani",
	"Doxiadi",
	"Dragoumi",
	"Fasoula",
	"Floraki",
	"Fotaki",
	"Fotiou",
	"Fourli",
	"Galani",
	"Galifianaki",
	"Gavriilidi",
	"Gazi",
	"Georgatou",
	"Georgiadi",
	"Georgiou",
	"Georgitsi",
	"Giakoumaki",
	"Goulandri",
	"Gounari",
	"Hatzi",
	"Hatzidaki",
	"Hatziioannou",
	"Hatzimichali",
	"Hrisoverghi",
	"Iakovou",
	"Ioannidi",
	"Ioannou",
	"Kaklamani",
	"Kanakari",
	"Karagouni",
	"Karakatsani",
	"Karaviti",
	"Katechi",
	"Katraki",
	"Kazazi",
	"Kefalogianni",
	"Kiriakidi",
	"Kokkinaki",
	"Kokkori",
	"Kokolaki",
	"Koletti",
	"Kolokotroni",
	"Kondyli",
	"Konstantinidi",
	"Konstantinou",
	"Kontogouri",
	"Kontoyianni",
	"Kordolaimi",
	"Kostaki",
	"Kouraki",
	"Koutsi",
	"Kresteniti",
	"Kriezi",
	"Kyriakaki",
	"Kyriakou",
	"Kyriazi",
	"Lagoudaki",
	"Lambraki",
	"Latsi",
	"Leivaditi",
	"Lemoni",
	"Leon",
	"Leventi",
	"Liourdi",
	"Logotheti",
	"Loizou",
	"Makri",
	"Makriyanni",
	"Manousaki",
	"Mantzari",
	"Margariti",
	"Mari",
	"Marinaki",
	"Markaki",
	"Matraxia",
	"Matsaki",
	"Matzouraki",
	"Mavridi",
	"Mavromati",
	"Miaouli",
	"Michailidi",
	"Michalopoulou",
	"Mitsotaki",
	"Mitzou",
	"Nafplioti",
	"Nerantzi",
	"Nevraki",
	"Nicolau",
	"Nikolaidi",
	"Nikolaou",
	"Nikoloudi",
	"Oikonomou",
	"Palli",
	"Panagi",
	"Panagiotidi",
	"Panayiotou",
	"Panousi",
	"Pantazi",
	"Papadaki",
	"Papadimitriou",
	"Papageorgiou",
	"Papagianni",
	"Papaioannou",
	"Papakonstantinou",
	"Papamichael",
	"Papanastasiou",
	"Papandreou",
	"Papanikolaou",
	"Papantoniou",
	"Papapostolou",
	"Papathanasiou",
	"Papayianni",
	"Papazoglou",
	"Paschalidi",
	"Pavlidi",
	"Pavlou",
	"Petridi",
	"Petrou",
	"Philippidi",
	"Prokopiou",
	"Psalti",
	"Ralli",
	"Rodocanachi",
	"Roubani",
	"Saitta",
	"Sakellaridi",
	"Sakkari",
	"Sifaki",
	"Siopi",
	"Sisini",
	"Skourleti",
	"Smaragdi",
	"Spanoudaki",
	"Spheeri",
	"Stamati",
	"Stathaki",
	"Stathi",
	"Stavridi",
	"Stavrou",
	"Straton",
	"Taskasaplidi",
	"Terzi",
	"Theodoraki",
	"Theodoridi",
	"Theodorou",
	"Toli",
	"Triantafyllou",
	"Tsakalidi",
	"Tsakiri",
	"Tsaldari",
	"Tsami",
	"Valaoriti",
	"Valavani",
	"Valvi",
	"Vardinogianni",
	"Vardoulaki",
	"Vasilakaki",
	"Vasileiou",
	"Vasiliadi",
	"Vassilaki",
	"Vlahaki",
	"Volikaki",
	"Votsi",
	"Vougiouklaki",
	"Voulgari",
	"Xenaki",
	"Xydaki",
	"Xylouri",
	"Yannakaki",
	"Yfanti",
	"Zaimi",
	"Zintiridi",
	"Zochoni",
	"Zografaki",
}

local male_surname = {
	"Achilleos",
	"Afroudakis",
	"Aggelonitis",
	"Alafouzos",
	"Alexakis",
	"Alexandris",
	"Alexiadis",
	"Alexopoulos",
	"Alexoudis",
	"Anagnostakis",
	"Anagnostopoulos",
	"Anastasiadis",
	"Anastasopoulos",
	"Anastopoulos",
	"Andreadis",
	"Andrianopoulos",
	"Andritsos",
	"Androulakis",
	"Anestis",
	"Angelidis",
	"Angelopoulos",
	"Antonakis",
	"Antoniades",
	"Antoniadis",
	"Antonopoulos",
	"Apostolidis",
	"Argyropoulos",
	"Argyros",
	"Armenis",
	"Arsenis",
	"Arvanitakis",
	"Athanasiadis",
	"Athanasoulas",
	"Avramidis",
	"Axiotis",
	"Bakirtzis",
	"Bakoyannis",
	"Barlos",
	"Belevonis",
	"Bernardakis",
	"Botsaris",
	"Botsis",
	"Bountrogiannis",
	"Calathes",
	"Calligaris",
	"Canellakis",
	"Carras",
	"Cassavetes",
	"Catsimatidis",
	"Chalkias",
	"Cholevas",
	"Chondroyannos",
	"Christakis",
	"Christodoulopoulos",
	"Christopoulos",
	"Christos",
	"Costas",
	"Coumantaros",
	"Dalidakis",
	"Daskalakis",
	"Diamandis",
	"Diamantopoulos",
	"Dimakos",
	"Dimas",
	"Dimitriadis",
	"Dimopoulos",
	"Dousmanis",
	"Doxapatres",
	"Doxiadis",
	"Dragoumis",
	"Economides",
	"Evangelatos",
	"Fasoulas",
	"Florakis",
	"Floros",
	"Fotakis",
	"Fotilas",
	"Fotopoulos",
	"Fourlis",
	"Frangos",
	"Galanis",
	"Galifianakis",
	"Gavalas",
	"Gavras",
	"Gavriilidis",
	"Gazis",
	"Georgiadis",
	"Georgitsis",
	"Gerontas",
	"Giakoumakis",
	"Giannakopoulos",
	"Giannopoulos",
	"Gikopoulos",
	"Glezos",
	"Goulandris",
	"Gounaris",
	"Grammatikopoulos",
	"Hatzidakis",
	"Hatzimichalis",
	"Hatzis",
	"Hondros",
	"Hrisoverghis",
	"Iliopoulos",
	"Ioannidis",
	"Kafatos",
	"Kaklamanis",
	"Kalogeras",
	"Kalogeropoulos",
	"Kalymnios",
	"Kamaras",
	"Kanakaris",
	"Kanellopoulos",
	"Karagounis",
	"Karahalios",
	"Karakatsanis",
	"Karakostas",
	"Karas",
	"Karavitis",
	"Karras",
	"Karvelas",
	"Katechis",
	"Katrakis",
	"Katsanevas",
	"Katsifaras",
	"Kazazis",
	"Kefalogiannis",
	"Kiriakidis",
	"Kokkinakis",
	"Kokkoris",
	"Kokolakis",
	"Kolettis",
	"Kolokotronis",
	"Kondylis",
	"Konstantinidis",
	"Konstantopoulos",
	"Kontogouris",
	"Kontos",
	"Kontoyiannis",
	"Kordolaimis",
	"Kostakis",
	"Kostakos",
	"Kostopoulos",
	"Kotsopoulos",
	"Kotzias",
	"Koufos",
	"Koundouros",
	"Kourakis",
	"Koutsis",
	"Koutsopoulos",
	"Krestenitis",
	"Kriezis",
	"Kyrgios",
	"Kyriakakis",
	"Kyriazis",
	"Kyrkos",
	"Labropoulos",
	"Lagoudakis",
	"Lambrakis",
	"Latsis",
	"Leandros",
	"Leichoudis",
	"Leivaditis",
	"Lekkas",
	"Lemonis",
	"Lemos",
	"Leon",
	"Leventis",
	"Liourdis",
	"Logothetis",
	"Loverdos",
	"Lytras",
	"Macrides",
	"Magoulas",
	"Maimonides",
	"Makris",
	"Makriyannis",
	"Malamas",
	"Manetas",
	"Manikas",
	"Manolas",
	"Manousakis",
	"Manousos",
	"Mantalos",
	"Mantzaris",
	"Mantzios",
	"Maragos",
	"Marangos",
	"Mardas",
	"Margaritis",
	"Marinakis",
	"Maris",
	"Markakis",
	"Markides",
	"Markopoulos",
	"Matraxia",
	"Matsakis",
	"Matsoukas",
	"Matzourakis",
	"Mavridis",
	"Mavromatis",
	"Miaoulis",
	"Michailidis",
	"Michalos",
	"Mitropoulos",
	"Mitsopoulos",
	"Mitsotakis",
	"Moustakas",
	"Mylonas",
	"Nafpliotis",
	"Nerantzis",
	"Nevrakis",
	"Nicolaides",
	"Nicolau",
	"Nikolaidis",
	"Nikolopoulos",
	"Nikoloudis",
	"Notaras",
	"Oikonomopoulos",
	"Orologas",
	"Pallis",
	"Panagakos",
	"Panagiotidis",
	"Panagiotopoulos",
	"Panagis",
	"Panagopoulos",
	"Panousis",
	"Pantazis",
	"Papachristos",
	"Papadakis",
	"Papadatos",
	"Papademos",
	"Papadiamantopoulos",
	"Papadopoulos",
	"Papageorgopoulos",
	"Papagiannis",
	"Papamichael",
	"Papanikolas",
	"Papayiannis",
	"Papoulias",
	"Pappas",
	"Paraschos",
	"Paraskevas",
	"Paraskevopoulos",
	"Parios",
	"Paschalidis",
	"Pavlidis",
	"Pavlopoulos",
	"Petimezas",
	"Petinos",
	"Petridis",
	"Philippidis",
	"Protopapas",
	"Psaltis",
	"Rallis",
	"Raskopoulos",
	"Regas",
	"Rodocanachis",
	"Roubanis",
	"Rouphos",
	"Roussopoulos",
	"Saitta",
	"Sakellaridis",
	"Sakellarios",
	"Sakellaropoulos",
	"Sakkaris",
	"Samaras",
	"Savalas",
	"Savvas",
	"Schinas",
	"Servopoulos",
	"Sgouros",
	"Sifakis",
	"Simopoulos",
	"Siopis",
	"Sisinis",
	"Skarlatos",
	"Skourletis",
	"Smaragdis",
	"Spanakos",
	"Spanos",
	"Spanoudakis",
	"Spheeris",
	"Spiliotopoulos",
	"Spyropoulos",
	"Stamatis",
	"Stamatopoulos",
	"Stamos",
	"Stasinopoulos",
	"Stathakis",
	"Stathis",
	"Stavridis",
	"Stavropoulos",
	"Stavros",
	"Stephanides",
	"Stephanopoulos",
	"Stratigos",
	"Straton",
	"Tadros",
	"Taskasaplidis",
	"Terzis",
	"Theodorakis",
	"Theodoridis",
	"Theodoropoulos",
	"Tolis",
	"Tombras",
	"Trakas",
	"Triantafyllopoulos",
	"Tsakalidis",
	"Tsakalotos",
	"Tsakiris",
	"Tsakonas",
	"Tsaldaris",
	"Tsamis",
	"Tsatsos",
	"Tsekrekos",
	"Tsitsipas",
	"Tzavaras",
	"Vakalopoulos",
	"Valaoritis",
	"Valavanis",
	"Valvis",
	"Vardinogiannis",
	"Vardoulakis",
	"Vasilakakis",
	"Vasiliadis",
	"Vasilopoulos",
	"Vassilakis",
	"Venizelos",
	"Vgenopoulos",
	"Vlachodimos",
	"Vlachopoulos",
	"Vlahakis",
	"Vlahos",
	"Vlasopoulos",
	"Vokos",
	"Volikakis",
	"Voskopoulos",
	"Votsis",
	"Vougiouklakis",
	"Voulgaris",
	"Vovos",
	"Vrakas",
	"Vranas",
	"Vrettos",
	"Xanthopoulos",
	"Xanthos",
	"Xenakis",
	"Xydakis",
	"Xylouris",
	"Yannakakis",
	"Yfantis",
	"Zaimis",
	"Zapropoulos",
	"Zervos",
	"Zintiridis",
	"Zochonis",
	"Zografakis",
	"Zografos"
}


local Greek = CultureName.New({
	male = male,
	female = female,
	surname = {},
	name = "Greek",
	code = "el",
	replace = {}
})

-- Greek surnames are gender specific
function Greek:Surname (isFemale, rand, ascii)
	local array = isFemale and female_surname or male_surname
	return utils.chooseEqual(array, rand)
end

return Greek
