#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-ABSvecpW2nOhXLWkDrKSy
key:                  postgrest-10.0.0-ABSvecpW2nOhXLWkDrKSy
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  92bf5915f4c815460a23f9973957ac0e
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-ABSvecpW2nOhXLWkDrKSy
depends:
    HTTP-4000.4.1-I2SHq0OXREm3IzlxzjgUek
    Ranged-sets-0.5.0-I9pY74NgLu1G5aXq22jKvk
    aeson-2.1.2.1-3HLieqpkeG06w6MDAYdLLk
    auto-update-0.1.6-J9gsS695efxIq6hqSt2si4 base-4.17.2.1
    base64-bytestring-1.2.1.0-G8BjkxE58WI1uqeVjCB0n4
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-4psXWcL2Or6Ff92NkDcfKY
    cassava-0.5.4.1-2GbrFrWHffq4KfrhkzdOtR
    configurator-pg-0.2.10-1jWQa6Qmzk1I3dHdLXg17c containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.5.0-Khxmud11aHE2bTuo1AKBzI directory-1.3.7.1
    either-5.0.3-1H3QHzumjE7EgPwL47HtVu
    gitrev-1.3.1-EAQEu0I0MYZ3NOvBCjPIAO
    hasql-1.5.0.5-GyUCDmolcLALaXTTlK3At6
    hasql-dynamic-statements-0.3.1.1-3nOilBNBPlPK6BocRjwAfe
    hasql-notifications-0.2.0.5-JFYrIjS7v4O7KDb4zfoWk1
    hasql-pool-0.5.2.2-BwHwxKHfI7IEs1vYZJSAQF
    hasql-transaction-1.0.1.1-DxfkXw1WfVa4E97a2soCNT
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-3Rkn4NOOYhzvBVdRap5Ii
    insert-ordered-containers-0.2.5.3-4jsGq1TPuGQ576igjgghvC
    interpolatedstring-perl6-1.0.2-HrFxb8vO5CSgG5RwG9WZw
    jose-0.10-IRAFqCyL6t7AS5eGnniYay lens-5.3.3-1zYcQilqoBK5EhYwkXjOnb
    lens-aeson-1.2.3-9hOzJLNvQbOAUIoSWVRISn mtl-2.2.2
    network-3.1.4.0-2g2oEkgQCahBaM3HvlpVNW
    network-uri-2.6.4.2-DVBcu05aYxxCjTvpzOd17v
    optparse-applicative-0.18.1.0-t4C6chS8YH5x9x9VuRkT0 parsec-3.1.16.1
    protolude-0.3.5-9VGJQNu16hMIjhzRCetHeO
    regex-tdfa-1.3.2.5-71D7aDzS2d23Ft8PQEnlRo
    retry-0.9.3.1-IY64eTdMZLhC7kIJKe8e84
    scientific-0.3.8.0-6QoqQGQc0yZ1FsULZsdy9C
    swagger2-2.8.10-4unazDcYMSk57rIqyBP1UV text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20.1-JRJBW0Nl9iEJULI134IWXM
    vault-0.3.1.5-BHykSY1WJa8JS453tvnLdt
    vector-0.13.2.0-DhQEcquLn8PDmAHUsOvAGS
    wai-3.2.4-GKgviHtnWhO3KoBTtmAmpl
    wai-cors-0.2.7-CsoAkv69lzM7kxtefCTfBe
    wai-extra-3.1.18-F6kzlF5sHmSKQRA7O6iDV5
    wai-logger-2.5.0-13YOrPyKsGy3LZtyMHSSJM
    warp-3.4.0-4WQzRXYOsvYHbiPfjmDm2s

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

