/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.metrics;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.semanticweb.owlapi.metrics.OWLMetric;
import org.semanticweb.owlapi.metrics.OWLMetricManager;

public class MetricsTableModel
extends AbstractTableModel {
    private OWLMetricManager metricManager;
    private List<Object> metricsValues = new ArrayList<Object>();

    public MetricsTableModel(OWLMetricManager metricManager) {
        this.metricManager = metricManager;
    }

    @Override
    public int getRowCount() {
        return this.metricManager.getMetrics().size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.metricsValues.isEmpty()) {
            this.rebuild();
        }
        OWLMetric metric = (OWLMetric)this.metricManager.getMetrics().get(rowIndex);
        if (columnIndex == 0) {
            return metric.getName();
        }
        return this.metricsValues.get(rowIndex);
    }

    private void rebuild() {
        this.metricManager.getMetrics().forEach(this::addMetricValue);
    }

    private void addMetricValue(OWLMetric<?> m) {
        Object value = m.getValue();
        String formattedMetric = value instanceof Integer ? String.format("%,d", value) : value.toString();
        this.metricsValues.add(formattedMetric);
    }

    public void invalidate() {
        this.metricsValues.clear();
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Metric";
        }
        return "Value";
    }

    public void includeImports(boolean b) {
        for (OWLMetric metric : this.metricManager.getMetrics()) {
            metric.setImportsClosureUsed(b);
        }
        this.fireTableDataChanged();
    }
}

