/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.HAManager;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.simplefan.FanEventListener;
import oracle.simplefan.FanUpEventListener;
import oracle.simplefan.LoadAdvisoryEvent;
import oracle.simplefan.NodeDownEvent;
import oracle.simplefan.NodeUpEvent;
import oracle.simplefan.ServiceDownEvent;
import oracle.simplefan.ServiceUpEvent;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.HIGH_AVAILABILITY})
final class HAFanListener
implements FanEventListener,
FanUpEventListener {
    HAManager haManager;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    HAFanListener(HAManager haManager) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, HAFanListener.class, $$$methodRef$$$6, null, haManager);
            }
            this.haManager = null;
            this.haManager = haManager;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, HAFanListener.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, HAFanListener.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, HAFanListener.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleEvent(ServiceDownEvent serviceDownEvent) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void event;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, HAFanListener.class, $$$methodRef$$$0, this, serviceDownEvent);
            }
            String evtService = HAFanListener.toLowerCase(event.getServiceName());
            String evtDbUnique = HAFanListener.toLowerCase(event.getDatabaseUniqueName());
            String evtInstance = null;
            String evtHost = null;
            int drainTimeout = event.getDrainTimeout();
            block1 : switch (event.getKind()) {
                case MEMBER: {
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "========= FAN down, event type: MEMBER");
                    }
                    evtInstance = HAFanListener.toLowerCase(event.getServiceMemberEvent().getInstanceName());
                    evtHost = HAFanListener.toLowerCase(event.getServiceMemberEvent().getNodeName());
                }
                case COMPOSITE: {
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "========= FAN down, event type: COMPOSITE");
                    }
                    switch (event.getReason()) {
                        case USER: {
                            this.haManager.plannedDown(evtService, evtInstance, evtDbUnique, evtHost, drainTimeout);
                            break block1;
                        }
                    }
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "========= FAN down, event type: default");
                    }
                    this.haManager.unplannedDown(evtService, evtInstance, evtDbUnique, evtHost);
                    break;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, HAFanListener.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, HAFanListener.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, HAFanListener.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleEvent(ServiceUpEvent serviceUpEvent) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void event;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, HAFanListener.class, $$$methodRef$$$1, this, serviceUpEvent);
            }
            String evtService = HAFanListener.toLowerCase(event.getServiceName());
            String evtDbUnique = HAFanListener.toLowerCase(event.getDatabaseUniqueName());
            String evtInstance = null;
            String evtHost = null;
            int cardinality = event.getCardinality();
            switch (event.getKind()) {
                case MEMBER: {
                    evtInstance = HAFanListener.toLowerCase(event.getServiceMemberEvent().getInstanceName());
                    evtHost = HAFanListener.toLowerCase(event.getServiceMemberEvent().getNodeName());
                }
                case COMPOSITE: {
                    this.haManager.serviceUp(evtService, evtInstance, evtDbUnique, evtHost, cardinality);
                    break;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, HAFanListener.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, HAFanListener.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, HAFanListener.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleEvent(NodeDownEvent nodeDownEvent) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void event;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, HAFanListener.class, $$$methodRef$$$2, this, nodeDownEvent);
            }
            String evtHost = event.getNodeName();
            this.haManager.nodeDown(evtHost);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, HAFanListener.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, HAFanListener.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, HAFanListener.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    public void handleEvent(LoadAdvisoryEvent loadAdvisoryEvent) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, HAFanListener.class, $$$methodRef$$$3, this, loadAdvisoryEvent);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, HAFanListener.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, HAFanListener.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, HAFanListener.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    public void handleEvent(NodeUpEvent nodeUpEvent) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, HAFanListener.class, $$$methodRef$$$4, this, nodeUpEvent);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, HAFanListener.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, HAFanListener.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, HAFanListener.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    private static String toLowerCase(String string) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            String s2;
            String string2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, HAFanListener.class, $$$methodRef$$$5, null, string);
            }
            String string3 = string2 = null == s2 ? null : s2.toLowerCase();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, HAFanListener.class, $$$methodRef$$$5, null, string2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, HAFanListener.class, $$$methodRef$$$5, null, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, HAFanListener.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$6 = HAFanListener.class.getDeclaredConstructor(HAManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = HAFanListener.class.getDeclaredMethod("toLowerCase", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = HAFanListener.class.getDeclaredMethod("handleEvent", NodeUpEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = HAFanListener.class.getDeclaredMethod("handleEvent", LoadAdvisoryEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = HAFanListener.class.getDeclaredMethod("handleEvent", NodeDownEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = HAFanListener.class.getDeclaredMethod("handleEvent", ServiceUpEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = HAFanListener.class.getDeclaredMethod("handleEvent", ServiceDownEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

