/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.AbstractShardingCallableStatement;
import oracle.jdbc.driver.AbstractShardingConnection;
import oracle.jdbc.driver.AbstractShardingDatabaseMetaData;
import oracle.jdbc.driver.AbstractShardingLob;
import oracle.jdbc.driver.AbstractShardingPreparedStatement;
import oracle.jdbc.driver.AbstractShardingResultSet;
import oracle.jdbc.driver.AbstractShardingStatement;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CInputStream;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.proxy.ProxyFactory;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class ShardingDriverExtension
extends OracleDriverExtension {
    static ProxyFactory PROXY_FACTORY;
    private static final Monitor proxyFactoryLock;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    ShardingDriverExtension() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$6, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @DefaultLevel(value=Logging.FINEST)
    Connection getConnection(String string, @Blind(value=PropertiesBlinder.class) Properties properties, AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void builder;
            void info;
            void url;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$0, this, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties), abstractConnectionBuilder);
            }
            Connection connection = null;
            try {
                connection = (Connection)PROXY_FACTORY.proxyForType(OracleConnection.class);
                ((AbstractShardingConnection)((Object)connection)).initialize((String)url, (Properties)info, this, (AbstractConnectionBuilder<?, ?>)builder);
            }
            catch (SQLException ex) {
                int errorCode = ex.getErrorCode() - 17000;
                if (errorCode == 1708 || errorCode == 1709) {
                    T4CConnection t4CConnection;
                    block12: {
                        try {
                            String driverExtensionClassName = "oracle.jdbc.driver.T4CDriverExtension";
                            OracleDriverExtension driverExtension = (OracleDriverExtension)Class.forName(driverExtensionClassName).newInstance();
                            T4CConnection conn = new T4CConnection((String)url, (Properties)info, driverExtension);
                            conn.connect((AbstractConnectionBuilder<?, ?>)builder);
                            conn.protocolId = 0;
                            t4CConnection = conn;
                            if (!bl) break block12;
                        }
                        catch (Exception e2) {
                            SQLException sQLException = new SQLException(e2);
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$0, this, sQLException);
                            }
                            throw sQLException;
                        }
                        ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$0, this, t4CConnection);
                        ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$0, this, null);
                    }
                    return t4CConnection;
                }
                SQLException sQLException = ex;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            Connection connection2 = connection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$0, this, connection2);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$0, this, null);
            }
            return connection2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    final CompletionStage<Connection> getConnectionAsync(String string, @Blind(value=PropertiesBlinder.class) Properties properties, AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$1, this, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties), abstractConnectionBuilder);
            }
            CompletionStage<Connection> completionStage = CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous connection is not supported by the sharding driver"));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$1, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$1, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    oracle.jdbc.internal.OracleStatement allocateStatement(OracleConnection oracleConnection, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void stmtProps;
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$2, this, oracleConnection, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            oracle.jdbc.internal.OracleStatement stmt = null;
            stmt = (oracle.jdbc.internal.OracleStatement)PROXY_FACTORY.proxyForType(oracle.jdbc.internal.OracleStatement.class, conn);
            ((AbstractShardingStatement)((Object)stmt)).initialize((AbstractShardingConnection)conn, (Properties)stmtProps);
            oracle.jdbc.internal.OracleStatement oracleStatement = stmt;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$2, this, oracleStatement);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$2, this, null);
            }
            return oracleStatement;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    OraclePreparedStatement allocatePreparedStatement(OracleConnection oracleConnection, String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void stmtProps;
            void sql;
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$3, this, oracleConnection, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            OraclePreparedStatement pstmt = null;
            pstmt = (OraclePreparedStatement)PROXY_FACTORY.proxyForType(OraclePreparedStatement.class, conn);
            ((AbstractShardingPreparedStatement)((Object)pstmt)).initialize((AbstractShardingConnection)conn, (String)sql, (Properties)stmtProps);
            OraclePreparedStatement oraclePreparedStatement = pstmt;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$3, this, oraclePreparedStatement);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$3, this, null);
            }
            return oraclePreparedStatement;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    OracleCallableStatement allocateCallableStatement(OracleConnection oracleConnection, String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void stmtProps;
            void sql;
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$4, this, oracleConnection, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            OracleCallableStatement cstmt = null;
            cstmt = (OracleCallableStatement)PROXY_FACTORY.proxyForType(OracleCallableStatement.class, conn);
            ((AbstractShardingCallableStatement)((Object)cstmt)).initialize((AbstractShardingConnection)conn, (String)sql, (Properties)stmtProps);
            OracleCallableStatement oracleCallableStatement = cstmt;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$4, this, oracleCallableStatement);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$4, this, null);
            }
            return oracleCallableStatement;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    OracleInputStream createInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void accessor2;
            void index;
            void stmt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$5, this, oracleStatement, n2, accessor);
            }
            T4CInputStream t4CInputStream = new T4CInputStream((OracleStatement)stmt, (int)index, (Accessor)accessor2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$5, this, t4CInputStream);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$5, this, null);
            }
            return t4CInputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingDriverExtension.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$6 = ShardingDriverExtension.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ShardingDriverExtension.class.getDeclaredMethod("createInputStream", OracleStatement.class, Integer.TYPE, Accessor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ShardingDriverExtension.class.getDeclaredMethod("allocateCallableStatement", OracleConnection.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ShardingDriverExtension.class.getDeclaredMethod("allocatePreparedStatement", OracleConnection.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ShardingDriverExtension.class.getDeclaredMethod("allocateStatement", OracleConnection.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ShardingDriverExtension.class.getDeclaredMethod("getConnectionAsync", String.class, Properties.class, AbstractConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ShardingDriverExtension.class.getDeclaredMethod("getConnection", String.class, Properties.class, AbstractConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        PROXY_FACTORY = null;
        proxyFactoryLock = Monitor.newInstance();
        try (Monitor.CloseableLock lock = proxyFactoryLock.acquireCloseableLock();){
            if (PROXY_FACTORY == null) {
                PROXY_FACTORY = ProxyFactory.createProxyFactory(AbstractShardingConnection.class, AbstractShardingStatement.class, AbstractShardingPreparedStatement.class, AbstractShardingCallableStatement.class, AbstractShardingResultSet.class, AbstractShardingDatabaseMetaData.class, AbstractShardingLob.class);
            }
        }
    }
}

