/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.startup.UserConfig;
import org.apache.catalina.startup.UserDatabase;

public final class HomesUserDatabase
implements UserDatabase {
    private final Map<String, String> homes = new HashMap<String, String>();
    private UserConfig userConfig = null;

    @Override
    public UserConfig getUserConfig() {
        return this.userConfig;
    }

    @Override
    public void setUserConfig(UserConfig userConfig) {
        this.userConfig = userConfig;
        this.init();
    }

    @Override
    public String getHome(String string) {
        return this.homes.get(string);
    }

    @Override
    public Enumeration<String> getUsers() {
        return Collections.enumeration(this.homes.keySet());
    }

    private void init() {
        String string = this.userConfig.getHomeBase();
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (String string2 : stringArray) {
            File file2 = new File(file, string2);
            if (!file2.isDirectory() || !file2.canRead()) continue;
            this.homes.put(string2, file2.toString());
        }
    }
}

