// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_WEBUI_RECORDER_APP_UI_RESOURCES_H_
#define ASH_WEBUI_RECORDER_APP_UI_RESOURCES_H_

#include "chromeos/strings/grit/chromeos_strings.h"
#include "ui/base/webui/web_ui_util.h"

namespace ash {

const webui::LocalizedString kLocalizedStrings[] = {
    {"exportDialogAudioFormatWebmOption",
     IDS_RECORDER_EXPORT_DIALOG_AUDIO_FORMAT_WEBM_OPTION},
    {"exportDialogAudioHeader", IDS_RECORDER_EXPORT_DIALOG_AUDIO_HEADER},
    {"exportDialogCancelButton", IDS_RECORDER_EXPORT_DIALOG_CANCEL_BUTTON},
    {"exportDialogHeader", IDS_RECORDER_EXPORT_DIALOG_HEADER},
    {"exportDialogSaveButton", IDS_RECORDER_EXPORT_DIALOG_SAVE_BUTTON},
    {"exportDialogTranscriptionFormatTxtOption",
     IDS_RECORDER_EXPORT_DIALOG_TRANSCRIPTION_FORMAT_TXT_OPTION},
    {"exportDialogTranscriptionHeader",
     IDS_RECORDER_EXPORT_DIALOG_TRANSCRIPTION_HEADER},
    {"genAiDisclaimerText", IDS_RECORDER_GEN_AI_DISCLAIMER_TEXT},
    {"genAiErrorGeneralLabel", IDS_RECORDER_GEN_AI_ERROR_GENERAL_LABEL},
    {"genAiErrorSummaryTrustAndSafetyLabel",
     IDS_RECORDER_GEN_AI_ERROR_SUMMARY_TRUST_AND_SAFETY_LABEL},
    {"genAiErrorTitleSuggestionTrustAndSafetyLabel",
     IDS_RECORDER_GEN_AI_ERROR_TITLE_SUGGESTION_TRUST_AND_SAFETY_LABEL},
    {"genAiExperimentBadge", IDS_RECORDER_GEN_AI_EXPERIMENT_BADGE},
    {"genAiLearnMoreLink", IDS_RECORDER_GEN_AI_LEARN_MORE_LINK},
    {"micSelectionMenuChromebookAudioOption",
     IDS_RECORDER_MIC_SELECTION_MENU_CHROMEBOOK_AUDIO_OPTION},
    {"onboardingDialogSpeakerIdAllowButton",
     IDS_RECORDER_ONBOARDING_DIALOG_SPEAKER_ID_ALLOW_BUTTON},
    {"onboardingDialogSpeakerIdDeferButton",
     IDS_RECORDER_ONBOARDING_DIALOG_SPEAKER_ID_DEFER_BUTTON},
    {"onboardingDialogSpeakerIdDescription",
     IDS_RECORDER_ONBOARDING_DIALOG_SPEAKER_ID_DESCRIPTION},
    {"onboardingDialogSpeakerIdDisallowButton",
     IDS_RECORDER_ONBOARDING_DIALOG_SPEAKER_ID_DISALLOW_BUTTON},
    {"onboardingDialogSpeakerIdHeader",
     IDS_RECORDER_ONBOARDING_DIALOG_SPEAKER_ID_HEADER},
    {"onboardingDialogSpeakerIdLearnMoreLink",
     IDS_RECORDER_ONBOARDING_DIALOG_SPEAKER_ID_LEARN_MORE_LINK},
    {"onboardingDialogTranscriptionCancelButton",
     IDS_RECORDER_ONBOARDING_DIALOG_TRANSCRIPTION_CANCEL_BUTTON},
    {"onboardingDialogTranscriptionDeferButton",
     IDS_RECORDER_ONBOARDING_DIALOG_TRANSCRIPTION_DEFER_BUTTON},
    {"onboardingDialogTranscriptionDescription",
     IDS_RECORDER_ONBOARDING_DIALOG_TRANSCRIPTION_DESCRIPTION},
    {"onboardingDialogTranscriptionHeader",
     IDS_RECORDER_ONBOARDING_DIALOG_TRANSCRIPTION_HEADER},
    {"onboardingDialogTranscriptionTurnOnButton",
     IDS_RECORDER_ONBOARDING_DIALOG_TRANSCRIPTION_TURN_ON_BUTTON},
    {"onboardingDialogWelcomeDescription",
     IDS_RECORDER_ONBOARDING_DIALOG_WELCOME_DESCRIPTION},
    {"onboardingDialogWelcomeHeader",
     IDS_RECORDER_ONBOARDING_DIALOG_WELCOME_HEADER},
    {"onboardingDialogWelcomeNextButton",
     IDS_RECORDER_ONBOARDING_DIALOG_WELCOME_NEXT_BUTTON},
    {"playbackMenuDeleteOption", IDS_RECORDER_PLAYBACK_MENU_DELETE_OPTION},
    {"playbackMenuExportOption", IDS_RECORDER_PLAYBACK_MENU_EXPORT_OPTION},
    {"playbackMenuShowDetailOption",
     IDS_RECORDER_PLAYBACK_MENU_SHOW_DETAIL_OPTION},
    {"recordDeleteDialogCancelButton",
     IDS_RECORDER_RECORD_DELETE_DIALOG_CANCEL_BUTTON},
    {"recordDeleteDialogCurrentHeader",
     IDS_RECORDER_RECORD_DELETE_DIALOG_CURRENT_HEADER},
    {"recordDeleteDialogDeleteButton",
     IDS_RECORDER_RECORD_DELETE_DIALOG_DELETE_BUTTON},
    {"recordDeleteDialogDescription",
     IDS_RECORDER_RECORD_DELETE_DIALOG_DESCRIPTION},
    {"recordDeleteDialogHeader", IDS_RECORDER_RECORD_DELETE_DIALOG_HEADER},
    {"recordExitDialogCancelButton",
     IDS_RECORDER_RECORD_EXIT_DIALOG_CANCEL_BUTTON},
    {"recordExitDialogDeleteButton",
     IDS_RECORDER_RECORD_EXIT_DIALOG_DELETE_BUTTON},
    {"recordExitDialogDescription",
     IDS_RECORDER_RECORD_EXIT_DIALOG_DESCRIPTION},
    {"recordExitDialogHeader", IDS_RECORDER_RECORD_EXIT_DIALOG_HEADER},
    {"recordExitDialogSaveAndExitButton",
     IDS_RECORDER_RECORD_EXIT_DIALOG_SAVE_AND_EXIT_BUTTON},
    {"recordMenuDeleteOption", IDS_RECORDER_RECORD_MENU_DELETE_OPTION},
    {"recordMenuToggleTranscriptionOption",
     IDS_RECORDER_RECORD_MENU_TOGGLE_TRANSCRIPTION_OPTION},
    {"recordStopButton", IDS_RECORDER_RECORD_STOP_BUTTON},
    {"recordTranscriptionEntryPointDescription",
     IDS_RECORDER_RECORD_TRANSCRIPTION_ENTRY_POINT_DESCRIPTION},
    {"recordTranscriptionEntryPointDisableButton",
     IDS_RECORDER_RECORD_TRANSCRIPTION_ENTRY_POINT_DISABLE_BUTTON},
    {"recordTranscriptionEntryPointEnableButton",
     IDS_RECORDER_RECORD_TRANSCRIPTION_ENTRY_POINT_ENABLE_BUTTON},
    {"recordTranscriptionEntryPointHeader",
     IDS_RECORDER_RECORD_TRANSCRIPTION_ENTRY_POINT_HEADER},
    {"recordTranscriptionOffDescription",
     IDS_RECORDER_RECORD_TRANSCRIPTION_OFF_DESCRIPTION},
    {"recordTranscriptionOffHeader",
     IDS_RECORDER_RECORD_TRANSCRIPTION_OFF_HEADER},
    {"recordingListHeader", IDS_RECORDER_RECORDING_LIST_HEADER},
    {"recordingListNoMatchText", IDS_RECORDER_RECORDING_LIST_NO_MATCH_TEXT},
    {"recordingListSearchBoxPlaceholder",
     IDS_RECORDER_RECORDING_LIST_SEARCH_BOX_PLACEHOLDER},
    {"recordingListSortByDateOption",
     IDS_RECORDER_RECORDING_LIST_SORT_BY_DATE_OPTION},
    {"recordingListSortByNameOption",
     IDS_RECORDER_RECORDING_LIST_SORT_BY_NAME_OPTION},
    {"recordingListThisMonthHeader",
     IDS_RECORDER_RECORDING_LIST_THIS_MONTH_HEADER},
    {"recordingListTodayHeader", IDS_RECORDER_RECORDING_LIST_TODAY_HEADER},
    {"recordingListYesterdayHeader",
     IDS_RECORDER_RECORDING_LIST_YESTERDAY_HEADER},
    {"settingsHeader", IDS_RECORDER_SETTINGS_HEADER},
    {"settingsOptionsDoNotDisturbDescription",
     IDS_RECORDER_SETTINGS_OPTIONS_DO_NOT_DISTURB_DESCRIPTION},
    {"settingsOptionsDoNotDisturbLabel",
     IDS_RECORDER_SETTINGS_OPTIONS_DO_NOT_DISTURB_LABEL},
    {"settingsOptionsKeepScreenOnLabel",
     IDS_RECORDER_SETTINGS_OPTIONS_KEEP_SCREEN_ON_LABEL},
    {"settingsOptionsSpeakerIdDescription",
     IDS_RECORDER_SETTINGS_OPTIONS_SPEAKER_ID_DESCRIPTION},
    {"settingsOptionsSpeakerIdLabel",
     IDS_RECORDER_SETTINGS_OPTIONS_SPEAKER_ID_LABEL},
    {"settingsOptionsSummaryDescription",
     IDS_RECORDER_SETTINGS_OPTIONS_SUMMARY_DESCRIPTION},
    {"settingsOptionsSummaryDownloadButton",
     IDS_RECORDER_SETTINGS_OPTIONS_SUMMARY_DOWNLOAD_BUTTON},
    {"settingsOptionsSummaryDownloadingButton",
     IDS_RECORDER_SETTINGS_OPTIONS_SUMMARY_DOWNLOADING_BUTTON},
    {"settingsOptionsSummaryDownloadingProgressDescription",
     IDS_RECORDER_SETTINGS_OPTIONS_SUMMARY_DOWNLOADING_PROGRESS_DESCRIPTION},
    {"settingsOptionsSummaryLabel",
     IDS_RECORDER_SETTINGS_OPTIONS_SUMMARY_LABEL},
    {"settingsOptionsSummaryLearnMoreLink",
     IDS_RECORDER_SETTINGS_OPTIONS_SUMMARY_LEARN_MORE_LINK},
    {"settingsOptionsTranscriptionDownloadButton",
     IDS_RECORDER_SETTINGS_OPTIONS_TRANSCRIPTION_DOWNLOAD_BUTTON},
    {"settingsOptionsTranscriptionDownloadingButton",
     IDS_RECORDER_SETTINGS_OPTIONS_TRANSCRIPTION_DOWNLOADING_BUTTON},
    {"settingsOptionsTranscriptionDownloadingProgressDescription",
     IDS_RECORDER_SETTINGS_OPTIONS_TRANSCRIPTION_DOWNLOADING_PROGRESS_DESCRIPTION},
    {"settingsOptionsTranscriptionLabel",
     IDS_RECORDER_SETTINGS_OPTIONS_TRANSCRIPTION_LABEL},
    {"settingsSectionGeneralHeader",
     IDS_RECORDER_SETTINGS_SECTION_GENERAL_HEADER},
    {"settingsSectionTranscriptionSummaryHeader",
     IDS_RECORDER_SETTINGS_SECTION_TRANSCRIPTION_SUMMARY_HEADER},
    {"summaryDownloadModelDescription",
     IDS_RECORDER_SUMMARY_DOWNLOAD_MODEL_DESCRIPTION},
    {"summaryDownloadModelDisableButton",
     IDS_RECORDER_SUMMARY_DOWNLOAD_MODEL_DISABLE_BUTTON},
    {"summaryDownloadModelDownloadButton",
     IDS_RECORDER_SUMMARY_DOWNLOAD_MODEL_DOWNLOAD_BUTTON},
    {"summaryDownloadModelHeader", IDS_RECORDER_SUMMARY_DOWNLOAD_MODEL_HEADER},
    {"summaryDownloadingProgressDescription",
     IDS_RECORDER_SUMMARY_DOWNLOADING_PROGRESS_DESCRIPTION},
    {"summaryHeader", IDS_RECORDER_SUMMARY_HEADER},
    {"titleRenameTooltip", IDS_RECORDER_TITLE_RENAME_TOOLTIP},
    {"titleSuggestionHeader", IDS_RECORDER_TITLE_SUGGESTION_HEADER},
    {"transcriptionAutoscrollButton",
     IDS_RECORDER_TRANSCRIPTION_AUTOSCROLL_BUTTON},
    {"transcriptionNoSpeechText", IDS_RECORDER_TRANSCRIPTION_NO_SPEECH_TEXT},
    {"transcriptionWaitingSpeechText",
     IDS_RECORDER_TRANSCRIPTION_WAITING_SPEECH_TEXT},
};

}  // namespace ash

#endif  // ASH_WEBUI_RECORDER_APP_UI_RESOURCES_H_
