// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_SYSTEM_POWER_BATTERY_NOTIFICATION_H_
#define ASH_SYSTEM_POWER_BATTERY_NOTIFICATION_H_

#include "ash/ash_export.h"
#include "ash/system/power/power_notification_controller.h"

namespace message_center {
class MessageCenter;
}

namespace ash {

// Class for showing and hiding a MessageCenter low battery notification.
class ASH_EXPORT BatteryNotification {
 public:
  BatteryNotification(
      message_center::MessageCenter* message_center,
      PowerNotificationController::NotificationState notification_state);

  BatteryNotification(const BatteryNotification&) = delete;
  BatteryNotification& operator=(const BatteryNotification&) = delete;

  ~BatteryNotification();

  static const char kNotificationId[];

  // Updates the notification if it still exists.
  void Update(
      PowerNotificationController::NotificationState notification_state);

 private:
  message_center::MessageCenter* message_center_;
};

}  // namespace ash

#endif  // ASH_SYSTEM_POWER_BATTERY_NOTIFICATION_H_
