// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#import "internal/platform/implementation/ios/Mediums/GNCMConnection.h"

NS_ASSUME_NONNULL_BEGIN

@implementation GNCMConnectionHandlers

+ (instancetype)payloadHandler:(GNCMPayloadHandler)payloadHandler
           disconnectedHandler:(dispatch_block_t)disconnectedHandler {
  GNCMConnectionHandlers *handlers = [[GNCMConnectionHandlers alloc] init];
  handlers.payloadHandler = payloadHandler;
  handlers.disconnectedHandler = disconnectedHandler;
  return handlers;
}

@end

NS_ASSUME_NONNULL_END
