/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/. */

use crate::ProcessHandle;

pub struct ProcessReader {
    process: ProcessHandle,
}

#[cfg(target_os = "windows")]
mod windows;

#[cfg(any(target_os = "android", target_os = "linux"))]
mod linux;

#[cfg(target_os = "macos")]
mod macos;
