// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,-wavefrontsize64 -show-encoding %s | FileCheck --check-prefixes=GFX11,W32 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=-wavefrontsize32,+wavefrontsize64 -show-encoding %s | FileCheck --check-prefixes=GFX11,W64 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,-wavefrontsize64 %s 2>&1 | FileCheck --check-prefix=W32-ERR --implicit-check-not=error: %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=-wavefrontsize32,+wavefrontsize64 %s 2>&1 | FileCheck --check-prefix=W64-ERR --implicit-check-not=error: %s

v_add3_u32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x05,0x0e,0x04]

v_add3_u32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x55,0xd6,0x01,0x05,0x0e,0x04]

v_add3_u32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0xff,0x05,0x0e,0x04]

v_add3_u32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x04,0x0e,0x04]

v_add3_u32 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x65,0x04,0x0e,0x04]

v_add3_u32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x6a,0x04,0x0e,0x04]

v_add3_u32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x6b,0x04,0x0e,0x04]

v_add3_u32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x7d,0x04,0x0e,0x04]

v_add3_u32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x7e,0x04,0x0e,0x04]

v_add3_u32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x7f,0x04,0x0e,0x04]

v_add3_u32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x80,0x04,0x0e,0x04]

v_add3_u32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0xc1,0x04,0x0e,0x04]

v_add3_u32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0xf0,0x04,0x0e,0x04]

v_add3_u32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0xf7,0x04,0x0e,0x04]

v_add3_u32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0xff,0x0f,0x04]

v_add3_u32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x05,0x0c,0x04]

v_add3_u32 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0xcb,0x0c,0x04]

v_add3_u32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0xd5,0x0c,0x04]

v_add3_u32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0xd7,0x0c,0x04]

v_add3_u32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0xfb,0x0c,0x04]

v_add3_u32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0xfd,0x0c,0x04]

v_add3_u32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0xff,0x0c,0x04]

v_add3_u32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x01,0x0d,0x04]

v_add3_u32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x83,0x0d,0x04]

v_add3_u32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0xe1,0x0d,0x04]

v_add3_u32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0xef,0x0d,0x04]

v_add3_u32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x05,0xfe,0x07]

v_add3_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x05,0x0e,0x00]

v_add3_u32 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x05,0x96,0x01]

v_add3_u32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x05,0xaa,0x01]

v_add3_u32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x05,0xae,0x01]

v_add3_u32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x05,0xf6,0x01]

v_add3_u32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x05,0xfa,0x01]

v_add3_u32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x05,0xfe,0x01]

v_add3_u32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x05,0x02,0x02]

v_add3_u32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x05,0x06,0x03]

v_add3_u32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x05,0xc2,0x03]

v_add3_u32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x05,0xde,0x03]

v_add_co_u32 v5, s0, v1, v2
// W32: encoding: [0x05,0x00,0x00,0xd7,0x01,0x05,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v255, s0, v1, v2
// W32: encoding: [0xff,0x00,0x00,0xd7,0x01,0x05,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, v255, v2
// W32: encoding: [0x05,0x00,0x00,0xd7,0xff,0x05,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, s1, v2
// W32: encoding: [0x05,0x00,0x00,0xd7,0x01,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, s103, v2
// W32: encoding: [0x05,0x00,0x00,0xd7,0x67,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, vcc_lo, v2
// W32: encoding: [0x05,0x00,0x00,0xd7,0x6a,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, vcc_hi, v2
// W32: encoding: [0x05,0x00,0x00,0xd7,0x6b,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, m0, v2
// W32: encoding: [0x05,0x00,0x00,0xd7,0x7d,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, exec_lo, v2
// W32: encoding: [0x05,0x00,0x00,0xd7,0x7e,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, exec_hi, v2
// W32: encoding: [0x05,0x00,0x00,0xd7,0x7f,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, 0, v2
// W32: encoding: [0x05,0x00,0x00,0xd7,0x80,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, -1, v2
// W32: encoding: [0x05,0x00,0x00,0xd7,0xc1,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, 0.5, v2
// W32: encoding: [0x05,0x00,0x00,0xd7,0xf0,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, -4.0, v2
// W32: encoding: [0x05,0x00,0x00,0xd7,0xf7,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, v255
// W32: encoding: [0x05,0x00,0x00,0xd7,0x01,0xff,0x03,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, s2
// W32: encoding: [0x05,0x00,0x00,0xd7,0x01,0x05,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, s103
// W32: encoding: [0x05,0x00,0x00,0xd7,0x01,0xcf,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, vcc_lo
// W32: encoding: [0x05,0x00,0x00,0xd7,0x01,0xd5,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, vcc_hi
// W32: encoding: [0x05,0x00,0x00,0xd7,0x01,0xd7,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, m0
// W32: encoding: [0x05,0x00,0x00,0xd7,0x01,0xfb,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, exec_lo
// W32: encoding: [0x05,0x00,0x00,0xd7,0x01,0xfd,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, exec_hi
// W32: encoding: [0x05,0x00,0x00,0xd7,0x01,0xff,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, 0
// W32: encoding: [0x05,0x00,0x00,0xd7,0x01,0x01,0x01,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, -1
// W32: encoding: [0x05,0x00,0x00,0xd7,0x01,0x83,0x01,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, 0.5
// W32: encoding: [0x05,0x00,0x00,0xd7,0x01,0xe1,0x01,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, -4.0
// W32: encoding: [0x05,0x00,0x00,0xd7,0x01,0xef,0x01,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, ttmp11, v2
// W32: encoding: [0x05,0x00,0x00,0xd7,0x77,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, ttmp11
// W32: encoding: [0x05,0x00,0x00,0xd7,0x01,0xef,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, v2
// W64: encoding: [0x05,0x00,0x00,0xd7,0x01,0x05,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v255, s[0:1], v1, v2
// W64: encoding: [0xff,0x00,0x00,0xd7,0x01,0x05,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v255, v2
// W64: encoding: [0x05,0x00,0x00,0xd7,0xff,0x05,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], s1, v2
// W64: encoding: [0x05,0x00,0x00,0xd7,0x01,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], s103, v2
// W64: encoding: [0x05,0x00,0x00,0xd7,0x67,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], vcc_lo, v2
// W64: encoding: [0x05,0x00,0x00,0xd7,0x6a,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], vcc_hi, v2
// W64: encoding: [0x05,0x00,0x00,0xd7,0x6b,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], m0, v2
// W64: encoding: [0x05,0x00,0x00,0xd7,0x7d,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], exec_lo, v2
// W64: encoding: [0x05,0x00,0x00,0xd7,0x7e,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], exec_hi, v2
// W64: encoding: [0x05,0x00,0x00,0xd7,0x7f,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], 0, v2
// W64: encoding: [0x05,0x00,0x00,0xd7,0x80,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], -1, v2
// W64: encoding: [0x05,0x00,0x00,0xd7,0xc1,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], 0.5, v2
// W64: encoding: [0x05,0x00,0x00,0xd7,0xf0,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], -4.0, v2
// W64: encoding: [0x05,0x00,0x00,0xd7,0xf7,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, v255
// W64: encoding: [0x05,0x00,0x00,0xd7,0x01,0xff,0x03,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, s2
// W64: encoding: [0x05,0x00,0x00,0xd7,0x01,0x05,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, s103
// W64: encoding: [0x05,0x00,0x00,0xd7,0x01,0xcf,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, vcc_lo
// W64: encoding: [0x05,0x00,0x00,0xd7,0x01,0xd5,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, vcc_hi
// W64: encoding: [0x05,0x00,0x00,0xd7,0x01,0xd7,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, m0
// W64: encoding: [0x05,0x00,0x00,0xd7,0x01,0xfb,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, exec_lo
// W64: encoding: [0x05,0x00,0x00,0xd7,0x01,0xfd,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, exec_hi
// W64: encoding: [0x05,0x00,0x00,0xd7,0x01,0xff,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, 0
// W64: encoding: [0x05,0x00,0x00,0xd7,0x01,0x01,0x01,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, -1
// W64: encoding: [0x05,0x00,0x00,0xd7,0x01,0x83,0x01,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, 0.5
// W64: encoding: [0x05,0x00,0x00,0xd7,0x01,0xe1,0x01,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, -4.0
// W64: encoding: [0x05,0x00,0x00,0xd7,0x01,0xef,0x01,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], ttmp11, v2
// W64: encoding: [0x05,0x00,0x00,0xd7,0x77,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, ttmp11
// W64: encoding: [0x05,0x00,0x00,0xd7,0x01,0xef,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_add_f64 v[5:6], v[1:2], v[2:3]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0x05,0x02,0x00]

v_add_f64 v[254:255], v[1:2], v[2:3]
// GFX11: encoding: [0xfe,0x00,0x27,0xd7,0x01,0x05,0x02,0x00]

v_add_f64 v[5:6], v[254:255], v[2:3]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0xfe,0x05,0x02,0x00]

v_add_f64 v[5:6], s[2:3], v[2:3]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x02,0x04,0x02,0x00]

v_add_f64 v[5:6], s[4:5], v[2:3]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x04,0x04,0x02,0x00]

v_add_f64 v[5:6], s[102:103], v[2:3]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x66,0x04,0x02,0x00]

v_add_f64 v[5:6], vcc, v[2:3]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x6a,0x04,0x02,0x00]

v_add_f64 v[5:6], exec, v[2:3]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x7e,0x04,0x02,0x00]

v_add_f64 v[5:6], 0, v[2:3]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x80,0x04,0x02,0x00]

v_add_f64 v[5:6], -1, v[2:3]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0xc1,0x04,0x02,0x00]

v_add_f64 v[5:6], 0.5, v[2:3]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0xf0,0x04,0x02,0x00]

v_add_f64 v[5:6], -4.0, v[2:3]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0xf7,0x04,0x02,0x00]

v_add_f64 v[5:6], v[1:2], v[254:255]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0xfd,0x03,0x00]

v_add_f64 v[5:6], v[1:2], s[4:5]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0x09,0x00,0x00]

v_add_f64 v[5:6], v[1:2], s[6:7]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0x0d,0x00,0x00]

v_add_f64 v[5:6], v[1:2], s[102:103]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0xcd,0x00,0x00]

v_add_f64 v[5:6], v[1:2], vcc
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0xd5,0x00,0x00]

v_add_f64 v[5:6], v[1:2], exec
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0xfd,0x00,0x00]

v_add_f64 v[5:6], v[1:2], 0
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0x01,0x01,0x00]

v_add_f64 v[5:6], v[1:2], -1
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0x83,0x01,0x00]

v_add_f64 v[5:6], v[1:2], 0.5
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0xe1,0x01,0x00]

v_add_f64 v[5:6], v[1:2], -4.0
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0xef,0x01,0x00]

v_add_f64 v[5:6], -v[1:2], v[2:3]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0x05,0x02,0x20]

v_add_f64 v[5:6], v[1:2], -v[2:3]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0x05,0x02,0x40]

v_add_f64 v[5:6], -v[1:2], -v[2:3]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0x05,0x02,0x60]

v_add_f64 v[5:6], v[1:2], v[2:3] clamp
// GFX11: encoding: [0x05,0x80,0x27,0xd7,0x01,0x05,0x02,0x00]

v_add_f64 v[5:6], v[1:2], v[2:3] mul:2
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0x05,0x02,0x08]

v_add_f64 v[5:6], v[1:2], v[2:3] mul:4
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0x05,0x02,0x10]

v_add_f64 v[5:6], v[1:2], v[2:3] div:2
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0x05,0x02,0x18]

v_add_f64 v[5:6], v[1:2], null
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0xf9,0x00,0x00]

v_add_f64 v[5:6], null, v[2:3]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x7c,0x04,0x02,0x00]

v_add_lshl_u32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x05,0x0e,0x04]

v_add_lshl_u32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x47,0xd6,0x01,0x05,0x0e,0x04]

v_add_lshl_u32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0xff,0x05,0x0e,0x04]

v_add_lshl_u32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x04,0x0e,0x04]

v_add_lshl_u32 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x65,0x04,0x0e,0x04]

v_add_lshl_u32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x6a,0x04,0x0e,0x04]

v_add_lshl_u32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x6b,0x04,0x0e,0x04]

v_add_lshl_u32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x7d,0x04,0x0e,0x04]

v_add_lshl_u32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x7e,0x04,0x0e,0x04]

v_add_lshl_u32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x7f,0x04,0x0e,0x04]

v_add_lshl_u32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x80,0x04,0x0e,0x04]

v_add_lshl_u32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0xc1,0x04,0x0e,0x04]

v_add_lshl_u32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0xf0,0x04,0x0e,0x04]

v_add_lshl_u32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0xf7,0x04,0x0e,0x04]

v_add_lshl_u32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0xff,0x0f,0x04]

v_add_lshl_u32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x05,0x0c,0x04]

v_add_lshl_u32 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0xcb,0x0c,0x04]

v_add_lshl_u32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0xd5,0x0c,0x04]

v_add_lshl_u32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0xd7,0x0c,0x04]

v_add_lshl_u32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0xfb,0x0c,0x04]

v_add_lshl_u32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0xfd,0x0c,0x04]

v_add_lshl_u32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0xff,0x0c,0x04]

v_add_lshl_u32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x01,0x0d,0x04]

v_add_lshl_u32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x83,0x0d,0x04]

v_add_lshl_u32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0xe1,0x0d,0x04]

v_add_lshl_u32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0xef,0x0d,0x04]

v_add_lshl_u32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x05,0xfe,0x07]

v_add_lshl_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x05,0x0e,0x00]

v_add_lshl_u32 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x05,0x96,0x01]

v_add_lshl_u32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x05,0xaa,0x01]

v_add_lshl_u32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x05,0xae,0x01]

v_add_lshl_u32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x05,0xf6,0x01]

v_add_lshl_u32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x05,0xfa,0x01]

v_add_lshl_u32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x05,0xfe,0x01]

v_add_lshl_u32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x05,0x02,0x02]

v_add_lshl_u32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x05,0x06,0x03]

v_add_lshl_u32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x05,0xc2,0x03]

v_add_lshl_u32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x05,0xde,0x03]

v_add_nc_i16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x01,0x05,0x02,0x00]

v_add_nc_i16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x0d,0xd7,0x01,0x05,0x02,0x00]

v_add_nc_i16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0xff,0x05,0x02,0x00]

v_add_nc_i16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x01,0x04,0x02,0x00]

v_add_nc_i16 v5, s101, v2
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x65,0x04,0x02,0x00]

v_add_nc_i16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x6a,0x04,0x02,0x00]

v_add_nc_i16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x6b,0x04,0x02,0x00]

v_add_nc_i16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x7d,0x04,0x02,0x00]

v_add_nc_i16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x7e,0x04,0x02,0x00]

v_add_nc_i16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x7f,0x04,0x02,0x00]

v_add_nc_i16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x80,0x04,0x02,0x00]

v_add_nc_i16 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0xc1,0x04,0x02,0x00]

v_add_nc_i16 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_add_nc_i16 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_add_nc_i16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x01,0xff,0x03,0x00]

v_add_nc_i16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x01,0x05,0x00,0x00]

v_add_nc_i16 v5, v1, s101
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x01,0xcb,0x00,0x00]

v_add_nc_i16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x01,0xd5,0x00,0x00]

v_add_nc_i16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x01,0xd7,0x00,0x00]

v_add_nc_i16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x01,0xfb,0x00,0x00]

v_add_nc_i16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x01,0xfd,0x00,0x00]

v_add_nc_i16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x01,0xff,0x00,0x00]

v_add_nc_i16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x01,0x01,0x01,0x00]

v_add_nc_i16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x01,0x83,0x01,0x00]

v_add_nc_i32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x01,0x05,0x02,0x00]

v_add_nc_i32 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x26,0xd7,0x01,0x05,0x02,0x00]

v_add_nc_i32 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0xff,0x05,0x02,0x00]

v_add_nc_i32 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x01,0x04,0x02,0x00]

v_add_nc_i32 v5, s103, v2
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x67,0x04,0x02,0x00]

v_add_nc_i32 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x6a,0x04,0x02,0x00]

v_add_nc_i32 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x6b,0x04,0x02,0x00]

v_add_nc_i32 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x7d,0x04,0x02,0x00]

v_add_nc_i32 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x7e,0x04,0x02,0x00]

v_add_nc_i32 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x7f,0x04,0x02,0x00]

v_add_nc_i32 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x80,0x04,0x02,0x00]

v_add_nc_i32 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0xc1,0x04,0x02,0x00]

v_add_nc_i32 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0xf0,0x04,0x02,0x00]

v_add_nc_i32 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0xf7,0x04,0x02,0x00]

v_add_nc_i32 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x01,0xff,0x03,0x00]

v_add_nc_i32 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x01,0x05,0x00,0x00]

v_add_nc_i32 v5, v1, s103
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x01,0xcf,0x00,0x00]

v_add_nc_i32 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x01,0xd5,0x00,0x00]

v_add_nc_i32 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x01,0xd7,0x00,0x00]

v_add_nc_i32 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x01,0xfb,0x00,0x00]

v_add_nc_i32 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x01,0xfd,0x00,0x00]

v_add_nc_i32 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x01,0xff,0x00,0x00]

v_add_nc_i32 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x01,0x01,0x01,0x00]

v_add_nc_i32 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x01,0x83,0x01,0x00]

v_add_nc_i32 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x01,0xe1,0x01,0x00]

v_add_nc_i32 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x01,0xef,0x01,0x00]

v_add_nc_i32 v5, v1, -4.0 clamp
// GFX11: encoding: [0x05,0x80,0x26,0xd7,0x01,0xef,0x01,0x00]

v_add_nc_i32 v5, ttmp11, v2
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x77,0x04,0x02,0x00]

v_add_nc_i32 v5, v1, ttmp11
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x01,0xef,0x00,0x00]

v_add_nc_u16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x01,0x05,0x02,0x00]

v_add_nc_u16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x03,0xd7,0x01,0x05,0x02,0x00]

v_add_nc_u16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0xff,0x05,0x02,0x00]

v_add_nc_u16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x01,0x04,0x02,0x00]

v_add_nc_u16 v5, s101, v2
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x65,0x04,0x02,0x00]

v_add_nc_u16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x6a,0x04,0x02,0x00]

v_add_nc_u16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x6b,0x04,0x02,0x00]

v_add_nc_u16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x7d,0x04,0x02,0x00]

v_add_nc_u16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x7e,0x04,0x02,0x00]

v_add_nc_u16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x7f,0x04,0x02,0x00]

v_add_nc_u16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x80,0x04,0x02,0x00]

v_add_nc_u16 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0xc1,0x04,0x02,0x00]

v_add_nc_u16 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_add_nc_u16 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_add_nc_u16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x01,0xff,0x03,0x00]

v_add_nc_u16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x01,0x05,0x00,0x00]

v_add_nc_u16 v5, v1, s101
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x01,0xcb,0x00,0x00]

v_add_nc_u16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x01,0xd5,0x00,0x00]

v_add_nc_u16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x01,0xd7,0x00,0x00]

v_add_nc_u16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x01,0xfb,0x00,0x00]

v_add_nc_u16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x01,0xfd,0x00,0x00]

v_add_nc_u16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x01,0xff,0x00,0x00]

v_add_nc_u16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x01,0x01,0x01,0x00]

v_add_nc_u16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x01,0x83,0x01,0x00]

v_add_nc_u16 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_add_nc_u16 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_add_nc_u16 v5, v1, -4.0 clamp
// GFX11: encoding: [0x05,0x80,0x03,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_alignbit_b32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0x05,0x0e,0x04]

v_alignbit_b32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x16,0xd6,0x01,0x05,0x0e,0x04]

v_alignbit_b32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0xff,0x05,0x0e,0x04]

v_alignbit_b32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0x04,0x0e,0x04]

v_alignbit_b32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x67,0x04,0x0e,0x04]

v_alignbit_b32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x6a,0x04,0x0e,0x04]

v_alignbit_b32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x6b,0x04,0x0e,0x04]

v_alignbit_b32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x7d,0x04,0x0e,0x04]

v_alignbit_b32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x7e,0x04,0x0e,0x04]

v_alignbit_b32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x7f,0x04,0x0e,0x04]

v_alignbit_b32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0xff,0x0f,0x04]

v_alignbit_b32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0x05,0x0c,0x04]

v_alignbit_b32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0xcf,0x0c,0x04]

v_alignbit_b32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0xd5,0x0c,0x04]

v_alignbit_b32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0xd7,0x0c,0x04]

v_alignbit_b32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0xfb,0x0c,0x04]

v_alignbit_b32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0xfd,0x0c,0x04]

v_alignbit_b32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0xff,0x0c,0x04]

v_alignbit_b32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0x05,0xfe,0x07]

v_alignbit_b32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0x05,0x0e,0x00]

v_alignbit_b32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0x05,0x9e,0x01]

v_alignbit_b32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0x05,0xaa,0x01]

v_alignbit_b32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0x05,0xae,0x01]

v_alignbit_b32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0x05,0xf6,0x01]

v_alignbit_b32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0x05,0xfa,0x01]

v_alignbit_b32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0x05,0xfe,0x01]

v_alignbit_b32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x77,0x04,0x0e,0x04]

v_alignbit_b32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0xef,0x0c,0x04]

v_alignbit_b32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0x05,0xde,0x01]

v_alignbyte_b32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0x05,0x0e,0x04]

v_alignbyte_b32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x17,0xd6,0x01,0x05,0x0e,0x04]

v_alignbyte_b32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0xff,0x05,0x0e,0x04]

v_alignbyte_b32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0x04,0x0e,0x04]

v_alignbyte_b32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x67,0x04,0x0e,0x04]

v_alignbyte_b32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x6a,0x04,0x0e,0x04]

v_alignbyte_b32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x6b,0x04,0x0e,0x04]

v_alignbyte_b32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x7d,0x04,0x0e,0x04]

v_alignbyte_b32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x7e,0x04,0x0e,0x04]

v_alignbyte_b32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x7f,0x04,0x0e,0x04]

v_alignbyte_b32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0xff,0x0f,0x04]

v_alignbyte_b32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0x05,0x0c,0x04]

v_alignbyte_b32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0xcf,0x0c,0x04]

v_alignbyte_b32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0xd5,0x0c,0x04]

v_alignbyte_b32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0xd7,0x0c,0x04]

v_alignbyte_b32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0xfb,0x0c,0x04]

v_alignbyte_b32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0xfd,0x0c,0x04]

v_alignbyte_b32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0xff,0x0c,0x04]

v_alignbyte_b32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0x05,0xfe,0x07]

v_alignbyte_b32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0x05,0x0e,0x00]

v_alignbyte_b32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0x05,0x9e,0x01]

v_alignbyte_b32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0x05,0xaa,0x01]

v_alignbyte_b32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0x05,0xae,0x01]

v_alignbyte_b32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0x05,0xf6,0x01]

v_alignbyte_b32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0x05,0xfa,0x01]

v_alignbyte_b32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0x05,0xfe,0x01]

v_alignbyte_b32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x77,0x04,0x0e,0x04]

v_alignbyte_b32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0xef,0x0c,0x04]

v_alignbyte_b32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0x05,0xde,0x01]

v_and_or_b32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x05,0x0e,0x04]

v_and_or_b32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x57,0xd6,0x01,0x05,0x0e,0x04]

v_and_or_b32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0xff,0x05,0x0e,0x04]

v_and_or_b32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x04,0x0e,0x04]

v_and_or_b32 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x65,0x04,0x0e,0x04]

v_and_or_b32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x6a,0x04,0x0e,0x04]

v_and_or_b32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x6b,0x04,0x0e,0x04]

v_and_or_b32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x7d,0x04,0x0e,0x04]

v_and_or_b32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x7e,0x04,0x0e,0x04]

v_and_or_b32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x7f,0x04,0x0e,0x04]

v_and_or_b32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x80,0x04,0x0e,0x04]

v_and_or_b32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0xc1,0x04,0x0e,0x04]

v_and_or_b32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0xf0,0x04,0x0e,0x04]

v_and_or_b32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0xf7,0x04,0x0e,0x04]

v_and_or_b32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0xff,0x0f,0x04]

v_and_or_b32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x05,0x0c,0x04]

v_and_or_b32 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0xcb,0x0c,0x04]

v_and_or_b32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0xd5,0x0c,0x04]

v_and_or_b32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0xd7,0x0c,0x04]

v_and_or_b32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0xfb,0x0c,0x04]

v_and_or_b32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0xfd,0x0c,0x04]

v_and_or_b32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0xff,0x0c,0x04]

v_and_or_b32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x01,0x0d,0x04]

v_and_or_b32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x83,0x0d,0x04]

v_and_or_b32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0xe1,0x0d,0x04]

v_and_or_b32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0xef,0x0d,0x04]

v_and_or_b32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x05,0xfe,0x07]

v_and_or_b32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x05,0x0e,0x00]

v_and_or_b32 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x05,0x96,0x01]

v_and_or_b32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x05,0xaa,0x01]

v_and_or_b32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x05,0xae,0x01]

v_and_or_b32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x05,0xf6,0x01]

v_and_or_b32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x05,0xfa,0x01]

v_and_or_b32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x05,0xfe,0x01]

v_and_or_b32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x05,0x02,0x02]

v_and_or_b32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x05,0x06,0x03]

v_and_or_b32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x05,0xc2,0x03]

v_and_or_b32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x05,0xde,0x03]

v_ashrrev_i16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x01,0x05,0x02,0x00]

v_ashrrev_i16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x3a,0xd7,0x01,0x05,0x02,0x00]

v_ashrrev_i16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0xff,0x05,0x02,0x00]

v_ashrrev_i16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x01,0x04,0x02,0x00]

v_ashrrev_i16 v5, s101, v2
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x65,0x04,0x02,0x00]

v_ashrrev_i16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x6a,0x04,0x02,0x00]

v_ashrrev_i16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x6b,0x04,0x02,0x00]

v_ashrrev_i16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x7d,0x04,0x02,0x00]

v_ashrrev_i16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x7e,0x04,0x02,0x00]

v_ashrrev_i16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x7f,0x04,0x02,0x00]

v_ashrrev_i16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x80,0x04,0x02,0x00]

v_ashrrev_i16 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0xc1,0x04,0x02,0x00]

v_ashrrev_i16 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_ashrrev_i16 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_ashrrev_i16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x01,0xff,0x03,0x00]

v_ashrrev_i16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x01,0x05,0x00,0x00]

v_ashrrev_i16 v5, v1, s101
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x01,0xcb,0x00,0x00]

v_ashrrev_i16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x01,0xd5,0x00,0x00]

v_ashrrev_i16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x01,0xd7,0x00,0x00]

v_ashrrev_i16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x01,0xfb,0x00,0x00]

v_ashrrev_i16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x01,0xfd,0x00,0x00]

v_ashrrev_i16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x01,0xff,0x00,0x00]

v_ashrrev_i16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x01,0x01,0x01,0x00]

v_ashrrev_i16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x01,0x83,0x01,0x00]

v_ashrrev_i16 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_ashrrev_i16 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x01,0x05,0x02,0x00]

v_ashrrev_i64 v[254:255], v1, v[2:3]
// GFX11: encoding: [0xfe,0x00,0x3e,0xd7,0x01,0x05,0x02,0x00]

v_ashrrev_i64 v[5:6], v255, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0xff,0x05,0x02,0x00]

v_ashrrev_i64 v[5:6], s1, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x01,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], s101, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x65,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], vcc_lo, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x6a,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], vcc_hi, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x6b,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], m0, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x7d,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], exec_lo, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x7e,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], exec_hi, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x7f,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], 0, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x80,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], -1, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0xc1,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], 0.5, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0xf0,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], -4.0, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0xf7,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], v1, v[254:255]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x01,0xfd,0x03,0x00]

v_ashrrev_i64 v[5:6], v1, s[4:5]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x01,0x09,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, s[6:7]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x01,0x0d,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, s[100:101]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x01,0xc9,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, vcc
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x01,0xd5,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, exec
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x01,0xfd,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, 0
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x01,0x01,0x01,0x00]

v_ashrrev_i64 v[5:6], v1, -1
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x01,0x83,0x01,0x00]

v_ashrrev_i64 v[5:6], v1, 0.5
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x01,0xe1,0x01,0x00]

v_ashrrev_i64 v[5:6], v1, -4.0
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x01,0xef,0x01,0x00]

v_bcnt_u32_b32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x01,0x05,0x02,0x00]

v_bcnt_u32_b32 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x1e,0xd7,0x01,0x05,0x02,0x00]

v_bcnt_u32_b32 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0xff,0x05,0x02,0x00]

v_bcnt_u32_b32 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x01,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, s103, v2
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x67,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x6a,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x6b,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x7d,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x7e,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x7f,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x80,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0xc1,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0xf0,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0xf7,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x01,0xff,0x03,0x00]

v_bcnt_u32_b32 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x01,0x05,0x00,0x00]

v_bcnt_u32_b32 v5, v1, s103
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x01,0xcf,0x00,0x00]

v_bcnt_u32_b32 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x01,0xd5,0x00,0x00]

v_bcnt_u32_b32 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x01,0xd7,0x00,0x00]

v_bcnt_u32_b32 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x01,0xfb,0x00,0x00]

v_bcnt_u32_b32 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x01,0xfd,0x00,0x00]

v_bcnt_u32_b32 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x01,0xff,0x00,0x00]

v_bcnt_u32_b32 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x01,0x01,0x01,0x00]

v_bcnt_u32_b32 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x01,0x83,0x01,0x00]

v_bcnt_u32_b32 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x01,0xe1,0x01,0x00]

v_bcnt_u32_b32 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x01,0xef,0x01,0x00]

v_bcnt_u32_b32 v5, ttmp11, v2
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x77,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, v1, ttmp11
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x01,0xef,0x00,0x00]

v_bfe_i32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x05,0x0e,0x04]

v_bfe_i32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x11,0xd6,0x01,0x05,0x0e,0x04]

v_bfe_i32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0xff,0x05,0x0e,0x04]

v_bfe_i32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x04,0x0e,0x04]

v_bfe_i32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x67,0x04,0x0e,0x04]

v_bfe_i32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x6a,0x04,0x0e,0x04]

v_bfe_i32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x6b,0x04,0x0e,0x04]

v_bfe_i32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x7d,0x04,0x0e,0x04]

v_bfe_i32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x7e,0x04,0x0e,0x04]

v_bfe_i32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x7f,0x04,0x0e,0x04]

v_bfe_i32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x80,0x04,0x0e,0x04]

v_bfe_i32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0xc1,0x04,0x0e,0x04]

v_bfe_i32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0xf0,0x04,0x0e,0x04]

v_bfe_i32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0xf7,0x04,0x0e,0x04]

v_bfe_i32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0xff,0x0f,0x04]

v_bfe_i32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x05,0x0c,0x04]

v_bfe_i32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0xcf,0x0c,0x04]

v_bfe_i32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0xd5,0x0c,0x04]

v_bfe_i32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0xd7,0x0c,0x04]

v_bfe_i32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0xfb,0x0c,0x04]

v_bfe_i32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0xfd,0x0c,0x04]

v_bfe_i32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0xff,0x0c,0x04]

v_bfe_i32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x01,0x0d,0x04]

v_bfe_i32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x83,0x0d,0x04]

v_bfe_i32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0xe1,0x0d,0x04]

v_bfe_i32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0xef,0x0d,0x04]

v_bfe_i32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x05,0xfe,0x07]

v_bfe_i32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x05,0x0e,0x00]

v_bfe_i32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x05,0x9e,0x01]

v_bfe_i32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x05,0xaa,0x01]

v_bfe_i32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x05,0xae,0x01]

v_bfe_i32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x05,0xf6,0x01]

v_bfe_i32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x05,0xfa,0x01]

v_bfe_i32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x05,0xfe,0x01]

v_bfe_i32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x05,0x02,0x02]

v_bfe_i32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x05,0x06,0x03]

v_bfe_i32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x05,0xc2,0x03]

v_bfe_i32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x05,0xde,0x03]

v_bfe_i32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x77,0x04,0x0e,0x04]

v_bfe_i32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0xef,0x0c,0x04]

v_bfe_i32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x05,0xde,0x01]

v_bfe_u32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x05,0x0e,0x04]

v_bfe_u32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x10,0xd6,0x01,0x05,0x0e,0x04]

v_bfe_u32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0xff,0x05,0x0e,0x04]

v_bfe_u32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x04,0x0e,0x04]

v_bfe_u32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x67,0x04,0x0e,0x04]

v_bfe_u32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x6a,0x04,0x0e,0x04]

v_bfe_u32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x6b,0x04,0x0e,0x04]

v_bfe_u32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x7d,0x04,0x0e,0x04]

v_bfe_u32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x7e,0x04,0x0e,0x04]

v_bfe_u32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x7f,0x04,0x0e,0x04]

v_bfe_u32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x80,0x04,0x0e,0x04]

v_bfe_u32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0xc1,0x04,0x0e,0x04]

v_bfe_u32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0xf0,0x04,0x0e,0x04]

v_bfe_u32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0xf7,0x04,0x0e,0x04]

v_bfe_u32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0xff,0x0f,0x04]

v_bfe_u32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x05,0x0c,0x04]

v_bfe_u32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0xcf,0x0c,0x04]

v_bfe_u32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0xd5,0x0c,0x04]

v_bfe_u32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0xd7,0x0c,0x04]

v_bfe_u32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0xfb,0x0c,0x04]

v_bfe_u32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0xfd,0x0c,0x04]

v_bfe_u32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0xff,0x0c,0x04]

v_bfe_u32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x01,0x0d,0x04]

v_bfe_u32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x83,0x0d,0x04]

v_bfe_u32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0xe1,0x0d,0x04]

v_bfe_u32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0xef,0x0d,0x04]

v_bfe_u32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x05,0xfe,0x07]

v_bfe_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x05,0x0e,0x00]

v_bfe_u32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x05,0x9e,0x01]

v_bfe_u32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x05,0xaa,0x01]

v_bfe_u32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x05,0xae,0x01]

v_bfe_u32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x05,0xf6,0x01]

v_bfe_u32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x05,0xfa,0x01]

v_bfe_u32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x05,0xfe,0x01]

v_bfe_u32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x05,0x02,0x02]

v_bfe_u32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x05,0x06,0x03]

v_bfe_u32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x05,0xc2,0x03]

v_bfe_u32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x05,0xde,0x03]

v_bfe_u32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x77,0x04,0x0e,0x04]

v_bfe_u32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0xef,0x0c,0x04]

v_bfe_u32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x05,0xde,0x01]

v_bfi_b32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x05,0x0e,0x04]

v_bfi_b32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x12,0xd6,0x01,0x05,0x0e,0x04]

v_bfi_b32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0xff,0x05,0x0e,0x04]

v_bfi_b32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x04,0x0e,0x04]

v_bfi_b32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x67,0x04,0x0e,0x04]

v_bfi_b32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x6a,0x04,0x0e,0x04]

v_bfi_b32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x6b,0x04,0x0e,0x04]

v_bfi_b32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x7d,0x04,0x0e,0x04]

v_bfi_b32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x7e,0x04,0x0e,0x04]

v_bfi_b32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x7f,0x04,0x0e,0x04]

v_bfi_b32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x80,0x04,0x0e,0x04]

v_bfi_b32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0xc1,0x04,0x0e,0x04]

v_bfi_b32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0xf0,0x04,0x0e,0x04]

v_bfi_b32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0xf7,0x04,0x0e,0x04]

v_bfi_b32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0xff,0x0f,0x04]

v_bfi_b32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x05,0x0c,0x04]

v_bfi_b32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0xcf,0x0c,0x04]

v_bfi_b32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0xd5,0x0c,0x04]

v_bfi_b32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0xd7,0x0c,0x04]

v_bfi_b32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0xfb,0x0c,0x04]

v_bfi_b32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0xfd,0x0c,0x04]

v_bfi_b32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0xff,0x0c,0x04]

v_bfi_b32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x01,0x0d,0x04]

v_bfi_b32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x83,0x0d,0x04]

v_bfi_b32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0xe1,0x0d,0x04]

v_bfi_b32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0xef,0x0d,0x04]

v_bfi_b32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x05,0xfe,0x07]

v_bfi_b32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x05,0x0e,0x00]

v_bfi_b32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x05,0x9e,0x01]

v_bfi_b32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x05,0xaa,0x01]

v_bfi_b32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x05,0xae,0x01]

v_bfi_b32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x05,0xf6,0x01]

v_bfi_b32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x05,0xfa,0x01]

v_bfi_b32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x05,0xfe,0x01]

v_bfi_b32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x05,0x02,0x02]

v_bfi_b32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x05,0x06,0x03]

v_bfi_b32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x05,0xc2,0x03]

v_bfi_b32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x05,0xde,0x03]

v_bfi_b32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x77,0x04,0x0e,0x04]

v_bfi_b32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0xef,0x0c,0x04]

v_bfi_b32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x05,0xde,0x01]

v_bfm_b32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x01,0x05,0x02,0x00]

v_bfm_b32 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x1d,0xd7,0x01,0x05,0x02,0x00]

v_bfm_b32 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0xff,0x05,0x02,0x00]

v_bfm_b32 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x01,0x04,0x02,0x00]

v_bfm_b32 v5, s103, v2
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x67,0x04,0x02,0x00]

v_bfm_b32 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x6a,0x04,0x02,0x00]

v_bfm_b32 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x6b,0x04,0x02,0x00]

v_bfm_b32 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x7d,0x04,0x02,0x00]

v_bfm_b32 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x7e,0x04,0x02,0x00]

v_bfm_b32 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x7f,0x04,0x02,0x00]

v_bfm_b32 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x80,0x04,0x02,0x00]

v_bfm_b32 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0xc1,0x04,0x02,0x00]

v_bfm_b32 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0xf0,0x04,0x02,0x00]

v_bfm_b32 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0xf7,0x04,0x02,0x00]

v_bfm_b32 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x01,0xff,0x03,0x00]

v_bfm_b32 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x01,0x05,0x00,0x00]

v_bfm_b32 v5, v1, s103
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x01,0xcf,0x00,0x00]

v_bfm_b32 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x01,0xd5,0x00,0x00]

v_bfm_b32 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x01,0xd7,0x00,0x00]

v_bfm_b32 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x01,0xfb,0x00,0x00]

v_bfm_b32 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x01,0xfd,0x00,0x00]

v_bfm_b32 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x01,0xff,0x00,0x00]

v_bfm_b32 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x01,0x01,0x01,0x00]

v_bfm_b32 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x01,0x83,0x01,0x00]

v_bfm_b32 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x01,0xe1,0x01,0x00]

v_bfm_b32 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x01,0xef,0x01,0x00]

v_bfm_b32 v5, ttmp11, v2
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x77,0x04,0x02,0x00]

v_bfm_b32 v5, v1, ttmp11
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x01,0xef,0x00,0x00]

v_bfrev_b32 v5, v1
// GFX11: encoding: [0x01,0x71,0x0a,0x7e]

v_bfrev_b32 v255, v1
// GFX11: encoding: [0x01,0x71,0xfe,0x7f]

v_bfrev_b32 v5, v255
// GFX11: encoding: [0xff,0x71,0x0a,0x7e]

v_bfrev_b32 v5, s1
// GFX11: encoding: [0x01,0x70,0x0a,0x7e]

v_bfrev_b32 v5, s103
// GFX11: encoding: [0x67,0x70,0x0a,0x7e]

v_bfrev_b32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x70,0x0a,0x7e]

v_bfrev_b32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x70,0x0a,0x7e]

v_bfrev_b32 v5, m0
// GFX11: encoding: [0x7d,0x70,0x0a,0x7e]

v_bfrev_b32 v5, exec_lo
// GFX11: encoding: [0x7e,0x70,0x0a,0x7e]

v_bfrev_b32 v5, exec_hi
// GFX11: encoding: [0x7f,0x70,0x0a,0x7e]

v_bfrev_b32 v5, 0
// GFX11: encoding: [0x80,0x70,0x0a,0x7e]

v_bfrev_b32 v5, -1
// GFX11: encoding: [0xc1,0x70,0x0a,0x7e]

v_bfrev_b32 v5, 0.5
// GFX11: encoding: [0xf0,0x70,0x0a,0x7e]

v_bfrev_b32 v5, -4.0
// GFX11: encoding: [0xf7,0x70,0x0a,0x7e]

v_bfrev_b32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x70,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_bfrev_b32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x70,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_bfrev_b32 v5, ttmp11
// GFX11: encoding: [0x77,0x70,0x0a,0x7e]

v_ceil_f32 v5, v1
// GFX11: encoding: [0x01,0x45,0x0a,0x7e]

v_ceil_f32 v255, v1
// GFX11: encoding: [0x01,0x45,0xfe,0x7f]

v_ceil_f32 v5, v255
// GFX11: encoding: [0xff,0x45,0x0a,0x7e]

v_ceil_f32 v5, s1
// GFX11: encoding: [0x01,0x44,0x0a,0x7e]

v_ceil_f32 v5, s103
// GFX11: encoding: [0x67,0x44,0x0a,0x7e]

v_ceil_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x44,0x0a,0x7e]

v_ceil_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x44,0x0a,0x7e]

v_ceil_f32 v5, m0
// GFX11: encoding: [0x7d,0x44,0x0a,0x7e]

v_ceil_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x44,0x0a,0x7e]

v_ceil_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x44,0x0a,0x7e]

v_ceil_f32 v5, 0
// GFX11: encoding: [0x80,0x44,0x0a,0x7e]

v_ceil_f32 v5, -1
// GFX11: encoding: [0xc1,0x44,0x0a,0x7e]

v_ceil_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x44,0x0a,0x7e]

v_ceil_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x44,0x0a,0x7e]

v_ceil_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x44,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ceil_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x44,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ceil_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x44,0x0a,0x7e]

v_ceil_f64 v[5:6], v[1:2]
// GFX11: encoding: [0x01,0x31,0x0a,0x7e]

v_ceil_f64 v[254:255], v[1:2]
// GFX11: encoding: [0x01,0x31,0xfc,0x7f]

v_ceil_f64 v[5:6], v[254:255]
// GFX11: encoding: [0xfe,0x31,0x0a,0x7e]

v_ceil_f64 v[5:6], s[2:3]
// GFX11: encoding: [0x02,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], s[4:5]
// GFX11: encoding: [0x04,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], s[102:103]
// GFX11: encoding: [0x66,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], vcc
// GFX11: encoding: [0x6a,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], exec
// GFX11: encoding: [0x7e,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], 0
// GFX11: encoding: [0x80,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], -1
// GFX11: encoding: [0xc1,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], 0.5
// GFX11: encoding: [0xf0,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], -4.0
// GFX11: encoding: [0xf7,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], 0xaf123456
// GFX11: encoding: [0xff,0x30,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ceil_f64 v[5:6], 0x3f717273
// GFX11: encoding: [0xff,0x30,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cos_f32 v5, v1
// GFX11: encoding: [0x01,0x6d,0x0a,0x7e]

v_cos_f32 v255, v1
// GFX11: encoding: [0x01,0x6d,0xfe,0x7f]

v_cos_f32 v5, v255
// GFX11: encoding: [0xff,0x6d,0x0a,0x7e]

v_cos_f32 v5, s1
// GFX11: encoding: [0x01,0x6c,0x0a,0x7e]

v_cos_f32 v5, s103
// GFX11: encoding: [0x67,0x6c,0x0a,0x7e]

v_cos_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x6c,0x0a,0x7e]

v_cos_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x6c,0x0a,0x7e]

v_cos_f32 v5, m0
// GFX11: encoding: [0x7d,0x6c,0x0a,0x7e]

v_cos_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x6c,0x0a,0x7e]

v_cos_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x6c,0x0a,0x7e]

v_cos_f32 v5, 0
// GFX11: encoding: [0x80,0x6c,0x0a,0x7e]

v_cos_f32 v5, -1
// GFX11: encoding: [0xc1,0x6c,0x0a,0x7e]

v_cos_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x6c,0x0a,0x7e]

v_cos_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x6c,0x0a,0x7e]

v_cos_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x6c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cos_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x6c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cos_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x6c,0x0a,0x7e]

v_cubeid_f32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x0c,0xd6,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0xff,0x05,0x0e,0x04]

v_cubeid_f32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x04,0x0e,0x04]

v_cubeid_f32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x67,0x04,0x0e,0x04]

v_cubeid_f32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x6a,0x04,0x0e,0x04]

v_cubeid_f32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x6b,0x04,0x0e,0x04]

v_cubeid_f32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x7d,0x04,0x0e,0x04]

v_cubeid_f32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x7e,0x04,0x0e,0x04]

v_cubeid_f32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x7f,0x04,0x0e,0x04]

v_cubeid_f32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x80,0x04,0x0e,0x04]

v_cubeid_f32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0xc1,0x04,0x0e,0x04]

v_cubeid_f32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0xf0,0x04,0x0e,0x04]

v_cubeid_f32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0xf7,0x04,0x0e,0x04]

v_cubeid_f32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0xff,0x0f,0x04]

v_cubeid_f32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0x0c,0x04]

v_cubeid_f32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0xcf,0x0c,0x04]

v_cubeid_f32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0xd5,0x0c,0x04]

v_cubeid_f32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0xd7,0x0c,0x04]

v_cubeid_f32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0xfb,0x0c,0x04]

v_cubeid_f32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0xfd,0x0c,0x04]

v_cubeid_f32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0xff,0x0c,0x04]

v_cubeid_f32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x01,0x0d,0x04]

v_cubeid_f32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x83,0x0d,0x04]

v_cubeid_f32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0xe1,0x0d,0x04]

v_cubeid_f32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0xef,0x0d,0x04]

v_cubeid_f32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0xfe,0x07]

v_cubeid_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0x0e,0x00]

v_cubeid_f32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0x9e,0x01]

v_cubeid_f32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0xaa,0x01]

v_cubeid_f32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0xae,0x01]

v_cubeid_f32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0xf6,0x01]

v_cubeid_f32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0xfa,0x01]

v_cubeid_f32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0xfe,0x01]

v_cubeid_f32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0x02,0x02]

v_cubeid_f32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0x06,0x03]

v_cubeid_f32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0xc2,0x03]

v_cubeid_f32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0xde,0x03]

v_cubeid_f32 v5, -v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0x0e,0x24]

v_cubeid_f32 v5, v1, -v2, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0x0e,0x44]

v_cubeid_f32 v5, v1, v2, -v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0x0e,0x84]

v_cubeid_f32 v5, -v1, -v2, -v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0x0e,0xe4]

v_cubeid_f32 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x0c,0xd6,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v5, v1, v2, v3 mul:2
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0x0e,0x0c]

v_cubeid_f32 v5, v1, v2, v3 mul:4
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0x0e,0x14]

v_cubeid_f32 v5, v1, v2, v3 div:2
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0x0e,0x1c]

v_cubeid_f32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x77,0x04,0x0e,0x04]

v_cubeid_f32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0xef,0x0c,0x04]

v_cubeid_f32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0xde,0x01]

v_cubema_f32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0x0e,0x04]

v_cubema_f32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x0f,0xd6,0x01,0x05,0x0e,0x04]

v_cubema_f32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0xff,0x05,0x0e,0x04]

v_cubema_f32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x04,0x0e,0x04]

v_cubema_f32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x67,0x04,0x0e,0x04]

v_cubema_f32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x6a,0x04,0x0e,0x04]

v_cubema_f32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x6b,0x04,0x0e,0x04]

v_cubema_f32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x7d,0x04,0x0e,0x04]

v_cubema_f32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x7e,0x04,0x0e,0x04]

v_cubema_f32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x7f,0x04,0x0e,0x04]

v_cubema_f32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x80,0x04,0x0e,0x04]

v_cubema_f32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0xc1,0x04,0x0e,0x04]

v_cubema_f32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0xf0,0x04,0x0e,0x04]

v_cubema_f32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0xf7,0x04,0x0e,0x04]

v_cubema_f32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0xff,0x0f,0x04]

v_cubema_f32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0x0c,0x04]

v_cubema_f32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0xcf,0x0c,0x04]

v_cubema_f32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0xd5,0x0c,0x04]

v_cubema_f32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0xd7,0x0c,0x04]

v_cubema_f32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0xfb,0x0c,0x04]

v_cubema_f32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0xfd,0x0c,0x04]

v_cubema_f32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0xff,0x0c,0x04]

v_cubema_f32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x01,0x0d,0x04]

v_cubema_f32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x83,0x0d,0x04]

v_cubema_f32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0xe1,0x0d,0x04]

v_cubema_f32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0xef,0x0d,0x04]

v_cubema_f32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0xfe,0x07]

v_cubema_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0x0e,0x00]

v_cubema_f32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0x9e,0x01]

v_cubema_f32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0xaa,0x01]

v_cubema_f32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0xae,0x01]

v_cubema_f32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0xf6,0x01]

v_cubema_f32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0xfa,0x01]

v_cubema_f32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0xfe,0x01]

v_cubema_f32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0x02,0x02]

v_cubema_f32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0x06,0x03]

v_cubema_f32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0xc2,0x03]

v_cubema_f32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0xde,0x03]

v_cubema_f32 v5, -v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0x0e,0x24]

v_cubema_f32 v5, v1, -v2, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0x0e,0x44]

v_cubema_f32 v5, v1, v2, -v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0x0e,0x84]

v_cubema_f32 v5, -v1, -v2, -v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0x0e,0xe4]

v_cubema_f32 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x0f,0xd6,0x01,0x05,0x0e,0x04]

v_cubema_f32 v5, v1, v2, v3 mul:2
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0x0e,0x0c]

v_cubema_f32 v5, v1, v2, v3 mul:4
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0x0e,0x14]

v_cubema_f32 v5, v1, v2, v3 div:2
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0x0e,0x1c]

v_cubema_f32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x77,0x04,0x0e,0x04]

v_cubema_f32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0xef,0x0c,0x04]

v_cubema_f32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0xde,0x01]

v_cubesc_f32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0x0e,0x04]

v_cubesc_f32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x0d,0xd6,0x01,0x05,0x0e,0x04]

v_cubesc_f32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0xff,0x05,0x0e,0x04]

v_cubesc_f32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x04,0x0e,0x04]

v_cubesc_f32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x67,0x04,0x0e,0x04]

v_cubesc_f32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x6a,0x04,0x0e,0x04]

v_cubesc_f32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x6b,0x04,0x0e,0x04]

v_cubesc_f32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x7d,0x04,0x0e,0x04]

v_cubesc_f32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x7e,0x04,0x0e,0x04]

v_cubesc_f32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x7f,0x04,0x0e,0x04]

v_cubesc_f32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x80,0x04,0x0e,0x04]

v_cubesc_f32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0xc1,0x04,0x0e,0x04]

v_cubesc_f32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0xf0,0x04,0x0e,0x04]

v_cubesc_f32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0xf7,0x04,0x0e,0x04]

v_cubesc_f32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0xff,0x0f,0x04]

v_cubesc_f32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0x0c,0x04]

v_cubesc_f32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0xcf,0x0c,0x04]

v_cubesc_f32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0xd5,0x0c,0x04]

v_cubesc_f32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0xd7,0x0c,0x04]

v_cubesc_f32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0xfb,0x0c,0x04]

v_cubesc_f32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0xfd,0x0c,0x04]

v_cubesc_f32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0xff,0x0c,0x04]

v_cubesc_f32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x01,0x0d,0x04]

v_cubesc_f32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x83,0x0d,0x04]

v_cubesc_f32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0xe1,0x0d,0x04]

v_cubesc_f32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0xef,0x0d,0x04]

v_cubesc_f32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0xfe,0x07]

v_cubesc_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0x0e,0x00]

v_cubesc_f32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0x9e,0x01]

v_cubesc_f32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0xaa,0x01]

v_cubesc_f32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0xae,0x01]

v_cubesc_f32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0xf6,0x01]

v_cubesc_f32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0xfa,0x01]

v_cubesc_f32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0xfe,0x01]

v_cubesc_f32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0x02,0x02]

v_cubesc_f32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0x06,0x03]

v_cubesc_f32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0xc2,0x03]

v_cubesc_f32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0xde,0x03]

v_cubesc_f32 v5, -v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0x0e,0x24]

v_cubesc_f32 v5, v1, -v2, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0x0e,0x44]

v_cubesc_f32 v5, v1, v2, -v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0x0e,0x84]

v_cubesc_f32 v5, -v1, -v2, -v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0x0e,0xe4]

v_cubesc_f32 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x0d,0xd6,0x01,0x05,0x0e,0x04]

v_cubesc_f32 v5, v1, v2, v3 mul:2
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0x0e,0x0c]

v_cubesc_f32 v5, v1, v2, v3 mul:4
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0x0e,0x14]

v_cubesc_f32 v5, v1, v2, v3 div:2
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0x0e,0x1c]

v_cubesc_f32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x77,0x04,0x0e,0x04]

v_cubesc_f32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0xef,0x0c,0x04]

v_cubesc_f32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0xde,0x01]

v_cubetc_f32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0x0e,0x04]

v_cubetc_f32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x0e,0xd6,0x01,0x05,0x0e,0x04]

v_cubetc_f32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0xff,0x05,0x0e,0x04]

v_cubetc_f32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x04,0x0e,0x04]

v_cubetc_f32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x67,0x04,0x0e,0x04]

v_cubetc_f32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x6a,0x04,0x0e,0x04]

v_cubetc_f32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x6b,0x04,0x0e,0x04]

v_cubetc_f32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x7d,0x04,0x0e,0x04]

v_cubetc_f32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x7e,0x04,0x0e,0x04]

v_cubetc_f32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x7f,0x04,0x0e,0x04]

v_cubetc_f32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x80,0x04,0x0e,0x04]

v_cubetc_f32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0xc1,0x04,0x0e,0x04]

v_cubetc_f32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0xf0,0x04,0x0e,0x04]

v_cubetc_f32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0xf7,0x04,0x0e,0x04]

v_cubetc_f32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0xff,0x0f,0x04]

v_cubetc_f32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0x0c,0x04]

v_cubetc_f32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0xcf,0x0c,0x04]

v_cubetc_f32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0xd5,0x0c,0x04]

v_cubetc_f32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0xd7,0x0c,0x04]

v_cubetc_f32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0xfb,0x0c,0x04]

v_cubetc_f32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0xfd,0x0c,0x04]

v_cubetc_f32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0xff,0x0c,0x04]

v_cubetc_f32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x01,0x0d,0x04]

v_cubetc_f32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x83,0x0d,0x04]

v_cubetc_f32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0xe1,0x0d,0x04]

v_cubetc_f32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0xef,0x0d,0x04]

v_cubetc_f32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0xfe,0x07]

v_cubetc_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0x0e,0x00]

v_cubetc_f32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0x9e,0x01]

v_cubetc_f32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0xaa,0x01]

v_cubetc_f32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0xae,0x01]

v_cubetc_f32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0xf6,0x01]

v_cubetc_f32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0xfa,0x01]

v_cubetc_f32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0xfe,0x01]

v_cubetc_f32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0x02,0x02]

v_cubetc_f32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0x06,0x03]

v_cubetc_f32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0xc2,0x03]

v_cubetc_f32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0xde,0x03]

v_cubetc_f32 v5, -v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0x0e,0x24]

v_cubetc_f32 v5, v1, -v2, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0x0e,0x44]

v_cubetc_f32 v5, v1, v2, -v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0x0e,0x84]

v_cubetc_f32 v5, -v1, -v2, -v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0x0e,0xe4]

v_cubetc_f32 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x0e,0xd6,0x01,0x05,0x0e,0x04]

v_cubetc_f32 v5, v1, v2, v3 mul:2
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0x0e,0x0c]

v_cubetc_f32 v5, v1, v2, v3 mul:4
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0x0e,0x14]

v_cubetc_f32 v5, v1, v2, v3 div:2
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0x0e,0x1c]

v_cubetc_f32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x77,0x04,0x0e,0x04]

v_cubetc_f32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0xef,0x0c,0x04]

v_cubetc_f32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0xde,0x01]

v_cvt_f16_f32 v5, v1
// GFX11: encoding: [0x01,0x15,0x0a,0x7e]

v_cvt_f16_f32 v5, v255
// GFX11: encoding: [0xff,0x15,0x0a,0x7e]

v_cvt_f16_f32 v5, s1
// GFX11: encoding: [0x01,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, s103
// GFX11: encoding: [0x67,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, m0
// GFX11: encoding: [0x7d,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, 0
// GFX11: encoding: [0x80,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, -1
// GFX11: encoding: [0xc1,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x14,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f16_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x14,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f16_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x14,0x0a,0x7e]

v_cvt_f32_f16 v5, v1
// GFX11: encoding: [0x01,0x17,0x0a,0x7e]

v_cvt_f32_f16 v255, v1
// GFX11: encoding: [0x01,0x17,0xfe,0x7f]

v_cvt_f32_f16 v5, s1
// GFX11: encoding: [0x01,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, s103
// GFX11: encoding: [0x67,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, vcc_lo
// GFX11: encoding: [0x6a,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, vcc_hi
// GFX11: encoding: [0x6b,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, m0
// GFX11: encoding: [0x7d,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, exec_lo
// GFX11: encoding: [0x7e,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, exec_hi
// GFX11: encoding: [0x7f,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, 0
// GFX11: encoding: [0x80,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, -1
// GFX11: encoding: [0xc1,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, ttmp11
// GFX11: encoding: [0x77,0x16,0x0a,0x7e]

v_cvt_f32_f64 v5, v[1:2]
// GFX11: encoding: [0x01,0x1f,0x0a,0x7e]

v_cvt_f32_f64 v255, v[1:2]
// GFX11: encoding: [0x01,0x1f,0xfe,0x7f]

v_cvt_f32_f64 v5, v[254:255]
// GFX11: encoding: [0xfe,0x1f,0x0a,0x7e]

v_cvt_f32_f64 v5, s[2:3]
// GFX11: encoding: [0x02,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, s[4:5]
// GFX11: encoding: [0x04,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, s[102:103]
// GFX11: encoding: [0x66,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, vcc
// GFX11: encoding: [0x6a,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, exec
// GFX11: encoding: [0x7e,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, 0
// GFX11: encoding: [0x80,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, -1
// GFX11: encoding: [0xc1,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, 0.5
// GFX11: encoding: [0xf0,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, -4.0
// GFX11: encoding: [0xf7,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, 0xaf123456
// GFX11: encoding: [0xff,0x1e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_f64 v5, 0x3f717273
// GFX11: encoding: [0xff,0x1e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte0 v5, v1
// GFX11: encoding: [0x01,0x23,0x0a,0x7e]

v_cvt_f32_ubyte0 v255, v1
// GFX11: encoding: [0x01,0x23,0xfe,0x7f]

v_cvt_f32_ubyte0 v5, v255
// GFX11: encoding: [0xff,0x23,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, s1
// GFX11: encoding: [0x01,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, s103
// GFX11: encoding: [0x67,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, vcc_lo
// GFX11: encoding: [0x6a,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, vcc_hi
// GFX11: encoding: [0x6b,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, m0
// GFX11: encoding: [0x7d,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, exec_lo
// GFX11: encoding: [0x7e,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, exec_hi
// GFX11: encoding: [0x7f,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, 0
// GFX11: encoding: [0x80,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, -1
// GFX11: encoding: [0xc1,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, 0.5
// GFX11: encoding: [0xf0,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, -4.0
// GFX11: encoding: [0xf7,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, 0xaf123456
// GFX11: encoding: [0xff,0x22,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte0 v5, 0x3f717273
// GFX11: encoding: [0xff,0x22,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte0 v5, ttmp11
// GFX11: encoding: [0x77,0x22,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, v1
// GFX11: encoding: [0x01,0x25,0x0a,0x7e]

v_cvt_f32_ubyte1 v255, v1
// GFX11: encoding: [0x01,0x25,0xfe,0x7f]

v_cvt_f32_ubyte1 v5, v255
// GFX11: encoding: [0xff,0x25,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, s1
// GFX11: encoding: [0x01,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, s103
// GFX11: encoding: [0x67,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, vcc_lo
// GFX11: encoding: [0x6a,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, vcc_hi
// GFX11: encoding: [0x6b,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, m0
// GFX11: encoding: [0x7d,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, exec_lo
// GFX11: encoding: [0x7e,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, exec_hi
// GFX11: encoding: [0x7f,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, 0
// GFX11: encoding: [0x80,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, -1
// GFX11: encoding: [0xc1,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, 0.5
// GFX11: encoding: [0xf0,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, -4.0
// GFX11: encoding: [0xf7,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, 0xaf123456
// GFX11: encoding: [0xff,0x24,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte1 v5, 0x3f717273
// GFX11: encoding: [0xff,0x24,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte1 v5, ttmp11
// GFX11: encoding: [0x77,0x24,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, v1
// GFX11: encoding: [0x01,0x27,0x0a,0x7e]

v_cvt_f32_ubyte2 v255, v1
// GFX11: encoding: [0x01,0x27,0xfe,0x7f]

v_cvt_f32_ubyte2 v5, v255
// GFX11: encoding: [0xff,0x27,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, s1
// GFX11: encoding: [0x01,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, s103
// GFX11: encoding: [0x67,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, vcc_lo
// GFX11: encoding: [0x6a,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, vcc_hi
// GFX11: encoding: [0x6b,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, m0
// GFX11: encoding: [0x7d,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, exec_lo
// GFX11: encoding: [0x7e,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, exec_hi
// GFX11: encoding: [0x7f,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, 0
// GFX11: encoding: [0x80,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, -1
// GFX11: encoding: [0xc1,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, 0.5
// GFX11: encoding: [0xf0,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, -4.0
// GFX11: encoding: [0xf7,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, 0xaf123456
// GFX11: encoding: [0xff,0x26,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte2 v5, 0x3f717273
// GFX11: encoding: [0xff,0x26,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte2 v5, ttmp11
// GFX11: encoding: [0x77,0x26,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, v1
// GFX11: encoding: [0x01,0x29,0x0a,0x7e]

v_cvt_f32_ubyte3 v255, v1
// GFX11: encoding: [0x01,0x29,0xfe,0x7f]

v_cvt_f32_ubyte3 v5, v255
// GFX11: encoding: [0xff,0x29,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, s1
// GFX11: encoding: [0x01,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, s103
// GFX11: encoding: [0x67,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, vcc_lo
// GFX11: encoding: [0x6a,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, vcc_hi
// GFX11: encoding: [0x6b,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, m0
// GFX11: encoding: [0x7d,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, exec_lo
// GFX11: encoding: [0x7e,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, exec_hi
// GFX11: encoding: [0x7f,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, 0
// GFX11: encoding: [0x80,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, -1
// GFX11: encoding: [0xc1,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, 0.5
// GFX11: encoding: [0xf0,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, -4.0
// GFX11: encoding: [0xf7,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, 0xaf123456
// GFX11: encoding: [0xff,0x28,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte3 v5, 0x3f717273
// GFX11: encoding: [0xff,0x28,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte3 v5, ttmp11
// GFX11: encoding: [0x77,0x28,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], v1
// GFX11: encoding: [0x01,0x21,0x0a,0x7e]

v_cvt_f64_f32 v[254:255], v1
// GFX11: encoding: [0x01,0x21,0xfc,0x7f]

v_cvt_f64_f32 v[5:6], v255
// GFX11: encoding: [0xff,0x21,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], s1
// GFX11: encoding: [0x01,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], s103
// GFX11: encoding: [0x67,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], vcc_lo
// GFX11: encoding: [0x6a,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], vcc_hi
// GFX11: encoding: [0x6b,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], m0
// GFX11: encoding: [0x7d,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], exec_lo
// GFX11: encoding: [0x7e,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], exec_hi
// GFX11: encoding: [0x7f,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], 0
// GFX11: encoding: [0x80,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], -1
// GFX11: encoding: [0xc1,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], 0.5
// GFX11: encoding: [0xf0,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], -4.0
// GFX11: encoding: [0xf7,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], 0xaf123456
// GFX11: encoding: [0xff,0x20,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f64_f32 v[5:6], 0x3f717273
// GFX11: encoding: [0xff,0x20,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f64_f32 v[5:6], ttmp11
// GFX11: encoding: [0x77,0x20,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], v1
// GFX11: encoding: [0x01,0x2d,0x0a,0x7e]

v_cvt_f64_u32 v[254:255], v1
// GFX11: encoding: [0x01,0x2d,0xfc,0x7f]

v_cvt_f64_u32 v[5:6], v255
// GFX11: encoding: [0xff,0x2d,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], s1
// GFX11: encoding: [0x01,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], s103
// GFX11: encoding: [0x67,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], vcc_lo
// GFX11: encoding: [0x6a,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], vcc_hi
// GFX11: encoding: [0x6b,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], m0
// GFX11: encoding: [0x7d,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], exec_lo
// GFX11: encoding: [0x7e,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], exec_hi
// GFX11: encoding: [0x7f,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], 0
// GFX11: encoding: [0x80,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], -1
// GFX11: encoding: [0xc1,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], 0.5
// GFX11: encoding: [0xf0,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], -4.0
// GFX11: encoding: [0xf7,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], 0xaf123456
// GFX11: encoding: [0xff,0x2c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f64_u32 v[5:6], 0x3f717273
// GFX11: encoding: [0xff,0x2c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f64_u32 v[5:6], ttmp11
// GFX11: encoding: [0x77,0x2c,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, v1
// GFX11: encoding: [0x01,0x1b,0x0a,0x7e]

v_cvt_flr_i32_f32 v255, v1
// GFX11: encoding: [0x01,0x1b,0xfe,0x7f]

v_cvt_flr_i32_f32 v5, v255
// GFX11: encoding: [0xff,0x1b,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, s1
// GFX11: encoding: [0x01,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, s103
// GFX11: encoding: [0x67,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, m0
// GFX11: encoding: [0x7d,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, 0
// GFX11: encoding: [0x80,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, -1
// GFX11: encoding: [0xc1,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x1a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_flr_i32_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x1a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_flr_i32_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x1a,0x0a,0x7e]

v_cvt_off_f32_i4 v5, v1
// GFX11: encoding: [0x01,0x1d,0x0a,0x7e]

v_cvt_off_f32_i4 v255, v1
// GFX11: encoding: [0x01,0x1d,0xfe,0x7f]

v_cvt_off_f32_i4 v5, v255
// GFX11: encoding: [0xff,0x1d,0x0a,0x7e]

v_cvt_off_f32_i4 v5, s1
// GFX11: encoding: [0x01,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, s103
// GFX11: encoding: [0x67,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, vcc_lo
// GFX11: encoding: [0x6a,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, vcc_hi
// GFX11: encoding: [0x6b,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, m0
// GFX11: encoding: [0x7d,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, exec_lo
// GFX11: encoding: [0x7e,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, exec_hi
// GFX11: encoding: [0x7f,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, 0
// GFX11: encoding: [0x80,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, -1
// GFX11: encoding: [0xc1,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, 0.5
// GFX11: encoding: [0xf0,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, -4.0
// GFX11: encoding: [0xf7,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, 0x4f
// GFX11: encoding: [0xff,0x1c,0x0a,0x7e,0x4f,0x00,0x00,0x00]

v_cvt_off_f32_i4 v5, 0x41
// GFX11: encoding: [0xff,0x1c,0x0a,0x7e,0x41,0x00,0x00,0x00]

v_cvt_off_f32_i4 v5, ttmp11
// GFX11: encoding: [0x77,0x1c,0x0a,0x7e]

v_cvt_pk_i16_i32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pk_i16_i32 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x24,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pk_i16_i32 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0xff,0x05,0x02,0x00]

v_cvt_pk_i16_i32 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x01,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, s103, v2
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x67,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x6a,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x6b,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x7d,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x7e,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x7f,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x80,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0xc1,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0xf0,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0xf7,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x01,0xff,0x03,0x00]

v_cvt_pk_i16_i32 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x01,0x05,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, s103
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x01,0xcf,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x01,0xd5,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x01,0xd7,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x01,0xfb,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x01,0xfd,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x01,0xff,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x01,0x01,0x01,0x00]

v_cvt_pk_i16_i32 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x01,0x83,0x01,0x00]

v_cvt_pk_i16_i32 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x01,0xe1,0x01,0x00]

v_cvt_pk_i16_i32 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x01,0xef,0x01,0x00]

v_cvt_pk_i16_i32 v5, ttmp11, v2
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x77,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, v1, ttmp11
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x01,0xef,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pk_u16_u32 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x23,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pk_u16_u32 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0xff,0x05,0x02,0x00]

v_cvt_pk_u16_u32 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x01,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, s103, v2
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x67,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x6a,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x6b,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x7d,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x7e,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x7f,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x80,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0xc1,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0xf0,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0xf7,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x01,0xff,0x03,0x00]

v_cvt_pk_u16_u32 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x01,0x05,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, s103
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x01,0xcf,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x01,0xd5,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x01,0xd7,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x01,0xfb,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x01,0xfd,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x01,0xff,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x01,0x01,0x01,0x00]

v_cvt_pk_u16_u32 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x01,0x83,0x01,0x00]

v_cvt_pk_u16_u32 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x01,0xe1,0x01,0x00]

v_cvt_pk_u16_u32 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x01,0xef,0x01,0x00]

v_cvt_pk_u16_u32 v5, ttmp11, v2
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x77,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, v1, ttmp11
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x01,0xef,0x00,0x00]

v_cvt_pk_u8_f32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x05,0x0e,0x04]

v_cvt_pk_u8_f32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x26,0xd6,0x01,0x05,0x0e,0x04]

v_cvt_pk_u8_f32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0xff,0x05,0x0e,0x04]

v_cvt_pk_u8_f32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x67,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x6a,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x6b,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x7d,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x7e,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x7f,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x80,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0xc1,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0xf0,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0xf7,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0xff,0x0f,0x04]

v_cvt_pk_u8_f32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x05,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0xcf,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0xd5,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0xd7,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0xfb,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0xfd,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0xff,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x01,0x0d,0x04]

v_cvt_pk_u8_f32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x83,0x0d,0x04]

v_cvt_pk_u8_f32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0xe1,0x0d,0x04]

v_cvt_pk_u8_f32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0xef,0x0d,0x04]

v_cvt_pk_u8_f32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x05,0xfe,0x07]

v_cvt_pk_u8_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x05,0x0e,0x00]

v_cvt_pk_u8_f32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x05,0x9e,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x05,0xaa,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x05,0xae,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x05,0xf6,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x05,0xfa,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x05,0xfe,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x05,0x02,0x02]

v_cvt_pk_u8_f32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x05,0x06,0x03]

v_cvt_pk_u8_f32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x05,0xc2,0x03]

v_cvt_pk_u8_f32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x05,0xde,0x03]

v_cvt_pk_u8_f32 v5, -v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x05,0x0e,0x24]

v_cvt_pk_u8_f32 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x26,0xd6,0x01,0x05,0x0e,0x04]

v_cvt_pk_u8_f32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x77,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0xef,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x05,0xde,0x01]

v_cvt_pknorm_i16_f16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x12,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0xff,0x05,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, s101, v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x65,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x6a,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x6b,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x7d,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x7e,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x7f,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x80,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0xc1,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0xf0,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0xf7,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0xff,0x03,0x00]

v_cvt_pknorm_i16_f16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0x05,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, v1, s101
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0xcb,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0xd5,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0xd7,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0xfb,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0xfd,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0xff,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0x01,0x01,0x00]

v_cvt_pknorm_i16_f16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0x83,0x01,0x00]

v_cvt_pknorm_i16_f16 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0xe1,0x01,0x00]

v_cvt_pknorm_i16_f16 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0xef,0x01,0x00]

v_cvt_pknorm_i16_f16 v5, -v1, v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0x05,0x02,0x20]

v_cvt_pknorm_i16_f16 v5, v1, -v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0x05,0x02,0x40]

v_cvt_pknorm_i16_f16 v5, -v1, -v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0x05,0x02,0x60]

v_cvt_pknorm_i16_f32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x21,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0xff,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, s103, v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x67,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x6a,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x6b,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x7d,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x7e,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x7f,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x80,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0xc1,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0xf0,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0xf7,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0xff,0x03,0x00]

v_cvt_pknorm_i16_f32 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0x05,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, s103
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0xcf,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0xd5,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0xd7,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0xfb,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0xfd,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0xff,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0x01,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0x83,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0xe1,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0xef,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, -v1, v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0x05,0x02,0x20]

v_cvt_pknorm_i16_f32 v5, v1, -v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0x05,0x02,0x40]

v_cvt_pknorm_i16_f32 v5, -v1, -v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0x05,0x02,0x60]

v_cvt_pknorm_i16_f32 v5, v1, v2 clamp
// GFX11: encoding: [0x05,0x80,0x21,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, ttmp11, v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x77,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, v1, ttmp11
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0xef,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x13,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0xff,0x05,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, s101, v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x65,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x6a,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x6b,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x7d,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x7e,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x7f,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x80,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0xc1,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0xf0,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0xf7,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0xff,0x03,0x00]

v_cvt_pknorm_u16_f16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0x05,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, v1, s101
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0xcb,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0xd5,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0xd7,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0xfb,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0xfd,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0xff,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0x01,0x01,0x00]

v_cvt_pknorm_u16_f16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0x83,0x01,0x00]

v_cvt_pknorm_u16_f16 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0xe1,0x01,0x00]

v_cvt_pknorm_u16_f16 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0xef,0x01,0x00]

v_cvt_pknorm_u16_f16 v5, -v1, v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0x05,0x02,0x20]

v_cvt_pknorm_u16_f16 v5, v1, -v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0x05,0x02,0x40]

v_cvt_pknorm_u16_f16 v5, -v1, -v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0x05,0x02,0x60]

v_cvt_pknorm_u16_f32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x22,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0xff,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, s103, v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x67,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x6a,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x6b,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x7d,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x7e,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x7f,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x80,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0xc1,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0xf0,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0xf7,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0xff,0x03,0x00]

v_cvt_pknorm_u16_f32 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0x05,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, s103
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0xcf,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0xd5,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0xd7,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0xfb,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0xfd,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0xff,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0x01,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0x83,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0xe1,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0xef,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, -v1, v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0x05,0x02,0x20]

v_cvt_pknorm_u16_f32 v5, v1, -v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0x05,0x02,0x40]

v_cvt_pknorm_u16_f32 v5, -v1, -v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0x05,0x02,0x60]

v_cvt_pknorm_u16_f32 v5, v1, v2 clamp
// GFX11: encoding: [0x05,0x80,0x22,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, ttmp11, v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x77,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, v1, ttmp11
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0xef,0x00,0x00]

v_cvt_rpi_i32_f32 v5, v1
// GFX11: encoding: [0x01,0x19,0x0a,0x7e]

v_cvt_rpi_i32_f32 v255, v1
// GFX11: encoding: [0x01,0x19,0xfe,0x7f]

v_cvt_rpi_i32_f32 v5, v255
// GFX11: encoding: [0xff,0x19,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, s1
// GFX11: encoding: [0x01,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, s103
// GFX11: encoding: [0x67,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, m0
// GFX11: encoding: [0x7d,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, 0
// GFX11: encoding: [0x80,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, -1
// GFX11: encoding: [0xc1,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x18,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_rpi_i32_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x18,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_rpi_i32_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x18,0x0a,0x7e]

v_cvt_u32_f64 v5, v[1:2]
// GFX11: encoding: [0x01,0x2b,0x0a,0x7e]

v_cvt_u32_f64 v255, v[1:2]
// GFX11: encoding: [0x01,0x2b,0xfe,0x7f]

v_cvt_u32_f64 v5, v[254:255]
// GFX11: encoding: [0xfe,0x2b,0x0a,0x7e]

v_cvt_u32_f64 v5, s[2:3]
// GFX11: encoding: [0x02,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, s[4:5]
// GFX11: encoding: [0x04,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, s[102:103]
// GFX11: encoding: [0x66,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, vcc
// GFX11: encoding: [0x6a,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, exec
// GFX11: encoding: [0x7e,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, 0
// GFX11: encoding: [0x80,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, -1
// GFX11: encoding: [0xc1,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, 0.5
// GFX11: encoding: [0xf0,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, -4.0
// GFX11: encoding: [0xf7,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, 0xaf123456
// GFX11: encoding: [0xff,0x2a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_u32_f64 v5, 0x3f717273
// GFX11: encoding: [0xff,0x2a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_div_fixup_f16 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x54,0xd6,0xf0,0x04,0x0e,0x04]

v_div_fixup_f16 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x54,0xd6,0x01,0xe1,0x0d,0x04]

v_div_fixup_f16 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x54,0xd6,0x01,0x05,0xc2,0x03]

v_div_fixup_f16 v5, -v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x54,0xd6,0x01,0x05,0x0e,0x24]

v_div_fixup_f16 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x54,0xd6,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x27,0xd6,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0xff,0x05,0x0e,0x04]

v_div_fixup_f32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x04,0x0e,0x04]

v_div_fixup_f32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x67,0x04,0x0e,0x04]

v_div_fixup_f32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x6a,0x04,0x0e,0x04]

v_div_fixup_f32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x6b,0x04,0x0e,0x04]

v_div_fixup_f32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x7d,0x04,0x0e,0x04]

v_div_fixup_f32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x7e,0x04,0x0e,0x04]

v_div_fixup_f32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x7f,0x04,0x0e,0x04]

v_div_fixup_f32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x80,0x04,0x0e,0x04]

v_div_fixup_f32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0xc1,0x04,0x0e,0x04]

v_div_fixup_f32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0xf0,0x04,0x0e,0x04]

v_div_fixup_f32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0xf7,0x04,0x0e,0x04]

v_div_fixup_f32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0xff,0x0f,0x04]

v_div_fixup_f32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0x0c,0x04]

v_div_fixup_f32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0xcf,0x0c,0x04]

v_div_fixup_f32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0xd5,0x0c,0x04]

v_div_fixup_f32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0xd7,0x0c,0x04]

v_div_fixup_f32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0xfb,0x0c,0x04]

v_div_fixup_f32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0xfd,0x0c,0x04]

v_div_fixup_f32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0xff,0x0c,0x04]

v_div_fixup_f32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x01,0x0d,0x04]

v_div_fixup_f32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x83,0x0d,0x04]

v_div_fixup_f32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0xe1,0x0d,0x04]

v_div_fixup_f32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0xef,0x0d,0x04]

v_div_fixup_f32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0xfe,0x07]

v_div_fixup_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0x0e,0x00]

v_div_fixup_f32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0x9e,0x01]

v_div_fixup_f32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0xaa,0x01]

v_div_fixup_f32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0xae,0x01]

v_div_fixup_f32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0xf6,0x01]

v_div_fixup_f32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0xfa,0x01]

v_div_fixup_f32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0xfe,0x01]

v_div_fixup_f32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0x02,0x02]

v_div_fixup_f32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0x06,0x03]

v_div_fixup_f32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0xc2,0x03]

v_div_fixup_f32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0xde,0x03]

v_div_fixup_f32 v5, -v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0x0e,0x24]

v_div_fixup_f32 v5, v1, -v2, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0x0e,0x44]

v_div_fixup_f32 v5, v1, v2, -v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0x0e,0x84]

v_div_fixup_f32 v5, -v1, -v2, -v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0x0e,0xe4]

v_div_fixup_f32 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x27,0xd6,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v5, v1, v2, v3 mul:2
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0x0e,0x0c]

v_div_fixup_f32 v5, v1, v2, v3 mul:4
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0x0e,0x14]

v_div_fixup_f32 v5, v1, v2, v3 div:2
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0x0e,0x1c]

v_div_fixup_f32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x77,0x04,0x0e,0x04]

v_div_fixup_f32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0xef,0x0c,0x04]

v_div_fixup_f32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0xde,0x01]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[254:255], v[1:2], v[2:3], v[3:4]
// GFX11: encoding: [0xfe,0x00,0x28,0xd6,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], v[254:255], v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0xfe,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], s[2:3], v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x02,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], s[4:5], v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x04,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], s[102:103], v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x66,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], vcc, v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x6a,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], exec, v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x7e,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], 0, v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x80,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], -1, v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0xc1,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], 0.5, v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0xf0,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], -4.0, v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0xf7,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], v[1:2], v[254:255], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0xfd,0x0f,0x04]

v_div_fixup_f64 v[5:6], v[1:2], s[4:5], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x09,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], s[6:7], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x0d,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], s[102:103], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0xcd,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], vcc, v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0xd5,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], exec, v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0xfd,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], 0, v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x01,0x0d,0x04]

v_div_fixup_f64 v[5:6], v[1:2], -1, v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x83,0x0d,0x04]

v_div_fixup_f64 v[5:6], v[1:2], 0.5, v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0xe1,0x0d,0x04]

v_div_fixup_f64 v[5:6], v[1:2], -4.0, v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0xef,0x0d,0x04]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[254:255]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0xfa,0x07]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], s[6:7]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0x1a,0x00]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], s[8:9]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0x22,0x00]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], s[102:103]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0x9a,0x01]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], vcc
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0xaa,0x01]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], exec
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0xfa,0x01]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], 0
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0x02,0x02]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], -1
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0x06,0x03]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], 0.5
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0xc2,0x03]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], -4.0
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0xde,0x03]

v_div_fixup_f64 v[5:6], -v[1:2], v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0x0e,0x24]

v_div_fixup_f64 v[5:6], v[1:2], -v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0x0e,0x44]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], -v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0x0e,0x84]

v_div_fixup_f64 v[5:6], -v[1:2], -v[2:3], -v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0x0e,0xe4]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[3:4] clamp
// GFX11: encoding: [0x05,0x80,0x28,0xd6,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:2
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0x0e,0x0c]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:4
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0x0e,0x14]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[3:4] div:2
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0x0e,0x1c]

v_div_fmas_f32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0x05,0x0e,0x04]

v_div_fmas_f32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x37,0xd6,0x01,0x05,0x0e,0x04]

v_div_fmas_f32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0xff,0x05,0x0e,0x04]

v_div_fmas_f32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x80,0x04,0x0e,0x04]

v_div_fmas_f32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0xc1,0x04,0x0e,0x04]

v_div_fmas_f32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0xf0,0x04,0x0e,0x04]

v_div_fmas_f32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0xf7,0x04,0x0e,0x04]

v_div_fmas_f32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0xff,0x0f,0x04]

v_div_fmas_f32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0x01,0x0d,0x04]

v_div_fmas_f32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0x83,0x0d,0x04]

v_div_fmas_f32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0xe1,0x0d,0x04]

v_div_fmas_f32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0xef,0x0d,0x04]

v_div_fmas_f32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0x05,0xfe,0x07]

v_div_fmas_f32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0x05,0x02,0x02]

v_div_fmas_f32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0x05,0x06,0x03]

v_div_fmas_f32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0x05,0xc2,0x03]

v_div_fmas_f32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0x05,0xde,0x03]

v_div_fmas_f32 v5, -v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0x05,0x0e,0x24]

v_div_fmas_f32 v5, v1, -v2, v3
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0x05,0x0e,0x44]

v_div_fmas_f32 v5, v1, v2, -v3
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0x05,0x0e,0x84]

v_div_fmas_f32 v5, -v1, -v2, -v3
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0x05,0x0e,0xe4]

v_div_fmas_f32 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x37,0xd6,0x01,0x05,0x0e,0x04]

v_div_fmas_f32 v5, v1, v2, v3 mul:2
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0x05,0x0e,0x0c]

v_div_fmas_f32 v5, v1, v2, v3 mul:4
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0x05,0x0e,0x14]

v_div_fmas_f32 v5, v1, v2, v3 div:2
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0x05,0x0e,0x1c]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0x05,0x0e,0x04]

v_div_fmas_f64 v[254:255], v[1:2], v[2:3], v[3:4]
// GFX11: encoding: [0xfe,0x00,0x38,0xd6,0x01,0x05,0x0e,0x04]

v_div_fmas_f64 v[5:6], v[254:255], v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0xfe,0x05,0x0e,0x04]

v_div_fmas_f64 v[5:6], 0, v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x80,0x04,0x0e,0x04]

v_div_fmas_f64 v[5:6], -1, v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0xc1,0x04,0x0e,0x04]

v_div_fmas_f64 v[5:6], 0.5, v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0xf0,0x04,0x0e,0x04]

v_div_fmas_f64 v[5:6], -4.0, v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0xf7,0x04,0x0e,0x04]

v_div_fmas_f64 v[5:6], v[1:2], v[254:255], v[3:4]
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0xfd,0x0f,0x04]

v_div_fmas_f64 v[5:6], v[1:2], 0, v[3:4]
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0x01,0x0d,0x04]

v_div_fmas_f64 v[5:6], v[1:2], -1, v[3:4]
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0x83,0x0d,0x04]

v_div_fmas_f64 v[5:6], v[1:2], 0.5, v[3:4]
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0xe1,0x0d,0x04]

v_div_fmas_f64 v[5:6], v[1:2], -4.0, v[3:4]
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0xef,0x0d,0x04]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[254:255]
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0x05,0xfa,0x07]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], 0
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0x05,0x02,0x02]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], -1
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0x05,0x06,0x03]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], 0.5
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0x05,0xc2,0x03]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], -4.0
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0x05,0xde,0x03]

v_div_fmas_f64 v[5:6], -v[1:2], v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0x05,0x0e,0x24]

v_div_fmas_f64 v[5:6], v[1:2], -v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0x05,0x0e,0x44]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], -v[3:4]
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0x05,0x0e,0x84]

v_div_fmas_f64 v[5:6], -v[1:2], -v[2:3], -v[3:4]
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0x05,0x0e,0xe4]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[3:4] clamp
// GFX11: encoding: [0x05,0x80,0x38,0xd6,0x01,0x05,0x0e,0x04]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:2
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0x05,0x0e,0x0c]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:4
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0x05,0x0e,0x14]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[3:4] div:2
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0x05,0x0e,0x1c]

v_dot2_f16_f16 v0, v1, v2, v3
// GFX11: encoding: [0x00,0x00,0x66,0xd6,0x01,0x05,0x0e,0x04]

v_dot2_f16_f16 v0, v1, v2, v3 op_sel:[1,1,0,0]
// W32-ERR: error: invalid op_sel operand
// W64-ERR: error: invalid op_sel operand

v_dot2_f16_f16 v0, v1, v2, v3 op_sel:[0,0,1,1]
// GFX11: encoding: [0x00,0x60,0x66,0xd6,0x01,0x05,0x0e,0x04]

v_dot2_f16_f16 v0, |v1|, -v2, -|v3| op_sel:[0,0,1,1]
// GFX11: encoding: [0x00,0x65,0x66,0xd6,0x01,0x05,0x0e,0xc4]

v_dot2_bf16_bf16 v0, v1, v2, v3
// GFX11: encoding: [0x00,0x00,0x67,0xd6,0x01,0x05,0x0e,0x04]

v_dot2_bf16_bf16 v0, v1, v2, v3 op_sel:[1,1,0,0]
// W32-ERR: error: invalid op_sel operand
// W64-ERR: error: invalid op_sel operand

v_dot2_bf16_bf16 v0, v1, v2, v3 op_sel:[0,0,1,1]
// GFX11: encoding: [0x00,0x60,0x67,0xd6,0x01,0x05,0x0e,0x04]

v_dot2_bf16_bf16 v0, |v1|, -v2, -|v3| op_sel:[0,0,1,1]
// GFX11: encoding: [0x00,0x65,0x67,0xd6,0x01,0x05,0x0e,0xc4]

v_dot2c_f32_f16_e32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x04]

v_dot2acc_f32_f16_e32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x04]

v_exp_f32 v5, v1
// GFX11: encoding: [0x01,0x4b,0x0a,0x7e]

v_exp_f32 v255, v1
// GFX11: encoding: [0x01,0x4b,0xfe,0x7f]

v_exp_f32 v5, v255
// GFX11: encoding: [0xff,0x4b,0x0a,0x7e]

v_exp_f32 v5, s1
// GFX11: encoding: [0x01,0x4a,0x0a,0x7e]

v_exp_f32 v5, s103
// GFX11: encoding: [0x67,0x4a,0x0a,0x7e]

v_exp_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x4a,0x0a,0x7e]

v_exp_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x4a,0x0a,0x7e]

v_exp_f32 v5, m0
// GFX11: encoding: [0x7d,0x4a,0x0a,0x7e]

v_exp_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x4a,0x0a,0x7e]

v_exp_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x4a,0x0a,0x7e]

v_exp_f32 v5, 0
// GFX11: encoding: [0x80,0x4a,0x0a,0x7e]

v_exp_f32 v5, -1
// GFX11: encoding: [0xc1,0x4a,0x0a,0x7e]

v_exp_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x4a,0x0a,0x7e]

v_exp_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x4a,0x0a,0x7e]

v_exp_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x4a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_exp_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x4a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_exp_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x4a,0x0a,0x7e]

v_ffbh_i32 v5, v1
// GFX11: encoding: [0x01,0x77,0x0a,0x7e]

v_ffbh_i32 v255, v1
// GFX11: encoding: [0x01,0x77,0xfe,0x7f]

v_ffbh_i32 v5, v255
// GFX11: encoding: [0xff,0x77,0x0a,0x7e]

v_ffbh_i32 v5, s1
// GFX11: encoding: [0x01,0x76,0x0a,0x7e]

v_ffbh_i32 v5, s103
// GFX11: encoding: [0x67,0x76,0x0a,0x7e]

v_ffbh_i32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x76,0x0a,0x7e]

v_ffbh_i32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x76,0x0a,0x7e]

v_ffbh_i32 v5, m0
// GFX11: encoding: [0x7d,0x76,0x0a,0x7e]

v_ffbh_i32 v5, exec_lo
// GFX11: encoding: [0x7e,0x76,0x0a,0x7e]

v_ffbh_i32 v5, exec_hi
// GFX11: encoding: [0x7f,0x76,0x0a,0x7e]

v_ffbh_i32 v5, 0
// GFX11: encoding: [0x80,0x76,0x0a,0x7e]

v_ffbh_i32 v5, -1
// GFX11: encoding: [0xc1,0x76,0x0a,0x7e]

v_ffbh_i32 v5, 0.5
// GFX11: encoding: [0xf0,0x76,0x0a,0x7e]

v_ffbh_i32 v5, -4.0
// GFX11: encoding: [0xf7,0x76,0x0a,0x7e]

v_ffbh_i32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x76,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ffbh_i32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x76,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ffbh_i32 v5, ttmp11
// GFX11: encoding: [0x77,0x76,0x0a,0x7e]

v_ffbh_u32 v5, v1
// GFX11: encoding: [0x01,0x73,0x0a,0x7e]

v_ffbh_u32 v255, v1
// GFX11: encoding: [0x01,0x73,0xfe,0x7f]

v_ffbh_u32 v5, v255
// GFX11: encoding: [0xff,0x73,0x0a,0x7e]

v_ffbh_u32 v5, s1
// GFX11: encoding: [0x01,0x72,0x0a,0x7e]

v_ffbh_u32 v5, s103
// GFX11: encoding: [0x67,0x72,0x0a,0x7e]

v_ffbh_u32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x72,0x0a,0x7e]

v_ffbh_u32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x72,0x0a,0x7e]

v_ffbh_u32 v5, m0
// GFX11: encoding: [0x7d,0x72,0x0a,0x7e]

v_ffbh_u32 v5, exec_lo
// GFX11: encoding: [0x7e,0x72,0x0a,0x7e]

v_ffbh_u32 v5, exec_hi
// GFX11: encoding: [0x7f,0x72,0x0a,0x7e]

v_ffbh_u32 v5, 0
// GFX11: encoding: [0x80,0x72,0x0a,0x7e]

v_ffbh_u32 v5, -1
// GFX11: encoding: [0xc1,0x72,0x0a,0x7e]

v_ffbh_u32 v5, 0.5
// GFX11: encoding: [0xf0,0x72,0x0a,0x7e]

v_ffbh_u32 v5, -4.0
// GFX11: encoding: [0xf7,0x72,0x0a,0x7e]

v_ffbh_u32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x72,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ffbh_u32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x72,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ffbh_u32 v5, ttmp11
// GFX11: encoding: [0x77,0x72,0x0a,0x7e]

v_ffbl_b32 v5, v1
// GFX11: encoding: [0x01,0x75,0x0a,0x7e]

v_ffbl_b32 v255, v1
// GFX11: encoding: [0x01,0x75,0xfe,0x7f]

v_ffbl_b32 v5, v255
// GFX11: encoding: [0xff,0x75,0x0a,0x7e]

v_ffbl_b32 v5, s1
// GFX11: encoding: [0x01,0x74,0x0a,0x7e]

v_ffbl_b32 v5, s103
// GFX11: encoding: [0x67,0x74,0x0a,0x7e]

v_ffbl_b32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x74,0x0a,0x7e]

v_ffbl_b32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x74,0x0a,0x7e]

v_ffbl_b32 v5, m0
// GFX11: encoding: [0x7d,0x74,0x0a,0x7e]

v_ffbl_b32 v5, exec_lo
// GFX11: encoding: [0x7e,0x74,0x0a,0x7e]

v_ffbl_b32 v5, exec_hi
// GFX11: encoding: [0x7f,0x74,0x0a,0x7e]

v_ffbl_b32 v5, 0
// GFX11: encoding: [0x80,0x74,0x0a,0x7e]

v_ffbl_b32 v5, -1
// GFX11: encoding: [0xc1,0x74,0x0a,0x7e]

v_ffbl_b32 v5, 0.5
// GFX11: encoding: [0xf0,0x74,0x0a,0x7e]

v_ffbl_b32 v5, -4.0
// GFX11: encoding: [0xf7,0x74,0x0a,0x7e]

v_ffbl_b32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x74,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ffbl_b32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x74,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ffbl_b32 v5, ttmp11
// GFX11: encoding: [0x77,0x74,0x0a,0x7e]

v_ctz_i32_b32 v5, v1
// GFX11: encoding: [0x01,0x75,0x0a,0x7e]

v_ctz_i32_b32 v255, v1
// GFX11: encoding: [0x01,0x75,0xfe,0x7f]

v_ctz_i32_b32 v5, v255
// GFX11: encoding: [0xff,0x75,0x0a,0x7e]

v_ctz_i32_b32 v5, s1
// GFX11: encoding: [0x01,0x74,0x0a,0x7e]

v_ctz_i32_b32 v5, s103
// GFX11: encoding: [0x67,0x74,0x0a,0x7e]

v_ctz_i32_b32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x74,0x0a,0x7e]

v_ctz_i32_b32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x74,0x0a,0x7e]

v_ctz_i32_b32 v5, m0
// GFX11: encoding: [0x7d,0x74,0x0a,0x7e]

v_ctz_i32_b32 v5, exec_lo
// GFX11: encoding: [0x7e,0x74,0x0a,0x7e]

v_ctz_i32_b32 v5, exec_hi
// GFX11: encoding: [0x7f,0x74,0x0a,0x7e]

v_ctz_i32_b32 v5, 0
// GFX11: encoding: [0x80,0x74,0x0a,0x7e]

v_ctz_i32_b32 v5, -1
// GFX11: encoding: [0xc1,0x74,0x0a,0x7e]

v_ctz_i32_b32 v5, 0.5
// GFX11: encoding: [0xf0,0x74,0x0a,0x7e]

v_ctz_i32_b32 v5, -4.0
// GFX11: encoding: [0xf7,0x74,0x0a,0x7e]

v_ctz_i32_b32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x74,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ctz_i32_b32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x74,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ctz_i32_b32 v5, ttmp11
// GFX11: encoding: [0x77,0x74,0x0a,0x7e]

v_floor_f32 v5, v1
// GFX11: encoding: [0x01,0x49,0x0a,0x7e]

v_floor_f32 v255, v1
// GFX11: encoding: [0x01,0x49,0xfe,0x7f]

v_floor_f32 v5, v255
// GFX11: encoding: [0xff,0x49,0x0a,0x7e]

v_floor_f32 v5, s1
// GFX11: encoding: [0x01,0x48,0x0a,0x7e]

v_floor_f32 v5, s103
// GFX11: encoding: [0x67,0x48,0x0a,0x7e]

v_floor_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x48,0x0a,0x7e]

v_floor_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x48,0x0a,0x7e]

v_floor_f32 v5, m0
// GFX11: encoding: [0x7d,0x48,0x0a,0x7e]

v_floor_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x48,0x0a,0x7e]

v_floor_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x48,0x0a,0x7e]

v_floor_f32 v5, 0
// GFX11: encoding: [0x80,0x48,0x0a,0x7e]

v_floor_f32 v5, -1
// GFX11: encoding: [0xc1,0x48,0x0a,0x7e]

v_floor_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x48,0x0a,0x7e]

v_floor_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x48,0x0a,0x7e]

v_floor_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x48,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_floor_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x48,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_floor_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x48,0x0a,0x7e]

v_floor_f64 v[5:6], v[1:2]
// GFX11: encoding: [0x01,0x35,0x0a,0x7e]

v_floor_f64 v[254:255], v[1:2]
// GFX11: encoding: [0x01,0x35,0xfc,0x7f]

v_floor_f64 v[5:6], v[254:255]
// GFX11: encoding: [0xfe,0x35,0x0a,0x7e]

v_floor_f64 v[5:6], s[2:3]
// GFX11: encoding: [0x02,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], s[4:5]
// GFX11: encoding: [0x04,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], s[102:103]
// GFX11: encoding: [0x66,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], vcc
// GFX11: encoding: [0x6a,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], exec
// GFX11: encoding: [0x7e,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], 0
// GFX11: encoding: [0x80,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], -1
// GFX11: encoding: [0xc1,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], 0.5
// GFX11: encoding: [0xf0,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], -4.0
// GFX11: encoding: [0xf7,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], 0xaf123456
// GFX11: encoding: [0xff,0x34,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_floor_f64 v[5:6], 0x3f717273
// GFX11: encoding: [0xff,0x34,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_fma_dx9_zero_f32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0x0e,0x04]

v_fma_dx9_zero_f32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x09,0xd6,0x01,0x05,0x0e,0x04]

v_fma_dx9_zero_f32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0xff,0x05,0x0e,0x04]

v_fma_dx9_zero_f32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x04,0x0e,0x04]

v_fma_dx9_zero_f32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x67,0x04,0x0e,0x04]

v_fma_dx9_zero_f32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x6a,0x04,0x0e,0x04]

v_fma_dx9_zero_f32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x6b,0x04,0x0e,0x04]

v_fma_dx9_zero_f32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x7d,0x04,0x0e,0x04]

v_fma_dx9_zero_f32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x7e,0x04,0x0e,0x04]

v_fma_dx9_zero_f32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x7f,0x04,0x0e,0x04]

v_fma_dx9_zero_f32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x80,0x04,0x0e,0x04]

v_fma_dx9_zero_f32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0xc1,0x04,0x0e,0x04]

v_fma_dx9_zero_f32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0xf0,0x04,0x0e,0x04]

v_fma_dx9_zero_f32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0xf7,0x04,0x0e,0x04]

v_fma_dx9_zero_f32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0xff,0x0f,0x04]

v_fma_dx9_zero_f32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0x0c,0x04]

v_fma_dx9_zero_f32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0xcf,0x0c,0x04]

v_fma_dx9_zero_f32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0xd5,0x0c,0x04]

v_fma_dx9_zero_f32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0xd7,0x0c,0x04]

v_fma_dx9_zero_f32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0xfb,0x0c,0x04]

v_fma_dx9_zero_f32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0xfd,0x0c,0x04]

v_fma_dx9_zero_f32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0xff,0x0c,0x04]

v_fma_dx9_zero_f32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x01,0x0d,0x04]

v_fma_dx9_zero_f32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x83,0x0d,0x04]

v_fma_dx9_zero_f32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0xe1,0x0d,0x04]

v_fma_dx9_zero_f32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0xef,0x0d,0x04]

v_fma_dx9_zero_f32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0xfe,0x07]

v_fma_dx9_zero_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0x0e,0x00]

v_fma_dx9_zero_f32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0x9e,0x01]

v_fma_dx9_zero_f32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0xaa,0x01]

v_fma_dx9_zero_f32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0xae,0x01]

v_fma_dx9_zero_f32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0xf6,0x01]

v_fma_dx9_zero_f32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0xfa,0x01]

v_fma_dx9_zero_f32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0xfe,0x01]

v_fma_dx9_zero_f32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0x02,0x02]

v_fma_dx9_zero_f32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0x06,0x03]

v_fma_dx9_zero_f32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0xc2,0x03]

v_fma_dx9_zero_f32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0xde,0x03]

v_fma_dx9_zero_f32 v5, -v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0x0e,0x24]

v_fma_dx9_zero_f32 v5, v1, -v2, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0x0e,0x44]

v_fma_dx9_zero_f32 v5, v1, v2, -v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0x0e,0x84]

v_fma_dx9_zero_f32 v5, -v1, -v2, -v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0x0e,0xe4]

v_fma_dx9_zero_f32 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x09,0xd6,0x01,0x05,0x0e,0x04]

v_fma_dx9_zero_f32 v5, v1, v2, v3 mul:2
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0x0e,0x0c]

v_fma_dx9_zero_f32 v5, v1, v2, v3 mul:4
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0x0e,0x14]

v_fma_dx9_zero_f32 v5, v1, v2, v3 div:2
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0x0e,0x1c]

v_fma_f16 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x48,0xd6,0x01,0x05,0x0e,0x04]

v_fma_f16 v5, v1, -v2, v3
// GFX11: encoding: [0x05,0x00,0x48,0xd6,0x01,0x05,0x0e,0x44]

v_fma_f16 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x48,0xd6,0x01,0x05,0x0e,0x04]

v_fma_f32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0x0e,0x04]

v_fma_f32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x13,0xd6,0x01,0x05,0x0e,0x04]

v_fma_f32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0xff,0x05,0x0e,0x04]

v_fma_f32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x04,0x0e,0x04]

v_fma_f32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x67,0x04,0x0e,0x04]

v_fma_f32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x6a,0x04,0x0e,0x04]

v_fma_f32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x6b,0x04,0x0e,0x04]

v_fma_f32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x7d,0x04,0x0e,0x04]

v_fma_f32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x7e,0x04,0x0e,0x04]

v_fma_f32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x7f,0x04,0x0e,0x04]

v_fma_f32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x80,0x04,0x0e,0x04]

v_fma_f32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0xc1,0x04,0x0e,0x04]

v_fma_f32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0xf0,0x04,0x0e,0x04]

v_fma_f32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0xf7,0x04,0x0e,0x04]

v_fma_f32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0xff,0x0f,0x04]

v_fma_f32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0x0c,0x04]

v_fma_f32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0xcf,0x0c,0x04]

v_fma_f32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0xd5,0x0c,0x04]

v_fma_f32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0xd7,0x0c,0x04]

v_fma_f32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0xfb,0x0c,0x04]

v_fma_f32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0xfd,0x0c,0x04]

v_fma_f32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0xff,0x0c,0x04]

v_fma_f32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x01,0x0d,0x04]

v_fma_f32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x83,0x0d,0x04]

v_fma_f32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0xe1,0x0d,0x04]

v_fma_f32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0xef,0x0d,0x04]

v_fma_f32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0xfe,0x07]

v_fma_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0x0e,0x00]

v_fma_f32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0x9e,0x01]

v_fma_f32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0xaa,0x01]

v_fma_f32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0xae,0x01]

v_fma_f32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0xf6,0x01]

v_fma_f32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0xfa,0x01]

v_fma_f32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0xfe,0x01]

v_fma_f32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0x02,0x02]

v_fma_f32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0x06,0x03]

v_fma_f32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0xc2,0x03]

v_fma_f32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0xde,0x03]

v_fma_f32 v5, -v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0x0e,0x24]

v_fma_f32 v5, v1, -v2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0x0e,0x44]

v_fma_f32 v5, v1, v2, -v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0x0e,0x84]

v_fma_f32 v5, -v1, -v2, -v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0x0e,0xe4]

v_fma_f32 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x13,0xd6,0x01,0x05,0x0e,0x04]

v_fma_f32 v5, v1, v2, v3 mul:2
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0x0e,0x0c]

v_fma_f32 v5, v1, v2, v3 mul:4
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0x0e,0x14]

v_fma_f32 v5, v1, v2, v3 div:2
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0x0e,0x1c]

v_fma_f32 v5, v1, v2, null
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0xf2,0x01]

v_fma_f32 v5, v1, null, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0xf9,0x0c,0x04]

v_fma_f32 v5, null, v2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x7c,0x04,0x0e,0x04]

v_fma_f32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x77,0x04,0x0e,0x04]

v_fma_f32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0xef,0x0c,0x04]

v_fma_f32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0xde,0x01]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0x0e,0x04]

v_fma_f64 v[254:255], v[1:2], v[2:3], v[3:4]
// GFX11: encoding: [0xfe,0x00,0x14,0xd6,0x01,0x05,0x0e,0x04]

v_fma_f64 v[5:6], v[254:255], v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0xfe,0x05,0x0e,0x04]

v_fma_f64 v[5:6], s[2:3], v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x02,0x04,0x0e,0x04]

v_fma_f64 v[5:6], s[4:5], v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x04,0x04,0x0e,0x04]

v_fma_f64 v[5:6], s[102:103], v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x66,0x04,0x0e,0x04]

v_fma_f64 v[5:6], vcc, v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x6a,0x04,0x0e,0x04]

v_fma_f64 v[5:6], exec, v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x7e,0x04,0x0e,0x04]

v_fma_f64 v[5:6], 0, v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x80,0x04,0x0e,0x04]

v_fma_f64 v[5:6], -1, v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0xc1,0x04,0x0e,0x04]

v_fma_f64 v[5:6], 0.5, v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0xf0,0x04,0x0e,0x04]

v_fma_f64 v[5:6], -4.0, v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0xf7,0x04,0x0e,0x04]

v_fma_f64 v[5:6], v[1:2], v[254:255], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0xfd,0x0f,0x04]

v_fma_f64 v[5:6], v[1:2], s[4:5], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x09,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], s[6:7], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x0d,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], s[102:103], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0xcd,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], vcc, v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0xd5,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], exec, v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0xfd,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], 0, v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x01,0x0d,0x04]

v_fma_f64 v[5:6], v[1:2], -1, v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x83,0x0d,0x04]

v_fma_f64 v[5:6], v[1:2], 0.5, v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0xe1,0x0d,0x04]

v_fma_f64 v[5:6], v[1:2], -4.0, v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0xef,0x0d,0x04]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[254:255]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0xfa,0x07]

v_fma_f64 v[5:6], v[1:2], v[2:3], s[6:7]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0x1a,0x00]

v_fma_f64 v[5:6], v[1:2], v[2:3], s[8:9]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0x22,0x00]

v_fma_f64 v[5:6], v[1:2], v[2:3], s[102:103]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0x9a,0x01]

v_fma_f64 v[5:6], v[1:2], v[2:3], vcc
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0xaa,0x01]

v_fma_f64 v[5:6], v[1:2], v[2:3], exec
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0xfa,0x01]

v_fma_f64 v[5:6], v[1:2], v[2:3], 0
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0x02,0x02]

v_fma_f64 v[5:6], v[1:2], v[2:3], -1
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0x06,0x03]

v_fma_f64 v[5:6], v[1:2], v[2:3], 0.5
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0xc2,0x03]

v_fma_f64 v[5:6], v[1:2], v[2:3], -4.0
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0xde,0x03]

v_fma_f64 v[5:6], -v[1:2], v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0x0e,0x24]

v_fma_f64 v[5:6], v[1:2], -v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0x0e,0x44]

v_fma_f64 v[5:6], v[1:2], v[2:3], -v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0x0e,0x84]

v_fma_f64 v[5:6], -v[1:2], -v[2:3], -v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0x0e,0xe4]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[3:4] clamp
// GFX11: encoding: [0x05,0x80,0x14,0xd6,0x01,0x05,0x0e,0x04]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:2
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0x0e,0x0c]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:4
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0x0e,0x14]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[3:4] div:2
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0x0e,0x1c]

v_fmaak_f32 v5, v1, v2, 0x11213141
// GFX11: encoding: [0x01,0x05,0x0a,0x5a,0x41,0x31,0x21,0x11]

v_fmaak_f32 v255, v1, v2, 0x11213141
// GFX11: encoding: [0x01,0x05,0xfe,0x5b,0x41,0x31,0x21,0x11]

v_fmaak_f32 v5, v255, v2, 0x11213141
// GFX11: encoding: [0xff,0x05,0x0a,0x5a,0x41,0x31,0x21,0x11]

v_fmaak_f32 v5, 0, v2, 0x11213141
// GFX11: encoding: [0x80,0x04,0x0a,0x5a,0x41,0x31,0x21,0x11]

v_fmaak_f32 v5, -1, v2, 0x11213141
// GFX11: encoding: [0xc1,0x04,0x0a,0x5a,0x41,0x31,0x21,0x11]

v_fmaak_f32 v5, 0.5, v2, 0x11213141
// GFX11: encoding: [0xf0,0x04,0x0a,0x5a,0x41,0x31,0x21,0x11]

v_fmaak_f32 v5, -4.0, v2, 0x11213141
// GFX11: encoding: [0xf7,0x04,0x0a,0x5a,0x41,0x31,0x21,0x11]

v_fmaak_f32 v5, v1, v255, 0x11213141
// GFX11: encoding: [0x01,0xff,0x0b,0x5a,0x41,0x31,0x21,0x11]

v_fmaak_f32 v5, v1, v2, 0xa1b1c1d1
// GFX11: encoding: [0x01,0x05,0x0a,0x5a,0xd1,0xc1,0xb1,0xa1]

v_fmaak_f16 v5, v1, v2, 0x1121
// GFX11: encoding: [0x01,0x05,0x0a,0x70,0x21,0x11,0x00,0x00]

v_fmaak_f16 v255, v1, v2, 0x1121
// GFX11: encoding: [0x01,0x05,0xfe,0x71,0x21,0x11,0x00,0x00]

v_fmaak_f16 v5, v255, v2, 0x1121
// GFX11: encoding: [0xff,0x05,0x0a,0x70,0x21,0x11,0x00,0x00]

v_fmaak_f16 v5, 0, v2, 0x1121
// GFX11: encoding: [0x80,0x04,0x0a,0x70,0x21,0x11,0x00,0x00]

v_fmaak_f16 v5, -1, v2, 0x1121
// GFX11: encoding: [0xc1,0x04,0x0a,0x70,0x21,0x11,0x00,0x00]

v_fmaak_f16 v5, 0.5, v2, 0x1121
// GFX11: encoding: [0xf0,0x04,0x0a,0x70,0x21,0x11,0x00,0x00]

v_fmaak_f16 v5, -4.0, v2, 0x1121
// GFX11: encoding: [0xf7,0x04,0x0a,0x70,0x21,0x11,0x00,0x00]

v_fmaak_f16 v5, v1, v255, 0x1121
// GFX11: encoding: [0x01,0xff,0x0b,0x70,0x21,0x11,0x00,0x00]

v_fmaak_f16 v5, v1, v2, 0xa1b1
// GFX11: encoding: [0x01,0x05,0x0a,0x70,0xb1,0xa1,0x00,0x00]

v_fmac_dx9_zero_f32 v0, v1, v2
// GFX11: encoding: [0x01,0x05,0x00,0x0c]

v_fmac_dx9_zero_f32 v0, |v1|, -v2
// GFX11: encoding: [0x00,0x01,0x06,0xd5,0x01,0x05,0x02,0x40]

v_fmac_dx9_zero_f32 v0, s1, 2.0
// GFX11: encoding: [0x00,0x00,0x06,0xd5,0x01,0xe8,0x01,0x00]

v_fmac_f16 v5, 0x1234, v2
// GFX11: encoding: [0xff,0x04,0x0a,0x6c,0x34,0x12,0x00,0x00]

v_fmac_f16 v0, v1, v2
// GFX11: encoding: [0x01,0x05,0x00,0x6c]

v_fmac_f16 v0, |v1|, -v2
// GFX11: encoding: [0x00,0x01,0x36,0xd5,0x01,0x05,0x02,0x40]

v_fmac_f16 v0, s1, 2.0
// GFX11: encoding: [0x00,0x00,0x36,0xd5,0x01,0xe8,0x01,0x00]

v_fmac_f32 v0, v1, v2
// GFX11: encoding: [0x01,0x05,0x00,0x56]

v_fmac_f32 v0, |v1|, -v2
// GFX11: encoding: [0x00,0x01,0x2b,0xd5,0x01,0x05,0x02,0x40]

v_fmac_f32 v0, s1, 2.0
// GFX11: encoding: [0x00,0x00,0x2b,0xd5,0x01,0xe8,0x01,0x00]

v_fmamk_f32 v5, v1, 0x11213141, v3
// GFX11: encoding: [0x01,0x07,0x0a,0x58,0x41,0x31,0x21,0x11]

v_fmamk_f32 v255, v1, 0x11213141, v3
// GFX11: encoding: [0x01,0x07,0xfe,0x59,0x41,0x31,0x21,0x11]

v_fmamk_f32 v5, v255, 0x11213141, v3
// GFX11: encoding: [0xff,0x07,0x0a,0x58,0x41,0x31,0x21,0x11]

v_fmamk_f32 v5, 0, 0x11213141, v3
// GFX11: encoding: [0x80,0x06,0x0a,0x58,0x41,0x31,0x21,0x11]

v_fmamk_f32 v5, -1, 0x11213141, v3
// GFX11: encoding: [0xc1,0x06,0x0a,0x58,0x41,0x31,0x21,0x11]

v_fmamk_f32 v5, 0.5, 0x11213141, v3
// GFX11: encoding: [0xf0,0x06,0x0a,0x58,0x41,0x31,0x21,0x11]

v_fmamk_f32 v5, -4.0, 0x11213141, v3
// GFX11: encoding: [0xf7,0x06,0x0a,0x58,0x41,0x31,0x21,0x11]

v_fmamk_f32 v5, v1, 0xa1b1c1d1, v3
// GFX11: encoding: [0x01,0x07,0x0a,0x58,0xd1,0xc1,0xb1,0xa1]

v_fmamk_f32 v5, v1, 0x11213141, v255
// GFX11: encoding: [0x01,0xff,0x0b,0x58,0x41,0x31,0x21,0x11]

v_fmamk_f16 v5, v1, 0x1121, v3
// GFX11: encoding: [0x01,0x07,0x0a,0x6e,0x21,0x11,0x00,0x00]

v_fmamk_f16 v255, v1, 0x1121, v3
// GFX11: encoding: [0x01,0x07,0xfe,0x6f,0x21,0x11,0x00,0x00]

v_fmamk_f16 v5, v255, 0x1121, v3
// GFX11: encoding: [0xff,0x07,0x0a,0x6e,0x21,0x11,0x00,0x00]

v_fmamk_f16 v5, 0, 0x1121, v3
// GFX11: encoding: [0x80,0x06,0x0a,0x6e,0x21,0x11,0x00,0x00]

v_fmamk_f16 v5, -1, 0x1121, v3
// GFX11: encoding: [0xc1,0x06,0x0a,0x6e,0x21,0x11,0x00,0x00]

v_fmamk_f16 v5, 0.5, 0x1121, v3
// GFX11: encoding: [0xf0,0x06,0x0a,0x6e,0x21,0x11,0x00,0x00]

v_fmamk_f16 v5, -4.0, 0x1121, v3
// GFX11: encoding: [0xf7,0x06,0x0a,0x6e,0x21,0x11,0x00,0x00]

v_fmamk_f16 v5, v1, 0xa1b1, v3
// GFX11: encoding: [0x01,0x07,0x0a,0x6e,0xb1,0xa1,0x00,0x00]

v_fmamk_f16 v5, v1, 0x1121, v255
// GFX11: encoding: [0x01,0xff,0x0b,0x6e,0x21,0x11,0x00,0x00]

v_fract_f32 v5, v1
// GFX11: encoding: [0x01,0x41,0x0a,0x7e]

v_fract_f32 v255, v1
// GFX11: encoding: [0x01,0x41,0xfe,0x7f]

v_fract_f32 v5, v255
// GFX11: encoding: [0xff,0x41,0x0a,0x7e]

v_fract_f32 v5, s1
// GFX11: encoding: [0x01,0x40,0x0a,0x7e]

v_fract_f32 v5, s103
// GFX11: encoding: [0x67,0x40,0x0a,0x7e]

v_fract_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x40,0x0a,0x7e]

v_fract_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x40,0x0a,0x7e]

v_fract_f32 v5, m0
// GFX11: encoding: [0x7d,0x40,0x0a,0x7e]

v_fract_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x40,0x0a,0x7e]

v_fract_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x40,0x0a,0x7e]

v_fract_f32 v5, 0
// GFX11: encoding: [0x80,0x40,0x0a,0x7e]

v_fract_f32 v5, -1
// GFX11: encoding: [0xc1,0x40,0x0a,0x7e]

v_fract_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x40,0x0a,0x7e]

v_fract_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x40,0x0a,0x7e]

v_fract_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x40,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_fract_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x40,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_fract_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x40,0x0a,0x7e]

v_fract_f64 v[5:6], v[1:2]
// GFX11: encoding: [0x01,0x7d,0x0a,0x7e]

v_fract_f64 v[254:255], v[1:2]
// GFX11: encoding: [0x01,0x7d,0xfc,0x7f]

v_fract_f64 v[5:6], v[254:255]
// GFX11: encoding: [0xfe,0x7d,0x0a,0x7e]

v_fract_f64 v[5:6], s[2:3]
// GFX11: encoding: [0x02,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], s[4:5]
// GFX11: encoding: [0x04,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], s[102:103]
// GFX11: encoding: [0x66,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], vcc
// GFX11: encoding: [0x6a,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], exec
// GFX11: encoding: [0x7e,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], 0
// GFX11: encoding: [0x80,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], -1
// GFX11: encoding: [0xc1,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], 0.5
// GFX11: encoding: [0xf0,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], -4.0
// GFX11: encoding: [0xf7,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], 0xaf123456
// GFX11: encoding: [0xff,0x7c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_fract_f64 v[5:6], 0x3f717273
// GFX11: encoding: [0xff,0x7c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_frexp_exp_i32_f32 v5, v1
// GFX11: encoding: [0x01,0x7f,0x0a,0x7e]

v_frexp_exp_i32_f32 v255, v1
// GFX11: encoding: [0x01,0x7f,0xfe,0x7f]

v_frexp_exp_i32_f32 v5, v255
// GFX11: encoding: [0xff,0x7f,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, s1
// GFX11: encoding: [0x01,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, s103
// GFX11: encoding: [0x67,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, m0
// GFX11: encoding: [0x7d,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, 0
// GFX11: encoding: [0x80,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, -1
// GFX11: encoding: [0xc1,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x7e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_frexp_exp_i32_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x7e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_frexp_exp_i32_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, v[1:2]
// GFX11: encoding: [0x01,0x79,0x0a,0x7e]

v_frexp_exp_i32_f64 v255, v[1:2]
// GFX11: encoding: [0x01,0x79,0xfe,0x7f]

v_frexp_exp_i32_f64 v5, v[254:255]
// GFX11: encoding: [0xfe,0x79,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, s[2:3]
// GFX11: encoding: [0x02,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, s[4:5]
// GFX11: encoding: [0x04,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, s[102:103]
// GFX11: encoding: [0x66,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, vcc
// GFX11: encoding: [0x6a,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, exec
// GFX11: encoding: [0x7e,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, 0
// GFX11: encoding: [0x80,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, -1
// GFX11: encoding: [0xc1,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, 0.5
// GFX11: encoding: [0xf0,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, -4.0
// GFX11: encoding: [0xf7,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, 0xaf123456
// GFX11: encoding: [0xff,0x78,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_frexp_exp_i32_f64 v5, 0x3f717273
// GFX11: encoding: [0xff,0x78,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_frexp_mant_f32 v5, v1
// GFX11: encoding: [0x01,0x81,0x0a,0x7e]

v_frexp_mant_f32 v255, v1
// GFX11: encoding: [0x01,0x81,0xfe,0x7f]

v_frexp_mant_f32 v5, v255
// GFX11: encoding: [0xff,0x81,0x0a,0x7e]

v_frexp_mant_f32 v5, s1
// GFX11: encoding: [0x01,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, s103
// GFX11: encoding: [0x67,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, m0
// GFX11: encoding: [0x7d,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, 0
// GFX11: encoding: [0x80,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, -1
// GFX11: encoding: [0xc1,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x80,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_frexp_mant_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x80,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_frexp_mant_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x80,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], v[1:2]
// GFX11: encoding: [0x01,0x7b,0x0a,0x7e]

v_frexp_mant_f64 v[254:255], v[1:2]
// GFX11: encoding: [0x01,0x7b,0xfc,0x7f]

v_frexp_mant_f64 v[5:6], v[254:255]
// GFX11: encoding: [0xfe,0x7b,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], s[2:3]
// GFX11: encoding: [0x02,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], s[4:5]
// GFX11: encoding: [0x04,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], s[102:103]
// GFX11: encoding: [0x66,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], vcc
// GFX11: encoding: [0x6a,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], exec
// GFX11: encoding: [0x7e,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], 0
// GFX11: encoding: [0x80,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], -1
// GFX11: encoding: [0xc1,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], 0.5
// GFX11: encoding: [0xf0,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], -4.0
// GFX11: encoding: [0xf7,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], 0xaf123456
// GFX11: encoding: [0xff,0x7a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_frexp_mant_f64 v[5:6], 0x3f717273
// GFX11: encoding: [0xff,0x7a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ldexp_f32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0x05,0x02,0x00]

v_ldexp_f32 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x1c,0xd7,0x01,0x05,0x02,0x00]

v_ldexp_f32 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0xff,0x05,0x02,0x00]

v_ldexp_f32 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0x04,0x02,0x00]

v_ldexp_f32 v5, s103, v2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x67,0x04,0x02,0x00]

v_ldexp_f32 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x6a,0x04,0x02,0x00]

v_ldexp_f32 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x6b,0x04,0x02,0x00]

v_ldexp_f32 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x7d,0x04,0x02,0x00]

v_ldexp_f32 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x7e,0x04,0x02,0x00]

v_ldexp_f32 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x7f,0x04,0x02,0x00]

v_ldexp_f32 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x80,0x04,0x02,0x00]

v_ldexp_f32 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0xc1,0x04,0x02,0x00]

v_ldexp_f32 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0xf0,0x04,0x02,0x00]

v_ldexp_f32 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0xf7,0x04,0x02,0x00]

v_ldexp_f32 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0xff,0x03,0x00]

v_ldexp_f32 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0x05,0x00,0x00]

v_ldexp_f32 v5, v1, s103
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0xcf,0x00,0x00]

v_ldexp_f32 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0xd5,0x00,0x00]

v_ldexp_f32 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0xd7,0x00,0x00]

v_ldexp_f32 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0xfb,0x00,0x00]

v_ldexp_f32 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0xfd,0x00,0x00]

v_ldexp_f32 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0xff,0x00,0x00]

v_ldexp_f32 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0x01,0x01,0x00]

v_ldexp_f32 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0x83,0x01,0x00]

v_ldexp_f32 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0xe1,0x01,0x00]

v_ldexp_f32 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0xef,0x01,0x00]

v_ldexp_f32 v5, -v1, v2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0x05,0x02,0x20]

v_ldexp_f32 v5, v1, v2 clamp
// GFX11: encoding: [0x05,0x80,0x1c,0xd7,0x01,0x05,0x02,0x00]

v_ldexp_f32 v5, v1, v2 mul:2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0x05,0x02,0x08]

v_ldexp_f32 v5, v1, v2 mul:4
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0x05,0x02,0x10]

v_ldexp_f32 v5, v1, v2 div:2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0x05,0x02,0x18]

v_ldexp_f32 v5, ttmp11, v2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x77,0x04,0x02,0x00]

v_ldexp_f32 v5, v1, ttmp11
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0xef,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], v2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0x05,0x02,0x00]

v_ldexp_f64 v[254:255], v[1:2], v2
// GFX11: encoding: [0xfe,0x00,0x2b,0xd7,0x01,0x05,0x02,0x00]

v_ldexp_f64 v[5:6], v[254:255], v2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0xfe,0x05,0x02,0x00]

v_ldexp_f64 v[5:6], s[2:3], v2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x02,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], s[4:5], v2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x04,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], s[102:103], v2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x66,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], vcc, v2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x6a,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], exec, v2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x7e,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], 0, v2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x80,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], -1, v2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0xc1,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], 0.5, v2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0xf0,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], -4.0, v2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0xf7,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], v[1:2], v255
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0xff,0x03,0x00]

v_ldexp_f64 v[5:6], v[1:2], s2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0x05,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], s103
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0xcf,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], vcc_lo
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0xd5,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], vcc_hi
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0xd7,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], m0
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0xfb,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], exec_lo
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0xfd,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], exec_hi
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0xff,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], 0
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0x01,0x01,0x00]

v_ldexp_f64 v[5:6], v[1:2], -1
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0x83,0x01,0x00]

v_ldexp_f64 v[5:6], v[1:2], 0.5
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0xe1,0x01,0x00]

v_ldexp_f64 v[5:6], v[1:2], -4.0
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0xef,0x01,0x00]

v_ldexp_f64 v[5:6], -v[1:2], v2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0x05,0x02,0x20]

v_ldexp_f64 v[5:6], v[1:2], v2 clamp
// GFX11: encoding: [0x05,0x80,0x2b,0xd7,0x01,0x05,0x02,0x00]

v_ldexp_f64 v[5:6], v[1:2], v2 mul:2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0x05,0x02,0x08]

v_ldexp_f64 v[5:6], v[1:2], v2 mul:4
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0x05,0x02,0x10]

v_ldexp_f64 v[5:6], v[1:2], v2 div:2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0x05,0x02,0x18]

v_ldexp_f64 v[5:6], v[1:2], ttmp11
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0xef,0x00,0x00]

v_lerp_u8 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x05,0x0e,0x04]

v_lerp_u8 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x15,0xd6,0x01,0x05,0x0e,0x04]

v_lerp_u8 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0xff,0x05,0x0e,0x04]

v_lerp_u8 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x04,0x0e,0x04]

v_lerp_u8 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x67,0x04,0x0e,0x04]

v_lerp_u8 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x6a,0x04,0x0e,0x04]

v_lerp_u8 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x6b,0x04,0x0e,0x04]

v_lerp_u8 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x7d,0x04,0x0e,0x04]

v_lerp_u8 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x7e,0x04,0x0e,0x04]

v_lerp_u8 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x7f,0x04,0x0e,0x04]

v_lerp_u8 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x80,0x04,0x0e,0x04]

v_lerp_u8 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0xc1,0x04,0x0e,0x04]

v_lerp_u8 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0xf0,0x04,0x0e,0x04]

v_lerp_u8 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0xf7,0x04,0x0e,0x04]

v_lerp_u8 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0xff,0x0f,0x04]

v_lerp_u8 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x05,0x0c,0x04]

v_lerp_u8 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0xcf,0x0c,0x04]

v_lerp_u8 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0xd5,0x0c,0x04]

v_lerp_u8 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0xd7,0x0c,0x04]

v_lerp_u8 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0xfb,0x0c,0x04]

v_lerp_u8 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0xfd,0x0c,0x04]

v_lerp_u8 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0xff,0x0c,0x04]

v_lerp_u8 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x01,0x0d,0x04]

v_lerp_u8 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x83,0x0d,0x04]

v_lerp_u8 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0xe1,0x0d,0x04]

v_lerp_u8 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0xef,0x0d,0x04]

v_lerp_u8 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x05,0xfe,0x07]

v_lerp_u8 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x05,0x0e,0x00]

v_lerp_u8 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x05,0x9e,0x01]

v_lerp_u8 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x05,0xaa,0x01]

v_lerp_u8 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x05,0xae,0x01]

v_lerp_u8 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x05,0xf6,0x01]

v_lerp_u8 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x05,0xfa,0x01]

v_lerp_u8 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x05,0xfe,0x01]

v_lerp_u8 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x05,0x02,0x02]

v_lerp_u8 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x05,0x06,0x03]

v_lerp_u8 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x05,0xc2,0x03]

v_lerp_u8 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x05,0xde,0x03]

v_lerp_u8 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x77,0x04,0x0e,0x04]

v_lerp_u8 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0xef,0x0c,0x04]

v_lerp_u8 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x05,0xde,0x01]

v_log_f32 v5, v1
// GFX11: encoding: [0x01,0x4f,0x0a,0x7e]

v_log_f32 v255, v1
// GFX11: encoding: [0x01,0x4f,0xfe,0x7f]

v_log_f32 v5, v255
// GFX11: encoding: [0xff,0x4f,0x0a,0x7e]

v_log_f32 v5, s1
// GFX11: encoding: [0x01,0x4e,0x0a,0x7e]

v_log_f32 v5, s103
// GFX11: encoding: [0x67,0x4e,0x0a,0x7e]

v_log_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x4e,0x0a,0x7e]

v_log_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x4e,0x0a,0x7e]

v_log_f32 v5, m0
// GFX11: encoding: [0x7d,0x4e,0x0a,0x7e]

v_log_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x4e,0x0a,0x7e]

v_log_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x4e,0x0a,0x7e]

v_log_f32 v5, 0
// GFX11: encoding: [0x80,0x4e,0x0a,0x7e]

v_log_f32 v5, -1
// GFX11: encoding: [0xc1,0x4e,0x0a,0x7e]

v_log_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x4e,0x0a,0x7e]

v_log_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x4e,0x0a,0x7e]

v_log_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x4e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_log_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x4e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_log_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x4e,0x0a,0x7e]

v_lshl_add_u32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x05,0x0e,0x04]

v_lshl_add_u32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x46,0xd6,0x01,0x05,0x0e,0x04]

v_lshl_add_u32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0xff,0x05,0x0e,0x04]

v_lshl_add_u32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x04,0x0e,0x04]

v_lshl_add_u32 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x65,0x04,0x0e,0x04]

v_lshl_add_u32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x6a,0x04,0x0e,0x04]

v_lshl_add_u32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x6b,0x04,0x0e,0x04]

v_lshl_add_u32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x7d,0x04,0x0e,0x04]

v_lshl_add_u32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x7e,0x04,0x0e,0x04]

v_lshl_add_u32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x7f,0x04,0x0e,0x04]

v_lshl_add_u32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x80,0x04,0x0e,0x04]

v_lshl_add_u32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0xc1,0x04,0x0e,0x04]

v_lshl_add_u32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0xf0,0x04,0x0e,0x04]

v_lshl_add_u32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0xf7,0x04,0x0e,0x04]

v_lshl_add_u32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0xff,0x0f,0x04]

v_lshl_add_u32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x05,0x0c,0x04]

v_lshl_add_u32 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0xcb,0x0c,0x04]

v_lshl_add_u32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0xd5,0x0c,0x04]

v_lshl_add_u32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0xd7,0x0c,0x04]

v_lshl_add_u32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0xfb,0x0c,0x04]

v_lshl_add_u32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0xfd,0x0c,0x04]

v_lshl_add_u32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0xff,0x0c,0x04]

v_lshl_add_u32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x01,0x0d,0x04]

v_lshl_add_u32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x83,0x0d,0x04]

v_lshl_add_u32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0xe1,0x0d,0x04]

v_lshl_add_u32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0xef,0x0d,0x04]

v_lshl_add_u32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x05,0xfe,0x07]

v_lshl_add_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x05,0x0e,0x00]

v_lshl_add_u32 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x05,0x96,0x01]

v_lshl_add_u32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x05,0xaa,0x01]

v_lshl_add_u32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x05,0xae,0x01]

v_lshl_add_u32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x05,0xf6,0x01]

v_lshl_add_u32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x05,0xfa,0x01]

v_lshl_add_u32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x05,0xfe,0x01]

v_lshl_add_u32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x05,0x02,0x02]

v_lshl_add_u32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x05,0x06,0x03]

v_lshl_add_u32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x05,0xc2,0x03]

v_lshl_add_u32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x05,0xde,0x03]

v_lshl_or_b32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x05,0x0e,0x04]

v_lshl_or_b32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x56,0xd6,0x01,0x05,0x0e,0x04]

v_lshl_or_b32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0xff,0x05,0x0e,0x04]

v_lshl_or_b32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x04,0x0e,0x04]

v_lshl_or_b32 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x65,0x04,0x0e,0x04]

v_lshl_or_b32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x6a,0x04,0x0e,0x04]

v_lshl_or_b32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x6b,0x04,0x0e,0x04]

v_lshl_or_b32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x7d,0x04,0x0e,0x04]

v_lshl_or_b32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x7e,0x04,0x0e,0x04]

v_lshl_or_b32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x7f,0x04,0x0e,0x04]

v_lshl_or_b32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x80,0x04,0x0e,0x04]

v_lshl_or_b32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0xc1,0x04,0x0e,0x04]

v_lshl_or_b32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0xf0,0x04,0x0e,0x04]

v_lshl_or_b32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0xf7,0x04,0x0e,0x04]

v_lshl_or_b32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0xff,0x0f,0x04]

v_lshl_or_b32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x05,0x0c,0x04]

v_lshl_or_b32 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0xcb,0x0c,0x04]

v_lshl_or_b32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0xd5,0x0c,0x04]

v_lshl_or_b32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0xd7,0x0c,0x04]

v_lshl_or_b32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0xfb,0x0c,0x04]

v_lshl_or_b32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0xfd,0x0c,0x04]

v_lshl_or_b32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0xff,0x0c,0x04]

v_lshl_or_b32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x01,0x0d,0x04]

v_lshl_or_b32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x83,0x0d,0x04]

v_lshl_or_b32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0xe1,0x0d,0x04]

v_lshl_or_b32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0xef,0x0d,0x04]

v_lshl_or_b32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x05,0xfe,0x07]

v_lshl_or_b32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x05,0x0e,0x00]

v_lshl_or_b32 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x05,0x96,0x01]

v_lshl_or_b32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x05,0xaa,0x01]

v_lshl_or_b32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x05,0xae,0x01]

v_lshl_or_b32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x05,0xf6,0x01]

v_lshl_or_b32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x05,0xfa,0x01]

v_lshl_or_b32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x05,0xfe,0x01]

v_lshl_or_b32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x05,0x02,0x02]

v_lshl_or_b32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x05,0x06,0x03]

v_lshl_or_b32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x05,0xc2,0x03]

v_lshl_or_b32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x05,0xde,0x03]

v_lshlrev_b16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x01,0x05,0x02,0x00]

v_lshlrev_b16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x38,0xd7,0x01,0x05,0x02,0x00]

v_lshlrev_b16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0xff,0x05,0x02,0x00]

v_lshlrev_b16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x01,0x04,0x02,0x00]

v_lshlrev_b16 v5, s101, v2
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x65,0x04,0x02,0x00]

v_lshlrev_b16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x6a,0x04,0x02,0x00]

v_lshlrev_b16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x6b,0x04,0x02,0x00]

v_lshlrev_b16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x7d,0x04,0x02,0x00]

v_lshlrev_b16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x7e,0x04,0x02,0x00]

v_lshlrev_b16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x7f,0x04,0x02,0x00]

v_lshlrev_b16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x80,0x04,0x02,0x00]

v_lshlrev_b16 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0xc1,0x04,0x02,0x00]

v_lshlrev_b16 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_lshlrev_b16 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_lshlrev_b16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x01,0xff,0x03,0x00]

v_lshlrev_b16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x01,0x05,0x00,0x00]

v_lshlrev_b16 v5, v1, s101
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x01,0xcb,0x00,0x00]

v_lshlrev_b16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x01,0xd5,0x00,0x00]

v_lshlrev_b16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x01,0xd7,0x00,0x00]

v_lshlrev_b16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x01,0xfb,0x00,0x00]

v_lshlrev_b16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x01,0xfd,0x00,0x00]

v_lshlrev_b16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x01,0xff,0x00,0x00]

v_lshlrev_b16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x01,0x01,0x01,0x00]

v_lshlrev_b16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x01,0x83,0x01,0x00]

v_lshlrev_b64 v[5:6], v1, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x01,0x05,0x02,0x00]

v_lshlrev_b64 v[254:255], v1, v[2:3]
// GFX11: encoding: [0xfe,0x00,0x3c,0xd7,0x01,0x05,0x02,0x00]

v_lshlrev_b64 v[5:6], v255, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0xff,0x05,0x02,0x00]

v_lshlrev_b64 v[5:6], s1, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x01,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], s101, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x65,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], vcc_lo, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x6a,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], vcc_hi, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x6b,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], m0, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x7d,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], exec_lo, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x7e,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], exec_hi, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x7f,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], 0, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x80,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], -1, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0xc1,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], 0.5, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0xf0,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], -4.0, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0xf7,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], v1, v[254:255]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x01,0xfd,0x03,0x00]

v_lshlrev_b64 v[5:6], v1, s[4:5]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x01,0x09,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, s[6:7]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x01,0x0d,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, s[100:101]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x01,0xc9,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, vcc
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x01,0xd5,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, exec
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x01,0xfd,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, 0
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x01,0x01,0x01,0x00]

v_lshlrev_b64 v[5:6], v1, -1
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x01,0x83,0x01,0x00]

v_lshlrev_b64 v[5:6], v1, 0.5
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x01,0xe1,0x01,0x00]

v_lshlrev_b64 v[5:6], v1, -4.0
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x01,0xef,0x01,0x00]

v_lshrrev_b16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x01,0x05,0x02,0x00]

v_lshrrev_b16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x39,0xd7,0x01,0x05,0x02,0x00]

v_lshrrev_b16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0xff,0x05,0x02,0x00]

v_lshrrev_b16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x01,0x04,0x02,0x00]

v_lshrrev_b16 v5, s101, v2
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x65,0x04,0x02,0x00]

v_lshrrev_b16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x6a,0x04,0x02,0x00]

v_lshrrev_b16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x6b,0x04,0x02,0x00]

v_lshrrev_b16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x7d,0x04,0x02,0x00]

v_lshrrev_b16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x7e,0x04,0x02,0x00]

v_lshrrev_b16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x7f,0x04,0x02,0x00]

v_lshrrev_b16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x80,0x04,0x02,0x00]

v_lshrrev_b16 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0xc1,0x04,0x02,0x00]

v_lshrrev_b16 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_lshrrev_b16 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_lshrrev_b16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x01,0xff,0x03,0x00]

v_lshrrev_b16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x01,0x05,0x00,0x00]

v_lshrrev_b16 v5, v1, s101
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x01,0xcb,0x00,0x00]

v_lshrrev_b16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x01,0xd5,0x00,0x00]

v_lshrrev_b16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x01,0xd7,0x00,0x00]

v_lshrrev_b16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x01,0xfb,0x00,0x00]

v_lshrrev_b16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x01,0xfd,0x00,0x00]

v_lshrrev_b16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x01,0xff,0x00,0x00]

v_lshrrev_b16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x01,0x01,0x01,0x00]

v_lshrrev_b16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x01,0x83,0x01,0x00]

v_lshrrev_b16 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_lshrrev_b16 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x01,0x05,0x02,0x00]

v_lshrrev_b64 v[254:255], v1, v[2:3]
// GFX11: encoding: [0xfe,0x00,0x3d,0xd7,0x01,0x05,0x02,0x00]

v_lshrrev_b64 v[5:6], v255, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0xff,0x05,0x02,0x00]

v_lshrrev_b64 v[5:6], s1, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x01,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], s101, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x65,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], vcc_lo, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x6a,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], vcc_hi, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x6b,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], m0, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x7d,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], exec_lo, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x7e,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], exec_hi, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x7f,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], 0, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x80,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], -1, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0xc1,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], 0.5, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0xf0,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], -4.0, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0xf7,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], v1, v[254:255]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x01,0xfd,0x03,0x00]

v_lshrrev_b64 v[5:6], v1, s[4:5]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x01,0x09,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, s[6:7]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x01,0x0d,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, s[100:101]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x01,0xc9,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, vcc
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x01,0xd5,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, exec
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x01,0xfd,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, 0
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x01,0x01,0x01,0x00]

v_lshrrev_b64 v[5:6], v1, -1
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x01,0x83,0x01,0x00]

v_lshrrev_b64 v[5:6], v1, 0.5
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x01,0xe1,0x01,0x00]

v_lshrrev_b64 v[5:6], v1, -4.0
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x01,0xef,0x01,0x00]

v_mad_i16 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x53,0xd6,0x80,0x04,0x0e,0x04]

v_mad_i16 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x53,0xd6,0x01,0x83,0x0d,0x04]

v_mad_i16 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x53,0xd6,0x01,0x05,0xfe,0x03,0x00,0xc4,0x00,0x00]

v_mad_i16 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x53,0xd6,0x01,0x05,0x0e,0x04]

v_mad_i32_i16 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x05,0x0e,0x04]

v_mad_i32_i16 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x5a,0xd6,0x01,0x05,0x0e,0x04]

v_mad_i32_i16 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0xff,0x05,0x0e,0x04]

v_mad_i32_i16 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x04,0x0e,0x04]

v_mad_i32_i16 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x65,0x04,0x0e,0x04]

v_mad_i32_i16 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x6a,0x04,0x0e,0x04]

v_mad_i32_i16 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x6b,0x04,0x0e,0x04]

v_mad_i32_i16 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x7d,0x04,0x0e,0x04]

v_mad_i32_i16 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x7e,0x04,0x0e,0x04]

v_mad_i32_i16 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x7f,0x04,0x0e,0x04]

v_mad_i32_i16 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x80,0x04,0x0e,0x04]

v_mad_i32_i16 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0xc1,0x04,0x0e,0x04]

v_mad_i32_i16 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0xff,0x04,0x0e,0x04,0x00,0x38,0x00,0x00]

v_mad_i32_i16 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0xff,0x04,0x0e,0x04,0x00,0xc4,0x00,0x00]

v_mad_i32_i16 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0xff,0x0f,0x04]

v_mad_i32_i16 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x05,0x0c,0x04]

v_mad_i32_i16 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0xcb,0x0c,0x04]

v_mad_i32_i16 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0xd5,0x0c,0x04]

v_mad_i32_i16 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0xd7,0x0c,0x04]

v_mad_i32_i16 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0xfb,0x0c,0x04]

v_mad_i32_i16 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0xfd,0x0c,0x04]

v_mad_i32_i16 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0xff,0x0c,0x04]

v_mad_i32_i16 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x01,0x0d,0x04]

v_mad_i32_i16 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x83,0x0d,0x04]

v_mad_i32_i16 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x05,0xfe,0x07]

v_mad_i32_i16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x05,0x0e,0x00]

v_mad_i32_i16 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x05,0x96,0x01]

v_mad_i32_i16 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x05,0xaa,0x01]

v_mad_i32_i16 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x05,0xae,0x01]

v_mad_i32_i16 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x05,0xf6,0x01]

v_mad_i32_i16 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x05,0xfa,0x01]

v_mad_i32_i16 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x05,0xfe,0x01]

v_mad_i32_i16 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x05,0x02,0x02]

v_mad_i32_i16 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x05,0x06,0x03]

v_mad_i32_i16 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x05,0xc2,0x03]

v_mad_i32_i16 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x05,0xde,0x03]

v_mad_i32_i16 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x5a,0xd6,0x01,0x05,0x0e,0x04]

v_mad_i32_i24 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x05,0x0e,0x04]

v_mad_i32_i24 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x0a,0xd6,0x01,0x05,0x0e,0x04]

v_mad_i32_i24 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0xff,0x05,0x0e,0x04]

v_mad_i32_i24 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x04,0x0e,0x04]

v_mad_i32_i24 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x67,0x04,0x0e,0x04]

v_mad_i32_i24 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x6a,0x04,0x0e,0x04]

v_mad_i32_i24 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x6b,0x04,0x0e,0x04]

v_mad_i32_i24 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x7d,0x04,0x0e,0x04]

v_mad_i32_i24 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x7e,0x04,0x0e,0x04]

v_mad_i32_i24 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x7f,0x04,0x0e,0x04]

v_mad_i32_i24 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x80,0x04,0x0e,0x04]

v_mad_i32_i24 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0xc1,0x04,0x0e,0x04]

v_mad_i32_i24 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0xf0,0x04,0x0e,0x04]

v_mad_i32_i24 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0xf7,0x04,0x0e,0x04]

v_mad_i32_i24 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0xff,0x0f,0x04]

v_mad_i32_i24 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x05,0x0c,0x04]

v_mad_i32_i24 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0xcf,0x0c,0x04]

v_mad_i32_i24 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0xd5,0x0c,0x04]

v_mad_i32_i24 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0xd7,0x0c,0x04]

v_mad_i32_i24 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0xfb,0x0c,0x04]

v_mad_i32_i24 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0xfd,0x0c,0x04]

v_mad_i32_i24 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0xff,0x0c,0x04]

v_mad_i32_i24 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x01,0x0d,0x04]

v_mad_i32_i24 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x83,0x0d,0x04]

v_mad_i32_i24 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0xe1,0x0d,0x04]

v_mad_i32_i24 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0xef,0x0d,0x04]

v_mad_i32_i24 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x05,0xfe,0x07]

v_mad_i32_i24 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x05,0x0e,0x00]

v_mad_i32_i24 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x05,0x9e,0x01]

v_mad_i32_i24 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x05,0xaa,0x01]

v_mad_i32_i24 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x05,0xae,0x01]

v_mad_i32_i24 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x05,0xf6,0x01]

v_mad_i32_i24 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x05,0xfa,0x01]

v_mad_i32_i24 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x05,0xfe,0x01]

v_mad_i32_i24 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x05,0x02,0x02]

v_mad_i32_i24 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x05,0x06,0x03]

v_mad_i32_i24 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x05,0xc2,0x03]

v_mad_i32_i24 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x05,0xde,0x03]

v_mad_i32_i24 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x77,0x04,0x0e,0x04]

v_mad_i32_i24 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0xef,0x0c,0x04]

v_mad_i32_i24 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x05,0xde,0x01]

v_mad_i64_i32 v[5:6], s12, v1, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[254:255], s12, v1, v2, v[3:4]
// W32: encoding: [0xfe,0x0c,0xff,0xd6,0x01,0x05,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s14, v1, v2, v[3:4]
// W32: encoding: [0x05,0x0e,0xff,0xd6,0x01,0x05,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s100, v1, v2, v[3:4]
// W32: encoding: [0x05,0x64,0xff,0xd6,0x01,0x05,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v255, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0xff,0x05,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, s1, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, s101, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x65,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, vcc_lo, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x6a,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, vcc_hi, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x6b,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, m0, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x7d,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, exec_lo, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x7e,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, exec_hi, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x7f,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, 0, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x80,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, -1, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0xc1,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, 0.5, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0xf0,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, -4.0, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0xf7,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v255, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xff,0x0f,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, s2, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0x0c,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, s101, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xcb,0x0c,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, vcc_lo, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xd5,0x0c,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, vcc_hi, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xd7,0x0c,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, m0, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xfb,0x0c,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, exec_lo, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xfd,0x0c,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, exec_hi, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xff,0x0c,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, 0, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x01,0x0d,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, -1, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x83,0x0d,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, 0.5, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xe1,0x0d,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, -4.0, v[3:4]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xef,0x0d,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, v[254:255]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0xfa,0x07]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, s[6:7]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0x1a,0x00]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, s[8:9]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0x22,0x00]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, s[100:101]
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0x92,0x01]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, vcc
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0xaa,0x01]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, exec
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0xfa,0x01]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, 0
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0x02,0x02]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, -1
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0x06,0x03]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, 0.5
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0xc2,0x03]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, -4.0
// W32: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0xde,0x03]
// W64-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[254:255], s[12:13], v1, v2, v[3:4]
// W64: encoding: [0xfe,0x0c,0xff,0xd6,0x01,0x05,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[14:15], v1, v2, v[3:4]
// W64: encoding: [0x05,0x0e,0xff,0xd6,0x01,0x05,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[100:101], v1, v2, v[3:4]
// W64: encoding: [0x05,0x64,0xff,0xd6,0x01,0x05,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v255, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0xff,0x05,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], s1, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], s101, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x65,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], vcc_lo, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x6a,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], vcc_hi, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x6b,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], m0, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x7d,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], exec_lo, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x7e,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], exec_hi, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x7f,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], 0, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x80,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], -1, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0xc1,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], 0.5, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0xf0,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], -4.0, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0xf7,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v255, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xff,0x0f,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, s2, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0x0c,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, s101, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xcb,0x0c,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, vcc_lo, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xd5,0x0c,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, vcc_hi, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xd7,0x0c,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, m0, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xfb,0x0c,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, exec_lo, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xfd,0x0c,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, exec_hi, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xff,0x0c,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, 0, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x01,0x0d,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, -1, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x83,0x0d,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, 0.5, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xe1,0x0d,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, -4.0, v[3:4]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0xef,0x0d,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, v[254:255]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0xfa,0x07]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0x1a,0x00]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, s[8:9]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0x22,0x00]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, s[100:101]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0x92,0x01]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, vcc
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0xaa,0x01]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, exec
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0xfa,0x01]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, 0
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0x02,0x02]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, -1
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0x06,0x03]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, 0.5
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0xc2,0x03]
// W32-ERR: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, -4.0
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x01,0x05,0xde,0x03]
// W32-ERR: error: invalid operand for instruction

v_mad_u16 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x41,0xd6,0x80,0x04,0x0e,0x04]

v_mad_u16 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x41,0xd6,0x01,0x83,0x0d,0x04]

v_mad_u16 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x41,0xd6,0x01,0x05,0xfe,0x03,0x00,0xc4,0x00,0x00]

v_mad_u16 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x41,0xd6,0x01,0x05,0x0e,0x04]

v_mad_u32_u16 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x05,0x0e,0x04]

v_mad_u32_u16 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x59,0xd6,0x01,0x05,0x0e,0x04]

v_mad_u32_u16 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0xff,0x05,0x0e,0x04]

v_mad_u32_u16 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x04,0x0e,0x04]

v_mad_u32_u16 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x65,0x04,0x0e,0x04]

v_mad_u32_u16 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x6a,0x04,0x0e,0x04]

v_mad_u32_u16 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x6b,0x04,0x0e,0x04]

v_mad_u32_u16 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x7d,0x04,0x0e,0x04]

v_mad_u32_u16 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x7e,0x04,0x0e,0x04]

v_mad_u32_u16 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x7f,0x04,0x0e,0x04]

v_mad_u32_u16 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x80,0x04,0x0e,0x04]

v_mad_u32_u16 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0xc1,0x04,0x0e,0x04]

v_mad_u32_u16 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0xff,0x04,0x0e,0x04,0x00,0x38,0x00,0x00]

v_mad_u32_u16 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0xff,0x04,0x0e,0x04,0x00,0xc4,0x00,0x00]

v_mad_u32_u16 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0xff,0x0f,0x04]

v_mad_u32_u16 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x05,0x0c,0x04]

v_mad_u32_u16 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0xcb,0x0c,0x04]

v_mad_u32_u16 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0xd5,0x0c,0x04]

v_mad_u32_u16 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0xd7,0x0c,0x04]

v_mad_u32_u16 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0xfb,0x0c,0x04]

v_mad_u32_u16 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0xfd,0x0c,0x04]

v_mad_u32_u16 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0xff,0x0c,0x04]

v_mad_u32_u16 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x01,0x0d,0x04]

v_mad_u32_u16 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x83,0x0d,0x04]

v_mad_u32_u16 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x05,0xfe,0x07]

v_mad_u32_u16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x05,0x0e,0x00]

v_mad_u32_u16 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x05,0x96,0x01]

v_mad_u32_u16 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x05,0xaa,0x01]

v_mad_u32_u16 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x05,0xae,0x01]

v_mad_u32_u16 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x05,0xf6,0x01]

v_mad_u32_u16 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x05,0xfa,0x01]

v_mad_u32_u16 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x05,0xfe,0x01]

v_mad_u32_u16 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x05,0x02,0x02]

v_mad_u32_u16 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x05,0x06,0x03]

v_mad_u32_u16 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x05,0xc2,0x03]

v_mad_u32_u16 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x05,0xde,0x03]

v_mad_u32_u16 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x59,0xd6,0x01,0x05,0x0e,0x04]

v_mad_u32_u24 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x05,0x0e,0x04]

v_mad_u32_u24 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x0b,0xd6,0x01,0x05,0x0e,0x04]

v_mad_u32_u24 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0xff,0x05,0x0e,0x04]

v_mad_u32_u24 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x04,0x0e,0x04]

v_mad_u32_u24 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x67,0x04,0x0e,0x04]

v_mad_u32_u24 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x6a,0x04,0x0e,0x04]

v_mad_u32_u24 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x6b,0x04,0x0e,0x04]

v_mad_u32_u24 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x7d,0x04,0x0e,0x04]

v_mad_u32_u24 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x7e,0x04,0x0e,0x04]

v_mad_u32_u24 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x7f,0x04,0x0e,0x04]

v_mad_u32_u24 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x80,0x04,0x0e,0x04]

v_mad_u32_u24 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0xc1,0x04,0x0e,0x04]

v_mad_u32_u24 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0xf0,0x04,0x0e,0x04]

v_mad_u32_u24 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0xf7,0x04,0x0e,0x04]

v_mad_u32_u24 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0xff,0x0f,0x04]

v_mad_u32_u24 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x05,0x0c,0x04]

v_mad_u32_u24 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0xcf,0x0c,0x04]

v_mad_u32_u24 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0xd5,0x0c,0x04]

v_mad_u32_u24 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0xd7,0x0c,0x04]

v_mad_u32_u24 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0xfb,0x0c,0x04]

v_mad_u32_u24 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0xfd,0x0c,0x04]

v_mad_u32_u24 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0xff,0x0c,0x04]

v_mad_u32_u24 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x01,0x0d,0x04]

v_mad_u32_u24 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x83,0x0d,0x04]

v_mad_u32_u24 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0xe1,0x0d,0x04]

v_mad_u32_u24 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0xef,0x0d,0x04]

v_mad_u32_u24 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x05,0xfe,0x07]

v_mad_u32_u24 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x05,0x0e,0x00]

v_mad_u32_u24 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x05,0x9e,0x01]

v_mad_u32_u24 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x05,0xaa,0x01]

v_mad_u32_u24 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x05,0xae,0x01]

v_mad_u32_u24 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x05,0xf6,0x01]

v_mad_u32_u24 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x05,0xfa,0x01]

v_mad_u32_u24 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x05,0xfe,0x01]

v_mad_u32_u24 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x05,0x02,0x02]

v_mad_u32_u24 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x05,0x06,0x03]

v_mad_u32_u24 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x05,0xc2,0x03]

v_mad_u32_u24 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x05,0xde,0x03]

v_mad_u32_u24 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x77,0x04,0x0e,0x04]

v_mad_u32_u24 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0xef,0x0c,0x04]

v_mad_u32_u24 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x05,0xde,0x01]

v_mad_u64_u32 v[5:6], s12, v1, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[254:255], s12, v1, v2, v[3:4]
// W32: encoding: [0xfe,0x0c,0xfe,0xd6,0x01,0x05,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s14, v1, v2, v[3:4]
// W32: encoding: [0x05,0x0e,0xfe,0xd6,0x01,0x05,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s100, v1, v2, v[3:4]
// W32: encoding: [0x05,0x64,0xfe,0xd6,0x01,0x05,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v255, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0xff,0x05,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, s1, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, s101, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x65,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, vcc_lo, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x6a,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, vcc_hi, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x6b,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, m0, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x7d,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, exec_lo, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x7e,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, exec_hi, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x7f,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, 0, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x80,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, -1, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0xc1,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, 0.5, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0xf0,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, -4.0, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0xf7,0x04,0x0e,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v255, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xff,0x0f,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, s2, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0x0c,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, s101, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xcb,0x0c,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, vcc_lo, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xd5,0x0c,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, vcc_hi, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xd7,0x0c,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, m0, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xfb,0x0c,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, exec_lo, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xfd,0x0c,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, exec_hi, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xff,0x0c,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, 0, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x01,0x0d,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, -1, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x83,0x0d,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, 0.5, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xe1,0x0d,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, -4.0, v[3:4]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xef,0x0d,0x04]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, v[254:255]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0xfa,0x07]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, s[6:7]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0x1a,0x00]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, s[8:9]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0x22,0x00]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, s[100:101]
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0x92,0x01]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, vcc
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0xaa,0x01]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, exec
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0xfa,0x01]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, 0
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0x02,0x02]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, -1
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0x06,0x03]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, 0.5
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0xc2,0x03]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, -4.0
// W32: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0xde,0x03]
// W64-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[254:255], s[12:13], v1, v2, v[3:4]
// W64: encoding: [0xfe,0x0c,0xfe,0xd6,0x01,0x05,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[14:15], v1, v2, v[3:4]
// W64: encoding: [0x05,0x0e,0xfe,0xd6,0x01,0x05,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[100:101], v1, v2, v[3:4]
// W64: encoding: [0x05,0x64,0xfe,0xd6,0x01,0x05,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v255, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0xff,0x05,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], s1, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], s101, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x65,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], vcc_lo, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x6a,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], vcc_hi, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x6b,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], m0, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x7d,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], exec_lo, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x7e,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], exec_hi, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x7f,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], 0, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x80,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], -1, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0xc1,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], 0.5, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0xf0,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], -4.0, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0xf7,0x04,0x0e,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v255, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xff,0x0f,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, s2, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0x0c,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, s101, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xcb,0x0c,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, vcc_lo, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xd5,0x0c,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, vcc_hi, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xd7,0x0c,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, m0, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xfb,0x0c,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, exec_lo, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xfd,0x0c,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, exec_hi, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xff,0x0c,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, 0, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x01,0x0d,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, -1, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x83,0x0d,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, 0.5, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xe1,0x0d,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, -4.0, v[3:4]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0xef,0x0d,0x04]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, v[254:255]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0xfa,0x07]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0x1a,0x00]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, s[8:9]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0x22,0x00]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, s[100:101]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0x92,0x01]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, vcc
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0xaa,0x01]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, exec
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0xfa,0x01]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, 0
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0x02,0x02]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, -1
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0x06,0x03]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, 0.5
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0xc2,0x03]
// W32-ERR: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, -4.0
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x01,0x05,0xde,0x03]
// W32-ERR: error: invalid operand for instruction

v_max3_f16 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0x0e,0x04]

v_max3_f16 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x4c,0xd6,0x01,0x05,0x0e,0x04]

v_max3_f16 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0xff,0x05,0x0e,0x04]

v_max3_f16 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x04,0x0e,0x04]

v_max3_f16 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x65,0x04,0x0e,0x04]

v_max3_f16 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x6a,0x04,0x0e,0x04]

v_max3_f16 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x6b,0x04,0x0e,0x04]

v_max3_f16 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x7d,0x04,0x0e,0x04]

v_max3_f16 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x7e,0x04,0x0e,0x04]

v_max3_f16 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x7f,0x04,0x0e,0x04]

v_max3_f16 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x80,0x04,0x0e,0x04]

v_max3_f16 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0xc1,0x04,0x0e,0x04]

v_max3_f16 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0xf0,0x04,0x0e,0x04]

v_max3_f16 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0xf7,0x04,0x0e,0x04]

v_max3_f16 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0xff,0x0f,0x04]

v_max3_f16 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0x0c,0x04]

v_max3_f16 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0xcb,0x0c,0x04]

v_max3_f16 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0xd5,0x0c,0x04]

v_max3_f16 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0xd7,0x0c,0x04]

v_max3_f16 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0xfb,0x0c,0x04]

v_max3_f16 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0xfd,0x0c,0x04]

v_max3_f16 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0xff,0x0c,0x04]

v_max3_f16 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x01,0x0d,0x04]

v_max3_f16 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x83,0x0d,0x04]

v_max3_f16 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0xe1,0x0d,0x04]

v_max3_f16 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0xef,0x0d,0x04]

v_max3_f16 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0xfe,0x07]

v_max3_f16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0x0e,0x00]

v_max3_f16 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0x96,0x01]

v_max3_f16 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0xaa,0x01]

v_max3_f16 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0xae,0x01]

v_max3_f16 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0xf6,0x01]

v_max3_f16 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0xfa,0x01]

v_max3_f16 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0xfe,0x01]

v_max3_f16 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0x02,0x02]

v_max3_f16 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0x06,0x03]

v_max3_f16 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0xc2,0x03]

v_max3_f16 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0xde,0x03]

v_max3_f16 v5, -v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0x0e,0x24]

v_max3_f16 v5, v1, -v2, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0x0e,0x44]

v_max3_f16 v5, v1, v2, -v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0x0e,0x84]

v_max3_f16 v5, -v1, -v2, -v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0x0e,0xe4]

v_max3_f16 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x4c,0xd6,0x01,0x05,0x0e,0x04]

v_max3_f32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0x0e,0x04]

v_max3_f32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x1c,0xd6,0x01,0x05,0x0e,0x04]

v_max3_f32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0xff,0x05,0x0e,0x04]

v_max3_f32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x04,0x0e,0x04]

v_max3_f32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x67,0x04,0x0e,0x04]

v_max3_f32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x6a,0x04,0x0e,0x04]

v_max3_f32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x6b,0x04,0x0e,0x04]

v_max3_f32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x7d,0x04,0x0e,0x04]

v_max3_f32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x7e,0x04,0x0e,0x04]

v_max3_f32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x7f,0x04,0x0e,0x04]

v_max3_f32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x80,0x04,0x0e,0x04]

v_max3_f32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0xc1,0x04,0x0e,0x04]

v_max3_f32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0xf0,0x04,0x0e,0x04]

v_max3_f32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0xf7,0x04,0x0e,0x04]

v_max3_f32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0xff,0x0f,0x04]

v_max3_f32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0x0c,0x04]

v_max3_f32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0xcf,0x0c,0x04]

v_max3_f32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0xd5,0x0c,0x04]

v_max3_f32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0xd7,0x0c,0x04]

v_max3_f32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0xfb,0x0c,0x04]

v_max3_f32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0xfd,0x0c,0x04]

v_max3_f32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0xff,0x0c,0x04]

v_max3_f32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x01,0x0d,0x04]

v_max3_f32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x83,0x0d,0x04]

v_max3_f32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0xe1,0x0d,0x04]

v_max3_f32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0xef,0x0d,0x04]

v_max3_f32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0xfe,0x07]

v_max3_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0x0e,0x00]

v_max3_f32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0x9e,0x01]

v_max3_f32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0xaa,0x01]

v_max3_f32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0xae,0x01]

v_max3_f32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0xf6,0x01]

v_max3_f32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0xfa,0x01]

v_max3_f32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0xfe,0x01]

v_max3_f32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0x02,0x02]

v_max3_f32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0x06,0x03]

v_max3_f32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0xc2,0x03]

v_max3_f32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0xde,0x03]

v_max3_f32 v5, -v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0x0e,0x24]

v_max3_f32 v5, v1, -v2, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0x0e,0x44]

v_max3_f32 v5, v1, v2, -v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0x0e,0x84]

v_max3_f32 v5, -v1, -v2, -v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0x0e,0xe4]

v_max3_f32 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x1c,0xd6,0x01,0x05,0x0e,0x04]

v_max3_f32 v5, v1, v2, v3 mul:2
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0x0e,0x0c]

v_max3_f32 v5, v1, v2, v3 mul:4
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0x0e,0x14]

v_max3_f32 v5, v1, v2, v3 div:2
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0x0e,0x1c]

v_max3_f32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x77,0x04,0x0e,0x04]

v_max3_f32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0xef,0x0c,0x04]

v_max3_f32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0xde,0x01]

v_max3_i16 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x05,0x0e,0x04]

v_max3_i16 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x4d,0xd6,0x01,0x05,0x0e,0x04]

v_max3_i16 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0xff,0x05,0x0e,0x04]

v_max3_i16 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x04,0x0e,0x04]

v_max3_i16 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x65,0x04,0x0e,0x04]

v_max3_i16 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x6a,0x04,0x0e,0x04]

v_max3_i16 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x6b,0x04,0x0e,0x04]

v_max3_i16 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x7d,0x04,0x0e,0x04]

v_max3_i16 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x7e,0x04,0x0e,0x04]

v_max3_i16 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x7f,0x04,0x0e,0x04]

v_max3_i16 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x80,0x04,0x0e,0x04]

v_max3_i16 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0xc1,0x04,0x0e,0x04]

v_max3_i16 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0xff,0x04,0x0e,0x04,0x00,0x38,0x00,0x00]

v_max3_i16 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0xff,0x04,0x0e,0x04,0x00,0xc4,0x00,0x00]

v_max3_i16 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0xff,0x0f,0x04]

v_max3_i16 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x05,0x0c,0x04]

v_max3_i16 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0xcb,0x0c,0x04]

v_max3_i16 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0xd5,0x0c,0x04]

v_max3_i16 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0xd7,0x0c,0x04]

v_max3_i16 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0xfb,0x0c,0x04]

v_max3_i16 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0xfd,0x0c,0x04]

v_max3_i16 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0xff,0x0c,0x04]

v_max3_i16 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x01,0x0d,0x04]

v_max3_i16 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x83,0x0d,0x04]

v_max3_i16 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x05,0xfe,0x07]

v_max3_i16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x05,0x0e,0x00]

v_max3_i16 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x05,0x96,0x01]

v_max3_i16 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x05,0xaa,0x01]

v_max3_i16 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x05,0xae,0x01]

v_max3_i16 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x05,0xf6,0x01]

v_max3_i16 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x05,0xfa,0x01]

v_max3_i16 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x05,0xfe,0x01]

v_max3_i16 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x05,0x02,0x02]

v_max3_i16 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x05,0x06,0x03]

v_max3_i16 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x05,0xfe,0x03,0x00,0x38,0x00,0x00]

v_max3_i16 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x05,0xfe,0x03,0x00,0xc4,0x00,0x00]

v_max3_i16 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x4d,0xd6,0x01,0x05,0x0e,0x04]

v_max3_i32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x05,0x0e,0x04]

v_max3_i32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x1d,0xd6,0x01,0x05,0x0e,0x04]

v_max3_i32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0xff,0x05,0x0e,0x04]

v_max3_i32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x04,0x0e,0x04]

v_max3_i32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x67,0x04,0x0e,0x04]

v_max3_i32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x6a,0x04,0x0e,0x04]

v_max3_i32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x6b,0x04,0x0e,0x04]

v_max3_i32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x7d,0x04,0x0e,0x04]

v_max3_i32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x7e,0x04,0x0e,0x04]

v_max3_i32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x7f,0x04,0x0e,0x04]

v_max3_i32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x80,0x04,0x0e,0x04]

v_max3_i32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0xc1,0x04,0x0e,0x04]

v_max3_i32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0xf0,0x04,0x0e,0x04]

v_max3_i32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0xf7,0x04,0x0e,0x04]

v_max3_i32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0xff,0x0f,0x04]

v_max3_i32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x05,0x0c,0x04]

v_max3_i32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0xcf,0x0c,0x04]

v_max3_i32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0xd5,0x0c,0x04]

v_max3_i32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0xd7,0x0c,0x04]

v_max3_i32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0xfb,0x0c,0x04]

v_max3_i32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0xfd,0x0c,0x04]

v_max3_i32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0xff,0x0c,0x04]

v_max3_i32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x01,0x0d,0x04]

v_max3_i32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x83,0x0d,0x04]

v_max3_i32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0xe1,0x0d,0x04]

v_max3_i32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0xef,0x0d,0x04]

v_max3_i32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x05,0xfe,0x07]

v_max3_i32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x05,0x0e,0x00]

v_max3_i32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x05,0x9e,0x01]

v_max3_i32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x05,0xaa,0x01]

v_max3_i32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x05,0xae,0x01]

v_max3_i32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x05,0xf6,0x01]

v_max3_i32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x05,0xfa,0x01]

v_max3_i32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x05,0xfe,0x01]

v_max3_i32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x05,0x02,0x02]

v_max3_i32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x05,0x06,0x03]

v_max3_i32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x05,0xc2,0x03]

v_max3_i32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x05,0xde,0x03]

v_max3_i32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x77,0x04,0x0e,0x04]

v_max3_i32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0xef,0x0c,0x04]

v_max3_i32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x05,0xde,0x01]

v_max3_u16 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x05,0x0e,0x04]

v_max3_u16 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x4e,0xd6,0x01,0x05,0x0e,0x04]

v_max3_u16 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0xff,0x05,0x0e,0x04]

v_max3_u16 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x04,0x0e,0x04]

v_max3_u16 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x65,0x04,0x0e,0x04]

v_max3_u16 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x6a,0x04,0x0e,0x04]

v_max3_u16 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x6b,0x04,0x0e,0x04]

v_max3_u16 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x7d,0x04,0x0e,0x04]

v_max3_u16 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x7e,0x04,0x0e,0x04]

v_max3_u16 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x7f,0x04,0x0e,0x04]

v_max3_u16 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x80,0x04,0x0e,0x04]

v_max3_u16 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0xc1,0x04,0x0e,0x04]

v_max3_u16 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0xff,0x0f,0x04]

v_max3_u16 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x05,0x0c,0x04]

v_max3_u16 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0xcb,0x0c,0x04]

v_max3_u16 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0xd5,0x0c,0x04]

v_max3_u16 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0xd7,0x0c,0x04]

v_max3_u16 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0xfb,0x0c,0x04]

v_max3_u16 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0xfd,0x0c,0x04]

v_max3_u16 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0xff,0x0c,0x04]

v_max3_u16 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x01,0x0d,0x04]

v_max3_u16 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x83,0x0d,0x04]

v_max3_u16 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x05,0xfe,0x07]

v_max3_u16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x05,0x0e,0x00]

v_max3_u16 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x05,0x96,0x01]

v_max3_u16 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x05,0xaa,0x01]

v_max3_u16 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x05,0xae,0x01]

v_max3_u16 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x05,0xf6,0x01]

v_max3_u16 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x05,0xfa,0x01]

v_max3_u16 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x05,0xfe,0x01]

v_max3_u16 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x05,0x02,0x02]

v_max3_u16 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x05,0x06,0x03]

v_max3_u16 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x05,0xfe,0x03,0x00,0x38,0x00,0x00]

v_max3_u16 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x05,0xfe,0x03,0x00,0xc4,0x00,0x00]

v_max3_u16 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x4e,0xd6,0x01,0x05,0x0e,0x04]

v_max3_u32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x05,0x0e,0x04]

v_max3_u32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x1e,0xd6,0x01,0x05,0x0e,0x04]

v_max3_u32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0xff,0x05,0x0e,0x04]

v_max3_u32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x04,0x0e,0x04]

v_max3_u32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x67,0x04,0x0e,0x04]

v_max3_u32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x6a,0x04,0x0e,0x04]

v_max3_u32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x6b,0x04,0x0e,0x04]

v_max3_u32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x7d,0x04,0x0e,0x04]

v_max3_u32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x7e,0x04,0x0e,0x04]

v_max3_u32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x7f,0x04,0x0e,0x04]

v_max3_u32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x80,0x04,0x0e,0x04]

v_max3_u32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0xc1,0x04,0x0e,0x04]

v_max3_u32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0xf0,0x04,0x0e,0x04]

v_max3_u32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0xf7,0x04,0x0e,0x04]

v_max3_u32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0xff,0x0f,0x04]

v_max3_u32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x05,0x0c,0x04]

v_max3_u32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0xcf,0x0c,0x04]

v_max3_u32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0xd5,0x0c,0x04]

v_max3_u32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0xd7,0x0c,0x04]

v_max3_u32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0xfb,0x0c,0x04]

v_max3_u32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0xfd,0x0c,0x04]

v_max3_u32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0xff,0x0c,0x04]

v_max3_u32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x01,0x0d,0x04]

v_max3_u32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x83,0x0d,0x04]

v_max3_u32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0xe1,0x0d,0x04]

v_max3_u32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0xef,0x0d,0x04]

v_max3_u32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x05,0xfe,0x07]

v_max3_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x05,0x0e,0x00]

v_max3_u32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x05,0x9e,0x01]

v_max3_u32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x05,0xaa,0x01]

v_max3_u32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x05,0xae,0x01]

v_max3_u32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x05,0xf6,0x01]

v_max3_u32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x05,0xfa,0x01]

v_max3_u32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x05,0xfe,0x01]

v_max3_u32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x05,0x02,0x02]

v_max3_u32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x05,0x06,0x03]

v_max3_u32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x05,0xc2,0x03]

v_max3_u32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x05,0xde,0x03]

v_max3_u32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x77,0x04,0x0e,0x04]

v_max3_u32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0xef,0x0c,0x04]

v_max3_u32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x05,0xde,0x01]

v_max_f64 v[5:6], v[1:2], v[2:3]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0x05,0x02,0x00]

v_max_f64 v[254:255], v[1:2], v[2:3]
// GFX11: encoding: [0xfe,0x00,0x2a,0xd7,0x01,0x05,0x02,0x00]

v_max_f64 v[5:6], v[254:255], v[2:3]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0xfe,0x05,0x02,0x00]

v_max_f64 v[5:6], s[2:3], v[2:3]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x02,0x04,0x02,0x00]

v_max_f64 v[5:6], s[4:5], v[2:3]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x04,0x04,0x02,0x00]

v_max_f64 v[5:6], s[102:103], v[2:3]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x66,0x04,0x02,0x00]

v_max_f64 v[5:6], vcc, v[2:3]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x6a,0x04,0x02,0x00]

v_max_f64 v[5:6], exec, v[2:3]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x7e,0x04,0x02,0x00]

v_max_f64 v[5:6], 0, v[2:3]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x80,0x04,0x02,0x00]

v_max_f64 v[5:6], -1, v[2:3]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0xc1,0x04,0x02,0x00]

v_max_f64 v[5:6], 0.5, v[2:3]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0xf0,0x04,0x02,0x00]

v_max_f64 v[5:6], -4.0, v[2:3]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0xf7,0x04,0x02,0x00]

v_max_f64 v[5:6], v[1:2], v[254:255]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0xfd,0x03,0x00]

v_max_f64 v[5:6], v[1:2], s[4:5]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0x09,0x00,0x00]

v_max_f64 v[5:6], v[1:2], s[6:7]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0x0d,0x00,0x00]

v_max_f64 v[5:6], v[1:2], s[102:103]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0xcd,0x00,0x00]

v_max_f64 v[5:6], v[1:2], vcc
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0xd5,0x00,0x00]

v_max_f64 v[5:6], v[1:2], exec
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0xfd,0x00,0x00]

v_max_f64 v[5:6], v[1:2], 0
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0x01,0x01,0x00]

v_max_f64 v[5:6], v[1:2], -1
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0x83,0x01,0x00]

v_max_f64 v[5:6], v[1:2], 0.5
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0xe1,0x01,0x00]

v_max_f64 v[5:6], v[1:2], -4.0
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0xef,0x01,0x00]

v_max_f64 v[5:6], -v[1:2], v[2:3]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0x05,0x02,0x20]

v_max_f64 v[5:6], v[1:2], -v[2:3]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0x05,0x02,0x40]

v_max_f64 v[5:6], -v[1:2], -v[2:3]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0x05,0x02,0x60]

v_max_f64 v[5:6], v[1:2], v[2:3] clamp
// GFX11: encoding: [0x05,0x80,0x2a,0xd7,0x01,0x05,0x02,0x00]

v_max_f64 v[5:6], v[1:2], v[2:3] mul:2
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0x05,0x02,0x08]

v_max_f64 v[5:6], v[1:2], v[2:3] mul:4
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0x05,0x02,0x10]

v_max_f64 v[5:6], v[1:2], v[2:3] div:2
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0x05,0x02,0x18]

v_max_i16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x01,0x05,0x02,0x00]

v_max_i16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x0a,0xd7,0x01,0x05,0x02,0x00]

v_max_i16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0xff,0x05,0x02,0x00]

v_max_i16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x01,0x04,0x02,0x00]

v_max_i16 v5, s101, v2
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x65,0x04,0x02,0x00]

v_max_i16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x6a,0x04,0x02,0x00]

v_max_i16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x6b,0x04,0x02,0x00]

v_max_i16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x7d,0x04,0x02,0x00]

v_max_i16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x7e,0x04,0x02,0x00]

v_max_i16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x7f,0x04,0x02,0x00]

v_max_i16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x80,0x04,0x02,0x00]

v_max_i16 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0xc1,0x04,0x02,0x00]

v_max_i16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x01,0xff,0x03,0x00]

v_max_i16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x01,0x05,0x00,0x00]

v_max_i16 v5, v1, s101
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x01,0xcb,0x00,0x00]

v_max_i16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x01,0xd5,0x00,0x00]

v_max_i16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x01,0xd7,0x00,0x00]

v_max_i16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x01,0xfb,0x00,0x00]

v_max_i16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x01,0xfd,0x00,0x00]

v_max_i16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x01,0xff,0x00,0x00]

v_max_i16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x01,0x01,0x01,0x00]

v_max_i16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x01,0x83,0x01,0x00]

v_max_u16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x01,0x05,0x02,0x00]

v_max_u16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x09,0xd7,0x01,0x05,0x02,0x00]

v_max_u16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0xff,0x05,0x02,0x00]

v_max_u16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x01,0x04,0x02,0x00]

v_max_u16 v5, s101, v2
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x65,0x04,0x02,0x00]

v_max_u16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x6a,0x04,0x02,0x00]

v_max_u16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x6b,0x04,0x02,0x00]

v_max_u16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x7d,0x04,0x02,0x00]

v_max_u16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x7e,0x04,0x02,0x00]

v_max_u16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x7f,0x04,0x02,0x00]

v_max_u16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x80,0x04,0x02,0x00]

v_max_u16 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0xc1,0x04,0x02,0x00]

v_max_u16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x01,0xff,0x03,0x00]

v_max_u16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x01,0x05,0x00,0x00]

v_max_u16 v5, v1, s101
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x01,0xcb,0x00,0x00]

v_max_u16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x01,0xd5,0x00,0x00]

v_max_u16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x01,0xd7,0x00,0x00]

v_max_u16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x01,0xfb,0x00,0x00]

v_max_u16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x01,0xfd,0x00,0x00]

v_max_u16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x01,0xff,0x00,0x00]

v_max_u16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x01,0x01,0x01,0x00]

v_max_u16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x01,0x83,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x01,0x05,0x02,0x00]

v_mbcnt_hi_u32_b32 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x20,0xd7,0x01,0x05,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0xff,0x05,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x01,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, s103, v2
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x67,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x6a,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x6b,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x7d,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x7e,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x7f,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x80,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0xc1,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0xf0,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0xf7,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x01,0xff,0x03,0x00]

v_mbcnt_hi_u32_b32 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x01,0x05,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, s103
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x01,0xcf,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x01,0xd5,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x01,0xd7,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x01,0xfb,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x01,0xfd,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x01,0xff,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x01,0x01,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x01,0x83,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x01,0xe1,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x01,0xef,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, ttmp11, v2
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x77,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, v1, ttmp11
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x01,0xef,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x01,0x05,0x02,0x00]

v_mbcnt_lo_u32_b32 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x1f,0xd7,0x01,0x05,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0xff,0x05,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x01,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, s103, v2
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x67,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x6a,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x6b,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x7d,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x7e,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x7f,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x80,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0xc1,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0xf0,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0xf7,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x01,0xff,0x03,0x00]

v_mbcnt_lo_u32_b32 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x01,0x05,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, s103
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x01,0xcf,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x01,0xd5,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x01,0xd7,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x01,0xfb,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x01,0xfd,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x01,0xff,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x01,0x01,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x01,0x83,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x01,0xe1,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x01,0xef,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, ttmp11, v2
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x77,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, v1, ttmp11
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x01,0xef,0x00,0x00]

v_med3_f16 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0x0e,0x04]

v_med3_f16 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x4f,0xd6,0x01,0x05,0x0e,0x04]

v_med3_f16 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0xff,0x05,0x0e,0x04]

v_med3_f16 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x04,0x0e,0x04]

v_med3_f16 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x65,0x04,0x0e,0x04]

v_med3_f16 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x6a,0x04,0x0e,0x04]

v_med3_f16 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x6b,0x04,0x0e,0x04]

v_med3_f16 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x7d,0x04,0x0e,0x04]

v_med3_f16 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x7e,0x04,0x0e,0x04]

v_med3_f16 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x7f,0x04,0x0e,0x04]

v_med3_f16 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x80,0x04,0x0e,0x04]

v_med3_f16 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0xc1,0x04,0x0e,0x04]

v_med3_f16 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0xf0,0x04,0x0e,0x04]

v_med3_f16 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0xf7,0x04,0x0e,0x04]

v_med3_f16 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0xff,0x0f,0x04]

v_med3_f16 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0x0c,0x04]

v_med3_f16 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0xcb,0x0c,0x04]

v_med3_f16 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0xd5,0x0c,0x04]

v_med3_f16 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0xd7,0x0c,0x04]

v_med3_f16 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0xfb,0x0c,0x04]

v_med3_f16 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0xfd,0x0c,0x04]

v_med3_f16 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0xff,0x0c,0x04]

v_med3_f16 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x01,0x0d,0x04]

v_med3_f16 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x83,0x0d,0x04]

v_med3_f16 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0xe1,0x0d,0x04]

v_med3_f16 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0xef,0x0d,0x04]

v_med3_f16 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0xfe,0x07]

v_med3_f16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0x0e,0x00]

v_med3_f16 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0x96,0x01]

v_med3_f16 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0xaa,0x01]

v_med3_f16 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0xae,0x01]

v_med3_f16 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0xf6,0x01]

v_med3_f16 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0xfa,0x01]

v_med3_f16 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0xfe,0x01]

v_med3_f16 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0x02,0x02]

v_med3_f16 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0x06,0x03]

v_med3_f16 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0xc2,0x03]

v_med3_f16 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0xde,0x03]

v_med3_f16 v5, -v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0x0e,0x24]

v_med3_f16 v5, v1, -v2, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0x0e,0x44]

v_med3_f16 v5, v1, v2, -v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0x0e,0x84]

v_med3_f16 v5, -v1, -v2, -v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0x0e,0xe4]

v_med3_f16 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x4f,0xd6,0x01,0x05,0x0e,0x04]

v_med3_f32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0x0e,0x04]

v_med3_f32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x1f,0xd6,0x01,0x05,0x0e,0x04]

v_med3_f32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0xff,0x05,0x0e,0x04]

v_med3_f32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x04,0x0e,0x04]

v_med3_f32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x67,0x04,0x0e,0x04]

v_med3_f32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x6a,0x04,0x0e,0x04]

v_med3_f32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x6b,0x04,0x0e,0x04]

v_med3_f32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x7d,0x04,0x0e,0x04]

v_med3_f32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x7e,0x04,0x0e,0x04]

v_med3_f32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x7f,0x04,0x0e,0x04]

v_med3_f32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x80,0x04,0x0e,0x04]

v_med3_f32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0xc1,0x04,0x0e,0x04]

v_med3_f32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0xf0,0x04,0x0e,0x04]

v_med3_f32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0xf7,0x04,0x0e,0x04]

v_med3_f32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0xff,0x0f,0x04]

v_med3_f32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0x0c,0x04]

v_med3_f32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0xcf,0x0c,0x04]

v_med3_f32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0xd5,0x0c,0x04]

v_med3_f32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0xd7,0x0c,0x04]

v_med3_f32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0xfb,0x0c,0x04]

v_med3_f32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0xfd,0x0c,0x04]

v_med3_f32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0xff,0x0c,0x04]

v_med3_f32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x01,0x0d,0x04]

v_med3_f32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x83,0x0d,0x04]

v_med3_f32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0xe1,0x0d,0x04]

v_med3_f32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0xef,0x0d,0x04]

v_med3_f32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0xfe,0x07]

v_med3_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0x0e,0x00]

v_med3_f32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0x9e,0x01]

v_med3_f32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0xaa,0x01]

v_med3_f32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0xae,0x01]

v_med3_f32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0xf6,0x01]

v_med3_f32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0xfa,0x01]

v_med3_f32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0xfe,0x01]

v_med3_f32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0x02,0x02]

v_med3_f32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0x06,0x03]

v_med3_f32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0xc2,0x03]

v_med3_f32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0xde,0x03]

v_med3_f32 v5, -v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0x0e,0x24]

v_med3_f32 v5, v1, -v2, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0x0e,0x44]

v_med3_f32 v5, v1, v2, -v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0x0e,0x84]

v_med3_f32 v5, -v1, -v2, -v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0x0e,0xe4]

v_med3_f32 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x1f,0xd6,0x01,0x05,0x0e,0x04]

v_med3_f32 v5, v1, v2, v3 mul:2
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0x0e,0x0c]

v_med3_f32 v5, v1, v2, v3 mul:4
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0x0e,0x14]

v_med3_f32 v5, v1, v2, v3 div:2
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0x0e,0x1c]

v_med3_f32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x77,0x04,0x0e,0x04]

v_med3_f32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0xef,0x0c,0x04]

v_med3_f32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0xde,0x01]

v_med3_i16 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0x05,0x0e,0x04]

v_med3_i16 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x50,0xd6,0x01,0x05,0x0e,0x04]

v_med3_i16 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0xff,0x05,0x0e,0x04]

v_med3_i16 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0x04,0x0e,0x04]

v_med3_i16 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x65,0x04,0x0e,0x04]

v_med3_i16 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x6a,0x04,0x0e,0x04]

v_med3_i16 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x6b,0x04,0x0e,0x04]

v_med3_i16 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x7d,0x04,0x0e,0x04]

v_med3_i16 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x7e,0x04,0x0e,0x04]

v_med3_i16 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x7f,0x04,0x0e,0x04]

v_med3_i16 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x80,0x04,0x0e,0x04]

v_med3_i16 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0xc1,0x04,0x0e,0x04]

v_med3_i16 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0xff,0x04,0x0e,0x04,0x00,0x38,0x00,0x00]

v_med3_i16 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0xff,0x04,0x0e,0x04,0x00,0xc4,0x00,0x00]

v_med3_i16 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0xff,0x0f,0x04]

v_med3_i16 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0x05,0x0c,0x04]

v_med3_i16 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0xcb,0x0c,0x04]

v_med3_i16 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0xd5,0x0c,0x04]

v_med3_i16 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0xd7,0x0c,0x04]

v_med3_i16 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0xfb,0x0c,0x04]

v_med3_i16 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0xfd,0x0c,0x04]

v_med3_i16 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0xff,0x0c,0x04]

v_med3_i16 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0x01,0x0d,0x04]

v_med3_i16 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0x83,0x0d,0x04]

v_med3_i16 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0x05,0xfe,0x07]

v_med3_i16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0x05,0x0e,0x00]

v_med3_i16 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0x05,0x96,0x01]

v_med3_i16 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0x05,0xaa,0x01]

v_med3_i16 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0x05,0xae,0x01]

v_med3_i16 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0x05,0xf6,0x01]

v_med3_i16 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0x05,0xfa,0x01]

v_med3_i16 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0x05,0xfe,0x01]

v_med3_i16 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0x05,0x02,0x02]

v_med3_i16 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0x05,0x06,0x03]

v_med3_i16 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x50,0xd6,0x01,0x05,0x0e,0x04]

v_med3_i32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x05,0x0e,0x04]

v_med3_i32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x20,0xd6,0x01,0x05,0x0e,0x04]

v_med3_i32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0xff,0x05,0x0e,0x04]

v_med3_i32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x04,0x0e,0x04]

v_med3_i32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x67,0x04,0x0e,0x04]

v_med3_i32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x6a,0x04,0x0e,0x04]

v_med3_i32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x6b,0x04,0x0e,0x04]

v_med3_i32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x7d,0x04,0x0e,0x04]

v_med3_i32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x7e,0x04,0x0e,0x04]

v_med3_i32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x7f,0x04,0x0e,0x04]

v_med3_i32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x80,0x04,0x0e,0x04]

v_med3_i32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0xc1,0x04,0x0e,0x04]

v_med3_i32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0xf0,0x04,0x0e,0x04]

v_med3_i32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0xf7,0x04,0x0e,0x04]

v_med3_i32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0xff,0x0f,0x04]

v_med3_i32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x05,0x0c,0x04]

v_med3_i32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0xcf,0x0c,0x04]

v_med3_i32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0xd5,0x0c,0x04]

v_med3_i32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0xd7,0x0c,0x04]

v_med3_i32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0xfb,0x0c,0x04]

v_med3_i32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0xfd,0x0c,0x04]

v_med3_i32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0xff,0x0c,0x04]

v_med3_i32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x01,0x0d,0x04]

v_med3_i32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x83,0x0d,0x04]

v_med3_i32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0xe1,0x0d,0x04]

v_med3_i32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0xef,0x0d,0x04]

v_med3_i32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x05,0xfe,0x07]

v_med3_i32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x05,0x0e,0x00]

v_med3_i32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x05,0x9e,0x01]

v_med3_i32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x05,0xaa,0x01]

v_med3_i32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x05,0xae,0x01]

v_med3_i32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x05,0xf6,0x01]

v_med3_i32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x05,0xfa,0x01]

v_med3_i32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x05,0xfe,0x01]

v_med3_i32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x05,0x02,0x02]

v_med3_i32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x05,0x06,0x03]

v_med3_i32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x05,0xc2,0x03]

v_med3_i32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x05,0xde,0x03]

v_med3_i32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x77,0x04,0x0e,0x04]

v_med3_i32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0xef,0x0c,0x04]

v_med3_i32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x05,0xde,0x01]

v_med3_u16 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0x05,0x0e,0x04]

v_med3_u16 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x51,0xd6,0x01,0x05,0x0e,0x04]

v_med3_u16 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0xff,0x05,0x0e,0x04]

v_med3_u16 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0x04,0x0e,0x04]

v_med3_u16 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x65,0x04,0x0e,0x04]

v_med3_u16 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x6a,0x04,0x0e,0x04]

v_med3_u16 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x6b,0x04,0x0e,0x04]

v_med3_u16 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x7d,0x04,0x0e,0x04]

v_med3_u16 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x7e,0x04,0x0e,0x04]

v_med3_u16 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x7f,0x04,0x0e,0x04]

v_med3_u16 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x80,0x04,0x0e,0x04]

v_med3_u16 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0xc1,0x04,0x0e,0x04]

v_med3_u16 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0xff,0x0f,0x04]

v_med3_u16 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0x05,0x0c,0x04]

v_med3_u16 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0xcb,0x0c,0x04]

v_med3_u16 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0xd5,0x0c,0x04]

v_med3_u16 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0xd7,0x0c,0x04]

v_med3_u16 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0xfb,0x0c,0x04]

v_med3_u16 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0xfd,0x0c,0x04]

v_med3_u16 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0xff,0x0c,0x04]

v_med3_u16 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0x01,0x0d,0x04]

v_med3_u16 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0x83,0x0d,0x04]

v_med3_u16 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0xff,0x0d,0x04,0x00,0x38,0x00,0x00]

v_med3_u16 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0xff,0x0d,0x04,0x00,0xc4,0x00,0x00]

v_med3_u16 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0x05,0xfe,0x07]

v_med3_u16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0x05,0x0e,0x00]

v_med3_u16 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0x05,0x96,0x01]

v_med3_u16 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0x05,0xaa,0x01]

v_med3_u16 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0x05,0xae,0x01]

v_med3_u16 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0x05,0xf6,0x01]

v_med3_u16 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0x05,0xfa,0x01]

v_med3_u16 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0x05,0xfe,0x01]

v_med3_u16 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0x05,0x02,0x02]

v_med3_u16 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0x05,0x06,0x03]

v_med3_u32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x05,0x0e,0x04]

v_med3_u32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x21,0xd6,0x01,0x05,0x0e,0x04]

v_med3_u32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0xff,0x05,0x0e,0x04]

v_med3_u32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x04,0x0e,0x04]

v_med3_u32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x67,0x04,0x0e,0x04]

v_med3_u32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x6a,0x04,0x0e,0x04]

v_med3_u32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x6b,0x04,0x0e,0x04]

v_med3_u32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x7d,0x04,0x0e,0x04]

v_med3_u32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x7e,0x04,0x0e,0x04]

v_med3_u32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x7f,0x04,0x0e,0x04]

v_med3_u32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x80,0x04,0x0e,0x04]

v_med3_u32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0xc1,0x04,0x0e,0x04]

v_med3_u32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0xf0,0x04,0x0e,0x04]

v_med3_u32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0xf7,0x04,0x0e,0x04]

v_med3_u32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0xff,0x0f,0x04]

v_med3_u32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x05,0x0c,0x04]

v_med3_u32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0xcf,0x0c,0x04]

v_med3_u32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0xd5,0x0c,0x04]

v_med3_u32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0xd7,0x0c,0x04]

v_med3_u32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0xfb,0x0c,0x04]

v_med3_u32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0xfd,0x0c,0x04]

v_med3_u32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0xff,0x0c,0x04]

v_med3_u32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x01,0x0d,0x04]

v_med3_u32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x83,0x0d,0x04]

v_med3_u32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0xe1,0x0d,0x04]

v_med3_u32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0xef,0x0d,0x04]

v_med3_u32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x05,0xfe,0x07]

v_med3_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x05,0x0e,0x00]

v_med3_u32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x05,0x9e,0x01]

v_med3_u32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x05,0xaa,0x01]

v_med3_u32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x05,0xae,0x01]

v_med3_u32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x05,0xf6,0x01]

v_med3_u32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x05,0xfa,0x01]

v_med3_u32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x05,0xfe,0x01]

v_med3_u32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x05,0x02,0x02]

v_med3_u32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x05,0x06,0x03]

v_med3_u32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x05,0xc2,0x03]

v_med3_u32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x05,0xde,0x03]

v_med3_u32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x77,0x04,0x0e,0x04]

v_med3_u32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0xef,0x0c,0x04]

v_med3_u32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x05,0xde,0x01]

v_min3_f16 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0x0e,0x04]

v_min3_f16 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x49,0xd6,0x01,0x05,0x0e,0x04]

v_min3_f16 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0xff,0x05,0x0e,0x04]

v_min3_f16 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x04,0x0e,0x04]

v_min3_f16 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x65,0x04,0x0e,0x04]

v_min3_f16 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x6a,0x04,0x0e,0x04]

v_min3_f16 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x6b,0x04,0x0e,0x04]

v_min3_f16 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x7d,0x04,0x0e,0x04]

v_min3_f16 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x7e,0x04,0x0e,0x04]

v_min3_f16 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x7f,0x04,0x0e,0x04]

v_min3_f16 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x80,0x04,0x0e,0x04]

v_min3_f16 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0xc1,0x04,0x0e,0x04]

v_min3_f16 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0xf0,0x04,0x0e,0x04]

v_min3_f16 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0xf7,0x04,0x0e,0x04]

v_min3_f16 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0xff,0x0f,0x04]

v_min3_f16 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0x0c,0x04]

v_min3_f16 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0xcb,0x0c,0x04]

v_min3_f16 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0xd5,0x0c,0x04]

v_min3_f16 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0xd7,0x0c,0x04]

v_min3_f16 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0xfb,0x0c,0x04]

v_min3_f16 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0xfd,0x0c,0x04]

v_min3_f16 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0xff,0x0c,0x04]

v_min3_f16 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x01,0x0d,0x04]

v_min3_f16 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x83,0x0d,0x04]

v_min3_f16 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0xe1,0x0d,0x04]

v_min3_f16 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0xef,0x0d,0x04]

v_min3_f16 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0xfe,0x07]

v_min3_f16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0x0e,0x00]

v_min3_f16 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0x96,0x01]

v_min3_f16 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0xaa,0x01]

v_min3_f16 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0xae,0x01]

v_min3_f16 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0xf6,0x01]

v_min3_f16 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0xfa,0x01]

v_min3_f16 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0xfe,0x01]

v_min3_f16 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0x02,0x02]

v_min3_f16 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0x06,0x03]

v_min3_f16 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0xc2,0x03]

v_min3_f16 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0xde,0x03]

v_min3_f16 v5, -v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0x0e,0x24]

v_min3_f16 v5, v1, -v2, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0x0e,0x44]

v_min3_f16 v5, v1, v2, -v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0x0e,0x84]

v_min3_f16 v5, -v1, -v2, -v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0x0e,0xe4]

v_min3_f16 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x49,0xd6,0x01,0x05,0x0e,0x04]

v_min3_f32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0x0e,0x04]

v_min3_f32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x19,0xd6,0x01,0x05,0x0e,0x04]

v_min3_f32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0xff,0x05,0x0e,0x04]

v_min3_f32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x04,0x0e,0x04]

v_min3_f32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x67,0x04,0x0e,0x04]

v_min3_f32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x6a,0x04,0x0e,0x04]

v_min3_f32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x6b,0x04,0x0e,0x04]

v_min3_f32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x7d,0x04,0x0e,0x04]

v_min3_f32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x7e,0x04,0x0e,0x04]

v_min3_f32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x7f,0x04,0x0e,0x04]

v_min3_f32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x80,0x04,0x0e,0x04]

v_min3_f32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0xc1,0x04,0x0e,0x04]

v_min3_f32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0xf0,0x04,0x0e,0x04]

v_min3_f32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0xf7,0x04,0x0e,0x04]

v_min3_f32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0xff,0x0f,0x04]

v_min3_f32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0x0c,0x04]

v_min3_f32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0xcf,0x0c,0x04]

v_min3_f32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0xd5,0x0c,0x04]

v_min3_f32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0xd7,0x0c,0x04]

v_min3_f32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0xfb,0x0c,0x04]

v_min3_f32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0xfd,0x0c,0x04]

v_min3_f32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0xff,0x0c,0x04]

v_min3_f32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x01,0x0d,0x04]

v_min3_f32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x83,0x0d,0x04]

v_min3_f32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0xe1,0x0d,0x04]

v_min3_f32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0xef,0x0d,0x04]

v_min3_f32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0xfe,0x07]

v_min3_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0x0e,0x00]

v_min3_f32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0x9e,0x01]

v_min3_f32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0xaa,0x01]

v_min3_f32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0xae,0x01]

v_min3_f32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0xf6,0x01]

v_min3_f32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0xfa,0x01]

v_min3_f32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0xfe,0x01]

v_min3_f32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0x02,0x02]

v_min3_f32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0x06,0x03]

v_min3_f32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0xc2,0x03]

v_min3_f32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0xde,0x03]

v_min3_f32 v5, -v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0x0e,0x24]

v_min3_f32 v5, v1, -v2, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0x0e,0x44]

v_min3_f32 v5, v1, v2, -v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0x0e,0x84]

v_min3_f32 v5, -v1, -v2, -v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0x0e,0xe4]

v_min3_f32 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x19,0xd6,0x01,0x05,0x0e,0x04]

v_min3_f32 v5, v1, v2, v3 mul:2
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0x0e,0x0c]

v_min3_f32 v5, v1, v2, v3 mul:4
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0x0e,0x14]

v_min3_f32 v5, v1, v2, v3 div:2
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0x0e,0x1c]

v_min3_f32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x77,0x04,0x0e,0x04]

v_min3_f32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0xef,0x0c,0x04]

v_min3_f32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0xde,0x01]

v_min3_i16 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0x05,0x0e,0x04]

v_min3_i16 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x4a,0xd6,0x01,0x05,0x0e,0x04]

v_min3_i16 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0xff,0x05,0x0e,0x04]

v_min3_i16 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0x04,0x0e,0x04]

v_min3_i16 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x65,0x04,0x0e,0x04]

v_min3_i16 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x6a,0x04,0x0e,0x04]

v_min3_i16 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x6b,0x04,0x0e,0x04]

v_min3_i16 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x7d,0x04,0x0e,0x04]

v_min3_i16 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x7e,0x04,0x0e,0x04]

v_min3_i16 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x7f,0x04,0x0e,0x04]

v_min3_i16 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x80,0x04,0x0e,0x04]

v_min3_i16 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0xc1,0x04,0x0e,0x04]

v_min3_i16 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0xff,0x04,0x0e,0x04,0x00,0x38,0x00,0x00]

v_min3_i16 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0xff,0x04,0x0e,0x04,0x00,0xc4,0x00,0x00]

v_min3_i16 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0xff,0x0f,0x04]

v_min3_i16 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0x05,0x0c,0x04]

v_min3_i16 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0xcb,0x0c,0x04]

v_min3_i16 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0xd5,0x0c,0x04]

v_min3_i16 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0xd7,0x0c,0x04]

v_min3_i16 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0xfb,0x0c,0x04]

v_min3_i16 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0xfd,0x0c,0x04]

v_min3_i16 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0xff,0x0c,0x04]

v_min3_i16 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0x01,0x0d,0x04]

v_min3_i16 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0x83,0x0d,0x04]

v_min3_i16 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0x05,0xfe,0x07]

v_min3_i16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0x05,0x0e,0x00]

v_min3_i16 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0x05,0x96,0x01]

v_min3_i16 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0x05,0xaa,0x01]

v_min3_i16 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0x05,0xae,0x01]

v_min3_i16 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0x05,0xf6,0x01]

v_min3_i16 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0x05,0xfa,0x01]

v_min3_i16 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0x05,0xfe,0x01]

v_min3_i16 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0x05,0x02,0x02]

v_min3_i16 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0x05,0x06,0x03]

v_min3_i16 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x4a,0xd6,0x01,0x05,0x0e,0x04]

v_min3_i32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x05,0x0e,0x04]

v_min3_i32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x1a,0xd6,0x01,0x05,0x0e,0x04]

v_min3_i32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0xff,0x05,0x0e,0x04]

v_min3_i32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x04,0x0e,0x04]

v_min3_i32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x67,0x04,0x0e,0x04]

v_min3_i32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x6a,0x04,0x0e,0x04]

v_min3_i32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x6b,0x04,0x0e,0x04]

v_min3_i32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x7d,0x04,0x0e,0x04]

v_min3_i32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x7e,0x04,0x0e,0x04]

v_min3_i32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x7f,0x04,0x0e,0x04]

v_min3_i32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x80,0x04,0x0e,0x04]

v_min3_i32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0xc1,0x04,0x0e,0x04]

v_min3_i32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0xf0,0x04,0x0e,0x04]

v_min3_i32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0xf7,0x04,0x0e,0x04]

v_min3_i32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0xff,0x0f,0x04]

v_min3_i32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x05,0x0c,0x04]

v_min3_i32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0xcf,0x0c,0x04]

v_min3_i32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0xd5,0x0c,0x04]

v_min3_i32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0xd7,0x0c,0x04]

v_min3_i32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0xfb,0x0c,0x04]

v_min3_i32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0xfd,0x0c,0x04]

v_min3_i32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0xff,0x0c,0x04]

v_min3_i32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x01,0x0d,0x04]

v_min3_i32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x83,0x0d,0x04]

v_min3_i32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0xe1,0x0d,0x04]

v_min3_i32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0xef,0x0d,0x04]

v_min3_i32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x05,0xfe,0x07]

v_min3_i32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x05,0x0e,0x00]

v_min3_i32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x05,0x9e,0x01]

v_min3_i32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x05,0xaa,0x01]

v_min3_i32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x05,0xae,0x01]

v_min3_i32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x05,0xf6,0x01]

v_min3_i32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x05,0xfa,0x01]

v_min3_i32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x05,0xfe,0x01]

v_min3_i32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x05,0x02,0x02]

v_min3_i32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x05,0x06,0x03]

v_min3_i32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x05,0xc2,0x03]

v_min3_i32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x05,0xde,0x03]

v_min3_i32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x77,0x04,0x0e,0x04]

v_min3_i32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0xef,0x0c,0x04]

v_min3_i32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x05,0xde,0x01]

v_min3_u16 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0x05,0x0e,0x04]

v_min3_u16 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x4b,0xd6,0x01,0x05,0x0e,0x04]

v_min3_u16 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0xff,0x05,0x0e,0x04]

v_min3_u16 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0x04,0x0e,0x04]

v_min3_u16 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x65,0x04,0x0e,0x04]

v_min3_u16 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x6a,0x04,0x0e,0x04]

v_min3_u16 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x6b,0x04,0x0e,0x04]

v_min3_u16 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x7d,0x04,0x0e,0x04]

v_min3_u16 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x7e,0x04,0x0e,0x04]

v_min3_u16 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x7f,0x04,0x0e,0x04]

v_min3_u16 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x80,0x04,0x0e,0x04]

v_min3_u16 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0xc1,0x04,0x0e,0x04]

v_min3_u16 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0xff,0x0f,0x04]

v_min3_u16 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0x05,0x0c,0x04]

v_min3_u16 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0xcb,0x0c,0x04]

v_min3_u16 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0xd5,0x0c,0x04]

v_min3_u16 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0xd7,0x0c,0x04]

v_min3_u16 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0xfb,0x0c,0x04]

v_min3_u16 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0xfd,0x0c,0x04]

v_min3_u16 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0xff,0x0c,0x04]

v_min3_u16 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0x01,0x0d,0x04]

v_min3_u16 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0x83,0x0d,0x04]

v_min3_u16 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0xff,0x0d,0x04,0x00,0x38,0x00,0x00]

v_min3_u16 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0xff,0x0d,0x04,0x00,0xc4,0x00,0x00]

v_min3_u16 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0x05,0xfe,0x07]

v_min3_u16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0x05,0x0e,0x00]

v_min3_u16 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0x05,0x96,0x01]

v_min3_u16 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0x05,0xaa,0x01]

v_min3_u16 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0x05,0xae,0x01]

v_min3_u16 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0x05,0xf6,0x01]

v_min3_u16 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0x05,0xfa,0x01]

v_min3_u16 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0x05,0xfe,0x01]

v_min3_u16 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0x05,0x02,0x02]

v_min3_u16 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0x05,0x06,0x03]

v_min3_u16 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x4b,0xd6,0x01,0x05,0x0e,0x04]

v_min3_u32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x05,0x0e,0x04]

v_min3_u32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x1b,0xd6,0x01,0x05,0x0e,0x04]

v_min3_u32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0xff,0x05,0x0e,0x04]

v_min3_u32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x04,0x0e,0x04]

v_min3_u32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x67,0x04,0x0e,0x04]

v_min3_u32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x6a,0x04,0x0e,0x04]

v_min3_u32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x6b,0x04,0x0e,0x04]

v_min3_u32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x7d,0x04,0x0e,0x04]

v_min3_u32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x7e,0x04,0x0e,0x04]

v_min3_u32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x7f,0x04,0x0e,0x04]

v_min3_u32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x80,0x04,0x0e,0x04]

v_min3_u32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0xc1,0x04,0x0e,0x04]

v_min3_u32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0xf0,0x04,0x0e,0x04]

v_min3_u32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0xf7,0x04,0x0e,0x04]

v_min3_u32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0xff,0x0f,0x04]

v_min3_u32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x05,0x0c,0x04]

v_min3_u32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0xcf,0x0c,0x04]

v_min3_u32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0xd5,0x0c,0x04]

v_min3_u32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0xd7,0x0c,0x04]

v_min3_u32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0xfb,0x0c,0x04]

v_min3_u32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0xfd,0x0c,0x04]

v_min3_u32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0xff,0x0c,0x04]

v_min3_u32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x01,0x0d,0x04]

v_min3_u32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x83,0x0d,0x04]

v_min3_u32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0xe1,0x0d,0x04]

v_min3_u32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0xef,0x0d,0x04]

v_min3_u32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x05,0xfe,0x07]

v_min3_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x05,0x0e,0x00]

v_min3_u32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x05,0x9e,0x01]

v_min3_u32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x05,0xaa,0x01]

v_min3_u32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x05,0xae,0x01]

v_min3_u32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x05,0xf6,0x01]

v_min3_u32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x05,0xfa,0x01]

v_min3_u32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x05,0xfe,0x01]

v_min3_u32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x05,0x02,0x02]

v_min3_u32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x05,0x06,0x03]

v_min3_u32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x05,0xc2,0x03]

v_min3_u32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x05,0xde,0x03]

v_min3_u32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x77,0x04,0x0e,0x04]

v_min3_u32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0xef,0x0c,0x04]

v_min3_u32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x05,0xde,0x01]

v_min_f64 v[5:6], v[1:2], v[2:3]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0x05,0x02,0x00]

v_min_f64 v[254:255], v[1:2], v[2:3]
// GFX11: encoding: [0xfe,0x00,0x29,0xd7,0x01,0x05,0x02,0x00]

v_min_f64 v[5:6], v[254:255], v[2:3]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0xfe,0x05,0x02,0x00]

v_min_f64 v[5:6], s[2:3], v[2:3]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x02,0x04,0x02,0x00]

v_min_f64 v[5:6], s[4:5], v[2:3]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x04,0x04,0x02,0x00]

v_min_f64 v[5:6], s[102:103], v[2:3]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x66,0x04,0x02,0x00]

v_min_f64 v[5:6], vcc, v[2:3]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x6a,0x04,0x02,0x00]

v_min_f64 v[5:6], exec, v[2:3]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x7e,0x04,0x02,0x00]

v_min_f64 v[5:6], 0, v[2:3]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x80,0x04,0x02,0x00]

v_min_f64 v[5:6], -1, v[2:3]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0xc1,0x04,0x02,0x00]

v_min_f64 v[5:6], 0.5, v[2:3]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0xf0,0x04,0x02,0x00]

v_min_f64 v[5:6], -4.0, v[2:3]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0xf7,0x04,0x02,0x00]

v_min_f64 v[5:6], v[1:2], v[254:255]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0xfd,0x03,0x00]

v_min_f64 v[5:6], v[1:2], s[4:5]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0x09,0x00,0x00]

v_min_f64 v[5:6], v[1:2], s[6:7]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0x0d,0x00,0x00]

v_min_f64 v[5:6], v[1:2], s[102:103]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0xcd,0x00,0x00]

v_min_f64 v[5:6], v[1:2], vcc
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0xd5,0x00,0x00]

v_min_f64 v[5:6], v[1:2], exec
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0xfd,0x00,0x00]

v_min_f64 v[5:6], v[1:2], 0
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0x01,0x01,0x00]

v_min_f64 v[5:6], v[1:2], -1
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0x83,0x01,0x00]

v_min_f64 v[5:6], v[1:2], 0.5
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0xe1,0x01,0x00]

v_min_f64 v[5:6], v[1:2], -4.0
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0xef,0x01,0x00]

v_min_f64 v[5:6], -v[1:2], v[2:3]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0x05,0x02,0x20]

v_min_f64 v[5:6], v[1:2], -v[2:3]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0x05,0x02,0x40]

v_min_f64 v[5:6], -v[1:2], -v[2:3]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0x05,0x02,0x60]

v_min_f64 v[5:6], v[1:2], v[2:3] clamp
// GFX11: encoding: [0x05,0x80,0x29,0xd7,0x01,0x05,0x02,0x00]

v_min_f64 v[5:6], v[1:2], v[2:3] mul:2
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0x05,0x02,0x08]

v_min_f64 v[5:6], v[1:2], v[2:3] mul:4
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0x05,0x02,0x10]

v_min_f64 v[5:6], v[1:2], v[2:3] div:2
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0x05,0x02,0x18]

v_min_i16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x01,0x05,0x02,0x00]

v_min_i16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x0c,0xd7,0x01,0x05,0x02,0x00]

v_min_i16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0xff,0x05,0x02,0x00]

v_min_i16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x01,0x04,0x02,0x00]

v_min_i16 v5, s101, v2
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x65,0x04,0x02,0x00]

v_min_i16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x6a,0x04,0x02,0x00]

v_min_i16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x6b,0x04,0x02,0x00]

v_min_i16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x7d,0x04,0x02,0x00]

v_min_i16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x7e,0x04,0x02,0x00]

v_min_i16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x7f,0x04,0x02,0x00]

v_min_i16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x80,0x04,0x02,0x00]

v_min_i16 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0xc1,0x04,0x02,0x00]

v_min_i16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xff,0x03,0x00]

v_min_i16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x01,0x05,0x00,0x00]

v_min_i16 v5, v1, s101
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xcb,0x00,0x00]

v_min_i16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xd5,0x00,0x00]

v_min_i16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xd7,0x00,0x00]

v_min_i16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xfb,0x00,0x00]

v_min_i16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xfd,0x00,0x00]

v_min_i16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xff,0x00,0x00]

v_min_i16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x01,0x01,0x01,0x00]

v_min_i16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x01,0x83,0x01,0x00]

v_min_i16 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_min_i16 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_min_u16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x01,0x05,0x02,0x00]

v_min_u16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x0b,0xd7,0x01,0x05,0x02,0x00]

v_min_u16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0xff,0x05,0x02,0x00]

v_min_u16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x01,0x04,0x02,0x00]

v_min_u16 v5, s101, v2
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x65,0x04,0x02,0x00]

v_min_u16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x6a,0x04,0x02,0x00]

v_min_u16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x6b,0x04,0x02,0x00]

v_min_u16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x7d,0x04,0x02,0x00]

v_min_u16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x7e,0x04,0x02,0x00]

v_min_u16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x7f,0x04,0x02,0x00]

v_min_u16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x80,0x04,0x02,0x00]

v_min_u16 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0xc1,0x04,0x02,0x00]

v_min_u16 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_min_u16 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_min_u16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x01,0xff,0x03,0x00]

v_min_u16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x01,0x05,0x00,0x00]

v_min_u16 v5, v1, s101
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x01,0xcb,0x00,0x00]

v_min_u16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x01,0xd5,0x00,0x00]

v_min_u16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x01,0xd7,0x00,0x00]

v_min_u16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x01,0xfb,0x00,0x00]

v_min_u16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x01,0xfd,0x00,0x00]

v_min_u16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x01,0xff,0x00,0x00]

v_min_u16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x01,0x01,0x01,0x00]

v_min_u16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x01,0x83,0x01,0x00]

v_movreld_b32 v5, v1
// GFX11: encoding: [0x01,0x85,0x0a,0x7e]

v_movreld_b32 v255, v1
// GFX11: encoding: [0x01,0x85,0xfe,0x7f]

v_movreld_b32 v5, v255
// GFX11: encoding: [0xff,0x85,0x0a,0x7e]

v_movreld_b32 v5, m0
// GFX11: encoding: [0x7d,0x84,0x0a,0x7e]

v_movreld_b32 v5, 0
// GFX11: encoding: [0x80,0x84,0x0a,0x7e]

v_movreld_b32 v5, -1
// GFX11: encoding: [0xc1,0x84,0x0a,0x7e]

v_movreld_b32 v5, 0.5
// GFX11: encoding: [0xf0,0x84,0x0a,0x7e]

v_movreld_b32 v5, -4.0
// GFX11: encoding: [0xf7,0x84,0x0a,0x7e]

v_movrels_b32 v5, v1
// GFX11: encoding: [0x01,0x87,0x0a,0x7e]

v_movrels_b32 v255, v1
// GFX11: encoding: [0x01,0x87,0xfe,0x7f]

v_movrels_b32 v5, v255
// GFX11: encoding: [0xff,0x87,0x0a,0x7e]

v_movrelsd_2_b32 v5, v1
// GFX11: encoding: [0x01,0x91,0x0a,0x7e]

v_movrelsd_2_b32 v255, v1
// GFX11: encoding: [0x01,0x91,0xfe,0x7f]

v_movrelsd_2_b32 v5, v255
// GFX11: encoding: [0xff,0x91,0x0a,0x7e]

v_movrelsd_b32 v5, v1
// GFX11: encoding: [0x01,0x89,0x0a,0x7e]

v_movrelsd_b32 v255, v1
// GFX11: encoding: [0x01,0x89,0xfe,0x7f]

v_movrelsd_b32 v5, v255
// GFX11: encoding: [0xff,0x89,0x0a,0x7e]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0x05,0x0e,0x04]

v_mqsad_pk_u16_u8 v[254:255], v[1:2], v2, v[3:4]
// GFX11: encoding: [0xfe,0x00,0x3b,0xd6,0x01,0x05,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[254:255], v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0xfe,0x05,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], s[2:3], v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x02,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], s[4:5], v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x04,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], s[102:103], v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x66,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], vcc, v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x6a,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], exec, v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x7e,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], 0, v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x80,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], -1, v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0xc1,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v255, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0xff,0x0f,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], s2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0x05,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], s103, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0xcf,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], vcc_lo, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0xd5,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], vcc_hi, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0xd7,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], m0, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0xfb,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], exec_lo, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0xfd,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], exec_hi, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0xff,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], 0, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0x01,0x0d,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], -1, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0x83,0x0d,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, v[254:255]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0x05,0xfa,0x07]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, s[6:7]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0x05,0x1a,0x00]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, s[8:9]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0x05,0x22,0x00]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, s[102:103]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0x05,0x9a,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, vcc
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0x05,0xaa,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, exec
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0x05,0xfa,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, 0
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0x05,0x02,0x02]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, -1
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0x05,0x06,0x03]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], ttmp11, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0xef,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], v2, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0x01,0x05,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], s[2:3], v2, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0x02,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], s[4:5], v2, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0x04,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], s[102:103], v2, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0x66,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], vcc, v2, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0x6a,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], exec, v2, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0x7e,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], 0, v2, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0x80,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], -1, v2, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0xc1,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], s2, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0x01,0x05,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], s103, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0x01,0xcf,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], vcc_lo, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0x01,0xd5,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], vcc_hi, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0x01,0xd7,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], m0, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0x01,0xfb,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], exec_lo, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0x01,0xfd,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], exec_hi, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0x01,0xff,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], 0, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0x01,0x01,0x0d,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], -1, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0x01,0x83,0x0d,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], ttmp11, v[3:6]
// GFX11: encoding: [0xfc,0x00,0x3d,0xd6,0x01,0xef,0x0c,0x04]

v_msad_u8 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x05,0x0e,0x04]

v_msad_u8 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x39,0xd6,0x01,0x05,0x0e,0x04]

v_msad_u8 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0xff,0x05,0x0e,0x04]

v_msad_u8 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x04,0x0e,0x04]

v_msad_u8 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x67,0x04,0x0e,0x04]

v_msad_u8 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x6a,0x04,0x0e,0x04]

v_msad_u8 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x6b,0x04,0x0e,0x04]

v_msad_u8 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x7d,0x04,0x0e,0x04]

v_msad_u8 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x7e,0x04,0x0e,0x04]

v_msad_u8 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x7f,0x04,0x0e,0x04]

v_msad_u8 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x80,0x04,0x0e,0x04]

v_msad_u8 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0xc1,0x04,0x0e,0x04]

v_msad_u8 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0xf0,0x04,0x0e,0x04]

v_msad_u8 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0xf7,0x04,0x0e,0x04]

v_msad_u8 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0xff,0x0f,0x04]

v_msad_u8 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x05,0x0c,0x04]

v_msad_u8 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0xcf,0x0c,0x04]

v_msad_u8 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0xd5,0x0c,0x04]

v_msad_u8 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0xd7,0x0c,0x04]

v_msad_u8 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0xfb,0x0c,0x04]

v_msad_u8 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0xfd,0x0c,0x04]

v_msad_u8 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0xff,0x0c,0x04]

v_msad_u8 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x01,0x0d,0x04]

v_msad_u8 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x83,0x0d,0x04]

v_msad_u8 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0xe1,0x0d,0x04]

v_msad_u8 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0xef,0x0d,0x04]

v_msad_u8 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x05,0xfe,0x07]

v_msad_u8 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x05,0x0e,0x00]

v_msad_u8 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x05,0x9e,0x01]

v_msad_u8 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x05,0xaa,0x01]

v_msad_u8 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x05,0xae,0x01]

v_msad_u8 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x05,0xf6,0x01]

v_msad_u8 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x05,0xfa,0x01]

v_msad_u8 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x05,0xfe,0x01]

v_msad_u8 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x05,0x02,0x02]

v_msad_u8 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x05,0x06,0x03]

v_msad_u8 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x05,0xc2,0x03]

v_msad_u8 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x05,0xde,0x03]

v_msad_u8 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x77,0x04,0x0e,0x04]

v_msad_u8 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0xef,0x0c,0x04]

v_msad_u8 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x05,0xde,0x01]

v_mul_f64 v[5:6], v[1:2], v[2:3]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0x05,0x02,0x00]

v_mul_f64 v[254:255], v[1:2], v[2:3]
// GFX11: encoding: [0xfe,0x00,0x28,0xd7,0x01,0x05,0x02,0x00]

v_mul_f64 v[5:6], v[254:255], v[2:3]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0xfe,0x05,0x02,0x00]

v_mul_f64 v[5:6], s[2:3], v[2:3]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x02,0x04,0x02,0x00]

v_mul_f64 v[5:6], s[4:5], v[2:3]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x04,0x04,0x02,0x00]

v_mul_f64 v[5:6], s[102:103], v[2:3]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x66,0x04,0x02,0x00]

v_mul_f64 v[5:6], vcc, v[2:3]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x6a,0x04,0x02,0x00]

v_mul_f64 v[5:6], exec, v[2:3]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x7e,0x04,0x02,0x00]

v_mul_f64 v[5:6], 0, v[2:3]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x80,0x04,0x02,0x00]

v_mul_f64 v[5:6], -1, v[2:3]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0xc1,0x04,0x02,0x00]

v_mul_f64 v[5:6], 0.5, v[2:3]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0xf0,0x04,0x02,0x00]

v_mul_f64 v[5:6], -4.0, v[2:3]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0xf7,0x04,0x02,0x00]

v_mul_f64 v[5:6], v[1:2], v[254:255]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0xfd,0x03,0x00]

v_mul_f64 v[5:6], v[1:2], s[4:5]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0x09,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], s[6:7]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0x0d,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], s[102:103]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0xcd,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], vcc
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0xd5,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], exec
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0xfd,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], 0
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0x01,0x01,0x00]

v_mul_f64 v[5:6], v[1:2], -1
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0x83,0x01,0x00]

v_mul_f64 v[5:6], v[1:2], 0.5
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0xe1,0x01,0x00]

v_mul_f64 v[5:6], v[1:2], -4.0
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0xef,0x01,0x00]

v_mul_f64 v[5:6], -v[1:2], v[2:3]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0x05,0x02,0x20]

v_mul_f64 v[5:6], v[1:2], -v[2:3]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0x05,0x02,0x40]

v_mul_f64 v[5:6], -v[1:2], -v[2:3]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0x05,0x02,0x60]

v_mul_f64 v[5:6], v[1:2], v[2:3] clamp
// GFX11: encoding: [0x05,0x80,0x28,0xd7,0x01,0x05,0x02,0x00]

v_mul_f64 v[5:6], v[1:2], v[2:3] mul:2
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0x05,0x02,0x08]

v_mul_f64 v[5:6], v[1:2], v[2:3] mul:4
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0x05,0x02,0x10]

v_mul_f64 v[5:6], v[1:2], v[2:3] div:2
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0x05,0x02,0x18]

v_mul_hi_i32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x01,0x05,0x02,0x00]

v_mul_hi_i32 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x2e,0xd7,0x01,0x05,0x02,0x00]

v_mul_hi_i32 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0xff,0x05,0x02,0x00]

v_mul_hi_i32 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x01,0x04,0x02,0x00]

v_mul_hi_i32 v5, s103, v2
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x67,0x04,0x02,0x00]

v_mul_hi_i32 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x6a,0x04,0x02,0x00]

v_mul_hi_i32 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x6b,0x04,0x02,0x00]

v_mul_hi_i32 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x7d,0x04,0x02,0x00]

v_mul_hi_i32 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x7e,0x04,0x02,0x00]

v_mul_hi_i32 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x7f,0x04,0x02,0x00]

v_mul_hi_i32 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x80,0x04,0x02,0x00]

v_mul_hi_i32 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0xc1,0x04,0x02,0x00]

v_mul_hi_i32 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0xf0,0x04,0x02,0x00]

v_mul_hi_i32 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0xf7,0x04,0x02,0x00]

v_mul_hi_i32 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x01,0xff,0x03,0x00]

v_mul_hi_i32 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x01,0x05,0x00,0x00]

v_mul_hi_i32 v5, v1, s103
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x01,0xcf,0x00,0x00]

v_mul_hi_i32 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x01,0xd5,0x00,0x00]

v_mul_hi_i32 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x01,0xd7,0x00,0x00]

v_mul_hi_i32 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x01,0xfb,0x00,0x00]

v_mul_hi_i32 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x01,0xfd,0x00,0x00]

v_mul_hi_i32 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x01,0xff,0x00,0x00]

v_mul_hi_i32 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x01,0x01,0x01,0x00]

v_mul_hi_i32 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x01,0x83,0x01,0x00]

v_mul_hi_i32 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x01,0xe1,0x01,0x00]

v_mul_hi_i32 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x01,0xef,0x01,0x00]

v_mul_hi_i32 v5, ttmp11, v2
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x77,0x04,0x02,0x00]

v_mul_hi_i32 v5, v1, ttmp11
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x01,0xef,0x00,0x00]

v_mul_hi_u32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x01,0x05,0x02,0x00]

v_mul_hi_u32 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x2d,0xd7,0x01,0x05,0x02,0x00]

v_mul_hi_u32 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0xff,0x05,0x02,0x00]

v_mul_hi_u32 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x01,0x04,0x02,0x00]

v_mul_hi_u32 v5, s103, v2
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x67,0x04,0x02,0x00]

v_mul_hi_u32 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x6a,0x04,0x02,0x00]

v_mul_hi_u32 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x6b,0x04,0x02,0x00]

v_mul_hi_u32 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x7d,0x04,0x02,0x00]

v_mul_hi_u32 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x7e,0x04,0x02,0x00]

v_mul_hi_u32 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x7f,0x04,0x02,0x00]

v_mul_hi_u32 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x80,0x04,0x02,0x00]

v_mul_hi_u32 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0xc1,0x04,0x02,0x00]

v_mul_hi_u32 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0xf0,0x04,0x02,0x00]

v_mul_hi_u32 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0xf7,0x04,0x02,0x00]

v_mul_hi_u32 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x01,0xff,0x03,0x00]

v_mul_hi_u32 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x01,0x05,0x00,0x00]

v_mul_hi_u32 v5, v1, s103
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x01,0xcf,0x00,0x00]

v_mul_hi_u32 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x01,0xd5,0x00,0x00]

v_mul_hi_u32 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x01,0xd7,0x00,0x00]

v_mul_hi_u32 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x01,0xfb,0x00,0x00]

v_mul_hi_u32 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x01,0xfd,0x00,0x00]

v_mul_hi_u32 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x01,0xff,0x00,0x00]

v_mul_hi_u32 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x01,0x01,0x01,0x00]

v_mul_hi_u32 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x01,0x83,0x01,0x00]

v_mul_hi_u32 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x01,0xe1,0x01,0x00]

v_mul_hi_u32 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x01,0xef,0x01,0x00]

v_mul_hi_u32 v5, ttmp11, v2
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x77,0x04,0x02,0x00]

v_mul_hi_u32 v5, v1, ttmp11
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x01,0xef,0x00,0x00]

v_mul_lo_u16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x01,0x05,0x02,0x00]

v_mul_lo_u16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x05,0xd7,0x01,0x05,0x02,0x00]

v_mul_lo_u16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0xff,0x05,0x02,0x00]

v_mul_lo_u16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x01,0x04,0x02,0x00]

v_mul_lo_u16 v5, s101, v2
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x65,0x04,0x02,0x00]

v_mul_lo_u16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x6a,0x04,0x02,0x00]

v_mul_lo_u16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x6b,0x04,0x02,0x00]

v_mul_lo_u16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x7d,0x04,0x02,0x00]

v_mul_lo_u16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x7e,0x04,0x02,0x00]

v_mul_lo_u16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x7f,0x04,0x02,0x00]

v_mul_lo_u16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x80,0x04,0x02,0x00]

v_mul_lo_u16 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0xc1,0x04,0x02,0x00]

v_mul_lo_u16 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_mul_lo_u16 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_mul_lo_u16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x01,0xff,0x03,0x00]

v_mul_lo_u16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x01,0x05,0x00,0x00]

v_mul_lo_u16 v5, v1, s101
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x01,0xcb,0x00,0x00]

v_mul_lo_u16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x01,0xd5,0x00,0x00]

v_mul_lo_u16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x01,0xd7,0x00,0x00]

v_mul_lo_u16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x01,0xfb,0x00,0x00]

v_mul_lo_u16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x01,0xfd,0x00,0x00]

v_mul_lo_u16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x01,0xff,0x00,0x00]

v_mul_lo_u16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x01,0x01,0x01,0x00]

v_mul_lo_u16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x01,0x83,0x01,0x00]

v_mul_lo_u16 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_mul_lo_u16 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_mul_lo_u32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x01,0x05,0x02,0x00]

v_mul_lo_u32 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x2c,0xd7,0x01,0x05,0x02,0x00]

v_mul_lo_u32 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0xff,0x05,0x02,0x00]

v_mul_lo_u32 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x01,0x04,0x02,0x00]

v_mul_lo_u32 v5, s103, v2
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x67,0x04,0x02,0x00]

v_mul_lo_u32 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x6a,0x04,0x02,0x00]

v_mul_lo_u32 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x6b,0x04,0x02,0x00]

v_mul_lo_u32 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x7d,0x04,0x02,0x00]

v_mul_lo_u32 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x7e,0x04,0x02,0x00]

v_mul_lo_u32 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x7f,0x04,0x02,0x00]

v_mul_lo_u32 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x80,0x04,0x02,0x00]

v_mul_lo_u32 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0xc1,0x04,0x02,0x00]

v_mul_lo_u32 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0xf0,0x04,0x02,0x00]

v_mul_lo_u32 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0xf7,0x04,0x02,0x00]

v_mul_lo_u32 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x01,0xff,0x03,0x00]

v_mul_lo_u32 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x01,0x05,0x00,0x00]

v_mul_lo_u32 v5, v1, s103
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x01,0xcf,0x00,0x00]

v_mul_lo_u32 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x01,0xd5,0x00,0x00]

v_mul_lo_u32 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x01,0xd7,0x00,0x00]

v_mul_lo_u32 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x01,0xfb,0x00,0x00]

v_mul_lo_u32 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x01,0xfd,0x00,0x00]

v_mul_lo_u32 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x01,0xff,0x00,0x00]

v_mul_lo_u32 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x01,0x01,0x01,0x00]

v_mul_lo_u32 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x01,0x83,0x01,0x00]

v_mul_lo_u32 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x01,0xe1,0x01,0x00]

v_mul_lo_u32 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x01,0xef,0x01,0x00]

v_mul_lo_u32 v5, ttmp11, v2
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x77,0x04,0x02,0x00]

v_mul_lo_u32 v5, v1, ttmp11
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x01,0xef,0x00,0x00]

v_mullit_f32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0x0e,0x04]

v_mullit_f32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x18,0xd6,0x01,0x05,0x0e,0x04]

v_mullit_f32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0xff,0x05,0x0e,0x04]

v_mullit_f32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x04,0x0e,0x04]

v_mullit_f32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x67,0x04,0x0e,0x04]

v_mullit_f32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x6a,0x04,0x0e,0x04]

v_mullit_f32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x6b,0x04,0x0e,0x04]

v_mullit_f32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x7d,0x04,0x0e,0x04]

v_mullit_f32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x7e,0x04,0x0e,0x04]

v_mullit_f32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x7f,0x04,0x0e,0x04]

v_mullit_f32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x80,0x04,0x0e,0x04]

v_mullit_f32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0xc1,0x04,0x0e,0x04]

v_mullit_f32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0xf0,0x04,0x0e,0x04]

v_mullit_f32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0xf7,0x04,0x0e,0x04]

v_mullit_f32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0xff,0x0f,0x04]

v_mullit_f32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0x0c,0x04]

v_mullit_f32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0xcf,0x0c,0x04]

v_mullit_f32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0xd5,0x0c,0x04]

v_mullit_f32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0xd7,0x0c,0x04]

v_mullit_f32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0xfb,0x0c,0x04]

v_mullit_f32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0xfd,0x0c,0x04]

v_mullit_f32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0xff,0x0c,0x04]

v_mullit_f32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x01,0x0d,0x04]

v_mullit_f32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x83,0x0d,0x04]

v_mullit_f32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0xe1,0x0d,0x04]

v_mullit_f32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0xef,0x0d,0x04]

v_mullit_f32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0xfe,0x07]

v_mullit_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0x0e,0x00]

v_mullit_f32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0x9e,0x01]

v_mullit_f32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0xaa,0x01]

v_mullit_f32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0xae,0x01]

v_mullit_f32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0xf6,0x01]

v_mullit_f32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0xfa,0x01]

v_mullit_f32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0xfe,0x01]

v_mullit_f32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0x02,0x02]

v_mullit_f32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0x06,0x03]

v_mullit_f32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0xc2,0x03]

v_mullit_f32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0xde,0x03]

v_mullit_f32 v5, -v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0x0e,0x24]

v_mullit_f32 v5, v1, -v2, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0x0e,0x44]

v_mullit_f32 v5, v1, v2, -v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0x0e,0x84]

v_mullit_f32 v5, -v1, -v2, -v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0x0e,0xe4]

v_mullit_f32 v5, v1, v2, v3 clamp
// GFX11: encoding: [0x05,0x80,0x18,0xd6,0x01,0x05,0x0e,0x04]

v_mullit_f32 v5, v1, v2, v3 mul:2
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0x0e,0x0c]

v_mullit_f32 v5, v1, v2, v3 mul:4
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0x0e,0x14]

v_mullit_f32 v5, v1, v2, v3 div:2
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0x0e,0x1c]

v_mullit_f32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x77,0x04,0x0e,0x04]

v_mullit_f32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0xef,0x0c,0x04]

v_mullit_f32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0xde,0x01]

v_not_b32 v5, v1
// GFX11: encoding: [0x01,0x6f,0x0a,0x7e]

v_not_b32 v255, v1
// GFX11: encoding: [0x01,0x6f,0xfe,0x7f]

v_not_b32 v5, v255
// GFX11: encoding: [0xff,0x6f,0x0a,0x7e]

v_not_b32 v5, s1
// GFX11: encoding: [0x01,0x6e,0x0a,0x7e]

v_not_b32 v5, s103
// GFX11: encoding: [0x67,0x6e,0x0a,0x7e]

v_not_b32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x6e,0x0a,0x7e]

v_not_b32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x6e,0x0a,0x7e]

v_not_b32 v5, m0
// GFX11: encoding: [0x7d,0x6e,0x0a,0x7e]

v_not_b32 v5, exec_lo
// GFX11: encoding: [0x7e,0x6e,0x0a,0x7e]

v_not_b32 v5, exec_hi
// GFX11: encoding: [0x7f,0x6e,0x0a,0x7e]

v_not_b32 v5, 0
// GFX11: encoding: [0x80,0x6e,0x0a,0x7e]

v_not_b32 v5, -1
// GFX11: encoding: [0xc1,0x6e,0x0a,0x7e]

v_not_b32 v5, 0.5
// GFX11: encoding: [0xf0,0x6e,0x0a,0x7e]

v_not_b32 v5, -4.0
// GFX11: encoding: [0xf7,0x6e,0x0a,0x7e]

v_not_b32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x6e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_not_b32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x6e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_not_b32 v5, ttmp11
// GFX11: encoding: [0x77,0x6e,0x0a,0x7e]

v_or3_b32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x05,0x0e,0x04]

v_or3_b32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x58,0xd6,0x01,0x05,0x0e,0x04]

v_or3_b32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0xff,0x05,0x0e,0x04]

v_or3_b32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x04,0x0e,0x04]

v_or3_b32 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x65,0x04,0x0e,0x04]

v_or3_b32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x6a,0x04,0x0e,0x04]

v_or3_b32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x6b,0x04,0x0e,0x04]

v_or3_b32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x7d,0x04,0x0e,0x04]

v_or3_b32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x7e,0x04,0x0e,0x04]

v_or3_b32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x7f,0x04,0x0e,0x04]

v_or3_b32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x80,0x04,0x0e,0x04]

v_or3_b32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0xc1,0x04,0x0e,0x04]

v_or3_b32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0xf0,0x04,0x0e,0x04]

v_or3_b32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0xf7,0x04,0x0e,0x04]

v_or3_b32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0xff,0x0f,0x04]

v_or3_b32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x05,0x0c,0x04]

v_or3_b32 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0xcb,0x0c,0x04]

v_or3_b32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0xd5,0x0c,0x04]

v_or3_b32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0xd7,0x0c,0x04]

v_or3_b32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0xfb,0x0c,0x04]

v_or3_b32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0xfd,0x0c,0x04]

v_or3_b32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0xff,0x0c,0x04]

v_or3_b32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x01,0x0d,0x04]

v_or3_b32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x83,0x0d,0x04]

v_or3_b32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0xe1,0x0d,0x04]

v_or3_b32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0xef,0x0d,0x04]

v_or3_b32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x05,0xfe,0x07]

v_or3_b32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x05,0x0e,0x00]

v_or3_b32 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x05,0x96,0x01]

v_or3_b32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x05,0xaa,0x01]

v_or3_b32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x05,0xae,0x01]

v_or3_b32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x05,0xf6,0x01]

v_or3_b32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x05,0xfa,0x01]

v_or3_b32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x05,0xfe,0x01]

v_or3_b32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x05,0x02,0x02]

v_or3_b32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x05,0x06,0x03]

v_or3_b32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x05,0xc2,0x03]

v_or3_b32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x05,0xde,0x03]

v_pack_b32_f16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0x05,0x02,0x00]

v_pack_b32_f16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x11,0xd7,0x01,0x05,0x02,0x00]

v_pack_b32_f16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0xff,0x05,0x02,0x00]

v_pack_b32_f16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0x04,0x02,0x00]

v_pack_b32_f16 v5, s101, v2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x65,0x04,0x02,0x00]

v_pack_b32_f16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x6a,0x04,0x02,0x00]

v_pack_b32_f16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x6b,0x04,0x02,0x00]

v_pack_b32_f16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x7d,0x04,0x02,0x00]

v_pack_b32_f16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x7e,0x04,0x02,0x00]

v_pack_b32_f16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x7f,0x04,0x02,0x00]

v_pack_b32_f16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x80,0x04,0x02,0x00]

v_pack_b32_f16 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0xc1,0x04,0x02,0x00]

v_pack_b32_f16 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0xf0,0x04,0x02,0x00]

v_pack_b32_f16 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0xf7,0x04,0x02,0x00]

v_pack_b32_f16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0xff,0x03,0x00]

v_pack_b32_f16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0x05,0x00,0x00]

v_pack_b32_f16 v5, v1, s101
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0xcb,0x00,0x00]

v_pack_b32_f16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0xd5,0x00,0x00]

v_pack_b32_f16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0xd7,0x00,0x00]

v_pack_b32_f16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0xfb,0x00,0x00]

v_pack_b32_f16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0xfd,0x00,0x00]

v_pack_b32_f16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0xff,0x00,0x00]

v_pack_b32_f16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0x01,0x01,0x00]

v_pack_b32_f16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0x83,0x01,0x00]

v_pack_b32_f16 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0xe1,0x01,0x00]

v_pack_b32_f16 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0xef,0x01,0x00]

v_pack_b32_f16 v5, -v1, v2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0x05,0x02,0x20]

v_pack_b32_f16 v5, v1, -v2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0x05,0x02,0x40]

v_pack_b32_f16 v5, -v1, -v2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0x05,0x02,0x60]

v_perm_b32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x05,0x0e,0x04]

v_perm_b32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x44,0xd6,0x01,0x05,0x0e,0x04]

v_perm_b32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0xff,0x05,0x0e,0x04]

v_perm_b32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x04,0x0e,0x04]

v_perm_b32 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x65,0x04,0x0e,0x04]

v_perm_b32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x6a,0x04,0x0e,0x04]

v_perm_b32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x6b,0x04,0x0e,0x04]

v_perm_b32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x7d,0x04,0x0e,0x04]

v_perm_b32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x7e,0x04,0x0e,0x04]

v_perm_b32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x7f,0x04,0x0e,0x04]

v_perm_b32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x80,0x04,0x0e,0x04]

v_perm_b32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0xc1,0x04,0x0e,0x04]

v_perm_b32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0xf0,0x04,0x0e,0x04]

v_perm_b32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0xf7,0x04,0x0e,0x04]

v_perm_b32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0xff,0x0f,0x04]

v_perm_b32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x05,0x0c,0x04]

v_perm_b32 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0xcb,0x0c,0x04]

v_perm_b32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0xd5,0x0c,0x04]

v_perm_b32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0xd7,0x0c,0x04]

v_perm_b32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0xfb,0x0c,0x04]

v_perm_b32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0xfd,0x0c,0x04]

v_perm_b32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0xff,0x0c,0x04]

v_perm_b32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x01,0x0d,0x04]

v_perm_b32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x83,0x0d,0x04]

v_perm_b32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0xe1,0x0d,0x04]

v_perm_b32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0xef,0x0d,0x04]

v_perm_b32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x05,0xfe,0x07]

v_perm_b32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x05,0x0e,0x00]

v_perm_b32 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x05,0x96,0x01]

v_perm_b32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x05,0xaa,0x01]

v_perm_b32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x05,0xae,0x01]

v_perm_b32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x05,0xf6,0x01]

v_perm_b32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x05,0xfa,0x01]

v_perm_b32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x05,0xfe,0x01]

v_perm_b32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x05,0x02,0x02]

v_perm_b32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x05,0x06,0x03]

v_perm_b32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x05,0xc2,0x03]

v_perm_b32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x05,0xde,0x03]

v_permlane16_b32 v5, v1, s2, s3
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0x05,0x0c,0x00]

v_permlane16_b32 v255, v1, s2, s3
// GFX11: encoding: [0xff,0x00,0x5b,0xd6,0x01,0x05,0x0c,0x00]

v_permlane16_b32 v5, v255, s2, s3
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0xff,0x05,0x0c,0x00]

v_permlane16_b32 v5, v103, s2, s3
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x67,0x05,0x0c,0x00]

v_permlane16_b32 v5, v1, vcc_lo, s2
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xd5,0x08,0x00]

v_permlane16_b32 v5, v1, vcc_hi, s2
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xd7,0x08,0x00]

v_permlane16_b32 v5, v1, m0, s2
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xfb,0x08,0x00]

v_permlane16_b32 v5, v1, exec_lo, s2
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xfd,0x08,0x00]

v_permlane16_b32 v5, v1, exec_hi, s2
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xff,0x08,0x00]

v_permlane16_b32 v5, v1, s103, s3
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xcf,0x0c,0x00]

v_permlane16_b32 v5, v1, vcc_lo, s3
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xd5,0x0c,0x00]

v_permlane16_b32 v5, v1, vcc_hi, s3
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xd7,0x0c,0x00]

v_permlane16_b32 v5, v1, m0, s3
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xfb,0x0c,0x00]

v_permlane16_b32 v5, v1, exec_lo, s3
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xfd,0x0c,0x00]

v_permlane16_b32 v5, v1, exec_hi, s3
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xff,0x0c,0x00]

v_permlane16_b32 v5, v1, 0, s3
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0x01,0x0d,0x00]

v_permlane16_b32 v5, v1, -1, s3
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0x83,0x0d,0x00]

v_permlane16_b32 v5, v1, 0.5, s3
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xe1,0x0d,0x00]

v_permlane16_b32 v5, v1, -4.0, s3
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xef,0x0d,0x00]

v_permlane16_b32 v5, v1, s2, s103
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0x05,0x9c,0x01]

v_permlane16_b32 v5, v1, s2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0x05,0xa8,0x01]

v_permlane16_b32 v5, v1, s2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0x05,0xac,0x01]

v_permlane16_b32 v5, v1, s2, m0
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0x05,0xf4,0x01]

v_permlane16_b32 v5, v1, s2, exec_lo
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0x05,0xf8,0x01]

v_permlane16_b32 v5, v1, s2, exec_hi
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0x05,0xfc,0x01]

v_permlane16_b32 v5, v1, s2, 0
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0x05,0x00,0x02]

v_permlane16_b32 v5, v1, s2, -1
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0x05,0x04,0x03]

v_permlane16_b32 v5, v1, s2, 0.5
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0x05,0xc0,0x03]

v_permlane16_b32 v5, v1, s2, -4.0
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0x05,0xdc,0x03]

v_permlane16_b32 v5, v1, ttmp11, s2
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xef,0x08,0x00]

v_permlane16_b32 v5, v1, ttmp11, s3
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xef,0x0c,0x00]

v_permlane16_b32 v5, v1, s2, ttmp11
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0x05,0xdc,0x01]

v_permlanex16_b32 v5, v1, s2, s3
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0x05,0x0c,0x00]

v_permlanex16_b32 v255, v1, s2, s3
// GFX11: encoding: [0xff,0x00,0x5c,0xd6,0x01,0x05,0x0c,0x00]

v_permlanex16_b32 v5, v255, s2, s3
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0xff,0x05,0x0c,0x00]

v_permlanex16_b32 v5, v103, s2, s3
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x67,0x05,0x0c,0x00]

v_permlanex16_b32 v5, v1, vcc_lo, s2
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xd5,0x08,0x00]

v_permlanex16_b32 v5, v1, vcc_hi, s2
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xd7,0x08,0x00]

v_permlanex16_b32 v5, v1, m0, s2
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xfb,0x08,0x00]

v_permlanex16_b32 v5, v1, exec_lo, s2
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xfd,0x08,0x00]

v_permlanex16_b32 v5, v1, exec_hi, s2
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xff,0x08,0x00]

v_permlanex16_b32 v5, v1, s103, s3
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xcf,0x0c,0x00]

v_permlanex16_b32 v5, v1, vcc_lo, s3
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xd5,0x0c,0x00]

v_permlanex16_b32 v5, v1, vcc_hi, s3
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xd7,0x0c,0x00]

v_permlanex16_b32 v5, v1, m0, s3
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xfb,0x0c,0x00]

v_permlanex16_b32 v5, v1, exec_lo, s3
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xfd,0x0c,0x00]

v_permlanex16_b32 v5, v1, exec_hi, s3
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xff,0x0c,0x00]

v_permlanex16_b32 v5, v1, 0, s3
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0x01,0x0d,0x00]

v_permlanex16_b32 v5, v1, -1, s3
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0x83,0x0d,0x00]

v_permlanex16_b32 v5, v1, 0.5, s3
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xe1,0x0d,0x00]

v_permlanex16_b32 v5, v1, -4.0, s3
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xef,0x0d,0x00]

v_permlanex16_b32 v5, v1, s2, s103
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0x05,0x9c,0x01]

v_permlanex16_b32 v5, v1, s2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0x05,0xa8,0x01]

v_permlanex16_b32 v5, v1, s2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0x05,0xac,0x01]

v_permlanex16_b32 v5, v1, s2, m0
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0x05,0xf4,0x01]

v_permlanex16_b32 v5, v1, s2, exec_lo
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0x05,0xf8,0x01]

v_permlanex16_b32 v5, v1, s2, exec_hi
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0x05,0xfc,0x01]

v_permlanex16_b32 v5, v1, s2, 0
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0x05,0x00,0x02]

v_permlanex16_b32 v5, v1, s2, -1
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0x05,0x04,0x03]

v_permlanex16_b32 v5, v1, s2, 0.5
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0x05,0xc0,0x03]

v_permlanex16_b32 v5, v1, s2, -4.0
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0x05,0xdc,0x03]

v_permlanex16_b32 v5, v1, ttmp11, s2
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xef,0x08,0x00]

v_permlanex16_b32 v5, v1, ttmp11, s3
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xef,0x0c,0x00]

v_permlanex16_b32 v5, v1, s2, ttmp11
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0x05,0xdc,0x01]

v_pipeflush
// GFX11: encoding: [0x00,0x36,0x00,0x7e]

v_pk_fmac_f16 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x78]

v_pk_fmac_f16 v255, v1, v2
// GFX11: encoding: [0x01,0x05,0xfe,0x79]

v_pk_fmac_f16 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x78]

v_pk_fmac_f16 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, s103, v2
// GFX11: encoding: [0x67,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, 0, v2
// GFX11: encoding: [0x80,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, -4.0, v2
// GFX11: encoding: [0xf7,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, v1, v255
// GFX11: encoding: [0x01,0xff,0x0b,0x78]

v_pk_fmac_f16 v5, ttmp11, v2
// GFX11: encoding: [0x77,0x04,0x0a,0x78]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0x05,0x0e,0x04]

v_qsad_pk_u16_u8 v[254:255], v[1:2], v2, v[3:4]
// GFX11: encoding: [0xfe,0x00,0x3a,0xd6,0x01,0x05,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], v[254:255], v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0xfe,0x05,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], s[2:3], v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x02,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], s[4:5], v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x04,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], s[102:103], v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x66,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], vcc, v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x6a,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], exec, v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x7e,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], 0, v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x80,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], -1, v2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0xc1,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v255, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0xff,0x0f,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], s2, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0x05,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], s103, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0xcf,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], vcc_lo, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0xd5,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], vcc_hi, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0xd7,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], m0, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0xfb,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], exec_lo, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0xfd,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], exec_hi, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0xff,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], 0, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0x01,0x0d,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], -1, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0x83,0x0d,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, v[254:255]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0x05,0xfa,0x07]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, s[6:7]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0x05,0x1a,0x00]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, s[8:9]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0x05,0x22,0x00]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, s[102:103]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0x05,0x9a,0x01]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, vcc
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0x05,0xaa,0x01]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, exec
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0x05,0xfa,0x01]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, 0
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0x05,0x02,0x02]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, -1
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0x05,0x06,0x03]

v_qsad_pk_u16_u8 v[5:6], v[1:2], ttmp11, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0xef,0x0c,0x04]

v_rcp_f32 v5, v1
// GFX11: encoding: [0x01,0x55,0x0a,0x7e]

v_rcp_f32 v255, v1
// GFX11: encoding: [0x01,0x55,0xfe,0x7f]

v_rcp_f32 v5, v255
// GFX11: encoding: [0xff,0x55,0x0a,0x7e]

v_rcp_f32 v5, s1
// GFX11: encoding: [0x01,0x54,0x0a,0x7e]

v_rcp_f32 v5, s103
// GFX11: encoding: [0x67,0x54,0x0a,0x7e]

v_rcp_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x54,0x0a,0x7e]

v_rcp_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x54,0x0a,0x7e]

v_rcp_f32 v5, m0
// GFX11: encoding: [0x7d,0x54,0x0a,0x7e]

v_rcp_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x54,0x0a,0x7e]

v_rcp_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x54,0x0a,0x7e]

v_rcp_f32 v5, 0
// GFX11: encoding: [0x80,0x54,0x0a,0x7e]

v_rcp_f32 v5, -1
// GFX11: encoding: [0xc1,0x54,0x0a,0x7e]

v_rcp_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x54,0x0a,0x7e]

v_rcp_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x54,0x0a,0x7e]

v_rcp_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x54,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x54,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x54,0x0a,0x7e]

v_rcp_f64 v[5:6], v[1:2]
// GFX11: encoding: [0x01,0x5f,0x0a,0x7e]

v_rcp_f64 v[254:255], v[1:2]
// GFX11: encoding: [0x01,0x5f,0xfc,0x7f]

v_rcp_f64 v[5:6], v[254:255]
// GFX11: encoding: [0xfe,0x5f,0x0a,0x7e]

v_rcp_f64 v[5:6], s[2:3]
// GFX11: encoding: [0x02,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], s[4:5]
// GFX11: encoding: [0x04,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], s[102:103]
// GFX11: encoding: [0x66,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], vcc
// GFX11: encoding: [0x6a,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], exec
// GFX11: encoding: [0x7e,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], 0
// GFX11: encoding: [0x80,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], -1
// GFX11: encoding: [0xc1,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], 0.5
// GFX11: encoding: [0xf0,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], -4.0
// GFX11: encoding: [0xf7,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], 0xaf123456
// GFX11: encoding: [0xff,0x5e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_f64 v[5:6], 0x3f717273
// GFX11: encoding: [0xff,0x5e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_iflag_f32 v5, v1
// GFX11: encoding: [0x01,0x57,0x0a,0x7e]

v_rcp_iflag_f32 v255, v1
// GFX11: encoding: [0x01,0x57,0xfe,0x7f]

v_rcp_iflag_f32 v5, v255
// GFX11: encoding: [0xff,0x57,0x0a,0x7e]

v_rcp_iflag_f32 v5, s1
// GFX11: encoding: [0x01,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, s103
// GFX11: encoding: [0x67,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, m0
// GFX11: encoding: [0x7d,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, 0
// GFX11: encoding: [0x80,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, -1
// GFX11: encoding: [0xc1,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x56,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_iflag_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x56,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_iflag_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x56,0x0a,0x7e]

v_readfirstlane_b32 s5, v1
// GFX11: encoding: [0x01,0x05,0x0a,0x7e]

v_readfirstlane_b32 s103, v1
// GFX11: encoding: [0x01,0x05,0xce,0x7e]

v_readfirstlane_b32 s5, v255
// GFX11: encoding: [0xff,0x05,0x0a,0x7e]

v_readfirstlane_b32 ttmp11, v1
// GFX11: encoding: [0x01,0x05,0xee,0x7e]

v_readlane_b32 s5, v1, s2
// GFX11: encoding: [0x05,0x00,0x60,0xd7,0x01,0x05,0x00,0x00]

v_readlane_b32 s101, v1, s2
// GFX11: encoding: [0x65,0x00,0x60,0xd7,0x01,0x05,0x00,0x00]

v_readlane_b32 s5, v255, s2
// GFX11: encoding: [0x05,0x00,0x60,0xd7,0xff,0x05,0x00,0x00]

v_readlane_b32 s5, v1, s101
// GFX11: encoding: [0x05,0x00,0x60,0xd7,0x01,0xcb,0x00,0x00]

v_readlane_b32 s5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x60,0xd7,0x01,0xd5,0x00,0x00]

v_readlane_b32 s5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x60,0xd7,0x01,0xd7,0x00,0x00]

v_readlane_b32 s5, v1, m0
// GFX11: encoding: [0x05,0x00,0x60,0xd7,0x01,0xfb,0x00,0x00]

v_readlane_b32 s5, v1, 0
// GFX11: encoding: [0x05,0x00,0x60,0xd7,0x01,0x01,0x01,0x00]

v_rndne_f32 v5, v1
// GFX11: encoding: [0x01,0x47,0x0a,0x7e]

v_rndne_f32 v255, v1
// GFX11: encoding: [0x01,0x47,0xfe,0x7f]

v_rndne_f32 v5, v255
// GFX11: encoding: [0xff,0x47,0x0a,0x7e]

v_rndne_f32 v5, s1
// GFX11: encoding: [0x01,0x46,0x0a,0x7e]

v_rndne_f32 v5, s103
// GFX11: encoding: [0x67,0x46,0x0a,0x7e]

v_rndne_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x46,0x0a,0x7e]

v_rndne_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x46,0x0a,0x7e]

v_rndne_f32 v5, m0
// GFX11: encoding: [0x7d,0x46,0x0a,0x7e]

v_rndne_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x46,0x0a,0x7e]

v_rndne_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x46,0x0a,0x7e]

v_rndne_f32 v5, 0
// GFX11: encoding: [0x80,0x46,0x0a,0x7e]

v_rndne_f32 v5, -1
// GFX11: encoding: [0xc1,0x46,0x0a,0x7e]

v_rndne_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x46,0x0a,0x7e]

v_rndne_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x46,0x0a,0x7e]

v_rndne_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x46,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rndne_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x46,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rndne_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x46,0x0a,0x7e]

v_rndne_f64 v[5:6], v[1:2]
// GFX11: encoding: [0x01,0x33,0x0a,0x7e]

v_rndne_f64 v[254:255], v[1:2]
// GFX11: encoding: [0x01,0x33,0xfc,0x7f]

v_rndne_f64 v[5:6], v[254:255]
// GFX11: encoding: [0xfe,0x33,0x0a,0x7e]

v_rndne_f64 v[5:6], s[2:3]
// GFX11: encoding: [0x02,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], s[4:5]
// GFX11: encoding: [0x04,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], s[102:103]
// GFX11: encoding: [0x66,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], vcc
// GFX11: encoding: [0x6a,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], exec
// GFX11: encoding: [0x7e,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], 0
// GFX11: encoding: [0x80,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], -1
// GFX11: encoding: [0xc1,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], 0.5
// GFX11: encoding: [0xf0,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], -4.0
// GFX11: encoding: [0xf7,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], 0xaf123456
// GFX11: encoding: [0xff,0x32,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rndne_f64 v[5:6], 0x3f717273
// GFX11: encoding: [0xff,0x32,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rsq_f32 v5, v1
// GFX11: encoding: [0x01,0x5d,0x0a,0x7e]

v_rsq_f32 v255, v1
// GFX11: encoding: [0x01,0x5d,0xfe,0x7f]

v_rsq_f32 v5, v255
// GFX11: encoding: [0xff,0x5d,0x0a,0x7e]

v_rsq_f32 v5, s1
// GFX11: encoding: [0x01,0x5c,0x0a,0x7e]

v_rsq_f32 v5, s103
// GFX11: encoding: [0x67,0x5c,0x0a,0x7e]

v_rsq_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x5c,0x0a,0x7e]

v_rsq_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x5c,0x0a,0x7e]

v_rsq_f32 v5, m0
// GFX11: encoding: [0x7d,0x5c,0x0a,0x7e]

v_rsq_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x5c,0x0a,0x7e]

v_rsq_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x5c,0x0a,0x7e]

v_rsq_f32 v5, 0
// GFX11: encoding: [0x80,0x5c,0x0a,0x7e]

v_rsq_f32 v5, -1
// GFX11: encoding: [0xc1,0x5c,0x0a,0x7e]

v_rsq_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x5c,0x0a,0x7e]

v_rsq_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x5c,0x0a,0x7e]

v_rsq_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x5c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rsq_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x5c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rsq_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x5c,0x0a,0x7e]

v_rsq_f64 v[5:6], v[1:2]
// GFX11: encoding: [0x01,0x63,0x0a,0x7e]

v_rsq_f64 v[254:255], v[1:2]
// GFX11: encoding: [0x01,0x63,0xfc,0x7f]

v_rsq_f64 v[5:6], v[254:255]
// GFX11: encoding: [0xfe,0x63,0x0a,0x7e]

v_rsq_f64 v[5:6], s[2:3]
// GFX11: encoding: [0x02,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], s[4:5]
// GFX11: encoding: [0x04,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], s[102:103]
// GFX11: encoding: [0x66,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], vcc
// GFX11: encoding: [0x6a,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], exec
// GFX11: encoding: [0x7e,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], 0
// GFX11: encoding: [0x80,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], -1
// GFX11: encoding: [0xc1,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], 0.5
// GFX11: encoding: [0xf0,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], -4.0
// GFX11: encoding: [0xf7,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], 0xaf123456
// GFX11: encoding: [0xff,0x62,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rsq_f64 v[5:6], 0x3f717273
// GFX11: encoding: [0xff,0x62,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_sad_hi_u8 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x05,0x0e,0x04]

v_sad_hi_u8 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x23,0xd6,0x01,0x05,0x0e,0x04]

v_sad_hi_u8 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0xff,0x05,0x0e,0x04]

v_sad_hi_u8 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x04,0x0e,0x04]

v_sad_hi_u8 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x67,0x04,0x0e,0x04]

v_sad_hi_u8 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x6a,0x04,0x0e,0x04]

v_sad_hi_u8 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x6b,0x04,0x0e,0x04]

v_sad_hi_u8 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x7d,0x04,0x0e,0x04]

v_sad_hi_u8 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x7e,0x04,0x0e,0x04]

v_sad_hi_u8 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x7f,0x04,0x0e,0x04]

v_sad_hi_u8 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x80,0x04,0x0e,0x04]

v_sad_hi_u8 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0xc1,0x04,0x0e,0x04]

v_sad_hi_u8 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0xf0,0x04,0x0e,0x04]

v_sad_hi_u8 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0xf7,0x04,0x0e,0x04]

v_sad_hi_u8 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0xff,0x0f,0x04]

v_sad_hi_u8 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x05,0x0c,0x04]

v_sad_hi_u8 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0xcf,0x0c,0x04]

v_sad_hi_u8 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0xd5,0x0c,0x04]

v_sad_hi_u8 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0xd7,0x0c,0x04]

v_sad_hi_u8 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0xfb,0x0c,0x04]

v_sad_hi_u8 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0xfd,0x0c,0x04]

v_sad_hi_u8 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0xff,0x0c,0x04]

v_sad_hi_u8 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x01,0x0d,0x04]

v_sad_hi_u8 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x83,0x0d,0x04]

v_sad_hi_u8 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0xe1,0x0d,0x04]

v_sad_hi_u8 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0xef,0x0d,0x04]

v_sad_hi_u8 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x05,0xfe,0x07]

v_sad_hi_u8 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x05,0x0e,0x00]

v_sad_hi_u8 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x05,0x9e,0x01]

v_sad_hi_u8 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x05,0xaa,0x01]

v_sad_hi_u8 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x05,0xae,0x01]

v_sad_hi_u8 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x05,0xf6,0x01]

v_sad_hi_u8 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x05,0xfa,0x01]

v_sad_hi_u8 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x05,0xfe,0x01]

v_sad_hi_u8 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x05,0x02,0x02]

v_sad_hi_u8 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x05,0x06,0x03]

v_sad_hi_u8 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x05,0xc2,0x03]

v_sad_hi_u8 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x05,0xde,0x03]

v_sad_hi_u8 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x77,0x04,0x0e,0x04]

v_sad_hi_u8 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0xef,0x0c,0x04]

v_sad_hi_u8 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x05,0xde,0x01]

v_sad_u16 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x05,0x0e,0x04]

v_sad_u16 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x24,0xd6,0x01,0x05,0x0e,0x04]

v_sad_u16 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0xff,0x05,0x0e,0x04]

v_sad_u16 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x04,0x0e,0x04]

v_sad_u16 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x67,0x04,0x0e,0x04]

v_sad_u16 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x6a,0x04,0x0e,0x04]

v_sad_u16 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x6b,0x04,0x0e,0x04]

v_sad_u16 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x7d,0x04,0x0e,0x04]

v_sad_u16 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x7e,0x04,0x0e,0x04]

v_sad_u16 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x7f,0x04,0x0e,0x04]

v_sad_u16 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x80,0x04,0x0e,0x04]

v_sad_u16 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0xc1,0x04,0x0e,0x04]

v_sad_u16 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0xf0,0x04,0x0e,0x04]

v_sad_u16 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0xf7,0x04,0x0e,0x04]

v_sad_u16 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0xff,0x0f,0x04]

v_sad_u16 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x05,0x0c,0x04]

v_sad_u16 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0xcf,0x0c,0x04]

v_sad_u16 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0xd5,0x0c,0x04]

v_sad_u16 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0xd7,0x0c,0x04]

v_sad_u16 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0xfb,0x0c,0x04]

v_sad_u16 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0xfd,0x0c,0x04]

v_sad_u16 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0xff,0x0c,0x04]

v_sad_u16 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x01,0x0d,0x04]

v_sad_u16 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x83,0x0d,0x04]

v_sad_u16 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0xe1,0x0d,0x04]

v_sad_u16 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0xef,0x0d,0x04]

v_sad_u16 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x05,0xfe,0x07]

v_sad_u16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x05,0x0e,0x00]

v_sad_u16 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x05,0x9e,0x01]

v_sad_u16 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x05,0xaa,0x01]

v_sad_u16 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x05,0xae,0x01]

v_sad_u16 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x05,0xf6,0x01]

v_sad_u16 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x05,0xfa,0x01]

v_sad_u16 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x05,0xfe,0x01]

v_sad_u16 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x05,0x02,0x02]

v_sad_u16 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x05,0x06,0x03]

v_sad_u16 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x05,0xc2,0x03]

v_sad_u16 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x05,0xde,0x03]

v_sad_u16 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x77,0x04,0x0e,0x04]

v_sad_u16 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0xef,0x0c,0x04]

v_sad_u16 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x05,0xde,0x01]

v_sad_u32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x05,0x0e,0x04]

v_sad_u32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x25,0xd6,0x01,0x05,0x0e,0x04]

v_sad_u32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0xff,0x05,0x0e,0x04]

v_sad_u32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x04,0x0e,0x04]

v_sad_u32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x67,0x04,0x0e,0x04]

v_sad_u32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x6a,0x04,0x0e,0x04]

v_sad_u32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x6b,0x04,0x0e,0x04]

v_sad_u32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x7d,0x04,0x0e,0x04]

v_sad_u32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x7e,0x04,0x0e,0x04]

v_sad_u32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x7f,0x04,0x0e,0x04]

v_sad_u32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x80,0x04,0x0e,0x04]

v_sad_u32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0xc1,0x04,0x0e,0x04]

v_sad_u32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0xf0,0x04,0x0e,0x04]

v_sad_u32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0xf7,0x04,0x0e,0x04]

v_sad_u32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0xff,0x0f,0x04]

v_sad_u32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x05,0x0c,0x04]

v_sad_u32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0xcf,0x0c,0x04]

v_sad_u32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0xd5,0x0c,0x04]

v_sad_u32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0xd7,0x0c,0x04]

v_sad_u32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0xfb,0x0c,0x04]

v_sad_u32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0xfd,0x0c,0x04]

v_sad_u32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0xff,0x0c,0x04]

v_sad_u32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x01,0x0d,0x04]

v_sad_u32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x83,0x0d,0x04]

v_sad_u32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0xe1,0x0d,0x04]

v_sad_u32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0xef,0x0d,0x04]

v_sad_u32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x05,0xfe,0x07]

v_sad_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x05,0x0e,0x00]

v_sad_u32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x05,0x9e,0x01]

v_sad_u32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x05,0xaa,0x01]

v_sad_u32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x05,0xae,0x01]

v_sad_u32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x05,0xf6,0x01]

v_sad_u32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x05,0xfa,0x01]

v_sad_u32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x05,0xfe,0x01]

v_sad_u32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x05,0x02,0x02]

v_sad_u32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x05,0x06,0x03]

v_sad_u32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x05,0xc2,0x03]

v_sad_u32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x05,0xde,0x03]

v_sad_u32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x77,0x04,0x0e,0x04]

v_sad_u32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0xef,0x0c,0x04]

v_sad_u32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x05,0xde,0x01]

v_sad_u8 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x05,0x0e,0x04]

v_sad_u8 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x22,0xd6,0x01,0x05,0x0e,0x04]

v_sad_u8 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0xff,0x05,0x0e,0x04]

v_sad_u8 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x04,0x0e,0x04]

v_sad_u8 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x67,0x04,0x0e,0x04]

v_sad_u8 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x6a,0x04,0x0e,0x04]

v_sad_u8 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x6b,0x04,0x0e,0x04]

v_sad_u8 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x7d,0x04,0x0e,0x04]

v_sad_u8 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x7e,0x04,0x0e,0x04]

v_sad_u8 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x7f,0x04,0x0e,0x04]

v_sad_u8 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x80,0x04,0x0e,0x04]

v_sad_u8 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0xc1,0x04,0x0e,0x04]

v_sad_u8 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0xf0,0x04,0x0e,0x04]

v_sad_u8 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0xf7,0x04,0x0e,0x04]

v_sad_u8 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0xff,0x0f,0x04]

v_sad_u8 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x05,0x0c,0x04]

v_sad_u8 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0xcf,0x0c,0x04]

v_sad_u8 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0xd5,0x0c,0x04]

v_sad_u8 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0xd7,0x0c,0x04]

v_sad_u8 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0xfb,0x0c,0x04]

v_sad_u8 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0xfd,0x0c,0x04]

v_sad_u8 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0xff,0x0c,0x04]

v_sad_u8 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x01,0x0d,0x04]

v_sad_u8 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x83,0x0d,0x04]

v_sad_u8 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0xe1,0x0d,0x04]

v_sad_u8 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0xef,0x0d,0x04]

v_sad_u8 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x05,0xfe,0x07]

v_sad_u8 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x05,0x0e,0x00]

v_sad_u8 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x05,0x9e,0x01]

v_sad_u8 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x05,0xaa,0x01]

v_sad_u8 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x05,0xae,0x01]

v_sad_u8 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x05,0xf6,0x01]

v_sad_u8 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x05,0xfa,0x01]

v_sad_u8 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x05,0xfe,0x01]

v_sad_u8 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x05,0x02,0x02]

v_sad_u8 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x05,0x06,0x03]

v_sad_u8 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x05,0xc2,0x03]

v_sad_u8 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x05,0xde,0x03]

v_sad_u8 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x77,0x04,0x0e,0x04]

v_sad_u8 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0xef,0x0c,0x04]

v_sad_u8 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x05,0xde,0x01]

v_sat_pk_u8_i16 v0, v2
// GFX11: encoding: [0x02,0xc5,0x00,0x7e]

v_sat_pk_u8_i16_e64 v0, v2
// W32:  encoding: [0x00,0x00,0xe2,0xd5,0x02,0x01,0x00,0x00]
// W64:  encoding: [0x00,0x00,0xe2,0xd5,0x02,0x01,0x00,0x00]

v_sin_f32 v5, v1
// GFX11: encoding: [0x01,0x6b,0x0a,0x7e]

v_sin_f32 v255, v1
// GFX11: encoding: [0x01,0x6b,0xfe,0x7f]

v_sin_f32 v5, v255
// GFX11: encoding: [0xff,0x6b,0x0a,0x7e]

v_sin_f32 v5, s1
// GFX11: encoding: [0x01,0x6a,0x0a,0x7e]

v_sin_f32 v5, s103
// GFX11: encoding: [0x67,0x6a,0x0a,0x7e]

v_sin_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x6a,0x0a,0x7e]

v_sin_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x6a,0x0a,0x7e]

v_sin_f32 v5, m0
// GFX11: encoding: [0x7d,0x6a,0x0a,0x7e]

v_sin_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x6a,0x0a,0x7e]

v_sin_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x6a,0x0a,0x7e]

v_sin_f32 v5, 0
// GFX11: encoding: [0x80,0x6a,0x0a,0x7e]

v_sin_f32 v5, -1
// GFX11: encoding: [0xc1,0x6a,0x0a,0x7e]

v_sin_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x6a,0x0a,0x7e]

v_sin_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x6a,0x0a,0x7e]

v_sin_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x6a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_sin_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x6a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_sin_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x6a,0x0a,0x7e]

v_sqrt_f32 v5, v1
// GFX11: encoding: [0x01,0x67,0x0a,0x7e]

v_sqrt_f32 v255, v1
// GFX11: encoding: [0x01,0x67,0xfe,0x7f]

v_sqrt_f32 v5, v255
// GFX11: encoding: [0xff,0x67,0x0a,0x7e]

v_sqrt_f32 v5, s1
// GFX11: encoding: [0x01,0x66,0x0a,0x7e]

v_sqrt_f32 v5, s103
// GFX11: encoding: [0x67,0x66,0x0a,0x7e]

v_sqrt_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x66,0x0a,0x7e]

v_sqrt_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x66,0x0a,0x7e]

v_sqrt_f32 v5, m0
// GFX11: encoding: [0x7d,0x66,0x0a,0x7e]

v_sqrt_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x66,0x0a,0x7e]

v_sqrt_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x66,0x0a,0x7e]

v_sqrt_f32 v5, 0
// GFX11: encoding: [0x80,0x66,0x0a,0x7e]

v_sqrt_f32 v5, -1
// GFX11: encoding: [0xc1,0x66,0x0a,0x7e]

v_sqrt_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x66,0x0a,0x7e]

v_sqrt_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x66,0x0a,0x7e]

v_sqrt_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x66,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_sqrt_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x66,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_sqrt_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x66,0x0a,0x7e]

v_sqrt_f64 v[5:6], v[1:2]
// GFX11: encoding: [0x01,0x69,0x0a,0x7e]

v_sqrt_f64 v[254:255], v[1:2]
// GFX11: encoding: [0x01,0x69,0xfc,0x7f]

v_sqrt_f64 v[5:6], v[254:255]
// GFX11: encoding: [0xfe,0x69,0x0a,0x7e]

v_sqrt_f64 v[5:6], s[2:3]
// GFX11: encoding: [0x02,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], s[4:5]
// GFX11: encoding: [0x04,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], s[102:103]
// GFX11: encoding: [0x66,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], vcc
// GFX11: encoding: [0x6a,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], exec
// GFX11: encoding: [0x7e,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], 0
// GFX11: encoding: [0x80,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], -1
// GFX11: encoding: [0xc1,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], 0.5
// GFX11: encoding: [0xf0,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], -4.0
// GFX11: encoding: [0xf7,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], 0xaf123456
// GFX11: encoding: [0xff,0x68,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_sqrt_f64 v[5:6], 0x3f717273
// GFX11: encoding: [0xff,0x68,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_sub_co_u32 v5, s0, v1, v2
// W32: encoding: [0x05,0x00,0x01,0xd7,0x01,0x05,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v255, s0, v1, v2
// W32: encoding: [0xff,0x00,0x01,0xd7,0x01,0x05,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v255, v2
// W32: encoding: [0x05,0x00,0x01,0xd7,0xff,0x05,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, s1, v2
// W32: encoding: [0x05,0x00,0x01,0xd7,0x01,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, s103, v2
// W32: encoding: [0x05,0x00,0x01,0xd7,0x67,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, vcc_lo, v2
// W32: encoding: [0x05,0x00,0x01,0xd7,0x6a,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, vcc_hi, v2
// W32: encoding: [0x05,0x00,0x01,0xd7,0x6b,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, m0, v2
// W32: encoding: [0x05,0x00,0x01,0xd7,0x7d,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, exec_lo, v2
// W32: encoding: [0x05,0x00,0x01,0xd7,0x7e,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, exec_hi, v2
// W32: encoding: [0x05,0x00,0x01,0xd7,0x7f,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, 0, v2
// W32: encoding: [0x05,0x00,0x01,0xd7,0x80,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, -1, v2
// W32: encoding: [0x05,0x00,0x01,0xd7,0xc1,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, 0.5, v2
// W32: encoding: [0x05,0x00,0x01,0xd7,0xf0,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, -4.0, v2
// W32: encoding: [0x05,0x00,0x01,0xd7,0xf7,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, v255
// W32: encoding: [0x05,0x00,0x01,0xd7,0x01,0xff,0x03,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, s2
// W32: encoding: [0x05,0x00,0x01,0xd7,0x01,0x05,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, s103
// W32: encoding: [0x05,0x00,0x01,0xd7,0x01,0xcf,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, vcc_lo
// W32: encoding: [0x05,0x00,0x01,0xd7,0x01,0xd5,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, vcc_hi
// W32: encoding: [0x05,0x00,0x01,0xd7,0x01,0xd7,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, m0
// W32: encoding: [0x05,0x00,0x01,0xd7,0x01,0xfb,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, exec_lo
// W32: encoding: [0x05,0x00,0x01,0xd7,0x01,0xfd,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, exec_hi
// W32: encoding: [0x05,0x00,0x01,0xd7,0x01,0xff,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, 0
// W32: encoding: [0x05,0x00,0x01,0xd7,0x01,0x01,0x01,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, -1
// W32: encoding: [0x05,0x00,0x01,0xd7,0x01,0x83,0x01,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, 0.5
// W32: encoding: [0x05,0x00,0x01,0xd7,0x01,0xe1,0x01,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, -4.0
// W32: encoding: [0x05,0x00,0x01,0xd7,0x01,0xef,0x01,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, ttmp11, v2
// W32: encoding: [0x05,0x00,0x01,0xd7,0x77,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, ttmp11
// W32: encoding: [0x05,0x00,0x01,0xd7,0x01,0xef,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, v2
// W64: encoding: [0x05,0x00,0x01,0xd7,0x01,0x05,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v255, s[0:1], v1, v2
// W64: encoding: [0xff,0x00,0x01,0xd7,0x01,0x05,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v255, v2
// W64: encoding: [0x05,0x00,0x01,0xd7,0xff,0x05,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], s1, v2
// W64: encoding: [0x05,0x00,0x01,0xd7,0x01,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], s103, v2
// W64: encoding: [0x05,0x00,0x01,0xd7,0x67,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], vcc_lo, v2
// W64: encoding: [0x05,0x00,0x01,0xd7,0x6a,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], vcc_hi, v2
// W64: encoding: [0x05,0x00,0x01,0xd7,0x6b,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], m0, v2
// W64: encoding: [0x05,0x00,0x01,0xd7,0x7d,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], exec_lo, v2
// W64: encoding: [0x05,0x00,0x01,0xd7,0x7e,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], exec_hi, v2
// W64: encoding: [0x05,0x00,0x01,0xd7,0x7f,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], 0, v2
// W64: encoding: [0x05,0x00,0x01,0xd7,0x80,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], -1, v2
// W64: encoding: [0x05,0x00,0x01,0xd7,0xc1,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], 0.5, v2
// W64: encoding: [0x05,0x00,0x01,0xd7,0xf0,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], -4.0, v2
// W64: encoding: [0x05,0x00,0x01,0xd7,0xf7,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, v255
// W64: encoding: [0x05,0x00,0x01,0xd7,0x01,0xff,0x03,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, s2
// W64: encoding: [0x05,0x00,0x01,0xd7,0x01,0x05,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, s103
// W64: encoding: [0x05,0x00,0x01,0xd7,0x01,0xcf,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, vcc_lo
// W64: encoding: [0x05,0x00,0x01,0xd7,0x01,0xd5,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, vcc_hi
// W64: encoding: [0x05,0x00,0x01,0xd7,0x01,0xd7,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, m0
// W64: encoding: [0x05,0x00,0x01,0xd7,0x01,0xfb,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, exec_lo
// W64: encoding: [0x05,0x00,0x01,0xd7,0x01,0xfd,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, exec_hi
// W64: encoding: [0x05,0x00,0x01,0xd7,0x01,0xff,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, 0
// W64: encoding: [0x05,0x00,0x01,0xd7,0x01,0x01,0x01,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, -1
// W64: encoding: [0x05,0x00,0x01,0xd7,0x01,0x83,0x01,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, 0.5
// W64: encoding: [0x05,0x00,0x01,0xd7,0x01,0xe1,0x01,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, -4.0
// W64: encoding: [0x05,0x00,0x01,0xd7,0x01,0xef,0x01,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], ttmp11, v2
// W64: encoding: [0x05,0x00,0x01,0xd7,0x77,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, ttmp11
// W64: encoding: [0x05,0x00,0x01,0xd7,0x01,0xef,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_sub_nc_i16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x01,0x05,0x02,0x00]

v_sub_nc_i16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x0e,0xd7,0x01,0x05,0x02,0x00]

v_sub_nc_i16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0xff,0x05,0x02,0x00]

v_sub_nc_i16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x01,0x04,0x02,0x00]

v_sub_nc_i16 v5, s101, v2
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x65,0x04,0x02,0x00]

v_sub_nc_i16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x6a,0x04,0x02,0x00]

v_sub_nc_i16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x6b,0x04,0x02,0x00]

v_sub_nc_i16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x7d,0x04,0x02,0x00]

v_sub_nc_i16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x7e,0x04,0x02,0x00]

v_sub_nc_i16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x7f,0x04,0x02,0x00]

v_sub_nc_i16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x80,0x04,0x02,0x00]

v_sub_nc_i16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xff,0x03,0x00]

v_sub_nc_i16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x01,0x05,0x00,0x00]

v_sub_nc_i16 v5, v1, s101
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xcb,0x00,0x00]

v_sub_nc_i16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xd5,0x00,0x00]

v_sub_nc_i16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xd7,0x00,0x00]

v_sub_nc_i16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xfb,0x00,0x00]

v_sub_nc_i16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xfd,0x00,0x00]

v_sub_nc_i16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xff,0x00,0x00]

v_sub_nc_i16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x01,0x01,0x01,0x00]

v_sub_nc_i16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x01,0x83,0x01,0x00]

v_sub_nc_i16 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_sub_nc_i16 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_sub_nc_i32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x01,0x05,0x02,0x00]

v_sub_nc_i32 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x25,0xd7,0x01,0x05,0x02,0x00]

v_sub_nc_i32 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0xff,0x05,0x02,0x00]

v_sub_nc_i32 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x01,0x04,0x02,0x00]

v_sub_nc_i32 v5, s103, v2
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x67,0x04,0x02,0x00]

v_sub_nc_i32 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x6a,0x04,0x02,0x00]

v_sub_nc_i32 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x6b,0x04,0x02,0x00]

v_sub_nc_i32 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x7d,0x04,0x02,0x00]

v_sub_nc_i32 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x7e,0x04,0x02,0x00]

v_sub_nc_i32 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x7f,0x04,0x02,0x00]

v_sub_nc_i32 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x80,0x04,0x02,0x00]

v_sub_nc_i32 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0xc1,0x04,0x02,0x00]

v_sub_nc_i32 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0xf0,0x04,0x02,0x00]

v_sub_nc_i32 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0xf7,0x04,0x02,0x00]

v_sub_nc_i32 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x01,0xff,0x03,0x00]

v_sub_nc_i32 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x01,0x05,0x00,0x00]

v_sub_nc_i32 v5, v1, s103
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x01,0xcf,0x00,0x00]

v_sub_nc_i32 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x01,0xd5,0x00,0x00]

v_sub_nc_i32 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x01,0xd7,0x00,0x00]

v_sub_nc_i32 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x01,0xfb,0x00,0x00]

v_sub_nc_i32 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x01,0xfd,0x00,0x00]

v_sub_nc_i32 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x01,0xff,0x00,0x00]

v_sub_nc_i32 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x01,0x01,0x01,0x00]

v_sub_nc_i32 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x01,0x83,0x01,0x00]

v_sub_nc_i32 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x01,0xe1,0x01,0x00]

v_sub_nc_i32 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x01,0xef,0x01,0x00]

v_sub_nc_i32 v5, v1, -4.0 clamp
// GFX11: encoding: [0x05,0x80,0x25,0xd7,0x01,0xef,0x01,0x00]

v_sub_nc_i32 v5, ttmp11, v2
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x77,0x04,0x02,0x00]

v_sub_nc_i32 v5, v1, ttmp11
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x01,0xef,0x00,0x00]

v_sub_nc_u16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x01,0x05,0x02,0x00]

v_sub_nc_u16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x04,0xd7,0x01,0x05,0x02,0x00]

v_sub_nc_u16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0xff,0x05,0x02,0x00]

v_sub_nc_u16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x01,0x04,0x02,0x00]

v_sub_nc_u16 v5, s101, v2
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x65,0x04,0x02,0x00]

v_sub_nc_u16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x6a,0x04,0x02,0x00]

v_sub_nc_u16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x6b,0x04,0x02,0x00]

v_sub_nc_u16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x7d,0x04,0x02,0x00]

v_sub_nc_u16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x7e,0x04,0x02,0x00]

v_sub_nc_u16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x7f,0x04,0x02,0x00]

v_sub_nc_u16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x80,0x04,0x02,0x00]

v_sub_nc_u16 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0xc1,0x04,0x02,0x00]

v_sub_nc_u16 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_sub_nc_u16 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_sub_nc_u16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x01,0xff,0x03,0x00]

v_sub_nc_u16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x01,0x05,0x00,0x00]

v_sub_nc_u16 v5, v1, s101
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x01,0xcb,0x00,0x00]

v_sub_nc_u16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x01,0xd5,0x00,0x00]

v_sub_nc_u16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x01,0xd7,0x00,0x00]

v_sub_nc_u16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x01,0xfb,0x00,0x00]

v_sub_nc_u16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x01,0xfd,0x00,0x00]

v_sub_nc_u16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x01,0xff,0x00,0x00]

v_sub_nc_u16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x01,0x01,0x01,0x00]

v_sub_nc_u16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x01,0x83,0x01,0x00]

v_sub_nc_u16 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_sub_nc_u16 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_sub_nc_u16 v5, v1, -4.0 clamp
// GFX11: encoding: [0x05,0x80,0x04,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_subrev_co_u32 v5, s0, v1, v2
// W32: encoding: [0x05,0x00,0x02,0xd7,0x01,0x05,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v255, s0, v1, v2
// W32: encoding: [0xff,0x00,0x02,0xd7,0x01,0x05,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v255, v2
// W32: encoding: [0x05,0x00,0x02,0xd7,0xff,0x05,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, s1, v2
// W32: encoding: [0x05,0x00,0x02,0xd7,0x01,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, s103, v2
// W32: encoding: [0x05,0x00,0x02,0xd7,0x67,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, vcc_lo, v2
// W32: encoding: [0x05,0x00,0x02,0xd7,0x6a,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, vcc_hi, v2
// W32: encoding: [0x05,0x00,0x02,0xd7,0x6b,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, m0, v2
// W32: encoding: [0x05,0x00,0x02,0xd7,0x7d,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, exec_lo, v2
// W32: encoding: [0x05,0x00,0x02,0xd7,0x7e,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, exec_hi, v2
// W32: encoding: [0x05,0x00,0x02,0xd7,0x7f,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, 0, v2
// W32: encoding: [0x05,0x00,0x02,0xd7,0x80,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, -1, v2
// W32: encoding: [0x05,0x00,0x02,0xd7,0xc1,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, 0.5, v2
// W32: encoding: [0x05,0x00,0x02,0xd7,0xf0,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, -4.0, v2
// W32: encoding: [0x05,0x00,0x02,0xd7,0xf7,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, v255
// W32: encoding: [0x05,0x00,0x02,0xd7,0x01,0xff,0x03,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, s2
// W32: encoding: [0x05,0x00,0x02,0xd7,0x01,0x05,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, s103
// W32: encoding: [0x05,0x00,0x02,0xd7,0x01,0xcf,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, vcc_lo
// W32: encoding: [0x05,0x00,0x02,0xd7,0x01,0xd5,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, vcc_hi
// W32: encoding: [0x05,0x00,0x02,0xd7,0x01,0xd7,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, m0
// W32: encoding: [0x05,0x00,0x02,0xd7,0x01,0xfb,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, exec_lo
// W32: encoding: [0x05,0x00,0x02,0xd7,0x01,0xfd,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, exec_hi
// W32: encoding: [0x05,0x00,0x02,0xd7,0x01,0xff,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, 0
// W32: encoding: [0x05,0x00,0x02,0xd7,0x01,0x01,0x01,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, -1
// W32: encoding: [0x05,0x00,0x02,0xd7,0x01,0x83,0x01,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, 0.5
// W32: encoding: [0x05,0x00,0x02,0xd7,0x01,0xe1,0x01,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, -4.0
// W32: encoding: [0x05,0x00,0x02,0xd7,0x01,0xef,0x01,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, ttmp11, v2
// W32: encoding: [0x05,0x00,0x02,0xd7,0x77,0x04,0x02,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, ttmp11
// W32: encoding: [0x05,0x00,0x02,0xd7,0x01,0xef,0x00,0x00]
// W64-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, v2
// W64: encoding: [0x05,0x00,0x02,0xd7,0x01,0x05,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v255, s[0:1], v1, v2
// W64: encoding: [0xff,0x00,0x02,0xd7,0x01,0x05,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v255, v2
// W64: encoding: [0x05,0x00,0x02,0xd7,0xff,0x05,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], s1, v2
// W64: encoding: [0x05,0x00,0x02,0xd7,0x01,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], s103, v2
// W64: encoding: [0x05,0x00,0x02,0xd7,0x67,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], vcc_lo, v2
// W64: encoding: [0x05,0x00,0x02,0xd7,0x6a,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], vcc_hi, v2
// W64: encoding: [0x05,0x00,0x02,0xd7,0x6b,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], m0, v2
// W64: encoding: [0x05,0x00,0x02,0xd7,0x7d,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], exec_lo, v2
// W64: encoding: [0x05,0x00,0x02,0xd7,0x7e,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], exec_hi, v2
// W64: encoding: [0x05,0x00,0x02,0xd7,0x7f,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], 0, v2
// W64: encoding: [0x05,0x00,0x02,0xd7,0x80,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], -1, v2
// W64: encoding: [0x05,0x00,0x02,0xd7,0xc1,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], 0.5, v2
// W64: encoding: [0x05,0x00,0x02,0xd7,0xf0,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], -4.0, v2
// W64: encoding: [0x05,0x00,0x02,0xd7,0xf7,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, v255
// W64: encoding: [0x05,0x00,0x02,0xd7,0x01,0xff,0x03,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, s2
// W64: encoding: [0x05,0x00,0x02,0xd7,0x01,0x05,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, s103
// W64: encoding: [0x05,0x00,0x02,0xd7,0x01,0xcf,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, vcc_lo
// W64: encoding: [0x05,0x00,0x02,0xd7,0x01,0xd5,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, vcc_hi
// W64: encoding: [0x05,0x00,0x02,0xd7,0x01,0xd7,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, m0
// W64: encoding: [0x05,0x00,0x02,0xd7,0x01,0xfb,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, exec_lo
// W64: encoding: [0x05,0x00,0x02,0xd7,0x01,0xfd,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, exec_hi
// W64: encoding: [0x05,0x00,0x02,0xd7,0x01,0xff,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, 0
// W64: encoding: [0x05,0x00,0x02,0xd7,0x01,0x01,0x01,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, -1
// W64: encoding: [0x05,0x00,0x02,0xd7,0x01,0x83,0x01,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, 0.5
// W64: encoding: [0x05,0x00,0x02,0xd7,0x01,0xe1,0x01,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, -4.0
// W64: encoding: [0x05,0x00,0x02,0xd7,0x01,0xef,0x01,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], ttmp11, v2
// W64: encoding: [0x05,0x00,0x02,0xd7,0x77,0x04,0x02,0x00]
// W32-ERR: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, ttmp11
// W64: encoding: [0x05,0x00,0x02,0xd7,0x01,0xef,0x00,0x00]
// W32-ERR: error: invalid operand for instruction

v_swap_b32 v5, v1
// GFX11: encoding: [0x01,0xcb,0x0a,0x7e]

v_swap_b32 v255, v1
// GFX11: encoding: [0x01,0xcb,0xfe,0x7f]

v_swap_b32 v5, v255
// GFX11: encoding: [0xff,0xcb,0x0a,0x7e]

v_swaprel_b32 v5, v1
// GFX11: encoding: [0x01,0xd1,0x0a,0x7e]

v_swaprel_b32 v255, v1
// GFX11: encoding: [0x01,0xd1,0xfe,0x7f]

v_swaprel_b32 v5, v255
// GFX11: encoding: [0xff,0xd1,0x0a,0x7e]

v_trig_preop_f64 v[5:6], v[1:2], v2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0x05,0x02,0x00]

v_trig_preop_f64 v[254:255], v[1:2], v2
// GFX11: encoding: [0xfe,0x00,0x2f,0xd7,0x01,0x05,0x02,0x00]

v_trig_preop_f64 v[5:6], v[254:255], v2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0xfe,0x05,0x02,0x00]

v_trig_preop_f64 v[5:6], s[2:3], v2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x02,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], s[4:5], v2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x04,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], s[102:103], v2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x66,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], vcc, v2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x6a,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], exec, v2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x7e,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], 0, v2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x80,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], -1, v2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0xc1,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], 0.5, v2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0xf0,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], -4.0, v2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0xf7,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], v[1:2], v255
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0xff,0x03,0x00]

v_trig_preop_f64 v[5:6], v[1:2], s2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0x05,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], s103
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0xcf,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], vcc_lo
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0xd5,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], vcc_hi
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0xd7,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], m0
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0xfb,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], exec_lo
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0xfd,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], exec_hi
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0xff,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], 0
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0x01,0x01,0x00]

v_trig_preop_f64 v[5:6], v[1:2], -1
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0x83,0x01,0x00]

v_trig_preop_f64 v[5:6], v[1:2], 0.5
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0xe1,0x01,0x00]

v_trig_preop_f64 v[5:6], v[1:2], -4.0
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0xef,0x01,0x00]

v_trig_preop_f64 v[5:6], -v[1:2], v2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0x05,0x02,0x20]

v_trig_preop_f64 v[5:6], v[1:2], v2 clamp
// GFX11: encoding: [0x05,0x80,0x2f,0xd7,0x01,0x05,0x02,0x00]

v_trig_preop_f64 v[5:6], v[1:2], v2 mul:2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0x05,0x02,0x08]

v_trig_preop_f64 v[5:6], v[1:2], v2 mul:4
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0x05,0x02,0x10]

v_trig_preop_f64 v[5:6], v[1:2], v2 div:2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0x05,0x02,0x18]

v_trig_preop_f64 v[5:6], v[1:2], ttmp11
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0xef,0x00,0x00]

v_trunc_f32 v5, v1
// GFX11: encoding: [0x01,0x43,0x0a,0x7e]

v_trunc_f32 v255, v1
// GFX11: encoding: [0x01,0x43,0xfe,0x7f]

v_trunc_f32 v5, v255
// GFX11: encoding: [0xff,0x43,0x0a,0x7e]

v_trunc_f32 v5, s1
// GFX11: encoding: [0x01,0x42,0x0a,0x7e]

v_trunc_f32 v5, s103
// GFX11: encoding: [0x67,0x42,0x0a,0x7e]

v_trunc_f32 v5, vcc_lo
// GFX11: encoding: [0x6a,0x42,0x0a,0x7e]

v_trunc_f32 v5, vcc_hi
// GFX11: encoding: [0x6b,0x42,0x0a,0x7e]

v_trunc_f32 v5, m0
// GFX11: encoding: [0x7d,0x42,0x0a,0x7e]

v_trunc_f32 v5, exec_lo
// GFX11: encoding: [0x7e,0x42,0x0a,0x7e]

v_trunc_f32 v5, exec_hi
// GFX11: encoding: [0x7f,0x42,0x0a,0x7e]

v_trunc_f32 v5, 0
// GFX11: encoding: [0x80,0x42,0x0a,0x7e]

v_trunc_f32 v5, -1
// GFX11: encoding: [0xc1,0x42,0x0a,0x7e]

v_trunc_f32 v5, 0.5
// GFX11: encoding: [0xf0,0x42,0x0a,0x7e]

v_trunc_f32 v5, -4.0
// GFX11: encoding: [0xf7,0x42,0x0a,0x7e]

v_trunc_f32 v5, 0xaf123456
// GFX11: encoding: [0xff,0x42,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_trunc_f32 v5, 0x3f717273
// GFX11: encoding: [0xff,0x42,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_trunc_f32 v5, ttmp11
// GFX11: encoding: [0x77,0x42,0x0a,0x7e]

v_trunc_f64 v[5:6], v[1:2]
// GFX11: encoding: [0x01,0x2f,0x0a,0x7e]

v_trunc_f64 v[254:255], v[1:2]
// GFX11: encoding: [0x01,0x2f,0xfc,0x7f]

v_trunc_f64 v[5:6], v[254:255]
// GFX11: encoding: [0xfe,0x2f,0x0a,0x7e]

v_trunc_f64 v[5:6], s[2:3]
// GFX11: encoding: [0x02,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], s[4:5]
// GFX11: encoding: [0x04,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], s[102:103]
// GFX11: encoding: [0x66,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], vcc
// GFX11: encoding: [0x6a,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], exec
// GFX11: encoding: [0x7e,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], 0
// GFX11: encoding: [0x80,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], -1
// GFX11: encoding: [0xc1,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], 0.5
// GFX11: encoding: [0xf0,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], -4.0
// GFX11: encoding: [0xf7,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], 0xaf123456
// GFX11: encoding: [0xff,0x2e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_trunc_f64 v[5:6], 0x3f717273
// GFX11: encoding: [0xff,0x2e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_writelane_b32 v5, 0, s2
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0x80,0x04,0x00,0x00]

v_writelane_b32 v255, 0, s2
// GFX11: encoding: [0xff,0x00,0x61,0xd7,0x80,0x04,0x00,0x00]

v_writelane_b32 v5, -1, s2
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0xc1,0x04,0x00,0x00]

v_writelane_b32 v5, 0.5, s2
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0xf0,0x04,0x00,0x00]

v_writelane_b32 v5, -4.0, s2
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0xf7,0x04,0x00,0x00]

v_writelane_b32 v5, 0, s101
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0x80,0xca,0x00,0x00]

v_writelane_b32 v5, 0, vcc_lo
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0x80,0xd4,0x00,0x00]

v_writelane_b32 v5, 0, vcc_hi
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0x80,0xd6,0x00,0x00]

v_writelane_b32 v5, 0, m0
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0x80,0xfa,0x00,0x00]

v_writelane_b32 v5, 0, 0
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0x80,0x00,0x01,0x00]

v_xad_u32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x05,0x0e,0x04]

v_xad_u32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x45,0xd6,0x01,0x05,0x0e,0x04]

v_xad_u32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0xff,0x05,0x0e,0x04]

v_xad_u32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x04,0x0e,0x04]

v_xad_u32 v5, s101, v2, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x65,0x04,0x0e,0x04]

v_xad_u32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x6a,0x04,0x0e,0x04]

v_xad_u32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x6b,0x04,0x0e,0x04]

v_xad_u32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x7d,0x04,0x0e,0x04]

v_xad_u32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x7e,0x04,0x0e,0x04]

v_xad_u32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x7f,0x04,0x0e,0x04]

v_xad_u32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x80,0x04,0x0e,0x04]

v_xad_u32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0xc1,0x04,0x0e,0x04]

v_xad_u32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0xf0,0x04,0x0e,0x04]

v_xad_u32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0xf7,0x04,0x0e,0x04]

v_xad_u32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0xff,0x0f,0x04]

v_xad_u32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x05,0x0c,0x04]

v_xad_u32 v5, v1, s101, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0xcb,0x0c,0x04]

v_xad_u32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0xd5,0x0c,0x04]

v_xad_u32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0xd7,0x0c,0x04]

v_xad_u32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0xfb,0x0c,0x04]

v_xad_u32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0xfd,0x0c,0x04]

v_xad_u32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0xff,0x0c,0x04]

v_xad_u32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x01,0x0d,0x04]

v_xad_u32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x83,0x0d,0x04]

v_xad_u32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0xe1,0x0d,0x04]

v_xad_u32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0xef,0x0d,0x04]

v_xad_u32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x05,0xfe,0x07]

v_xad_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x05,0x0e,0x00]

v_xad_u32 v5, v1, v2, s101
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x05,0x96,0x01]

v_xad_u32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x05,0xaa,0x01]

v_xad_u32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x05,0xae,0x01]

v_xad_u32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x05,0xf6,0x01]

v_xad_u32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x05,0xfa,0x01]

v_xad_u32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x05,0xfe,0x01]

v_xad_u32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x05,0x02,0x02]

v_xad_u32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x05,0x06,0x03]

v_xad_u32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x05,0xc2,0x03]

v_xad_u32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x05,0xde,0x03]

v_xor3_b32 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x05,0x0e,0x04]

v_xor3_b32 v255, v1, v2, v3
// GFX11: encoding: [0xff,0x00,0x40,0xd6,0x01,0x05,0x0e,0x04]

v_xor3_b32 v5, v255, v2, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0xff,0x05,0x0e,0x04]

v_xor3_b32 v5, s1, v2, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x04,0x0e,0x04]

v_xor3_b32 v5, s103, v2, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x67,0x04,0x0e,0x04]

v_xor3_b32 v5, vcc_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x6a,0x04,0x0e,0x04]

v_xor3_b32 v5, vcc_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x6b,0x04,0x0e,0x04]

v_xor3_b32 v5, m0, v2, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x7d,0x04,0x0e,0x04]

v_xor3_b32 v5, exec_lo, v2, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x7e,0x04,0x0e,0x04]

v_xor3_b32 v5, exec_hi, v2, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x7f,0x04,0x0e,0x04]

v_xor3_b32 v5, 0, v2, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x80,0x04,0x0e,0x04]

v_xor3_b32 v5, -1, v2, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0xc1,0x04,0x0e,0x04]

v_xor3_b32 v5, 0.5, v2, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0xf0,0x04,0x0e,0x04]

v_xor3_b32 v5, -4.0, v2, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0xf7,0x04,0x0e,0x04]

v_xor3_b32 v5, v1, v255, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0xff,0x0f,0x04]

v_xor3_b32 v5, v1, s2, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x05,0x0c,0x04]

v_xor3_b32 v5, v1, s103, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0xcf,0x0c,0x04]

v_xor3_b32 v5, v1, vcc_lo, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0xd5,0x0c,0x04]

v_xor3_b32 v5, v1, vcc_hi, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0xd7,0x0c,0x04]

v_xor3_b32 v5, v1, m0, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0xfb,0x0c,0x04]

v_xor3_b32 v5, v1, exec_lo, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0xfd,0x0c,0x04]

v_xor3_b32 v5, v1, exec_hi, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0xff,0x0c,0x04]

v_xor3_b32 v5, v1, 0, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x01,0x0d,0x04]

v_xor3_b32 v5, v1, -1, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x83,0x0d,0x04]

v_xor3_b32 v5, v1, 0.5, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0xe1,0x0d,0x04]

v_xor3_b32 v5, v1, -4.0, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0xef,0x0d,0x04]

v_xor3_b32 v5, v1, v2, v255
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x05,0xfe,0x07]

v_xor3_b32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x05,0x0e,0x00]

v_xor3_b32 v5, v1, v2, s103
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x05,0x9e,0x01]

v_xor3_b32 v5, v1, v2, vcc_lo
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x05,0xaa,0x01]

v_xor3_b32 v5, v1, v2, vcc_hi
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x05,0xae,0x01]

v_xor3_b32 v5, v1, v2, m0
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x05,0xf6,0x01]

v_xor3_b32 v5, v1, v2, exec_lo
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x05,0xfa,0x01]

v_xor3_b32 v5, v1, v2, exec_hi
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x05,0xfe,0x01]

v_xor3_b32 v5, v1, v2, 0
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x05,0x02,0x02]

v_xor3_b32 v5, v1, v2, -1
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x05,0x06,0x03]

v_xor3_b32 v5, v1, v2, 0.5
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x05,0xc2,0x03]

v_xor3_b32 v5, v1, v2, -4.0
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x05,0xde,0x03]

v_xor3_b32 v5, ttmp11, v2, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x77,0x04,0x0e,0x04]

v_xor3_b32 v5, v1, ttmp11, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0xef,0x0c,0x04]

v_xor3_b32 v5, v1, v2, ttmp11
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x05,0xde,0x01]

v_cndmask_b16 v5, v1, v2, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x05,0x0e,0x00]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v255, v1, v2, s3
// W32: encoding: [0xff,0x00,0x5d,0xd6,0x01,0x05,0x0e,0x00]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v255, v2, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0xff,0x05,0x0e,0x00]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, vcc_lo, v2, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x6a,0x04,0x0e,0x00]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, 0, v2, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x80,0x04,0x0e,0x00]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, -1, v2, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0xc1,0x04,0x0e,0x00]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, v255, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x01,0xff,0x0f,0x00]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, vcc_lo, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x01,0xd5,0x0c,0x00]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, 0, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x01,0x0d,0x00]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, -1, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x83,0x0d,0x00]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, v2, s105
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x05,0xa6,0x01]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, v2, vcc_lo
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x05,0xaa,0x01]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, v2, vcc_hi
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x05,0xae,0x01]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, v2, ttmp15
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x05,0xee,0x01]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, -v1, v2, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x05,0x0e,0x20]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, -v2, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x05,0x0e,0x40]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, -v1, -v2, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x05,0x0e,0x60]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, |v1|, v2, s3
// W32: encoding: [0x05,0x01,0x5d,0xd6,0x01,0x05,0x0e,0x00]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, |v2|, s3
// W32: encoding: [0x05,0x02,0x5d,0xd6,0x01,0x05,0x0e,0x00]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, |v1|, |v2|, s3
// W32: encoding: [0x05,0x03,0x5d,0xd6,0x01,0x05,0x0e,0x00]
// W64-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, v2, s[4:5]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x05,0x12,0x00]
// W32-ERR: error: invalid operand for instruction

v_cndmask_b16 v255, v1, v2, s[4:5]
// W64: encoding: [0xff,0x00,0x5d,0xd6,0x01,0x05,0x12,0x00]
// W32-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v255, v2, s[4:5]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0xff,0x05,0x12,0x00]
// W32-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, vcc_lo, v2, s[4:5]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x6a,0x04,0x12,0x00]
// W32-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, 0, v2, s[4:5]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x80,0x04,0x12,0x00]
// W32-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, -1, v2, s[4:5]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0xc1,0x04,0x12,0x00]
// W32-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, v255, s[4:5]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x01,0xff,0x13,0x00]
// W32-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, vcc_lo, s[4:5]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x01,0xd5,0x10,0x00]
// W32-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, 0, s[4:5]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x01,0x11,0x00]
// W32-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, -1, s[4:5]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x83,0x11,0x00]
// W32-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, v2, vcc
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x05,0xaa,0x01]
// W32-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, v2, vcc
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x05,0xaa,0x01]
// W32-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, -v1, v2, s[4:5]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x05,0x12,0x20]
// W32-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, -v2, s[4:5]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x05,0x12,0x40]
// W32-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, -v1, -v2, s[4:5]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x01,0x05,0x12,0x60]
// W32-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, |v1|, v2, s[4:5]
// W64: encoding: [0x05,0x01,0x5d,0xd6,0x01,0x05,0x12,0x00]
// W32-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, v1, |v2|, s[4:5]
// W64: encoding: [0x05,0x02,0x5d,0xd6,0x01,0x05,0x12,0x00]
// W32-ERR: error: invalid operand for instruction

v_cndmask_b16 v5, |v1|, |v2|, s[4:5]
// W64: encoding: [0x05,0x03,0x5d,0xd6,0x01,0x05,0x12,0x00]
// W32-ERR: error: invalid operand for instruction

v_and_b16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0x05,0x02,0x00]

v_and_b16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x62,0xd7,0x01,0x05,0x02,0x00]

v_and_b16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0xff,0x05,0x02,0x00]

v_and_b16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0x04,0x02,0x00]

v_and_b16 v5, s105, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x69,0x04,0x02,0x00]

v_and_b16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x6a,0x04,0x02,0x00]

v_and_b16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x6b,0x04,0x02,0x00]

v_and_b16 v5, ttmp15, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x7b,0x04,0x02,0x00]

v_and_b16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x7d,0x04,0x02,0x00]

v_and_b16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x7e,0x04,0x02,0x00]

v_and_b16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x7f,0x04,0x02,0x00]

v_and_b16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x80,0x04,0x02,0x00]

v_and_b16 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0xc1,0x04,0x02,0x00]

v_and_b16 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_and_b16 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_and_b16 v5, src_scc, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0xfd,0x04,0x02,0x00]

v_and_b16 v5, 0xfe0b, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0xff,0x04,0x02,0x00,0x0b,0xfe,0x00,0x00]

v_and_b16 v5, 0x3456, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0xff,0x04,0x02,0x00,0x56,0x34,0x00,0x00]

v_and_b16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0xff,0x03,0x00]

v_and_b16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0x05,0x00,0x00]

v_and_b16 v5, v1, s105
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0xd3,0x00,0x00]

v_and_b16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0xd5,0x00,0x00]

v_and_b16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0xd7,0x00,0x00]

v_and_b16 v5, v1, ttmp15
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0xf7,0x00,0x00]

v_and_b16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0xfb,0x00,0x00]

v_and_b16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0xfd,0x00,0x00]

v_and_b16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0xff,0x00,0x00]

v_and_b16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0x01,0x01,0x00]

v_and_b16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0x83,0x01,0x00]

v_and_b16 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_and_b16 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_and_b16 v5, v1, src_scc
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0xfb,0x01,0x00]

v_and_b16 v5, v1, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0xff,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_and_b16 v5, v1, 0x3456
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0xff,0x01,0x00,0x56,0x34,0x00,0x00]

v_or_b16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0x05,0x02,0x00]

v_or_b16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x63,0xd7,0x01,0x05,0x02,0x00]

v_or_b16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0xff,0x05,0x02,0x00]

v_or_b16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0x04,0x02,0x00]

v_or_b16 v5, s105, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x69,0x04,0x02,0x00]

v_or_b16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x6a,0x04,0x02,0x00]

v_or_b16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x6b,0x04,0x02,0x00]

v_or_b16 v5, ttmp15, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x7b,0x04,0x02,0x00]

v_or_b16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x7d,0x04,0x02,0x00]

v_or_b16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x7e,0x04,0x02,0x00]

v_or_b16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x7f,0x04,0x02,0x00]

v_or_b16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x80,0x04,0x02,0x00]

v_or_b16 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0xc1,0x04,0x02,0x00]

v_or_b16 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_or_b16 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_or_b16 v5, src_scc, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0xfd,0x04,0x02,0x00]

v_or_b16 v5, 0xfe0b, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0xff,0x04,0x02,0x00,0x0b,0xfe,0x00,0x00]

v_or_b16 v5, 0x3456, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0xff,0x04,0x02,0x00,0x56,0x34,0x00,0x00]

v_or_b16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0xff,0x03,0x00]

v_or_b16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0x05,0x00,0x00]

v_or_b16 v5, v1, s105
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0xd3,0x00,0x00]

v_or_b16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0xd5,0x00,0x00]

v_or_b16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0xd7,0x00,0x00]

v_or_b16 v5, v1, ttmp15
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0xf7,0x00,0x00]

v_or_b16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0xfb,0x00,0x00]

v_or_b16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0xfd,0x00,0x00]

v_or_b16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0xff,0x00,0x00]

v_or_b16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0x01,0x01,0x00]

v_or_b16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0x83,0x01,0x00]

v_or_b16 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_or_b16 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_or_b16 v5, v1, src_scc
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0xfb,0x01,0x00]

v_or_b16 v5, v1, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0xff,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_or_b16 v5, v1, 0x3456
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0xff,0x01,0x00,0x56,0x34,0x00,0x00]

v_xor_b16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0x05,0x02,0x00]

v_xor_b16 v255, v1, v2
// GFX11: encoding: [0xff,0x00,0x64,0xd7,0x01,0x05,0x02,0x00]

v_xor_b16 v5, v255, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0xff,0x05,0x02,0x00]

v_xor_b16 v5, s1, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0x04,0x02,0x00]

v_xor_b16 v5, s105, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x69,0x04,0x02,0x00]

v_xor_b16 v5, vcc_lo, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x6a,0x04,0x02,0x00]

v_xor_b16 v5, vcc_hi, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x6b,0x04,0x02,0x00]

v_xor_b16 v5, ttmp15, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x7b,0x04,0x02,0x00]

v_xor_b16 v5, m0, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x7d,0x04,0x02,0x00]

v_xor_b16 v5, exec_lo, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x7e,0x04,0x02,0x00]

v_xor_b16 v5, exec_hi, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x7f,0x04,0x02,0x00]

v_xor_b16 v5, 0, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x80,0x04,0x02,0x00]

v_xor_b16 v5, -1, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0xc1,0x04,0x02,0x00]

v_xor_b16 v5, 0.5, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_xor_b16 v5, -4.0, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_xor_b16 v5, src_scc, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0xfd,0x04,0x02,0x00]

v_xor_b16 v5, 0xfe0b, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0xff,0x04,0x02,0x00,0x0b,0xfe,0x00,0x00]

v_xor_b16 v5, 0x3456, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0xff,0x04,0x02,0x00,0x56,0x34,0x00,0x00]

v_xor_b16 v5, v1, v255
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0xff,0x03,0x00]

v_xor_b16 v5, v1, s2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0x05,0x00,0x00]

v_xor_b16 v5, v1, s105
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0xd3,0x00,0x00]

v_xor_b16 v5, v1, vcc_lo
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0xd5,0x00,0x00]

v_xor_b16 v5, v1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0xd7,0x00,0x00]

v_xor_b16 v5, v1, ttmp15
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0xf7,0x00,0x00]

v_xor_b16 v5, v1, m0
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0xfb,0x00,0x00]

v_xor_b16 v5, v1, exec_lo
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0xfd,0x00,0x00]

v_xor_b16 v5, v1, exec_hi
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0xff,0x00,0x00]

v_xor_b16 v5, v1, 0
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0x01,0x01,0x00]

v_xor_b16 v5, v1, -1
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0x83,0x01,0x00]

v_xor_b16 v5, v1, 0.5
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_xor_b16 v5, v1, -4.0
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_xor_b16 v5, v1, src_scc
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0xfb,0x01,0x00]

v_xor_b16 v5, v1, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0xff,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_xor_b16 v5, v1, 0x3456
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0xff,0x01,0x00,0x56,0x34,0x00,0x00]
