impl VARIANT_BOOL {
    #[inline]
    pub fn as_bool(self) -> bool {
        self.0 != 0
    }
    #[inline]
    pub fn ok(self) -> ::windows::core::Result<()> {
        if self.as_bool() {
            Ok(())
        } else {
            Err(::windows::core::Error::from_win32())
        }
    }
    #[inline]
    #[track_caller]
    pub fn unwrap(self) {
        self.ok().unwrap();
    }
    #[inline]
    #[track_caller]
    pub fn expect(self, msg: &str) {
        self.ok().expect(msg);
    }
}
impl ::core::convert::From<VARIANT_BOOL> for bool {
    fn from(value: VARIANT_BOOL) -> Self {
        value.as_bool()
    }
}
impl ::core::convert::From<&VARIANT_BOOL> for bool {
    fn from(value: &VARIANT_BOOL) -> Self {
        value.as_bool()
    }
}
impl ::core::convert::From<bool> for VARIANT_BOOL {
    fn from(value: bool) -> Self {
        if value {
            VARIANT_TRUE
        } else {
            VARIANT_FALSE
        }
    }
}
impl ::core::convert::From<&bool> for VARIANT_BOOL {
    fn from(value: &bool) -> Self {
        (*value).into()
    }
}
impl ::core::cmp::PartialEq<bool> for VARIANT_BOOL {
    fn eq(&self, other: &bool) -> bool {
        self.as_bool() == *other
    }
}
impl ::core::cmp::PartialEq<VARIANT_BOOL> for bool {
    fn eq(&self, other: &VARIANT_BOOL) -> bool {
        *self == other.as_bool()
    }
}
impl ::core::ops::Not for VARIANT_BOOL {
    type Output = Self;
    fn not(self) -> Self::Output {
        if self.as_bool() {
            VARIANT_FALSE
        } else {
            VARIANT_TRUE
        }
    }
}
